#if   !defined(__LISTMEDIATOR_HPP)
#define __LISTMEDIATOR_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__COLLEAGUE_HPP)
#include <corelinux/Colleague.hpp>
#endif

#if   !defined(__MEDIATOR_HPP)
#include <corelinux/Mediator.hpp>
#endif

#if   !defined(__MAP_HPP)
#include <corelinux/Map.hpp>
#endif

#if   !defined(__SET_HPP)
#include <corelinux/Set.hpp>
#endif

using namespace std;

DECLARE_CLASS( ListColleague );     // Adds to list, notifies of List Change
                                    // Notified of edit change

DECLARE_CLASS( EditColleague );     // Edits list entry, notifies of edit
                                    // Notified of selection

DECLARE_CLASS( SelectColleague );   // Selects from list, notifies of selection
                                    // Notified of List change

DECLARE_CLASS( ListMediator );

/**
Manages list activity between ListColleagues
*/

class ListMediator : public CORELINUX( Mediator )
{
   CORELINUX_MAP
      ( 
         DwordIdentifier, 
         CORELINUX(ColleaguePtr), 
         less<DwordIdentifier>,
	 InterestedMap
      );

public:

   //
   // Constructors and destructor
   //

                     /// Default constructor

                     ListMediator( void );

                     /// Virtual destructor

   virtual           ~ListMediator( void );

   //
   // Mutators
   //

            /// Gets the activity rolling

            void  run( void );   

protected:

                     /// Copy constructor never called

                     ListMediator( ListMediatorCref )
                        throw ( CORELINUX( Assertion ) );

            /// Assignment never called.

            ListMediatorRef operator=( ListMediatorCref )
               throw ( CORELINUX( Assertion ) );

            /// Equality never called

            bool operator==( ListMediatorCref ) const
               throw ( CORELINUX( Assertion ) );

   //
   // Implementation requirements from Mediator
   //
            /// Call when creating a Colleague

   virtual  void  colleagueCreated( CORELINUX(ColleaguePtr) ) ;

            /// Call when requesting Colleagues interested in EventType

   virtual  CORELINUX(Iterator<corelinux::ColleaguePtr>)  *createIterator
               ( 
                  CORELINUX(Event<corelinux::Identifier>) * 
               ) ;

            /// Called when destroying the iterator

   virtual  void  destroyIterator( CORELINUX(Iterator<corelinux::ColleaguePtr>) * ) ;


private:

            ListColleaguePtr     theList;
            EditColleaguePtr     theEditor;
            SelectColleaguePtr   theSelection;

            /// Maps event identifiers to interested colleagues

            InterestedMap        theInterestedMap;

};

#endif // if !defined(__LISTMEDIATOR_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:49:01 $
   $Locker:  $
*/


