/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.List;
import java.util.Optional;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;

public class Jre12Compat
extends JreCompat {
    private static final Log log = LogFactory.getLog(Jre12Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre12Compat.class);
    private static final boolean supported;

    static boolean isSupported() {
        return supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanonCachesDisabled() {
        if (canonCachesDisabled != null) {
            return canonCachesDisabled;
        }
        Object object = canonCachesDisabledLock;
        synchronized (object) {
            if (canonCachesDisabled != null) {
                return canonCachesDisabled;
            }
            List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : args) {
                String value;
                boolean cacheEnabled;
                if (!arg.startsWith("-Dsun.io.useCanonCaches=") || !(cacheEnabled = Boolean.valueOf(value = arg.substring("-Dsun.io.useCanonCaches=".length())).booleanValue())) continue;
                canonCachesDisabled = Boolean.FALSE;
                return false;
            }
            canonCachesDisabled = Boolean.TRUE;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ensureUseCanonCachesFieldIsPopulated() {
        if (useCanonCachesField != null) {
            return;
        }
        Object object = useCanonCachesFieldLock;
        synchronized (object) {
            if (useCanonCachesField != null) {
                return;
            }
            Field f = null;
            try {
                Class<?> clazz = Class.forName("java.io.FileSystem");
                f = clazz.getDeclaredField("useCanonCaches");
                f.setAccessible(true);
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(Field.class, MethodHandles.lookup());
                VarHandle modifiers = lookup.findVarHandle(Field.class, "modifiers", Integer.TYPE);
                modifiers.set(f, f.getModifiers() & 0xFFFFFFEF);
            }
            catch (UnsupportedOperationException e) {
                f = null;
                log.warn((Object)sm.getString("jreCompat.useCanonCaches.java18"), (Throwable)e);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | InaccessibleObjectException e) {
                f = null;
                log.warn((Object)sm.getString("jreCompat.useCanonCaches.init"), (Throwable)e);
            }
            useCanonCachesField = f == null ? Optional.empty() : Optional.of(f);
        }
    }

    static {
        Class<?> c1 = null;
        try {
            c1 = Class.forName("java.text.CompactNumberFormat");
        }
        catch (ClassNotFoundException cnfe) {
            log.debug((Object)sm.getString("jre12Compat.javaPre12"), (Throwable)cnfe);
        }
        supported = c1 != null;
    }
}

