/* This file was autogenerated by ctest; do not modify directly */

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdio.h>

#define SUPPRESS_ERROR
#include <macro.h>
#undef SUPPRESS_ERROR

#if defined(__cplusplus)
    #define CTEST_ALIGNOF(T) alignof(T)
    #define CTEST_EXTERN extern "C"
#else
    #define CTEST_ALIGNOF(T) _Alignof(T)
    #define CTEST_EXTERN
#endif

typedef void (*ctest_void_func)(void);

/* Query a pointer to string constants.
 *
 *  Define a function that returns a pointer to the value of the constant to test.
 *  This will later be called on the Rust side via FFI.
 */


/* Query a pointer to non-string constants.
 *
 * Define a function that returns a pointer to the value of the constant to test.
 * This will later be called on the Rust side via FFI.
 */


/* Query the size and alignment of all types */

CTEST_EXTERN uint64_t ctest_size_of__VecU8(void) { return sizeof(struct VecU8); }
CTEST_EXTERN uint64_t ctest_align_of__VecU8(void) { return CTEST_ALIGNOF(struct VecU8); }

CTEST_EXTERN uint64_t ctest_size_of__VecU16(void) { return sizeof(struct VecU16); }
CTEST_EXTERN uint64_t ctest_align_of__VecU16(void) { return CTEST_ALIGNOF(struct VecU16); }


/* Query the signedness of a type.
 *
 * Return `1` if the type is signed, otherwise return `0`.
 * Casting -1 to the aliased type if signed evaluates to `-1 < 0`, if unsigned to `MAX_VALUE < 0`
 */


/* Query the offsets of fields and their sizes. */

CTEST_EXTERN uint64_t ctest_offset_of__VecU8__x(void) {
    return offsetof(struct VecU8, x);
}

CTEST_EXTERN uint64_t ctest_size_of__VecU8__x(void) {
    return sizeof(((struct VecU8){}).x);
}

CTEST_EXTERN uint64_t ctest_offset_of__VecU8__y(void) {
    return offsetof(struct VecU8, y);
}

CTEST_EXTERN uint64_t ctest_size_of__VecU8__y(void) {
    return sizeof(((struct VecU8){}).y);
}

CTEST_EXTERN uint64_t ctest_offset_of__VecU16__x(void) {
    return offsetof(struct VecU16, x);
}

CTEST_EXTERN uint64_t ctest_size_of__VecU16__x(void) {
    return sizeof(((struct VecU16){}).x);
}

CTEST_EXTERN uint64_t ctest_offset_of__VecU16__y(void) {
    return offsetof(struct VecU16, y);
}

CTEST_EXTERN uint64_t ctest_size_of__VecU16__y(void) {
    return sizeof(((struct VecU16){}).y);
}


/* Query a pointer to a field given a pointer to its struct */


typedef uint8_t *ctest_field_ty__VecU8__x;
CTEST_EXTERN ctest_field_ty__VecU8__x
ctest_field_ptr__VecU8__x(struct VecU8 *b) {
    return &b->x;
}


typedef uint8_t *ctest_field_ty__VecU8__y;
CTEST_EXTERN ctest_field_ty__VecU8__y
ctest_field_ptr__VecU8__y(struct VecU8 *b) {
    return &b->y;
}


typedef uint16_t *ctest_field_ty__VecU16__x;
CTEST_EXTERN ctest_field_ty__VecU16__x
ctest_field_ptr__VecU16__x(struct VecU16 *b) {
    return &b->x;
}


typedef uint16_t *ctest_field_ty__VecU16__y;
CTEST_EXTERN ctest_field_ty__VecU16__y
ctest_field_ptr__VecU16__y(struct VecU16 *b) {
    return &b->y;
}

#ifdef _MSC_VER
    // Disable signed/unsigned conversion warnings on MSVC.
    // These trigger even if the conversion is explicit.
    #pragma warning(disable:4365)
#endif

#ifdef __GNUC__
    // GCC emits a warning with `-Wextra` if we return a typedef to a type  marked `volatile`.
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wignored-qualifiers"
#endif


/* Write a nonrepeating bitpattern to a data type
 *
 * Tests whether the struct/union/alias `x` when passed by value to C and back to Rust
 * remains unchanged.
 * It checks if the size is the same as well as if the padding bytes are all in the correct place.
 */

CTEST_EXTERN struct VecU8 ctest_roundtrip__VecU8(
    struct VecU8 value,
    const uint8_t is_padding_byte[sizeof(struct VecU8)],
    uint8_t value_bytes[sizeof(struct VecU8)]
) {
    int size = (int)sizeof(struct VecU8);
    
    volatile uint8_t* p = (volatile uint8_t*)&value;
    int i = 0;
    for (i = 0; i < size; ++i) {
        
        if (is_padding_byte[i]) { continue; }
        value_bytes[i] = p[i];
        
        uint8_t d = (uint8_t)(255) - (uint8_t)(i % 256);
        d = d == 0 ? 42: d;
        p[i] = d;
    }
    return value;
}

CTEST_EXTERN struct VecU16 ctest_roundtrip__VecU16(
    struct VecU16 value,
    const uint8_t is_padding_byte[sizeof(struct VecU16)],
    uint8_t value_bytes[sizeof(struct VecU16)]
) {
    int size = (int)sizeof(struct VecU16);
    
    volatile uint8_t* p = (volatile uint8_t*)&value;
    int i = 0;
    for (i = 0; i < size; ++i) {
        
        if (is_padding_byte[i]) { continue; }
        value_bytes[i] = p[i];
        
        uint8_t d = (uint8_t)(255) - (uint8_t)(i % 256);
        d = d == 0 ? 42: d;
        p[i] = d;
    }
    return value;
}

#ifdef __GNUC__
    // Pop allow for `-Wignored-qualifiers`
    #pragma GCC diagnostic pop
#endif

#ifdef _MSC_VER
    // Pop allow for 4365
    #pragma warning(default:4365)
#endif

#ifdef _MSC_VER
    // Disable function pointer type conversion warnings on MSVC.
    // The conversion may fail only if we call that function, however we only check its address.
    #pragma warning(disable:4191)
#endif

/* Query a function's pointer */

#ifdef _MSC_VER
    // Pop allow for 4191
    #pragma warning(default:4191)
#endif


/* Query pointers to statics */
