// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
//! Windows Internet Services API procedure declarations, types and constants.
use ctypes::c_int;
use shared::basetsd::DWORD_PTR;
use shared::minwindef::{
    BOOL, DWORD, FALSE, FILETIME, INT, LPBYTE,
    LPCVOID, LPDWORD, LPVOID, PBYTE, PDWORD, TRUE, WORD,
};
use shared::ntdef::{LONG, LONGLONG, PLONG};
use shared::windef::HWND;
use um::minwinbase::{LPWIN32_FIND_DATAA, LPWIN32_FIND_DATAW, SYSTEMTIME};
use um::winineti::INTERNET_FLAG_BGUPDATE;
use um::winnt::{
    CHAR, DWORDLONG, HANDLE, LPCSTR, LPCWSTR,
    LPSTR, LPWSTR, PCWSTR, PSTR, PWSTR, WCHAR,
};
pub type HINTERNET = LPVOID;
pub type LPHINTERNET = *mut HINTERNET;
pub type INTERNET_PORT = WORD;
pub type LPINTERNET_PORT = *mut INTERNET_PORT;
pub const INTERNET_INVALID_PORT_NUMBER: DWORD = 0;
pub const INTERNET_DEFAULT_FTP_PORT: DWORD = 21;
pub const INTERNET_DEFAULT_GOPHER_PORT: DWORD = 70;
pub const INTERNET_DEFAULT_HTTP_PORT: DWORD = 80;
pub const INTERNET_DEFAULT_HTTPS_PORT: DWORD = 443;
pub const INTERNET_DEFAULT_SOCKS_PORT: DWORD = 1080;
pub const INTERNET_MAX_HOST_NAME_LENGTH: usize = 256;
pub const INTERNET_MAX_USER_NAME_LENGTH: usize = 128;
pub const INTERNET_MAX_PASSWORD_LENGTH: usize = 128;
pub const INTERNET_MAX_PORT_NUMBER_LENGTH: usize = 5;
pub const INTERNET_MAX_PORT_NUMBER_VALUE: DWORD = 65535;
pub const INTERNET_MAX_PATH_LENGTH: usize = 2048;
pub const INTERNET_MAX_SCHEME_LENGTH: usize = 32;
pub const INTERNET_MAX_URL_LENGTH: usize = INTERNET_MAX_SCHEME_LENGTH + 3
    + INTERNET_MAX_PATH_LENGTH;
pub const INTERNET_KEEP_ALIVE_UNKNOWN: DWORD = -1i32 as u32;
pub const INTERNET_KEEP_ALIVE_ENABLED: DWORD = 1;
pub const INTERNET_KEEP_ALIVE_DISABLED: DWORD = 0;
pub const INTERNET_REQFLAG_FROM_CACHE: DWORD = 0x00000001;
pub const INTERNET_REQFLAG_ASYNC: DWORD = 0x00000002;
pub const INTERNET_REQFLAG_VIA_PROXY: DWORD = 0x00000004;
pub const INTERNET_REQFLAG_NO_HEADERS: DWORD = 0x00000008;
pub const INTERNET_REQFLAG_PASSIVE: DWORD = 0x00000010;
pub const INTERNET_REQFLAG_CACHE_WRITE_DISABLED: DWORD = 0x00000040;
pub const INTERNET_REQFLAG_NET_TIMEOUT: DWORD = 0x00000080;
pub const INTERNET_FLAG_IDN_DIRECT: DWORD = 0x00000001;
pub const INTERNET_FLAG_IDN_PROXY: DWORD = 0x00000002;
pub const INTERNET_FLAG_RELOAD: DWORD = 0x80000000;
pub const INTERNET_FLAG_RAW_DATA: DWORD = 0x40000000;
pub const INTERNET_FLAG_EXISTING_CONNECT: DWORD = 0x20000000;
pub const INTERNET_FLAG_ASYNC: DWORD = 0x10000000;
pub const INTERNET_FLAG_PASSIVE: DWORD = 0x08000000;
pub const INTERNET_FLAG_NO_CACHE_WRITE: DWORD = 0x04000000;
pub const INTERNET_FLAG_DONT_CACHE: DWORD = INTERNET_FLAG_NO_CACHE_WRITE;
pub const INTERNET_FLAG_MAKE_PERSISTENT: DWORD = 0x02000000;
pub const INTERNET_FLAG_FROM_CACHE: DWORD = 0x01000000;
pub const INTERNET_FLAG_OFFLINE: DWORD = INTERNET_FLAG_FROM_CACHE;
pub const INTERNET_FLAG_SECURE: DWORD = 0x00800000;
pub const INTERNET_FLAG_KEEP_CONNECTION: DWORD = 0x00400000;
pub const INTERNET_FLAG_NO_AUTO_REDIRECT: DWORD = 0x00200000;
pub const INTERNET_FLAG_READ_PREFETCH: DWORD = 0x00100000;
pub const INTERNET_FLAG_NO_COOKIES: DWORD = 0x00080000;
pub const INTERNET_FLAG_NO_AUTH: DWORD = 0x00040000;
pub const INTERNET_FLAG_RESTRICTED_ZONE: DWORD = 0x00020000;
pub const INTERNET_FLAG_CACHE_IF_NET_FAIL: DWORD = 0x00010000;
pub const INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP: DWORD = 0x00008000;
pub const INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS: DWORD = 0x00004000;
pub const INTERNET_FLAG_IGNORE_CERT_DATE_INVALID: DWORD = 0x00002000;
pub const INTERNET_FLAG_IGNORE_CERT_CN_INVALID: DWORD = 0x00001000;
pub const INTERNET_FLAG_RESYNCHRONIZE: DWORD = 0x00000800;
pub const INTERNET_FLAG_HYPERLINK: DWORD = 0x00000400;
pub const INTERNET_FLAG_NO_UI: DWORD = 0x00000200;
pub const INTERNET_FLAG_PRAGMA_NOCACHE: DWORD = 0x00000100;
pub const INTERNET_FLAG_CACHE_ASYNC: DWORD = 0x00000080;
pub const INTERNET_FLAG_FORMS_SUBMIT: DWORD = 0x00000040;
pub const INTERNET_FLAG_FWD_BACK: DWORD = 0x00000020;
pub const INTERNET_FLAG_NEED_FILE: DWORD = 0x00000010;
pub const INTERNET_FLAG_MUST_CACHE_REQUEST: DWORD = INTERNET_FLAG_NEED_FILE;
pub const INTERNET_FLAG_TRANSFER_ASCII: DWORD = FTP_TRANSFER_TYPE_ASCII;
pub const INTERNET_FLAG_TRANSFER_BINARY: DWORD = FTP_TRANSFER_TYPE_BINARY;
pub const SECURITY_INTERNET_MASK: DWORD = INTERNET_FLAG_IGNORE_CERT_CN_INVALID
    | INTERNET_FLAG_IGNORE_CERT_DATE_INVALID | INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS
    | INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP;
pub const SECURITY_IGNORE_ERROR_MASK: DWORD = INTERNET_FLAG_IGNORE_CERT_CN_INVALID
    | INTERNET_FLAG_IGNORE_CERT_DATE_INVALID | SECURITY_FLAG_IGNORE_UNKNOWN_CA
    | SECURITY_FLAG_IGNORE_REVOCATION;
pub const INTERNET_FLAGS_MASK: DWORD = INTERNET_FLAG_RELOAD | INTERNET_FLAG_RAW_DATA
    | INTERNET_FLAG_EXISTING_CONNECT | INTERNET_FLAG_ASYNC | INTERNET_FLAG_PASSIVE
    | INTERNET_FLAG_NO_CACHE_WRITE | INTERNET_FLAG_MAKE_PERSISTENT | INTERNET_FLAG_FROM_CACHE
    | INTERNET_FLAG_SECURE | INTERNET_FLAG_KEEP_CONNECTION | INTERNET_FLAG_NO_AUTO_REDIRECT
    | INTERNET_FLAG_READ_PREFETCH | INTERNET_FLAG_NO_COOKIES | INTERNET_FLAG_NO_AUTH
    | INTERNET_FLAG_CACHE_IF_NET_FAIL | SECURITY_INTERNET_MASK | INTERNET_FLAG_RESYNCHRONIZE
    | INTERNET_FLAG_HYPERLINK | INTERNET_FLAG_NO_UI | INTERNET_FLAG_PRAGMA_NOCACHE
    | INTERNET_FLAG_CACHE_ASYNC | INTERNET_FLAG_FORMS_SUBMIT | INTERNET_FLAG_NEED_FILE
    | INTERNET_FLAG_RESTRICTED_ZONE | INTERNET_FLAG_TRANSFER_BINARY | INTERNET_FLAG_TRANSFER_ASCII
    | INTERNET_FLAG_FWD_BACK | INTERNET_FLAG_BGUPDATE;
pub const INTERNET_ERROR_MASK_INSERT_CDROM: DWORD = 0x1;
pub const INTERNET_ERROR_MASK_COMBINED_SEC_CERT: DWORD = 0x2;
pub const INTERNET_ERROR_MASK_NEED_MSN_SSPI_PKG: DWORD = 0x4;
pub const INTERNET_ERROR_MASK_LOGIN_FAILURE_DISPLAY_ENTITY_BODY: DWORD = 0x8;
pub const INTERNET_OPTIONS_MASK: DWORD = !INTERNET_FLAGS_MASK;
pub const WININET_API_FLAG_ASYNC: DWORD = 0x00000001;
pub const WININET_API_FLAG_SYNC: DWORD = 0x00000004;
pub const WININET_API_FLAG_USE_CONTEXT: DWORD = 0x00000008;
pub const INTERNET_NO_CALLBACK: DWORD = 0;
ENUM!{enum INTERNET_SCHEME {
    INTERNET_SCHEME_PARTIAL = -2i32 as u32,
    INTERNET_SCHEME_UNKNOWN = -1i32 as u32,
    INTERNET_SCHEME_DEFAULT = 0,
    INTERNET_SCHEME_FTP,
    INTERNET_SCHEME_GOPHER,
    INTERNET_SCHEME_HTTP,
    INTERNET_SCHEME_HTTPS,
    INTERNET_SCHEME_FILE,
    INTERNET_SCHEME_NEWS,
    INTERNET_SCHEME_MAILTO,
    INTERNET_SCHEME_SOCKS,
    INTERNET_SCHEME_JAVASCRIPT,
    INTERNET_SCHEME_VBSCRIPT,
    INTERNET_SCHEME_RES,
    INTERNET_SCHEME_FIRST = INTERNET_SCHEME_FTP,
    INTERNET_SCHEME_LAST = INTERNET_SCHEME_RES,
}}
pub type LPINTERNET_SCHEME = *mut INTERNET_SCHEME;
STRUCT!{struct INTERNET_ASYNC_RESULT {
    dwResult: DWORD_PTR,
    dwError: DWORD,
}}
pub type LPINTERNET_ASYNC_RESULT = *mut INTERNET_ASYNC_RESULT;
STRUCT!{struct INTERNET_DIAGNOSTIC_SOCKET_INFO {
    Socket: DWORD_PTR,
    SourcePort: DWORD,
    DestPort: DWORD,
    Flags: DWORD,
}}
pub type LPINTERNET_DIAGNOSTIC_SOCKET_INFO = *mut INTERNET_DIAGNOSTIC_SOCKET_INFO;
pub const IDSI_FLAG_KEEP_ALIVE: DWORD = 0x00000001;
pub const IDSI_FLAG_SECURE: DWORD = 0x00000002;
pub const IDSI_FLAG_PROXY: DWORD = 0x00000004;
pub const IDSI_FLAG_TUNNEL: DWORD = 0x00000008;
STRUCT!{struct INTERNET_PROXY_INFO {
    dwAccessType: DWORD,
    lpszProxy: LPCWSTR,
    lpszProxyBypass: LPCWSTR,
}}
pub type LPINTERNET_PROXY_INFO = *mut INTERNET_PROXY_INFO;
UNION!{union INTERNET_PER_CONN_OPTIONA_Value {
    [u32; 2] [u64; 1],
    dwValue dwValue_mut: DWORD,
    pszValue pszValue_mut: LPSTR,
    ftValue ftValue_mut: FILETIME,
}}
STRUCT!{struct INTERNET_PER_CONN_OPTIONA {
    dwOption: DWORD,
    Value: INTERNET_PER_CONN_OPTIONA_Value,
}}
pub type LPINTERNET_PER_CONN_OPTIONA = *mut INTERNET_PER_CONN_OPTIONA;
UNION!{union INTERNET_PER_CONN_OPTIONW_Value {
    [u32; 2] [u64; 1],
    dwValue dwValue_mut: DWORD,
    pszValue pszValue_mut: LPWSTR,
    ftValue ftValue_mut: FILETIME,
}}
STRUCT!{struct INTERNET_PER_CONN_OPTIONW {
    dwOption: DWORD,
    Value: INTERNET_PER_CONN_OPTIONW_Value,
}}
pub type LPINTERNET_PER_CONN_OPTIONW = *mut INTERNET_PER_CONN_OPTIONW;
STRUCT!{struct INTERNET_PER_CONN_OPTION_LISTA {
    dwSize: DWORD,
    pszConnection: LPSTR,
    dwOptionCount: DWORD,
    dwOptionError: DWORD,
    pOptions: LPINTERNET_PER_CONN_OPTIONA,
}}
pub type LPINTERNET_PER_CONN_OPTION_LISTA = *mut INTERNET_PER_CONN_OPTION_LISTA;
STRUCT!{struct INTERNET_PER_CONN_OPTION_LISTW {
    dwSize: DWORD,
    pszConnection: LPWSTR,
    dwOptionCount: DWORD,
    dwOptionError: DWORD,
    pOptions: LPINTERNET_PER_CONN_OPTIONW,
}}
pub type LPINTERNET_PER_CONN_OPTION_LISTW = *mut INTERNET_PER_CONN_OPTION_LISTW;
pub const INTERNET_PER_CONN_FLAGS: DWORD = 1;
pub const INTERNET_PER_CONN_PROXY_SERVER: DWORD = 2;
pub const INTERNET_PER_CONN_PROXY_BYPASS: DWORD = 3;
pub const INTERNET_PER_CONN_AUTOCONFIG_URL: DWORD = 4;
pub const INTERNET_PER_CONN_AUTODISCOVERY_FLAGS: DWORD = 5;
pub const INTERNET_PER_CONN_AUTOCONFIG_SECONDARY_URL: DWORD = 6;
pub const INTERNET_PER_CONN_AUTOCONFIG_RELOAD_DELAY_MINS: DWORD = 7;
pub const INTERNET_PER_CONN_AUTOCONFIG_LAST_DETECT_TIME: DWORD = 8;
pub const INTERNET_PER_CONN_AUTOCONFIG_LAST_DETECT_URL: DWORD = 9;
pub const INTERNET_PER_CONN_FLAGS_UI: DWORD = 10;
pub const PROXY_TYPE_DIRECT: DWORD = 0x00000001;
pub const PROXY_TYPE_PROXY: DWORD = 0x00000002;
pub const PROXY_TYPE_AUTO_PROXY_URL: DWORD = 0x00000004;
pub const PROXY_TYPE_AUTO_DETECT: DWORD = 0x00000008;
pub const AUTO_PROXY_FLAG_USER_SET: DWORD = 0x00000001;
pub const AUTO_PROXY_FLAG_ALWAYS_DETECT: DWORD = 0x00000002;
pub const AUTO_PROXY_FLAG_DETECTION_RUN: DWORD = 0x00000004;
pub const AUTO_PROXY_FLAG_MIGRATED: DWORD = 0x00000008;
pub const AUTO_PROXY_FLAG_DONT_CACHE_PROXY_RESULT: DWORD = 0x00000010;
pub const AUTO_PROXY_FLAG_CACHE_INIT_RUN: DWORD = 0x00000020;
pub const AUTO_PROXY_FLAG_DETECTION_SUSPECT: DWORD = 0x00000040;
STRUCT!{struct INTERNET_VERSION_INFO {
    dwMajorVersion: DWORD,
    dwMinorVersion: DWORD,
}}
pub type LPINTERNET_VERSION_INFO = *mut INTERNET_VERSION_INFO;
STRUCT!{struct HTTP_VERSION_INFO {
    dwMajorVersion: DWORD,
    dwMinorVersion: DWORD,
}}
pub type LPHTTP_VERSION_INFO = *mut HTTP_VERSION_INFO;
STRUCT!{struct INTERNET_CONNECTED_INFO {
    dwConnectedState: DWORD,
    dwFlags: DWORD,
}}
pub type LPINTERNET_CONNECTED_INFO = *mut INTERNET_CONNECTED_INFO;
pub const ISO_FORCE_DISCONNECTED: DWORD = 0x00000001;
STRUCT!{struct URL_COMPONENTSA {
    dwStructSize: DWORD,
    lpszScheme: LPSTR,
    dwSchemeLength: DWORD,
    nScheme: INTERNET_SCHEME,
    lpszHostName: LPSTR,
    dwHostNameLength: DWORD,
    nPort: INTERNET_PORT,
    lpszUserName: LPSTR,
    dwUserNameLength: DWORD,
    lpszPassword: LPSTR,
    dwPasswordLength: DWORD,
    lpszUrlPath: LPSTR,
    dwUrlPathLength: DWORD,
    lpszExtraInfo: LPSTR,
    dwExtraInfoLength: DWORD,
}}
pub type LPURL_COMPONENTSA = *mut URL_COMPONENTSA;
STRUCT!{struct URL_COMPONENTSW {
    dwStructSize: DWORD,
    lpszScheme: LPWSTR,
    dwSchemeLength: DWORD,
    nScheme: INTERNET_SCHEME,
    lpszHostName: LPWSTR,
    dwHostNameLength: DWORD,
    nPort: INTERNET_PORT,
    lpszUserName: LPWSTR,
    dwUserNameLength: DWORD,
    lpszPassword: LPWSTR,
    dwPasswordLength: DWORD,
    lpszUrlPath: LPWSTR,
    dwUrlPathLength: DWORD,
    lpszExtraInfo: LPWSTR,
    dwExtraInfoLength: DWORD,
}}
pub type LPURL_COMPONENTSW = *mut URL_COMPONENTSW;
STRUCT!{struct INTERNET_CERTIFICATE_INFO {
    ftExpiry: FILETIME,
    ftStart: FILETIME,
    lpszSubjectInfo: LPWSTR,
    lpszIssuerInfo: LPWSTR,
    lpszProtocolName: LPWSTR,
    lpszSignatureAlgName: LPWSTR,
    lpszEncryptionAlgName: LPWSTR,
    dwKeySize: DWORD,
}}
pub type LPINTERNET_CERTIFICATE_INFO = *mut INTERNET_CERTIFICATE_INFO;
STRUCT!{struct INTERNET_BUFFERSA {
    dwStructSize: DWORD,
    Next: *mut INTERNET_BUFFERSA,
    lpcszHeader: LPCSTR,
    dwHeadersLength: DWORD,
    dwHeadersTotal: DWORD,
    lpvBuffer: LPVOID,
    dwBufferLength: DWORD,
    dwBufferTotal: DWORD,
    dwOffsetLow: DWORD,
    dwOffsetHigh: DWORD,
}}
pub type LPINTERNET_BUFFERSA = *mut INTERNET_BUFFERSA;
STRUCT!{struct INTERNET_BUFFERSW {
    dwStructSize: DWORD,
    Next: *mut INTERNET_BUFFERSW,
    lpcszHeader: LPCWSTR,
    dwHeadersLength: DWORD,
    dwHeadersTotal: DWORD,
    lpvBuffer: LPVOID,
    dwBufferLength: DWORD,
    dwBufferTotal: DWORD,
    dwOffsetLow: DWORD,
    dwOffsetHigh: DWORD,
}}
pub type LPINTERNET_BUFFERSW = *mut INTERNET_BUFFERSW;
pub const INTERNET_RFC1123_FORMAT: DWORD = 0;
pub const INTERNET_RFC1123_BUFSIZE: DWORD = 30;
pub const ICU_ESCAPE: DWORD = 0x80000000;
pub const ICU_USERNAME: DWORD = 0x40000000;
pub const ICU_NO_ENCODE: DWORD = 0x20000000;
pub const ICU_DECODE: DWORD = 0x10000000;
pub const ICU_NO_META: DWORD = 0x08000000;
pub const ICU_ENCODE_SPACES_ONLY: DWORD = 0x04000000;
pub const ICU_BROWSER_MODE: DWORD = 0x02000000;
pub const ICU_ENCODE_PERCENT: DWORD = 0x00001000;
pub const INTERNET_OPEN_TYPE_PRECONFIG: DWORD = 0;
pub const INTERNET_OPEN_TYPE_DIRECT: DWORD = 1;
pub const INTERNET_OPEN_TYPE_PROXY: DWORD = 3;
pub const INTERNET_OPEN_TYPE_PRECONFIG_WITH_NO_AUTOPROXY: DWORD = 4;
pub const PRE_CONFIG_INTERNET_ACCESS: DWORD = INTERNET_OPEN_TYPE_PRECONFIG;
pub const LOCAL_INTERNET_ACCESS: DWORD = INTERNET_OPEN_TYPE_DIRECT;
pub const CERN_PROXY_INTERNET_ACCESS: DWORD = INTERNET_OPEN_TYPE_PROXY;
pub const INTERNET_SERVICE_FTP: DWORD = 1;
pub const INTERNET_SERVICE_GOPHER: DWORD = 2;
pub const INTERNET_SERVICE_HTTP: DWORD = 3;
pub const IRF_ASYNC: DWORD = WININET_API_FLAG_ASYNC;
pub const IRF_SYNC: DWORD = WININET_API_FLAG_SYNC;
pub const IRF_USE_CONTEXT: DWORD = WININET_API_FLAG_USE_CONTEXT;
pub const IRF_NO_WAIT: DWORD = 0x00000008;
pub const ISO_GLOBAL: DWORD = 0x00000001;
pub const ISO_REGISTRY: DWORD = 0x00000002;
pub const ISO_VALID_FLAGS: DWORD = ISO_GLOBAL | ISO_REGISTRY;
pub const INTERNET_OPTION_CALLBACK: DWORD = 1;
pub const INTERNET_OPTION_CONNECT_TIMEOUT: DWORD = 2;
pub const INTERNET_OPTION_CONNECT_RETRIES: DWORD = 3;
pub const INTERNET_OPTION_CONNECT_BACKOFF: DWORD = 4;
pub const INTERNET_OPTION_SEND_TIMEOUT: DWORD = 5;
pub const INTERNET_OPTION_CONTROL_SEND_TIMEOUT: DWORD = INTERNET_OPTION_SEND_TIMEOUT;
pub const INTERNET_OPTION_RECEIVE_TIMEOUT: DWORD = 6;
pub const INTERNET_OPTION_CONTROL_RECEIVE_TIMEOUT: DWORD = INTERNET_OPTION_RECEIVE_TIMEOUT;
pub const INTERNET_OPTION_DATA_SEND_TIMEOUT: DWORD = 7;
pub const INTERNET_OPTION_DATA_RECEIVE_TIMEOUT: DWORD = 8;
pub const INTERNET_OPTION_HANDLE_TYPE: DWORD = 9;
pub const INTERNET_OPTION_LISTEN_TIMEOUT: DWORD = 11;
pub const INTERNET_OPTION_READ_BUFFER_SIZE: DWORD = 12;
pub const INTERNET_OPTION_WRITE_BUFFER_SIZE: DWORD = 13;
pub const INTERNET_OPTION_ASYNC_ID: DWORD = 15;
pub const INTERNET_OPTION_ASYNC_PRIORITY: DWORD = 16;
pub const INTERNET_OPTION_PARENT_HANDLE: DWORD = 21;
pub const INTERNET_OPTION_KEEP_CONNECTION: DWORD = 22;
pub const INTERNET_OPTION_REQUEST_FLAGS: DWORD = 23;
pub const INTERNET_OPTION_EXTENDED_ERROR: DWORD = 24;
pub const INTERNET_OPTION_OFFLINE_MODE: DWORD = 26;
pub const INTERNET_OPTION_CACHE_STREAM_HANDLE: DWORD = 27;
pub const INTERNET_OPTION_USERNAME: DWORD = 28;
pub const INTERNET_OPTION_PASSWORD: DWORD = 29;
pub const INTERNET_OPTION_ASYNC: DWORD = 30;
pub const INTERNET_OPTION_SECURITY_FLAGS: DWORD = 31;
pub const INTERNET_OPTION_SECURITY_CERTIFICATE_STRUCT: DWORD = 32;
pub const INTERNET_OPTION_DATAFILE_NAME: DWORD = 33;
pub const INTERNET_OPTION_URL: DWORD = 34;
pub const INTERNET_OPTION_SECURITY_CERTIFICATE: DWORD = 35;
pub const INTERNET_OPTION_SECURITY_KEY_BITNESS: DWORD = 36;
pub const INTERNET_OPTION_REFRESH: DWORD = 37;
pub const INTERNET_OPTION_PROXY: DWORD = 38;
pub const INTERNET_OPTION_SETTINGS_CHANGED: DWORD = 39;
pub const INTERNET_OPTION_VERSION: DWORD = 40;
pub const INTERNET_OPTION_USER_AGENT: DWORD = 41;
pub const INTERNET_OPTION_END_BROWSER_SESSION: DWORD = 42;
pub const INTERNET_OPTION_PROXY_USERNAME: DWORD = 43;
pub const INTERNET_OPTION_PROXY_PASSWORD: DWORD = 44;
pub const INTERNET_OPTION_CONTEXT_VALUE: DWORD = 45;
pub const INTERNET_OPTION_CONNECT_LIMIT: DWORD = 46;
pub const INTERNET_OPTION_SECURITY_SELECT_CLIENT_CERT: DWORD = 47;
pub const INTERNET_OPTION_POLICY: DWORD = 48;
pub const INTERNET_OPTION_DISCONNECTED_TIMEOUT: DWORD = 49;
pub const INTERNET_OPTION_CONNECTED_STATE: DWORD = 50;
pub const INTERNET_OPTION_IDLE_STATE: DWORD = 51;
pub const INTERNET_OPTION_OFFLINE_SEMANTICS: DWORD = 52;
pub const INTERNET_OPTION_SECONDARY_CACHE_KEY: DWORD = 53;
pub const INTERNET_OPTION_CALLBACK_FILTER: DWORD = 54;
pub const INTERNET_OPTION_CONNECT_TIME: DWORD = 55;
pub const INTERNET_OPTION_SEND_THROUGHPUT: DWORD = 56;
pub const INTERNET_OPTION_RECEIVE_THROUGHPUT: DWORD = 57;
pub const INTERNET_OPTION_REQUEST_PRIORITY: DWORD = 58;
pub const INTERNET_OPTION_HTTP_VERSION: DWORD = 59;
pub const INTERNET_OPTION_RESET_URLCACHE_SESSION: DWORD = 60;
pub const INTERNET_OPTION_ERROR_MASK: DWORD = 62;
pub const INTERNET_OPTION_FROM_CACHE_TIMEOUT: DWORD = 63;
pub const INTERNET_OPTION_BYPASS_EDITED_ENTRY: DWORD = 64;
pub const INTERNET_OPTION_HTTP_DECODING: DWORD = 65;
pub const INTERNET_OPTION_DIAGNOSTIC_SOCKET_INFO: DWORD = 67;
pub const INTERNET_OPTION_CODEPAGE: DWORD = 68;
pub const INTERNET_OPTION_CACHE_TIMESTAMPS: DWORD = 69;
pub const INTERNET_OPTION_DISABLE_AUTODIAL: DWORD = 70;
pub const INTERNET_OPTION_MAX_CONNS_PER_SERVER: DWORD = 73;
pub const INTERNET_OPTION_MAX_CONNS_PER_1_0_SERVER: DWORD = 74;
pub const INTERNET_OPTION_PER_CONNECTION_OPTION: DWORD = 75;
pub const INTERNET_OPTION_DIGEST_AUTH_UNLOAD: DWORD = 76;
pub const INTERNET_OPTION_IGNORE_OFFLINE: DWORD = 77;
pub const INTERNET_OPTION_IDENTITY: DWORD = 78;
pub const INTERNET_OPTION_REMOVE_IDENTITY: DWORD = 79;
pub const INTERNET_OPTION_ALTER_IDENTITY: DWORD = 80;
pub const INTERNET_OPTION_SUPPRESS_BEHAVIOR: DWORD = 81;
pub const INTERNET_OPTION_AUTODIAL_MODE: DWORD = 82;
pub const INTERNET_OPTION_AUTODIAL_CONNECTION: DWORD = 83;
pub const INTERNET_OPTION_CLIENT_CERT_CONTEXT: DWORD = 84;
pub const INTERNET_OPTION_AUTH_FLAGS: DWORD = 85;
pub const INTERNET_OPTION_COOKIES_3RD_PARTY: DWORD = 86;
pub const INTERNET_OPTION_DISABLE_PASSPORT_AUTH: DWORD = 87;
pub const INTERNET_OPTION_SEND_UTF8_SERVERNAME_TO_PROXY: DWORD = 88;
pub const INTERNET_OPTION_EXEMPT_CONNECTION_LIMIT: DWORD = 89;
pub const INTERNET_OPTION_ENABLE_PASSPORT_AUTH: DWORD = 90;
pub const INTERNET_OPTION_HIBERNATE_INACTIVE_WORKER_THREADS: DWORD = 91;
pub const INTERNET_OPTION_ACTIVATE_WORKER_THREADS: DWORD = 92;
pub const INTERNET_OPTION_RESTORE_WORKER_THREAD_DEFAULTS: DWORD = 93;
pub const INTERNET_OPTION_SOCKET_SEND_BUFFER_LENGTH: DWORD = 94;
pub const INTERNET_OPTION_PROXY_SETTINGS_CHANGED: DWORD = 95;
pub const INTERNET_OPTION_DATAFILE_EXT: DWORD = 96;
pub const INTERNET_OPTION_CODEPAGE_PATH: DWORD = 100;
pub const INTERNET_OPTION_CODEPAGE_EXTRA: DWORD = 101;
pub const INTERNET_OPTION_IDN: DWORD = 102;
pub const INTERNET_OPTION_MAX_CONNS_PER_PROXY: DWORD = 103;
pub const INTERNET_OPTION_SUPPRESS_SERVER_AUTH: DWORD = 104;
pub const INTERNET_OPTION_SERVER_CERT_CHAIN_CONTEXT: DWORD = 105;
pub const INTERNET_OPTION_ENABLE_REDIRECT_CACHE_READ: DWORD = 122;
pub const INTERNET_OPTION_ENCODE_EXTRA: DWORD = 155;
pub const INTERNET_FIRST_OPTION: DWORD = INTERNET_OPTION_CALLBACK;
pub const INTERNET_LAST_OPTION: DWORD = INTERNET_OPTION_ENCODE_EXTRA;
pub const INTERNET_PRIORITY_FOREGROUND: DWORD = 1000;
pub const INTERNET_HANDLE_TYPE_INTERNET: DWORD = 1;
pub const INTERNET_HANDLE_TYPE_CONNECT_FTP: DWORD = 2;
pub const INTERNET_HANDLE_TYPE_CONNECT_GOPHER: DWORD = 3;
pub const INTERNET_HANDLE_TYPE_CONNECT_HTTP: DWORD = 4;
pub const INTERNET_HANDLE_TYPE_FTP_FIND: DWORD = 5;
pub const INTERNET_HANDLE_TYPE_FTP_FIND_HTML: DWORD = 6;
pub const INTERNET_HANDLE_TYPE_FTP_FILE: DWORD = 7;
pub const INTERNET_HANDLE_TYPE_FTP_FILE_HTML: DWORD = 8;
pub const INTERNET_HANDLE_TYPE_GOPHER_FIND: DWORD = 9;
pub const INTERNET_HANDLE_TYPE_GOPHER_FIND_HTML: DWORD = 10;
pub const INTERNET_HANDLE_TYPE_GOPHER_FILE: DWORD = 11;
pub const INTERNET_HANDLE_TYPE_GOPHER_FILE_HTML: DWORD = 12;
pub const INTERNET_HANDLE_TYPE_HTTP_REQUEST: DWORD = 13;
pub const INTERNET_HANDLE_TYPE_FILE_REQUEST: DWORD = 14;
pub const AUTH_FLAG_DISABLE_NEGOTIATE: DWORD = 0x00000001;
pub const AUTH_FLAG_ENABLE_NEGOTIATE: DWORD = 0x00000002;
pub const AUTH_FLAG_DISABLE_BASIC_CLEARCHANNEL: DWORD = 0x00000004;
pub const AUTH_FLAG_DISABLE_SERVER_AUTH: DWORD = 0x00000008;
pub const SECURITY_FLAG_SECURE: DWORD = 0x00000001;
pub const SECURITY_FLAG_STRENGTH_WEAK: DWORD = 0x10000000;
pub const SECURITY_FLAG_STRENGTH_MEDIUM: DWORD = 0x40000000;
pub const SECURITY_FLAG_STRENGTH_STRONG: DWORD = 0x20000000;
pub const SECURITY_FLAG_UNKNOWNBIT: DWORD = 0x80000000;
pub const SECURITY_FLAG_FORTEZZA: DWORD = 0x08000000;
pub const SECURITY_FLAG_NORMALBITNESS: DWORD = SECURITY_FLAG_STRENGTH_WEAK;
pub const SECURITY_FLAG_SSL: DWORD = 0x00000002;
pub const SECURITY_FLAG_SSL3: DWORD = 0x00000004;
pub const SECURITY_FLAG_PCT: DWORD = 0x00000008;
pub const SECURITY_FLAG_PCT4: DWORD = 0x00000010;
pub const SECURITY_FLAG_IETFSSL4: DWORD = 0x00000020;
pub const SECURITY_FLAG_40BIT: DWORD = SECURITY_FLAG_STRENGTH_WEAK;
pub const SECURITY_FLAG_128BIT: DWORD = SECURITY_FLAG_STRENGTH_STRONG;
pub const SECURITY_FLAG_56BIT: DWORD = SECURITY_FLAG_STRENGTH_MEDIUM;
pub const SECURITY_FLAG_IGNORE_REVOCATION: DWORD = 0x00000080;
pub const SECURITY_FLAG_IGNORE_UNKNOWN_CA: DWORD = 0x00000100;
pub const SECURITY_FLAG_IGNORE_WRONG_USAGE: DWORD = 0x00000200;
pub const SECURITY_FLAG_IGNORE_CERT_CN_INVALID: DWORD = INTERNET_FLAG_IGNORE_CERT_CN_INVALID;
pub const SECURITY_FLAG_IGNORE_CERT_DATE_INVALID: DWORD = INTERNET_FLAG_IGNORE_CERT_DATE_INVALID;
pub const SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTPS: DWORD = INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS;
pub const SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTP: DWORD = INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP;
pub const SECURITY_SET_MASK: DWORD = SECURITY_FLAG_IGNORE_REVOCATION
    | SECURITY_FLAG_IGNORE_UNKNOWN_CA | SECURITY_FLAG_IGNORE_CERT_CN_INVALID
    | SECURITY_FLAG_IGNORE_CERT_DATE_INVALID | SECURITY_FLAG_IGNORE_WRONG_USAGE;
pub const AUTODIAL_MODE_NEVER: DWORD = 1;
pub const AUTODIAL_MODE_ALWAYS: DWORD = 2;
pub const AUTODIAL_MODE_NO_NETWORK_PRESENT: DWORD = 4;
FN!{stdcall INTERNET_STATUS_CALLBACK(
    HINTERNET,
    DWORD_PTR,
    DWORD,
    LPVOID,
    DWORD,
) -> ()}
pub type LPINTERNET_STATUS_CALLBACK = *mut INTERNET_STATUS_CALLBACK;
pub const INTERNET_STATUS_RESOLVING_NAME: DWORD = 10;
pub const INTERNET_STATUS_NAME_RESOLVED: DWORD = 11;
pub const INTERNET_STATUS_CONNECTING_TO_SERVER: DWORD = 20;
pub const INTERNET_STATUS_CONNECTED_TO_SERVER: DWORD = 21;
pub const INTERNET_STATUS_SENDING_REQUEST: DWORD = 30;
pub const INTERNET_STATUS_REQUEST_SENT: DWORD = 31;
pub const INTERNET_STATUS_RECEIVING_RESPONSE: DWORD = 40;
pub const INTERNET_STATUS_RESPONSE_RECEIVED: DWORD = 41;
pub const INTERNET_STATUS_CTL_RESPONSE_RECEIVED: DWORD = 42;
pub const INTERNET_STATUS_PREFETCH: DWORD = 43;
pub const INTERNET_STATUS_CLOSING_CONNECTION: DWORD = 50;
pub const INTERNET_STATUS_CONNECTION_CLOSED: DWORD = 51;
pub const INTERNET_STATUS_HANDLE_CREATED: DWORD = 60;
pub const INTERNET_STATUS_HANDLE_CLOSING: DWORD = 70;
pub const INTERNET_STATUS_DETECTING_PROXY: DWORD = 80;
pub const INTERNET_STATUS_REQUEST_COMPLETE: DWORD = 100;
pub const INTERNET_STATUS_REDIRECT: DWORD = 110;
pub const INTERNET_STATUS_INTERMEDIATE_RESPONSE: DWORD = 120;
pub const INTERNET_STATUS_USER_INPUT_REQUIRED: DWORD = 140;
pub const INTERNET_STATUS_STATE_CHANGE: DWORD = 200;
pub const INTERNET_STATUS_COOKIE_SENT: DWORD = 320;
pub const INTERNET_STATUS_COOKIE_RECEIVED: DWORD = 321;
pub const INTERNET_STATUS_PRIVACY_IMPACTED: DWORD = 324;
pub const INTERNET_STATUS_P3P_HEADER: DWORD = 325;
pub const INTERNET_STATUS_P3P_POLICYREF: DWORD = 326;
pub const INTERNET_STATUS_COOKIE_HISTORY: DWORD = 327;
pub const INTERNET_STATE_CONNECTED: DWORD = 0x00000001;
pub const INTERNET_STATE_DISCONNECTED: DWORD = 0x00000002;
pub const INTERNET_STATE_DISCONNECTED_BY_USER: DWORD = 0x00000010;
pub const INTERNET_STATE_IDLE: DWORD = 0x00000100;
pub const INTERNET_STATE_BUSY: DWORD = 0x00000200;
ENUM!{enum InternetCookieState {
    COOKIE_STATE_UNKNOWN = 0x0,
    COOKIE_STATE_ACCEPT = 0x1,
    COOKIE_STATE_PROMPT = 0x2,
    COOKIE_STATE_LEASH = 0x3,
    COOKIE_STATE_DOWNGRADE = 0x4,
    COOKIE_STATE_REJECT = 0x5,
    COOKIE_STATE_MAX = COOKIE_STATE_REJECT,
}}
STRUCT!{struct IncomingCookieState {
    cSession: c_int,
    cPersistent: c_int,
    cAccepted: c_int,
    cLeashed: c_int,
    cDowngraded: c_int,
    cBlocked: c_int,
    pszLocation: LPCSTR,
}}
STRUCT!{struct OutgoingCookieState {
    cSent: c_int,
    cSuppressed: c_int,
    pszLocation: LPCSTR,
}}
STRUCT!{struct InternetCookieHistory {
    fAccepted: BOOL,
    fLeashed: BOOL,
    fDowngraded: BOOL,
    fRejected: BOOL,
}}
STRUCT!{struct CookieDecision {
    dwCookieState: DWORD,
    fAllowSession: BOOL,
}}
pub const INTERNET_INVALID_STATUS_CALLBACK: usize = -1isize as usize;
pub const FTP_TRANSFER_TYPE_UNKNOWN: DWORD = 0x00000000;
pub const FTP_TRANSFER_TYPE_ASCII: DWORD = 0x00000001;
pub const FTP_TRANSFER_TYPE_BINARY: DWORD = 0x00000002;
pub const FTP_TRANSFER_TYPE_MASK: DWORD = FTP_TRANSFER_TYPE_ASCII | FTP_TRANSFER_TYPE_BINARY;
pub const MAX_GOPHER_DISPLAY_TEXT: usize = 128;
pub const MAX_GOPHER_SELECTOR_TEXT: usize = 256;
pub const MAX_GOPHER_HOST_NAME: usize = INTERNET_MAX_HOST_NAME_LENGTH;
pub const MAX_GOPHER_LOCATOR_LENGTH: usize = 1 + MAX_GOPHER_DISPLAY_TEXT + 1
    + MAX_GOPHER_SELECTOR_TEXT + 1 + MAX_GOPHER_HOST_NAME + 1 + INTERNET_MAX_PORT_NUMBER_LENGTH
    + 1 + 1 + 2;
STRUCT!{struct GOPHER_FIND_DATAA {
    DisplayString: [CHAR; MAX_GOPHER_DISPLAY_TEXT+ 1],
    GopherType: DWORD,
    SizeLow: DWORD,
    SizeHigh: DWORD,
    LastModificationTime: FILETIME,
    Locator: [CHAR; MAX_GOPHER_LOCATOR_LENGTH + 1],
}}
pub type LPGOPHER_FIND_DATAA = *mut GOPHER_FIND_DATAA;
STRUCT!{struct GOPHER_FIND_DATAW {
    DisplayString: [WCHAR; MAX_GOPHER_DISPLAY_TEXT+ 1],
    GopherType: DWORD,
    SizeLow: DWORD,
    SizeHigh: DWORD,
    LastModificationTime: FILETIME,
    Locator: [WCHAR; MAX_GOPHER_LOCATOR_LENGTH + 1],
}}
pub type LPGOPHER_FIND_DATAW = *mut GOPHER_FIND_DATAW;
pub const GOPHER_TYPE_TEXT_FILE: DWORD = 0x00000001;
pub const GOPHER_TYPE_DIRECTORY: DWORD = 0x00000002;
pub const GOPHER_TYPE_CSO: DWORD = 0x00000004;
pub const GOPHER_TYPE_ERROR: DWORD = 0x00000008;
pub const GOPHER_TYPE_MAC_BINHEX: DWORD = 0x00000010;
pub const GOPHER_TYPE_DOS_ARCHIVE: DWORD = 0x00000020;
pub const GOPHER_TYPE_UNIX_UUENCODED: DWORD = 0x00000040;
pub const GOPHER_TYPE_INDEX_SERVER: DWORD = 0x00000080;
pub const GOPHER_TYPE_TELNET: DWORD = 0x00000100;
pub const GOPHER_TYPE_BINARY: DWORD = 0x00000200;
pub const GOPHER_TYPE_REDUNDANT: DWORD = 0x00000400;
pub const GOPHER_TYPE_TN3270: DWORD = 0x00000800;
pub const GOPHER_TYPE_GIF: DWORD = 0x00001000;
pub const GOPHER_TYPE_IMAGE: DWORD = 0x00002000;
pub const GOPHER_TYPE_BITMAP: DWORD = 0x00004000;
pub const GOPHER_TYPE_MOVIE: DWORD = 0x00008000;
pub const GOPHER_TYPE_SOUND: DWORD = 0x00010000;
pub const GOPHER_TYPE_HTML: DWORD = 0x00020000;
pub const GOPHER_TYPE_PDF: DWORD = 0x00040000;
pub const GOPHER_TYPE_CALENDAR: DWORD = 0x00080000;
pub const GOPHER_TYPE_INLINE: DWORD = 0x00100000;
pub const GOPHER_TYPE_UNKNOWN: DWORD = 0x20000000;
pub const GOPHER_TYPE_ASK: DWORD = 0x40000000;
pub const GOPHER_TYPE_GOPHER_PLUS: DWORD = 0x80000000;
#[inline]
pub fn IS_GOPHER_FILE(type_: DWORD) -> BOOL {
    if (type_ & GOPHER_TYPE_FILE_MASK) != 0 { TRUE } else { FALSE }
}
#[inline]
pub fn IS_GOPHER_DIRECTORY(type_: DWORD) -> BOOL {
    if (type_ & GOPHER_TYPE_DIRECTORY) != 0 { TRUE } else { FALSE }
}
#[inline]
pub fn IS_GOPHER_PHONE_SERVER(type_: DWORD) -> BOOL {
    if (type_ & GOPHER_TYPE_CSO) != 0 { TRUE } else { FALSE }
}
#[inline]
pub fn IS_GOPHER_ERROR(type_: DWORD) -> BOOL {
    if (type_ & GOPHER_TYPE_ERROR) != 0 { TRUE } else { FALSE }
}
#[inline]
pub fn IS_GOPHER_INDEX_SERVER(type_: DWORD) -> BOOL {
    if (type_ & GOPHER_TYPE_INDEX_SERVER) != 0 { TRUE } else { FALSE }
}
#[inline]
pub fn IS_GOPHER_TELNET_SESSION(type_: DWORD) -> BOOL {
    if (type_ & GOPHER_TYPE_TELNET) != 0 { TRUE } else { FALSE }
}
#[inline]
pub fn IS_GOPHER_BACKUP_SERVER(type_: DWORD) -> BOOL {
    if (type_ & GOPHER_TYPE_REDUNDANT) != 0 { TRUE } else { FALSE }
}
#[inline]
pub fn IS_GOPHER_TN3270_SESSION(type_: DWORD) -> BOOL {
    if (type_ & GOPHER_TYPE_TN3270) != 0 { TRUE } else { FALSE }
}
#[inline]
pub fn IS_GOPHER_ASK(type_: DWORD) -> BOOL {
    if (type_ & GOPHER_TYPE_ASK) != 0 { TRUE } else { FALSE }
}
#[inline]
pub fn IS_GOPHER_PLUS(type_: DWORD) -> BOOL {
    if (type_ & GOPHER_TYPE_GOPHER_PLUS) != 0 { TRUE } else { FALSE }
}
#[inline]
pub fn IS_GOPHER_TYPE_KNOWN(type_: DWORD) -> BOOL {
    if (type_ & GOPHER_TYPE_UNKNOWN) != 0 { FALSE } else { TRUE }
}
pub const GOPHER_TYPE_FILE_MASK: DWORD = GOPHER_TYPE_TEXT_FILE | GOPHER_TYPE_MAC_BINHEX
    | GOPHER_TYPE_DOS_ARCHIVE | GOPHER_TYPE_UNIX_UUENCODED | GOPHER_TYPE_BINARY | GOPHER_TYPE_GIF
    | GOPHER_TYPE_IMAGE | GOPHER_TYPE_BITMAP | GOPHER_TYPE_MOVIE | GOPHER_TYPE_SOUND
    | GOPHER_TYPE_HTML | GOPHER_TYPE_PDF | GOPHER_TYPE_CALENDAR | GOPHER_TYPE_INLINE;
STRUCT!{struct GOPHER_ADMIN_ATTRIBUTE_TYPE {
    Comment: LPCWSTR,
    EmailAddress: LPCWSTR,
}}
pub type LPGOPHER_ADMIN_ATTRIBUTE_TYPE = *mut GOPHER_ADMIN_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_MOD_DATE_ATTRIBUTE_TYPE {
    DateAndTime: FILETIME,
}}
pub type LPGOPHER_MOD_DATE_ATTRIBUTE_TYPE = *mut GOPHER_MOD_DATE_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_TTL_ATTRIBUTE_TYPE {
    Ttl: DWORD,
}}
pub type LPGOPHER_TTL_ATTRIBUTE_TYPE = *mut GOPHER_TTL_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_SCORE_ATTRIBUTE_TYPE {
    Score: INT,
}}
pub type LPGOPHER_SCORE_ATTRIBUTE_TYPE = *mut GOPHER_SCORE_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE {
    LowerBound: INT,
    UpperBound: INT,
}}
pub type LPGOPHER_SCORE_RANGE_ATTRIBUTE_TYPE = *mut GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_SITE_ATTRIBUTE_TYPE {
    Site: LPCWSTR,
}}
pub type LPGOPHER_SITE_ATTRIBUTE_TYPE = *mut GOPHER_SITE_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_ORGANIZATION_ATTRIBUTE_TYPE {
    Organization: LPCWSTR,
}}
pub type LPGOPHER_ORGANIZATION_ATTRIBUTE_TYPE = *mut GOPHER_ORGANIZATION_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_LOCATION_ATTRIBUTE_TYPE {
    Location: LPCWSTR,
}}
pub type LPGOPHER_LOCATION_ATTRIBUTE_TYPE = *mut GOPHER_LOCATION_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE {
    DegreesNorth: INT,
    MinutesNorth: INT,
    SecondsNorth: INT,
    DegreesEast: INT,
    MinutesEast: INT,
    SecondsEast: INT,
}}
pub type LPGOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE =
    *mut GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_TIMEZONE_ATTRIBUTE_TYPE {
    Zone: INT,
}}
pub type LPGOPHER_TIMEZONE_ATTRIBUTE_TYPE = *mut GOPHER_TIMEZONE_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_PROVIDER_ATTRIBUTE_TYPE {
    Provider: LPCWSTR,
}}
pub type LPGOPHER_PROVIDER_ATTRIBUTE_TYPE = *mut GOPHER_PROVIDER_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_VERSION_ATTRIBUTE_TYPE {
    Version: LPCWSTR,
}}
pub type LPGOPHER_VERSION_ATTRIBUTE_TYPE = *mut GOPHER_VERSION_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_ABSTRACT_ATTRIBUTE_TYPE {
    ShortAbstract: LPCWSTR,
    AbstractFile: LPCWSTR,
}}
pub type LPGOPHER_ABSTRACT_ATTRIBUTE_TYPE = *mut GOPHER_ABSTRACT_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_VIEW_ATTRIBUTE_TYPE {
    ContentType: LPCWSTR,
    Language: LPCWSTR,
    Size: DWORD,
}}
pub type LPGOPHER_VIEW_ATTRIBUTE_TYPE = *mut GOPHER_VIEW_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_VERONICA_ATTRIBUTE_TYPE {
    TreeWalk: BOOL,
}}
pub type LPGOPHER_VERONICA_ATTRIBUTE_TYPE = *mut GOPHER_VERONICA_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_ASK_ATTRIBUTE_TYPE {
    QuestionType: LPCWSTR,
    QuestionText: LPCWSTR,
}}
pub type LPGOPHER_ASK_ATTRIBUTE_TYPE = *mut GOPHER_ASK_ATTRIBUTE_TYPE;
STRUCT!{struct GOPHER_UNKNOWN_ATTRIBUTE_TYPE {
    Text: LPCWSTR,
}}
pub type LPGOPHER_UNKNOWN_ATTRIBUTE_TYPE = *mut GOPHER_UNKNOWN_ATTRIBUTE_TYPE;
UNION!{union GOPHER_ATTRIBUTE_TYPE_AttributeType {
    [u32; 6] [u64; 3],
    Admin Admin_mut: GOPHER_ADMIN_ATTRIBUTE_TYPE,
    ModDate ModDate_mut: GOPHER_MOD_DATE_ATTRIBUTE_TYPE,
    Ttl Ttl_mut: GOPHER_TTL_ATTRIBUTE_TYPE,
    Score Score_mut: GOPHER_SCORE_ATTRIBUTE_TYPE,
    ScoreRange ScoreRange_mut: GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE,
    Site Site_mut: GOPHER_SITE_ATTRIBUTE_TYPE,
    Organization Organization_mut: GOPHER_ORGANIZATION_ATTRIBUTE_TYPE,
    Location Location_mut: GOPHER_LOCATION_ATTRIBUTE_TYPE,
    GeographicalLocation GeographicalLocation_mut: GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE,
    TimeZone TimeZone_mut: GOPHER_TIMEZONE_ATTRIBUTE_TYPE,
    Provider Provider_mut: GOPHER_PROVIDER_ATTRIBUTE_TYPE,
    Version Version_mut: GOPHER_VERSION_ATTRIBUTE_TYPE,
    Abstract Abstract_mut: GOPHER_ABSTRACT_ATTRIBUTE_TYPE,
    View View_mut: GOPHER_VIEW_ATTRIBUTE_TYPE,
    Veronica Veronica_mut: GOPHER_VERONICA_ATTRIBUTE_TYPE,
    Ask Ask_mut: GOPHER_ASK_ATTRIBUTE_TYPE,
    Unknown Unknown_mut: GOPHER_UNKNOWN_ATTRIBUTE_TYPE,
}}
STRUCT!{struct GOPHER_ATTRIBUTE_TYPE {
    CategoryId: DWORD,
    AttributeId: DWORD,
    AttributeType: GOPHER_ATTRIBUTE_TYPE_AttributeType,
}}
pub type LPGOPHER_ATTRIBUTE_TYPE = *mut GOPHER_ATTRIBUTE_TYPE;
pub const MAX_GOPHER_CATEGORY_NAME: DWORD = 128;
pub const MAX_GOPHER_ATTRIBUTE_NAME: DWORD = 128;
pub const MIN_GOPHER_ATTRIBUTE_LENGTH: DWORD = 256;
pub const GOPHER_INFO_CATEGORY: &'static str = " + INFO";
pub const GOPHER_ADMIN_CATEGORY: &'static str = " + ADMIN";
pub const GOPHER_VIEWS_CATEGORY: &'static str = " + VIEWS";
pub const GOPHER_ABSTRACT_CATEGORY: &'static str = " + ABSTRACT";
pub const GOPHER_VERONICA_CATEGORY: &'static str = " + VERONICA";
pub const GOPHER_ADMIN_ATTRIBUTE: &'static str = "Admin";
pub const GOPHER_MOD_DATE_ATTRIBUTE: &'static str = "Mod-Date";
pub const GOPHER_TTL_ATTRIBUTE: &'static str = "TTL";
pub const GOPHER_SCORE_ATTRIBUTE: &'static str = "Score";
pub const GOPHER_RANGE_ATTRIBUTE: &'static str = "Score-range";
pub const GOPHER_SITE_ATTRIBUTE: &'static str = "Site";
pub const GOPHER_ORG_ATTRIBUTE: &'static str = "Org";
pub const GOPHER_LOCATION_ATTRIBUTE: &'static str = "Loc";
pub const GOPHER_GEOG_ATTRIBUTE: &'static str = "Geog";
pub const GOPHER_TIMEZONE_ATTRIBUTE: &'static str = "TZ";
pub const GOPHER_PROVIDER_ATTRIBUTE: &'static str = "Provider";
pub const GOPHER_VERSION_ATTRIBUTE: &'static str = "Version";
pub const GOPHER_ABSTRACT_ATTRIBUTE: &'static str = "Abstract";
pub const GOPHER_VIEW_ATTRIBUTE: &'static str = "View";
pub const GOPHER_TREEWALK_ATTRIBUTE: &'static str = "treewalk";
pub const GOPHER_ATTRIBUTE_ID_BASE: DWORD = 0xabcccc00;
pub const GOPHER_CATEGORY_ID_ALL: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 1;
pub const GOPHER_CATEGORY_ID_INFO: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 2;
pub const GOPHER_CATEGORY_ID_ADMIN: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 3;
pub const GOPHER_CATEGORY_ID_VIEWS: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 4;
pub const GOPHER_CATEGORY_ID_ABSTRACT: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 5;
pub const GOPHER_CATEGORY_ID_VERONICA: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 6;
pub const GOPHER_CATEGORY_ID_ASK: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 7;
pub const GOPHER_CATEGORY_ID_UNKNOWN: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 8;
pub const GOPHER_ATTRIBUTE_ID_ALL: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 9;
pub const GOPHER_ATTRIBUTE_ID_ADMIN: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 10;
pub const GOPHER_ATTRIBUTE_ID_MOD_DATE: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 11;
pub const GOPHER_ATTRIBUTE_ID_TTL: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 12;
pub const GOPHER_ATTRIBUTE_ID_SCORE: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 13;
pub const GOPHER_ATTRIBUTE_ID_RANGE: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 14;
pub const GOPHER_ATTRIBUTE_ID_SITE: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 15;
pub const GOPHER_ATTRIBUTE_ID_ORG: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 16;
pub const GOPHER_ATTRIBUTE_ID_LOCATION: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 17;
pub const GOPHER_ATTRIBUTE_ID_GEOG: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 18;
pub const GOPHER_ATTRIBUTE_ID_TIMEZONE: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 19;
pub const GOPHER_ATTRIBUTE_ID_PROVIDER: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 20;
pub const GOPHER_ATTRIBUTE_ID_VERSION: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 21;
pub const GOPHER_ATTRIBUTE_ID_ABSTRACT: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 22;
pub const GOPHER_ATTRIBUTE_ID_VIEW: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 23;
pub const GOPHER_ATTRIBUTE_ID_TREEWALK: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 24;
pub const GOPHER_ATTRIBUTE_ID_UNKNOWN: DWORD = GOPHER_ATTRIBUTE_ID_BASE + 25;
FN!{stdcall GOPHER_ATTRIBUTE_ENUMERATOR(
    LPGOPHER_ATTRIBUTE_TYPE,
    DWORD,
) -> BOOL}
pub const HTTP_MAJOR_VERSION: DWORD = 1;
pub const HTTP_MINOR_VERSION: DWORD = 0;
pub const HTTP_VERSION: &'static str = "HTTP/1.0";
pub const HTTP_QUERY_MIME_VERSION: DWORD = 0;
pub const HTTP_QUERY_CONTENT_TYPE: DWORD = 1;
pub const HTTP_QUERY_CONTENT_TRANSFER_ENCODING: DWORD = 2;
pub const HTTP_QUERY_CONTENT_ID: DWORD = 3;
pub const HTTP_QUERY_CONTENT_DESCRIPTION: DWORD = 4;
pub const HTTP_QUERY_CONTENT_LENGTH: DWORD = 5;
pub const HTTP_QUERY_CONTENT_LANGUAGE: DWORD = 6;
pub const HTTP_QUERY_ALLOW: DWORD = 7;
pub const HTTP_QUERY_PUBLIC: DWORD = 8;
pub const HTTP_QUERY_DATE: DWORD = 9;
pub const HTTP_QUERY_EXPIRES: DWORD = 10;
pub const HTTP_QUERY_LAST_MODIFIED: DWORD = 11;
pub const HTTP_QUERY_MESSAGE_ID: DWORD = 12;
pub const HTTP_QUERY_URI: DWORD = 13;
pub const HTTP_QUERY_DERIVED_FROM: DWORD = 14;
pub const HTTP_QUERY_COST: DWORD = 15;
pub const HTTP_QUERY_LINK: DWORD = 16;
pub const HTTP_QUERY_PRAGMA: DWORD = 17;
pub const HTTP_QUERY_VERSION: DWORD = 18;
pub const HTTP_QUERY_STATUS_CODE: DWORD = 19;
pub const HTTP_QUERY_STATUS_TEXT: DWORD = 20;
pub const HTTP_QUERY_RAW_HEADERS: DWORD = 21;
pub const HTTP_QUERY_RAW_HEADERS_CRLF: DWORD = 22;
pub const HTTP_QUERY_CONNECTION: DWORD = 23;
pub const HTTP_QUERY_ACCEPT: DWORD = 24;
pub const HTTP_QUERY_ACCEPT_CHARSET: DWORD = 25;
pub const HTTP_QUERY_ACCEPT_ENCODING: DWORD = 26;
pub const HTTP_QUERY_ACCEPT_LANGUAGE: DWORD = 27;
pub const HTTP_QUERY_AUTHORIZATION: DWORD = 28;
pub const HTTP_QUERY_CONTENT_ENCODING: DWORD = 29;
pub const HTTP_QUERY_FORWARDED: DWORD = 30;
pub const HTTP_QUERY_FROM: DWORD = 31;
pub const HTTP_QUERY_IF_MODIFIED_SINCE: DWORD = 32;
pub const HTTP_QUERY_LOCATION: DWORD = 33;
pub const HTTP_QUERY_ORIG_URI: DWORD = 34;
pub const HTTP_QUERY_REFERER: DWORD = 35;
pub const HTTP_QUERY_RETRY_AFTER: DWORD = 36;
pub const HTTP_QUERY_SERVER: DWORD = 37;
pub const HTTP_QUERY_TITLE: DWORD = 38;
pub const HTTP_QUERY_USER_AGENT: DWORD = 39;
pub const HTTP_QUERY_WWW_AUTHENTICATE: DWORD = 40;
pub const HTTP_QUERY_PROXY_AUTHENTICATE: DWORD = 41;
pub const HTTP_QUERY_ACCEPT_RANGES: DWORD = 42;
pub const HTTP_QUERY_SET_COOKIE: DWORD = 43;
pub const HTTP_QUERY_COOKIE: DWORD = 44;
pub const HTTP_QUERY_REQUEST_METHOD: DWORD = 45;
pub const HTTP_QUERY_REFRESH: DWORD = 46;
pub const HTTP_QUERY_CONTENT_DISPOSITION: DWORD = 47;
pub const HTTP_QUERY_AGE: DWORD = 48;
pub const HTTP_QUERY_CACHE_CONTROL: DWORD = 49;
pub const HTTP_QUERY_CONTENT_BASE: DWORD = 50;
pub const HTTP_QUERY_CONTENT_LOCATION: DWORD = 51;
pub const HTTP_QUERY_CONTENT_MD5: DWORD = 52;
pub const HTTP_QUERY_CONTENT_RANGE: DWORD = 53;
pub const HTTP_QUERY_ETAG: DWORD = 54;
pub const HTTP_QUERY_HOST: DWORD = 55;
pub const HTTP_QUERY_IF_MATCH: DWORD = 56;
pub const HTTP_QUERY_IF_NONE_MATCH: DWORD = 57;
pub const HTTP_QUERY_IF_RANGE: DWORD = 58;
pub const HTTP_QUERY_IF_UNMODIFIED_SINCE: DWORD = 59;
pub const HTTP_QUERY_MAX_FORWARDS: DWORD = 60;
pub const HTTP_QUERY_PROXY_AUTHORIZATION: DWORD = 61;
pub const HTTP_QUERY_RANGE: DWORD = 62;
pub const HTTP_QUERY_TRANSFER_ENCODING: DWORD = 63;
pub const HTTP_QUERY_UPGRADE: DWORD = 64;
pub const HTTP_QUERY_VARY: DWORD = 65;
pub const HTTP_QUERY_VIA: DWORD = 66;
pub const HTTP_QUERY_WARNING: DWORD = 67;
pub const HTTP_QUERY_EXPECT: DWORD = 68;
pub const HTTP_QUERY_PROXY_CONNECTION: DWORD = 69;
pub const HTTP_QUERY_UNLESS_MODIFIED_SINCE: DWORD = 70;
pub const HTTP_QUERY_ECHO_REQUEST: DWORD = 71;
pub const HTTP_QUERY_ECHO_REPLY: DWORD = 72;
pub const HTTP_QUERY_ECHO_HEADERS: DWORD = 73;
pub const HTTP_QUERY_ECHO_HEADERS_CRLF: DWORD = 74;
pub const HTTP_QUERY_PROXY_SUPPORT: DWORD = 75;
pub const HTTP_QUERY_AUTHENTICATION_INFO: DWORD = 76;
pub const HTTP_QUERY_PASSPORT_URLS: DWORD = 77;
pub const HTTP_QUERY_PASSPORT_CONFIG: DWORD = 78;
pub const HTTP_QUERY_X_CONTENT_TYPE_OPTIONS: DWORD = 79;
pub const HTTP_QUERY_P3P: DWORD = 80;
pub const HTTP_QUERY_X_P2P_PEERDIST: DWORD = 81;
pub const HTTP_QUERY_TRANSLATE: DWORD = 82;
pub const HTTP_QUERY_X_UA_COMPATIBLE: DWORD = 83;
pub const HTTP_QUERY_DEFAULT_STYLE: DWORD = 84;
pub const HTTP_QUERY_X_FRAME_OPTIONS: DWORD = 85;
pub const HTTP_QUERY_X_XSS_PROTECTION: DWORD = 86;
pub const HTTP_QUERY_SET_COOKIE2: DWORD = 87;
pub const HTTP_QUERY_DO_NOT_TRACK: DWORD = 88;
pub const HTTP_QUERY_KEEP_ALIVE: DWORD = 89;
pub const HTTP_QUERY_MAX: DWORD = 89;
pub const HTTP_QUERY_CUSTOM: DWORD = 65535;
pub const HTTP_QUERY_FLAG_REQUEST_HEADERS: DWORD = 0x80000000;
pub const HTTP_QUERY_FLAG_SYSTEMTIME: DWORD = 0x40000000;
pub const HTTP_QUERY_FLAG_NUMBER: DWORD = 0x20000000;
pub const HTTP_QUERY_FLAG_COALESCE: DWORD = 0x10000000;
pub const HTTP_QUERY_FLAG_NUMBER64: DWORD = 0x08000000;
pub const HTTP_QUERY_MODIFIER_FLAGS_MASK: DWORD = HTTP_QUERY_FLAG_REQUEST_HEADERS
    | HTTP_QUERY_FLAG_SYSTEMTIME | HTTP_QUERY_FLAG_NUMBER | HTTP_QUERY_FLAG_COALESCE
    | HTTP_QUERY_FLAG_NUMBER64;
pub const HTTP_QUERY_HEADER_MASK: DWORD = !HTTP_QUERY_MODIFIER_FLAGS_MASK;
pub const HTTP_STATUS_CONTINUE: DWORD = 100;
pub const HTTP_STATUS_SWITCH_PROTOCOLS: DWORD = 101;
pub const HTTP_STATUS_OK: DWORD = 200;
pub const HTTP_STATUS_CREATED: DWORD = 201;
pub const HTTP_STATUS_ACCEPTED: DWORD = 202;
pub const HTTP_STATUS_PARTIAL: DWORD = 203;
pub const HTTP_STATUS_NO_CONTENT: DWORD = 204;
pub const HTTP_STATUS_RESET_CONTENT: DWORD = 205;
pub const HTTP_STATUS_PARTIAL_CONTENT: DWORD = 206;
pub const HTTP_STATUS_AMBIGUOUS: DWORD = 300;
pub const HTTP_STATUS_MOVED: DWORD = 301;
pub const HTTP_STATUS_REDIRECT: DWORD = 302;
pub const HTTP_STATUS_REDIRECT_METHOD: DWORD = 303;
pub const HTTP_STATUS_NOT_MODIFIED: DWORD = 304;
pub const HTTP_STATUS_USE_PROXY: DWORD = 305;
pub const HTTP_STATUS_REDIRECT_KEEP_VERB: DWORD = 307;
pub const HTTP_STATUS_BAD_REQUEST: DWORD = 400;
pub const HTTP_STATUS_DENIED: DWORD = 401;
pub const HTTP_STATUS_PAYMENT_REQ: DWORD = 402;
pub const HTTP_STATUS_FORBIDDEN: DWORD = 403;
pub const HTTP_STATUS_NOT_FOUND: DWORD = 404;
pub const HTTP_STATUS_BAD_METHOD: DWORD = 405;
pub const HTTP_STATUS_NONE_ACCEPTABLE: DWORD = 406;
pub const HTTP_STATUS_PROXY_AUTH_REQ: DWORD = 407;
pub const HTTP_STATUS_REQUEST_TIMEOUT: DWORD = 408;
pub const HTTP_STATUS_CONFLICT: DWORD = 409;
pub const HTTP_STATUS_GONE: DWORD = 410;
pub const HTTP_STATUS_LENGTH_REQUIRED: DWORD = 411;
pub const HTTP_STATUS_PRECOND_FAILED: DWORD = 412;
pub const HTTP_STATUS_REQUEST_TOO_LARGE: DWORD = 413;
pub const HTTP_STATUS_URI_TOO_LONG: DWORD = 414;
pub const HTTP_STATUS_UNSUPPORTED_MEDIA: DWORD = 415;
pub const HTTP_STATUS_RETRY_WITH: DWORD = 449;
pub const HTTP_STATUS_SERVER_ERROR: DWORD = 500;
pub const HTTP_STATUS_NOT_SUPPORTED: DWORD = 501;
pub const HTTP_STATUS_BAD_GATEWAY: DWORD = 502;
pub const HTTP_STATUS_SERVICE_UNAVAIL: DWORD = 503;
pub const HTTP_STATUS_GATEWAY_TIMEOUT: DWORD = 504;
pub const HTTP_STATUS_VERSION_NOT_SUP: DWORD = 505;
pub const HTTP_STATUS_FIRST: DWORD = HTTP_STATUS_CONTINUE;
pub const HTTP_STATUS_LAST: DWORD = HTTP_STATUS_VERSION_NOT_SUP;
pub const HTTP_ADDREQ_INDEX_MASK: DWORD = 0x0000FFFF;
pub const HTTP_ADDREQ_FLAGS_MASK: DWORD = 0xFFFF0000;
pub const HTTP_ADDREQ_FLAG_ADD_IF_NEW: DWORD = 0x10000000;
pub const HTTP_ADDREQ_FLAG_ADD: DWORD = 0x20000000;
pub const HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA: DWORD = 0x40000000;
pub const HTTP_ADDREQ_FLAG_COALESCE_WITH_SEMICOLON: DWORD = 0x01000000;
pub const HTTP_ADDREQ_FLAG_COALESCE: DWORD = HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA;
pub const HTTP_ADDREQ_FLAG_REPLACE: DWORD = 0x80000000;
pub const HSR_ASYNC: DWORD = WININET_API_FLAG_ASYNC;
pub const HSR_SYNC: DWORD = WININET_API_FLAG_SYNC;
pub const HSR_USE_CONTEXT: DWORD = WININET_API_FLAG_USE_CONTEXT;
pub const HSR_INITIATE: DWORD = 0x00000008;
pub const HSR_DOWNLOAD: DWORD = 0x00000010;
pub const HSR_CHUNKED: DWORD = 0x00000020;
STRUCT!{struct INTERNET_COOKIE2 {
    pwszName: PWSTR,
    pwszValue: PWSTR,
    pwszDomain: PWSTR,
    pwszPath: PWSTR,
    dwFlags: DWORD,
    ftExpires: FILETIME,
    fExpiresSet: BOOL,
}}
pub const INTERNET_COOKIE_IS_SECURE: DWORD = 0x01;
pub const INTERNET_COOKIE_IS_SESSION: DWORD = 0x02;
pub const INTERNET_COOKIE_THIRD_PARTY: DWORD = 0x10;
pub const INTERNET_COOKIE_PROMPT_REQUIRED: DWORD = 0x20;
pub const INTERNET_COOKIE_EVALUATE_P3P: DWORD = 0x40;
pub const INTERNET_COOKIE_APPLY_P3P: DWORD = 0x80;
pub const INTERNET_COOKIE_P3P_ENABLED: DWORD = 0x100;
pub const INTERNET_COOKIE_IS_RESTRICTED: DWORD = 0x200;
pub const INTERNET_COOKIE_IE6: DWORD = 0x400;
pub const INTERNET_COOKIE_IS_LEGACY: DWORD = 0x800;
pub const INTERNET_COOKIE_NON_SCRIPT: DWORD = 0x00001000;
pub const INTERNET_COOKIE_HTTPONLY: DWORD = 0x00002000;
pub const FLAG_ICC_FORCE_CONNECTION: DWORD = 0x00000001;
pub const FLAGS_ERROR_UI_FILTER_FOR_ERRORS: DWORD = 0x01;
pub const FLAGS_ERROR_UI_FLAGS_CHANGE_OPTIONS: DWORD = 0x02;
pub const FLAGS_ERROR_UI_FLAGS_GENERATE_DATA: DWORD = 0x04;
pub const FLAGS_ERROR_UI_FLAGS_NO_UI: DWORD = 0x08;
pub const FLAGS_ERROR_UI_SERIALIZE_DIALOGS: DWORD = 0x10;
FN!{stdcall PFN_AUTH_NOTIFY(
    DWORD_PTR,
    DWORD,
    LPVOID,
) -> DWORD}
STRUCT!{struct INTERNET_AUTH_NOTIFY_DATA {
    cbStruct: DWORD,
    dwOptions: DWORD,
    pfnNotify: PFN_AUTH_NOTIFY,
    dwContext: DWORD_PTR,
}}
pub const INTERNET_ERROR_BASE: DWORD = 12000;
pub const ERROR_INTERNET_OUT_OF_HANDLES: DWORD = INTERNET_ERROR_BASE + 1;
pub const ERROR_INTERNET_TIMEOUT: DWORD = INTERNET_ERROR_BASE + 2;
pub const ERROR_INTERNET_EXTENDED_ERROR: DWORD = INTERNET_ERROR_BASE + 3;
pub const ERROR_INTERNET_INTERNAL_ERROR: DWORD = INTERNET_ERROR_BASE + 4;
pub const ERROR_INTERNET_INVALID_URL: DWORD = INTERNET_ERROR_BASE + 5;
pub const ERROR_INTERNET_UNRECOGNIZED_SCHEME: DWORD = INTERNET_ERROR_BASE + 6;
pub const ERROR_INTERNET_NAME_NOT_RESOLVED: DWORD = INTERNET_ERROR_BASE + 7;
pub const ERROR_INTERNET_PROTOCOL_NOT_FOUND: DWORD = INTERNET_ERROR_BASE + 8;
pub const ERROR_INTERNET_INVALID_OPTION: DWORD = INTERNET_ERROR_BASE + 9;
pub const ERROR_INTERNET_BAD_OPTION_LENGTH: DWORD = INTERNET_ERROR_BASE + 10;
pub const ERROR_INTERNET_OPTION_NOT_SETTABLE: DWORD = INTERNET_ERROR_BASE + 11;
pub const ERROR_INTERNET_SHUTDOWN: DWORD = INTERNET_ERROR_BASE + 12;
pub const ERROR_INTERNET_INCORRECT_USER_NAME: DWORD = INTERNET_ERROR_BASE + 13;
pub const ERROR_INTERNET_INCORRECT_PASSWORD: DWORD = INTERNET_ERROR_BASE + 14;
pub const ERROR_INTERNET_LOGIN_FAILURE: DWORD = INTERNET_ERROR_BASE + 15;
pub const ERROR_INTERNET_INVALID_OPERATION: DWORD = INTERNET_ERROR_BASE + 16;
pub const ERROR_INTERNET_OPERATION_CANCELLED: DWORD = INTERNET_ERROR_BASE + 17;
pub const ERROR_INTERNET_INCORRECT_HANDLE_TYPE: DWORD = INTERNET_ERROR_BASE + 18;
pub const ERROR_INTERNET_INCORRECT_HANDLE_STATE: DWORD = INTERNET_ERROR_BASE + 19;
pub const ERROR_INTERNET_NOT_PROXY_REQUEST: DWORD = INTERNET_ERROR_BASE + 20;
pub const ERROR_INTERNET_REGISTRY_VALUE_NOT_FOUND: DWORD = INTERNET_ERROR_BASE + 21;
pub const ERROR_INTERNET_BAD_REGISTRY_PARAMETER: DWORD = INTERNET_ERROR_BASE + 22;
pub const ERROR_INTERNET_NO_DIRECT_ACCESS: DWORD = INTERNET_ERROR_BASE + 23;
pub const ERROR_INTERNET_NO_CONTEXT: DWORD = INTERNET_ERROR_BASE + 24;
pub const ERROR_INTERNET_NO_CALLBACK: DWORD = INTERNET_ERROR_BASE + 25;
pub const ERROR_INTERNET_REQUEST_PENDING: DWORD = INTERNET_ERROR_BASE + 26;
pub const ERROR_INTERNET_INCORRECT_FORMAT: DWORD = INTERNET_ERROR_BASE + 27;
pub const ERROR_INTERNET_ITEM_NOT_FOUND: DWORD = INTERNET_ERROR_BASE + 28;
pub const ERROR_INTERNET_CANNOT_CONNECT: DWORD = INTERNET_ERROR_BASE + 29;
pub const ERROR_INTERNET_CONNECTION_ABORTED: DWORD = INTERNET_ERROR_BASE + 30;
pub const ERROR_INTERNET_CONNECTION_RESET: DWORD = INTERNET_ERROR_BASE + 31;
pub const ERROR_INTERNET_FORCE_RETRY: DWORD = INTERNET_ERROR_BASE + 32;
pub const ERROR_INTERNET_INVALID_PROXY_REQUEST: DWORD = INTERNET_ERROR_BASE + 33;
pub const ERROR_INTERNET_NEED_UI: DWORD = INTERNET_ERROR_BASE + 34;
pub const ERROR_INTERNET_HANDLE_EXISTS: DWORD = INTERNET_ERROR_BASE + 36;
pub const ERROR_INTERNET_SEC_CERT_DATE_INVALID: DWORD = INTERNET_ERROR_BASE + 37;
pub const ERROR_INTERNET_SEC_CERT_CN_INVALID: DWORD = INTERNET_ERROR_BASE + 38;
pub const ERROR_INTERNET_HTTP_TO_HTTPS_ON_REDIR: DWORD = INTERNET_ERROR_BASE + 39;
pub const ERROR_INTERNET_HTTPS_TO_HTTP_ON_REDIR: DWORD = INTERNET_ERROR_BASE + 40;
pub const ERROR_INTERNET_MIXED_SECURITY: DWORD = INTERNET_ERROR_BASE + 41;
pub const ERROR_INTERNET_CHG_POST_IS_NON_SECURE: DWORD = INTERNET_ERROR_BASE + 42;
pub const ERROR_INTERNET_POST_IS_NON_SECURE: DWORD = INTERNET_ERROR_BASE + 43;
pub const ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED: DWORD = INTERNET_ERROR_BASE + 44;
pub const ERROR_INTERNET_INVALID_CA: DWORD = INTERNET_ERROR_BASE + 45;
pub const ERROR_INTERNET_CLIENT_AUTH_NOT_SETUP: DWORD = INTERNET_ERROR_BASE + 46;
pub const ERROR_INTERNET_ASYNC_THREAD_FAILED: DWORD = INTERNET_ERROR_BASE + 47;
pub const ERROR_INTERNET_REDIRECT_SCHEME_CHANGE: DWORD = INTERNET_ERROR_BASE + 48;
pub const ERROR_INTERNET_DIALOG_PENDING: DWORD = INTERNET_ERROR_BASE + 49;
pub const ERROR_INTERNET_RETRY_DIALOG: DWORD = INTERNET_ERROR_BASE + 50;
pub const ERROR_INTERNET_HTTPS_HTTP_SUBMIT_REDIR: DWORD = INTERNET_ERROR_BASE + 52;
pub const ERROR_INTERNET_INSERT_CDROM: DWORD = INTERNET_ERROR_BASE + 53;
pub const ERROR_INTERNET_FORTEZZA_LOGIN_NEEDED: DWORD = INTERNET_ERROR_BASE + 54;
pub const ERROR_INTERNET_SEC_CERT_ERRORS: DWORD = INTERNET_ERROR_BASE + 55;
pub const ERROR_INTERNET_SEC_CERT_NO_REV: DWORD = INTERNET_ERROR_BASE + 56;
pub const ERROR_INTERNET_SEC_CERT_REV_FAILED: DWORD = INTERNET_ERROR_BASE + 57;
pub const ERROR_FTP_TRANSFER_IN_PROGRESS: DWORD = INTERNET_ERROR_BASE + 110;
pub const ERROR_FTP_DROPPED: DWORD = INTERNET_ERROR_BASE + 111;
pub const ERROR_FTP_NO_PASSIVE_MODE: DWORD = INTERNET_ERROR_BASE + 112;
pub const ERROR_GOPHER_PROTOCOL_ERROR: DWORD = INTERNET_ERROR_BASE + 130;
pub const ERROR_GOPHER_NOT_FILE: DWORD = INTERNET_ERROR_BASE + 131;
pub const ERROR_GOPHER_DATA_ERROR: DWORD = INTERNET_ERROR_BASE + 132;
pub const ERROR_GOPHER_END_OF_DATA: DWORD = INTERNET_ERROR_BASE + 133;
pub const ERROR_GOPHER_INVALID_LOCATOR: DWORD = INTERNET_ERROR_BASE + 134;
pub const ERROR_GOPHER_INCORRECT_LOCATOR_TYPE: DWORD = INTERNET_ERROR_BASE + 135;
pub const ERROR_GOPHER_NOT_GOPHER_PLUS: DWORD = INTERNET_ERROR_BASE + 136;
pub const ERROR_GOPHER_ATTRIBUTE_NOT_FOUND: DWORD = INTERNET_ERROR_BASE + 137;
pub const ERROR_GOPHER_UNKNOWN_LOCATOR: DWORD = INTERNET_ERROR_BASE + 138;
pub const ERROR_HTTP_HEADER_NOT_FOUND: DWORD = INTERNET_ERROR_BASE + 150;
pub const ERROR_HTTP_DOWNLEVEL_SERVER: DWORD = INTERNET_ERROR_BASE + 151;
pub const ERROR_HTTP_INVALID_SERVER_RESPONSE: DWORD = INTERNET_ERROR_BASE + 152;
pub const ERROR_HTTP_INVALID_HEADER: DWORD = INTERNET_ERROR_BASE + 153;
pub const ERROR_HTTP_INVALID_QUERY_REQUEST: DWORD = INTERNET_ERROR_BASE + 154;
pub const ERROR_HTTP_HEADER_ALREADY_EXISTS: DWORD = INTERNET_ERROR_BASE + 155;
pub const ERROR_HTTP_REDIRECT_FAILED: DWORD = INTERNET_ERROR_BASE + 156;
pub const ERROR_HTTP_NOT_REDIRECTED: DWORD = INTERNET_ERROR_BASE + 160;
pub const ERROR_HTTP_COOKIE_NEEDS_CONFIRMATION: DWORD = INTERNET_ERROR_BASE + 161;
pub const ERROR_HTTP_COOKIE_DECLINED: DWORD = INTERNET_ERROR_BASE + 162;
pub const ERROR_HTTP_REDIRECT_NEEDS_CONFIRMATION: DWORD = INTERNET_ERROR_BASE + 168;
pub const ERROR_INTERNET_SECURITY_CHANNEL_ERROR: DWORD = INTERNET_ERROR_BASE + 157;
pub const ERROR_INTERNET_UNABLE_TO_CACHE_FILE: DWORD = INTERNET_ERROR_BASE + 158;
pub const ERROR_INTERNET_TCPIP_NOT_INSTALLED: DWORD = INTERNET_ERROR_BASE + 159;
pub const ERROR_INTERNET_DISCONNECTED: DWORD = INTERNET_ERROR_BASE + 163;
pub const ERROR_INTERNET_SERVER_UNREACHABLE: DWORD = INTERNET_ERROR_BASE + 164;
pub const ERROR_INTERNET_PROXY_SERVER_UNREACHABLE: DWORD = INTERNET_ERROR_BASE + 165;
pub const ERROR_INTERNET_BAD_AUTO_PROXY_SCRIPT: DWORD = INTERNET_ERROR_BASE + 166;
pub const ERROR_INTERNET_UNABLE_TO_DOWNLOAD_SCRIPT: DWORD = INTERNET_ERROR_BASE + 167;
pub const ERROR_INTERNET_SEC_INVALID_CERT: DWORD = INTERNET_ERROR_BASE + 169;
pub const ERROR_INTERNET_SEC_CERT_REVOKED: DWORD = INTERNET_ERROR_BASE + 170;
pub const ERROR_INTERNET_FAILED_DUETOSECURITYCHECK: DWORD = INTERNET_ERROR_BASE + 171;
pub const ERROR_INTERNET_NOT_INITIALIZED: DWORD = INTERNET_ERROR_BASE + 172;
pub const ERROR_INTERNET_NEED_MSN_SSPI_PKG: DWORD = INTERNET_ERROR_BASE + 173;
pub const ERROR_INTERNET_LOGIN_FAILURE_DISPLAY_ENTITY_BODY: DWORD = INTERNET_ERROR_BASE + 174;
pub const ERROR_INTERNET_DECODING_FAILED: DWORD = INTERNET_ERROR_BASE + 175;
pub const INTERNET_ERROR_LAST: DWORD = ERROR_INTERNET_DECODING_FAILED;
pub const NORMAL_CACHE_ENTRY: DWORD = 0x00000001;
pub const STICKY_CACHE_ENTRY: DWORD = 0x00000004;
pub const EDITED_CACHE_ENTRY: DWORD = 0x00000008;
pub const TRACK_OFFLINE_CACHE_ENTRY: DWORD = 0x00000010;
pub const TRACK_ONLINE_CACHE_ENTRY: DWORD = 0x00000020;
pub const SPARSE_CACHE_ENTRY: DWORD = 0x00010000;
pub const COOKIE_CACHE_ENTRY: DWORD = 0x00100000;
pub const URLHISTORY_CACHE_ENTRY: DWORD = 0x00200000;
pub const URLCACHE_FIND_DEFAULT_FILTER: DWORD = NORMAL_CACHE_ENTRY | COOKIE_CACHE_ENTRY
    | URLHISTORY_CACHE_ENTRY | TRACK_OFFLINE_CACHE_ENTRY | TRACK_ONLINE_CACHE_ENTRY
    | STICKY_CACHE_ENTRY;
UNION!{union INTERNET_CACHE_ENTRY_INFOA_u {
    [u32; 1],
    dwReserved dwReserved_mut: DWORD,
    dwExemptDelta dwExemptDelta_mut: DWORD,
}}
STRUCT!{struct INTERNET_CACHE_ENTRY_INFOA {
    dwStructSize: DWORD,
    lpszSourceUrlName: LPSTR,
    lpszLocalFileName: LPSTR,
    CacheEntryType: DWORD,
    dwUseCount: DWORD,
    dwHitRate: DWORD,
    dwSizeLow: DWORD,
    dwSizeHigh: DWORD,
    LastModifiedTime: FILETIME,
    ExpireTime: FILETIME,
    LastAccessTime: FILETIME,
    LastSyncTime: FILETIME,
    lpHeaderInfo: LPSTR,
    dwHeaderInfoSize: DWORD,
    lpszFileExtension: LPSTR,
    u: INTERNET_CACHE_ENTRY_INFOA_u,
}}
pub type LPINTERNET_CACHE_ENTRY_INFOA = *mut INTERNET_CACHE_ENTRY_INFOA;
UNION!{union INTERNET_CACHE_ENTRY_INFOW_u {
    [u32; 1],
    dwReserved dwReserved_mut: DWORD,
    dwExemptDelta dwExemptDelta_mut: DWORD,
}}
STRUCT!{struct INTERNET_CACHE_ENTRY_INFOW {
    dwStructSize: DWORD,
    lpszSourceUrlName: LPWSTR,
    lpszLocalFileName: LPWSTR,
    CacheEntryType: DWORD,
    dwUseCount: DWORD,
    dwHitRate: DWORD,
    dwSizeLow: DWORD,
    dwSizeHigh: DWORD,
    LastModifiedTime: FILETIME,
    ExpireTime: FILETIME,
    LastAccessTime: FILETIME,
    LastSyncTime: FILETIME,
    lpHeaderInfo: LPWSTR,
    dwHeaderInfoSize: DWORD,
    lpszFileExtension: LPWSTR,
    u: INTERNET_CACHE_ENTRY_INFOW_u,
}}
pub type LPINTERNET_CACHE_ENTRY_INFOW = *mut INTERNET_CACHE_ENTRY_INFOW;
STRUCT!{struct INTERNET_CACHE_TIMESTAMPS {
    ftExpires: FILETIME,
    ftLastModified: FILETIME,
}}
pub type LPINTERNET_CACHE_TIMESTAMPS = *mut INTERNET_CACHE_TIMESTAMPS;
pub type GROUPID = LONGLONG;
pub const CACHEGROUP_ATTRIBUTE_GET_ALL: DWORD = 0xffffffff;
pub const CACHEGROUP_ATTRIBUTE_BASIC: DWORD = 0x00000001;
pub const CACHEGROUP_ATTRIBUTE_FLAG: DWORD = 0x00000002;
pub const CACHEGROUP_ATTRIBUTE_TYPE: DWORD = 0x00000004;
pub const CACHEGROUP_ATTRIBUTE_QUOTA: DWORD = 0x00000008;
pub const CACHEGROUP_ATTRIBUTE_GROUPNAME: DWORD = 0x00000010;
pub const CACHEGROUP_ATTRIBUTE_STORAGE: DWORD = 0x00000020;
pub const CACHEGROUP_FLAG_NONPURGEABLE: DWORD = 0x00000001;
pub const CACHEGROUP_FLAG_GIDONLY: DWORD = 0x00000004;
pub const CACHEGROUP_FLAG_FLUSHURL_ONDELETE: DWORD = 0x00000002;
pub const CACHEGROUP_SEARCH_ALL: DWORD = 0x00000000;
pub const CACHEGROUP_SEARCH_BYURL: DWORD = 0x00000001;
pub const CACHEGROUP_TYPE_INVALID: DWORD = 0x00000001;
pub const CACHEGROUP_READWRITE_MASK: DWORD = CACHEGROUP_ATTRIBUTE_TYPE
    | CACHEGROUP_ATTRIBUTE_QUOTA | CACHEGROUP_ATTRIBUTE_GROUPNAME | CACHEGROUP_ATTRIBUTE_STORAGE;
pub const GROUPNAME_MAX_LENGTH: usize = 120;
pub const GROUP_OWNER_STORAGE_SIZE: usize = 4;
STRUCT!{struct INTERNET_CACHE_GROUP_INFOA {
    dwGroupSize: DWORD,
    dwGroupFlags: DWORD,
    dwGroupType: DWORD,
    dwDiskUsage: DWORD,
    dwDiskQuota: DWORD,
    dwOwnerStorage: [DWORD; GROUP_OWNER_STORAGE_SIZE],
    szGroupName: [CHAR; GROUPNAME_MAX_LENGTH],
}}
pub type LPINTERNET_CACHE_GROUP_INFOA = *mut INTERNET_CACHE_GROUP_INFOA;
STRUCT!{struct INTERNET_CACHE_GROUP_INFOW {
    dwGroupSize: DWORD,
    dwGroupFlags: DWORD,
    dwGroupType: DWORD,
    dwDiskUsage: DWORD,
    dwDiskQuota: DWORD,
    dwOwnerStorage: [DWORD; GROUP_OWNER_STORAGE_SIZE],
    szGroupName: [WCHAR; GROUPNAME_MAX_LENGTH],
}}
pub type LPINTERNET_CACHE_GROUP_INFOW = *mut INTERNET_CACHE_GROUP_INFOW;
pub const CACHE_ENTRY_ATTRIBUTE_FC: DWORD = 0x00000004;
pub const CACHE_ENTRY_HITRATE_FC: DWORD = 0x00000010;
pub const CACHE_ENTRY_MODTIME_FC: DWORD = 0x00000040;
pub const CACHE_ENTRY_EXPTIME_FC: DWORD = 0x00000080;
pub const CACHE_ENTRY_ACCTIME_FC: DWORD = 0x00000100;
pub const CACHE_ENTRY_SYNCTIME_FC: DWORD = 0x00000200;
pub const CACHE_ENTRY_HEADERINFO_FC: DWORD = 0x00000400;
pub const CACHE_ENTRY_EXEMPT_DELTA_FC: DWORD = 0x00000800;
pub const INTERNET_CACHE_GROUP_ADD: DWORD = 0;
pub const INTERNET_CACHE_GROUP_REMOVE: DWORD = 1;
pub const INTERNET_DIAL_FORCE_PROMPT: DWORD = 0x2000;
pub const INTERNET_DIAL_SHOW_OFFLINE: DWORD = 0x4000;
pub const INTERNET_DIAL_UNATTENDED: DWORD = 0x8000;
pub const INTERENT_GOONLINE_REFRESH: DWORD = 0x00000001;
pub const INTERENT_GOONLINE_NOPROMPT: DWORD = 0x00000002;
pub const INTERENT_GOONLINE_MASK: DWORD = 0x00000003;
pub const INTERNET_AUTODIAL_FORCE_ONLINE: DWORD = 1;
pub const INTERNET_AUTODIAL_FORCE_UNATTENDED: DWORD = 2;
pub const INTERNET_AUTODIAL_FAILIFSECURITYCHECK: DWORD = 4;
pub const INTERNET_AUTODIAL_OVERRIDE_NET_PRESENT: DWORD = 8;
pub const INTERNET_AUTODIAL_FLAGS_MASK: DWORD = INTERNET_AUTODIAL_FORCE_ONLINE
    | INTERNET_AUTODIAL_FORCE_UNATTENDED | INTERNET_AUTODIAL_FAILIFSECURITYCHECK
    | INTERNET_AUTODIAL_OVERRIDE_NET_PRESENT;
pub const PROXY_AUTO_DETECT_TYPE_DHCP: DWORD = 1;
pub const PROXY_AUTO_DETECT_TYPE_DNS_A: DWORD = 2;
STRUCT!{struct AutoProxyHelperVtbl {
    IsResolvable: Option<unsafe extern "system" fn(
        lpszHost: LPSTR,
    ) -> BOOL>,
    GetIPAddress: Option<unsafe extern "system" fn(
        lpszIPAddress: LPSTR,
        lpdwIPAddressSize: LPDWORD,
    ) -> DWORD>,
    ResolveHostName: Option<unsafe extern "system" fn(
        lpszHostName: LPSTR,
        lpszIPAddress: LPSTR,
        lpdwIPAddressSize: LPDWORD,
    ) -> DWORD>,
    IsInNet: Option<unsafe extern "system" fn(
        lpszIPAddress: LPSTR,
        lpszDest: LPSTR,
        lpszMask: LPSTR,
    ) -> BOOL>,
    IsResolvableEx: Option<unsafe extern "system" fn(
        lpszHost: LPSTR,
    ) -> BOOL>,
    GetIPAddressEx: Option<unsafe extern "system" fn(
        lpszIPAddress: LPSTR,
        lpdwIPAddressSize: LPDWORD,
    ) -> DWORD>,
    ResolveHostNameEx: Option<unsafe extern "system" fn(
        lpszHostName: LPSTR,
        lpszIPAddress: LPSTR,
        lpdwIPAddressSize: LPDWORD,
    ) -> DWORD>,
    IsInNetEx: Option<unsafe extern "system" fn(
        lpszIPAddress: LPSTR,
        lpszIPPrefix: LPSTR,
    ) -> BOOL>,
    SortIpList: Option<unsafe extern "system" fn(
        lpszIPAddressList: LPSTR,
        lpszIPSortedList: LPSTR,
        lpdwIPSortedListSize: LPDWORD,
    ) -> DWORD>,
}}
STRUCT!{struct AUTO_PROXY_SCRIPT_BUFFER {
    dwStructSize: DWORD,
    lpszScriptBuffer: LPSTR,
    dwScriptBufferSize: DWORD,
}}
pub type LPAUTO_PROXY_SCRIPT_BUFFER = *mut AUTO_PROXY_SCRIPT_BUFFER;
STRUCT!{struct AutoProxyHelperFunctions {
    lpVtbl: *const AutoProxyHelperVtbl,
}}
FN!{stdcall pfnInternetInitializeAutoProxyDll(
    DWORD,
    LPSTR,
    LPSTR,
    *mut AutoProxyHelperFunctions,
    LPAUTO_PROXY_SCRIPT_BUFFER,
) -> BOOL}
FN!{stdcall pfnInternetDeInitializeAutoProxyDll(
    LPSTR,
    DWORD,
) -> BOOL}
FN!{stdcall pfnInternetGetProxyInfo(
    LPCSTR,
    DWORD,
    LPSTR,
    DWORD,
    *mut LPSTR,
    LPDWORD,
) -> BOOL}
ENUM!{enum WPAD_CACHE_DELETE {
    WPAD_CACHE_DELETE_CURRENT = 0x0,
    WPAD_CACHE_DELETE_ALL = 0x1,
}}
pub const INTERNET_CONNECTION_MODEM: DWORD = 0x01;
pub const INTERNET_CONNECTION_LAN: DWORD = 0x02;
pub const INTERNET_CONNECTION_PROXY: DWORD = 0x04;
pub const INTERNET_CONNECTION_MODEM_BUSY: DWORD = 0x08;
pub const INTERNET_RAS_INSTALLED: DWORD = 0x10;
pub const INTERNET_CONNECTION_OFFLINE: DWORD = 0x20;
pub const INTERNET_CONNECTION_CONFIGURED: DWORD = 0x40;
FN!{stdcall PFN_DIAL_HANDLER(
    HWND,
    LPCSTR,
    DWORD,
    LPDWORD,
) -> DWORD}
pub const INTERNET_CUSTOMDIAL_CONNECT: DWORD = 0;
pub const INTERNET_CUSTOMDIAL_UNATTENDED: DWORD = 1;
pub const INTERNET_CUSTOMDIAL_DISCONNECT: DWORD = 2;
pub const INTERNET_CUSTOMDIAL_SHOWOFFLINE: DWORD = 4;
pub const INTERNET_CUSTOMDIAL_SAFE_FOR_UNATTENDED: DWORD = 1;
pub const INTERNET_CUSTOMDIAL_WILL_SUPPLY_STATE: DWORD = 2;
pub const INTERNET_CUSTOMDIAL_CAN_HANGUP: DWORD = 4;
pub const INTERNET_DIALSTATE_DISCONNECTED: DWORD = 1;
pub const INTERNET_IDENTITY_FLAG_PRIVATE_CACHE: DWORD = 0x01;
pub const INTERNET_IDENTITY_FLAG_SHARED_CACHE: DWORD = 0x02;
pub const INTERNET_IDENTITY_FLAG_CLEAR_DATA: DWORD = 0x04;
pub const INTERNET_IDENTITY_FLAG_CLEAR_COOKIES: DWORD = 0x08;
pub const INTERNET_IDENTITY_FLAG_CLEAR_HISTORY: DWORD = 0x10;
pub const INTERNET_IDENTITY_FLAG_CLEAR_CONTENT: DWORD = 0x20;
pub const INTERNET_SUPPRESS_RESET_ALL: DWORD = 0x00;
pub const INTERNET_SUPPRESS_COOKIE_POLICY: DWORD = 0x01;
pub const INTERNET_SUPPRESS_COOKIE_POLICY_RESET: DWORD = 0x02;
pub const PRIVACY_TEMPLATE_NO_COOKIES: DWORD = 0;
pub const PRIVACY_TEMPLATE_HIGH: DWORD = 1;
pub const PRIVACY_TEMPLATE_MEDIUM_HIGH: DWORD = 2;
pub const PRIVACY_TEMPLATE_MEDIUM: DWORD = 3;
pub const PRIVACY_TEMPLATE_MEDIUM_LOW: DWORD = 4;
pub const PRIVACY_TEMPLATE_LOW: DWORD = 5;
pub const PRIVACY_TEMPLATE_CUSTOM: DWORD = 100;
pub const PRIVACY_TEMPLATE_ADVANCED: DWORD = 101;
pub const PRIVACY_TEMPLATE_MAX: DWORD = PRIVACY_TEMPLATE_LOW;
pub const PRIVACY_TYPE_FIRST_PARTY: DWORD = 0;
pub const PRIVACY_TYPE_THIRD_PARTY: DWORD = 1;
extern "system" {
    pub fn CommitUrlCacheEntryA(
        lpszUrlName: LPCSTR,
        lpszLocalFileName: LPCSTR,
        ExpireTime: FILETIME,
        LastModifiedTime: FILETIME,
        CacheEntryType: DWORD,
        lpHeaderInfo: LPBYTE,
        cchHeaderInfo: DWORD,
        lpszFileExtension: LPCSTR,
        lpszOriginalUrl: LPCSTR,
    ) -> BOOL;
    pub fn CommitUrlCacheEntryW(
        lpszUrlName: LPCWSTR,
        lpszLocalFileName: LPCWSTR,
        ExpireTime: FILETIME,
        LastModifiedTime: FILETIME,
        CacheEntryType: DWORD,
        lpszHeaderInfo: LPWSTR,
        cchHeaderInfo: DWORD,
        lpszFileExtension: LPCWSTR,
        lpszOriginalUrl: LPCWSTR,
    ) -> BOOL;
    pub fn CreateMD5SSOHash (
        pszChallengeInfo: PWSTR,
        pwszRealm: PWSTR,
        pwszTarget: PWSTR,
        pbHexHash: PBYTE,
    ) -> BOOL;
    pub fn CreateUrlCacheEntryA(
        lpszUrlName: LPCSTR,
        dwExpectedFileSize: DWORD,
        lpszFileExtension: LPCSTR,
        lpszFileName: LPSTR,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn CreateUrlCacheEntryW(
        lpszUrlName: LPCWSTR,
        dwExpectedFileSize: DWORD,
        lpszFileExtension: LPCWSTR,
        lpszFileName: LPWSTR,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn CreateUrlCacheGroup(
        dwFlags: DWORD,
        lpReserved: LPVOID,
    ) -> GROUPID;
    pub fn DeleteUrlCacheEntryA(
        lpszUrlName: LPCSTR,
    ) -> BOOL;
    pub fn DeleteUrlCacheEntryW(
        lpszUrlName: LPCWSTR,
    ) -> BOOL;
    pub fn DeleteUrlCacheGroup(
        GroupId: GROUPID,
        dwFlags: DWORD,
        lpReserved: LPVOID,
    ) -> BOOL;
    pub fn DeleteWpadCacheForNetworks(
        arg0: WPAD_CACHE_DELETE,
    ) -> BOOL;
    pub fn DetectAutoProxyUrl(
        pszAutoProxyUrl: PSTR,
        cchAutoProxyUrl: DWORD,
        dwDetectFlags: DWORD,
    ) -> BOOL;
    pub fn FindCloseUrlCache(
        hEnumHandle: HANDLE,
    ) -> BOOL;
    pub fn FindFirstUrlCacheEntryA(
        lpszUrlSearchPattern: LPCSTR,
        lpFirstCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA,
        lpcbCacheEntryInfo: LPDWORD,
    ) -> HANDLE;
    pub fn FindFirstUrlCacheEntryExA(
        lpszUrlSearchPattern: LPCSTR,
        dwFlags: DWORD,
        dwFilter: DWORD,
        GroupId: GROUPID,
        lpFirstCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA,
        lpcbCacheEntryInfo: LPDWORD,
        lpGroupAttributes: LPVOID,
        lpcbGroupAttributes: LPDWORD,
        lpReserved: LPVOID,
    ) -> HANDLE;
    pub fn FindFirstUrlCacheEntryExW(
        lpszUrlSearchPattern: LPCWSTR,
        dwFlags: DWORD,
        dwFilter: DWORD,
        GroupId: GROUPID,
        lpFirstCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW,
        lpcbCacheEntryInfo: LPDWORD,
        lpGroupAttributes: LPVOID,
        lpcbGroupAttributes: LPDWORD,
        lpReserved: LPVOID,
    ) -> HANDLE;
    pub fn FindFirstUrlCacheEntryW(
        lpszUrlSearchPattern: LPCWSTR,
        lpFirstCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW,
        lpcbCacheEntryInfo: LPDWORD,
    ) -> HANDLE;
    pub fn FindFirstUrlCacheGroup(
        dwFlags: DWORD,
        dwFilter: DWORD,
        lpSearchCondition: LPVOID,
        dwSearchCondition: DWORD,
        lpGroupId: *mut GROUPID,
        lpReserved: LPVOID,
    ) -> HANDLE;
    pub fn FindNextUrlCacheEntryA(
        hEnumHandle: HANDLE,
        lpNextCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA,
        lpcbCacheEntryInfo: LPDWORD,
    ) -> BOOL;
    pub fn FindNextUrlCacheEntryExA(
        hEnumHandle: HANDLE,
        lpNextCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA,
        lpcbCacheEntryInfo: LPDWORD,
        lpGroupAttributes: LPVOID,
        lpcbGroupAttributes: LPDWORD,
        lpReserved: LPVOID,
    ) -> BOOL;
    pub fn FindNextUrlCacheEntryExW(
        hEnumHandle: HANDLE,
        lpNextCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW,
        lpcbCacheEntryInfo: LPDWORD,
        lpGroupAttributes: LPVOID,
        lpcbGroupAttributes: LPDWORD,
        lpReserved: LPVOID,
    ) -> BOOL;
    pub fn FindNextUrlCacheEntryW(
        hEnumHandle: HANDLE,
        lpNextCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW,
        lpcbCacheEntryInfo: LPDWORD,
    ) -> BOOL;
    pub fn FindNextUrlCacheGroup(
        hFind: HANDLE,
        lpGroupId: *mut GROUPID,
        lpReserved: LPVOID,
    ) -> BOOL;
    pub fn FtpCommandA(
        hConnect: HINTERNET,
        fExpectResponse: BOOL,
        dwFlags: DWORD,
        lpszCommand: LPCSTR,
        dwContext: DWORD_PTR,
        phFtpCommand: *mut HINTERNET,
    ) -> BOOL;
    pub fn FtpCommandW(
        hConnect: HINTERNET,
        fExpectResponse: BOOL,
        dwFlags: DWORD,
        lpszCommand: LPCWSTR,
        dwContext: DWORD_PTR,
        phFtpCommand: *mut HINTERNET,
    ) -> BOOL;
    pub fn FtpCreateDirectoryA(
        hConnect: HINTERNET,
        lpszDirectory: LPCSTR,
    ) -> BOOL;
    pub fn FtpCreateDirectoryW(
        hConnect: HINTERNET,
        lpszDirectory: LPCWSTR,
    ) -> BOOL;
    pub fn FtpDeleteFileA(
        hConnect: HINTERNET,
        lpszFileName: LPCSTR,
    ) -> BOOL;
    pub fn FtpDeleteFileW(
        hConnect: HINTERNET,
        lpszFileName: LPCWSTR,
    ) -> BOOL;
    pub fn FtpFindFirstFileA(
        hConnect: HINTERNET,
        lpszSearchFile: LPCSTR,
        lpFindFileData: LPWIN32_FIND_DATAA,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn FtpFindFirstFileW(
        hConnect: HINTERNET,
        lpszSearchFile: LPCWSTR,
        lpFindFileData: LPWIN32_FIND_DATAW,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn FtpGetCurrentDirectoryA(
        hConnect: HINTERNET,
        lpszCurrentDirectory: LPSTR,
        lpdwCurrentDirectory: LPDWORD,
    ) -> BOOL;
    pub fn FtpGetCurrentDirectoryW(
        hConnect: HINTERNET,
        lpszCurrentDirectory: LPWSTR,
        lpdwCurrentDirectory: LPDWORD,
    ) -> BOOL;
    pub fn FtpGetFileA(
        hConnect: HINTERNET,
        lpszRemoteFile: LPCSTR,
        lpszNewFile: LPCSTR,
        fFailIfExists: BOOL,
        dwFlagsAndAttributes: DWORD,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn FtpGetFileEx(
        hFtpSession: HINTERNET,
        lpszRemoteFile: LPCSTR,
        lpszNewFile: LPCWSTR,
        fFailIfExists: BOOL,
        dwFlagsAndAttributes: DWORD,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn FtpGetFileSize(
        hFile: HINTERNET,
        lpdwFileSizeHigh: LPDWORD,
    ) -> DWORD;
    pub fn FtpGetFileW(
        hConnect: HINTERNET,
        lpszRemoteFile: LPCWSTR,
        lpszNewFile: LPCWSTR,
        fFailIfExists: BOOL,
        dwFlagsAndAttributes: DWORD,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn FtpOpenFileA(
        hConnect: HINTERNET,
        lpszFileName: LPCSTR,
        dwAccess: DWORD,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn FtpOpenFileW(
        hConnect: HINTERNET,
        lpszFileName: LPCWSTR,
        dwAccess: DWORD,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn FtpPutFileA(
        hConnect: HINTERNET,
        lpszLocalFile: LPCSTR,
        lpszNewRemoteFile: LPCSTR,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn FtpPutFileEx(
        hFtpSession: HINTERNET,
        lpszLocalFile: LPCWSTR,
        lpszNewRemoteFile: LPCSTR,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn FtpPutFileW(
        hConnect: HINTERNET,
        lpszLocalFile: LPCWSTR,
        lpszNewRemoteFile: LPCWSTR,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn FtpRemoveDirectoryA(
        hConnect: HINTERNET,
        lpszDirectory: LPCSTR,
    ) -> BOOL;
    pub fn FtpRemoveDirectoryW(
        hConnect: HINTERNET,
        lpszDirectory: LPCWSTR,
    ) -> BOOL;
    pub fn FtpRenameFileA(
        hConnect: HINTERNET,
        lpszExisting: LPCSTR,
        lpszNew: LPCSTR,
    ) -> BOOL;
    pub fn FtpRenameFileW(
        hConnect: HINTERNET,
        lpszExisting: LPCWSTR,
        lpszNew: LPCWSTR,
    ) -> BOOL;
    pub fn FtpSetCurrentDirectoryA(
        hConnect: HINTERNET,
        lpszDirectory: LPCSTR,
    ) -> BOOL;
    pub fn FtpSetCurrentDirectoryW(
        hConnect: HINTERNET,
        lpszDirectory: LPCWSTR,
    ) -> BOOL;
    pub fn GetUrlCacheEntryInfoA(
        lpszUrlName: LPCSTR,
        lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA,
        lpcbCacheEntryInfo: LPDWORD,
    ) -> BOOL;
    pub fn GetUrlCacheEntryInfoExA(
        lpszUrl: LPCSTR,
        lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA,
        lpcbCacheEntryInfo: LPDWORD,
        lpszRedirectUrl: LPSTR,
        lpcbRedirectUrl: LPDWORD,
        lpReserved: LPVOID,
        dwFlags: DWORD,
    ) -> BOOL;
    pub fn GetUrlCacheEntryInfoExW(
        lpszUrl: LPCWSTR,
        lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW,
        lpcbCacheEntryInfo: LPDWORD,
        lpszRedirectUrl: LPWSTR,
        lpcbRedirectUrl: LPDWORD,
        lpReserved: LPVOID,
        dwFlags: DWORD,
    ) -> BOOL;
    pub fn GetUrlCacheEntryInfoW(
        lpszUrlName: LPCWSTR,
        lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW,
        lpcbCacheEntryInfo: LPDWORD,
    ) -> BOOL;
    pub fn GetUrlCacheGroupAttributeA(
        gid: GROUPID,
        dwFlags: DWORD,
        dwAttributes: DWORD,
        lpGroupInfo: LPINTERNET_CACHE_GROUP_INFOA,
        lpcbGroupInfo: LPDWORD,
        lpReserved: LPVOID,
    ) -> BOOL;
    pub fn GetUrlCacheGroupAttributeW(
        gid: GROUPID,
        dwFlags: DWORD,
        dwAttributes: DWORD,
        lpGroupInfo: LPINTERNET_CACHE_GROUP_INFOW,
        lpcbGroupInfo: LPDWORD,
        lpReserved: LPVOID,
    ) -> BOOL;
    pub fn GopherCreateLocatorA(
        lpszHost: LPCSTR,
        nServerPort: INTERNET_PORT,
        lpszDisplayString: LPCSTR,
        lpszSelectorString: LPCSTR,
        dwGopherType: DWORD,
        lpszLocator: LPSTR,
        lpdwBufferLength: LPDWORD,
    ) -> BOOL;
    pub fn GopherCreateLocatorW(
        lpszHost: LPCWSTR,
        nServerPort: INTERNET_PORT,
        lpszDisplayString: LPCWSTR,
        lpszSelectorString: LPCWSTR,
        dwGopherType: DWORD,
        lpszLocator: LPWSTR,
        lpdwBufferLength: LPDWORD,
    ) -> BOOL;
    pub fn GopherFindFirstFileA(
        hConnect: HINTERNET,
        lpszLocator: LPCSTR,
        lpszSearchString: LPCSTR,
        lpFindData: LPGOPHER_FIND_DATAA,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn GopherFindFirstFileW(
        hConnect: HINTERNET,
        lpszLocator: LPCWSTR,
        lpszSearchString: LPCWSTR,
        lpFindData: LPGOPHER_FIND_DATAW,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn GopherGetAttributeA(
        hConnect: HINTERNET,
        lpszLocator: LPCSTR,
        lpszAttributeName: LPCSTR,
        lpBuffer: LPBYTE,
        dwBufferLength: DWORD,
        lpdwCharactersReturned: LPDWORD,
        lpfnEnumerator: GOPHER_ATTRIBUTE_ENUMERATOR,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn GopherGetAttributeW(
        hConnect: HINTERNET,
        lpszLocator: LPCWSTR,
        lpszAttributeName: LPCWSTR,
        lpBuffer: LPBYTE,
        dwBufferLength: DWORD,
        lpdwCharactersReturned: LPDWORD,
        lpfnEnumerator: GOPHER_ATTRIBUTE_ENUMERATOR,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn GopherGetLocatorTypeA(
        lpszLocator: LPCSTR,
        lpdwGopherType: LPDWORD,
    ) -> BOOL;
    pub fn GopherGetLocatorTypeW(
        lpszLocator: LPCWSTR,
        lpdwGopherType: LPDWORD,
    ) -> BOOL;
    pub fn GopherOpenFileA(
        hConnect: HINTERNET,
        lpszLocator: LPCSTR,
        lpszView: LPCSTR,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn GopherOpenFileW(
        hConnect: HINTERNET,
        lpszLocator: LPCWSTR,
        lpszView: LPCWSTR,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn HttpAddRequestHeadersA(
        hRequest: HINTERNET,
        lpszHeaders: LPCSTR,
        dwHeadersLength: DWORD,
        dwModifiers: DWORD,
    ) -> BOOL;
    pub fn HttpAddRequestHeadersW(
        hRequest: HINTERNET,
        lpszHeaders: LPCWSTR,
        dwHeadersLength: DWORD,
        dwModifiers: DWORD,
    ) -> BOOL;
    pub fn HttpEndRequestA(
        hRequest: HINTERNET,
        lpBuffersOut: LPINTERNET_BUFFERSA,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn HttpEndRequestW(
        hRequest: HINTERNET,
        lpBuffersOut: LPINTERNET_BUFFERSW,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn HttpOpenRequestA(
        hConnect: HINTERNET,
        lpszVerb: LPCSTR,
        lpszObjectName: LPCSTR,
        lpszVersion: LPCSTR,
        lpszReferrer: LPCSTR,
        lplpszAcceptTypes: *mut LPCSTR,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn HttpOpenRequestW(
        hConnect: HINTERNET,
        lpszVerb: LPCWSTR,
        lpszObjectName: LPCWSTR,
        lpszVersion: LPCWSTR,
        lpszReferrer: LPCWSTR,
        lplpszAcceptTypes: *mut LPCWSTR,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn HttpQueryInfoA(
        hRequest: HINTERNET,
        dwInfoLevel: DWORD,
        lpBuffer: LPVOID,
        lpdwBufferLength: LPDWORD,
        lpdwIndex: LPDWORD,
    ) -> BOOL;
    pub fn HttpQueryInfoW(
        hRequest: HINTERNET,
        dwInfoLevel: DWORD,
        lpBuffer: LPVOID,
        lpdwBufferLength: LPDWORD,
        lpdwIndex: LPDWORD,
    ) -> BOOL;
    pub fn HttpSendRequestA(
        hRequest: HINTERNET,
        lpszHeaders: LPCSTR,
        dwHeadersLength: DWORD,
        lpOptional: LPVOID,
        dwOptionalLength: DWORD,
    ) -> BOOL;
    pub fn HttpSendRequestExA(
        hRequest: HINTERNET,
        lpBuffersIn: LPINTERNET_BUFFERSA,
        lpBuffersOut: LPINTERNET_BUFFERSA,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn HttpSendRequestExW(
        hRequest: HINTERNET,
        lpBuffersIn: LPINTERNET_BUFFERSW,
        lpBuffersOut: LPINTERNET_BUFFERSW,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn HttpSendRequestW(
        hRequest: HINTERNET,
        lpszHeaders: LPCWSTR,
        dwHeadersLength: DWORD,
        lpOptional: LPVOID,
        dwOptionalLength: DWORD,
    ) -> BOOL;
    pub fn InternetAttemptConnect(
        dwReserved: DWORD,
    ) -> DWORD;
    pub fn InternetAutodial(
        dwFlags: DWORD,
        hwndParent: HWND,
    ) -> BOOL;
    pub fn InternetAutodialHangup(
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn InternetCanonicalizeUrlA(
        lpszUrl: LPCSTR,
        lpszBuffer: LPSTR,
        lpdwBufferLength: LPDWORD,
        dwFlags: DWORD,
    ) -> BOOL;
    pub fn InternetCanonicalizeUrlW(
        lpszUrl: LPCWSTR,
        lpszBuffer: LPWSTR,
        lpdwBufferLength: LPDWORD,
        dwFlags: DWORD,
    ) -> BOOL;
    pub fn InternetCheckConnectionA(
        lpszUrl: LPCSTR,
        dwFlags: DWORD,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn InternetCheckConnectionW(
        lpszUrl: LPCWSTR,
        dwFlags: DWORD,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn InternetClearAllPerSiteCookieDecisions() -> BOOL;
    pub fn InternetCloseHandle(
        hInternet: HINTERNET,
    ) -> BOOL;
    pub fn InternetCombineUrlA(
        lpszBaseUrl: LPCSTR,
        lpszRelativeUrl: LPCSTR,
        lpszBuffer: LPSTR,
        lpdwBufferLength: LPDWORD,
        dwFlags: DWORD,
    ) -> BOOL;
    pub fn InternetCombineUrlW(
        lpszBaseUrl: LPCWSTR,
        lpszRelativeUrl: LPCWSTR,
        lpszBuffer: LPWSTR,
        lpdwBufferLength: LPDWORD,
        dwFlags: DWORD,
    ) -> BOOL;
    pub fn InternetConfirmZoneCrossingA(
        hWnd: HWND,
        szUrlPrev: LPSTR,
        szUrlNew: LPSTR,
        bPost: BOOL,
    ) -> DWORD;
    pub fn InternetConfirmZoneCrossingW(
        hWnd: HWND,
        szUrlPrev: LPWSTR,
        szUrlNew: LPWSTR,
        bPost: BOOL,
    ) -> DWORD;
    pub fn InternetConnectA(
        hInternet: HINTERNET,
        lpszServerName: LPCSTR,
        nServerPort: INTERNET_PORT,
        lpszUserName: LPCSTR,
        lpszPassword: LPCSTR,
        dwService: DWORD,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn InternetConnectW(
        hInternet: HINTERNET,
        lpszServerName: LPCWSTR,
        nServerPort: INTERNET_PORT,
        lpszUserName: LPCWSTR,
        lpszPassword: LPCWSTR,
        dwService: DWORD,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn InternetCrackUrlA(
        lpszUrl: LPCSTR,
        dwUrlLength: DWORD,
        dwFlags: DWORD,
        lpUrlComponents: LPURL_COMPONENTSA,
    ) -> BOOL;
    pub fn InternetCrackUrlW(
        lpszUrl: LPCWSTR,
        dwUrlLength: DWORD,
        dwFlags: DWORD,
        lpUrlComponents: LPURL_COMPONENTSW,
    ) -> BOOL;
    pub fn InternetCreateUrlA(
        lpUrlComponents: LPURL_COMPONENTSA,
        dwFlags: DWORD,
        lpszUrl: LPSTR,
        lpdwUrlLength: LPDWORD,
    ) -> BOOL;
    pub fn InternetCreateUrlW(
        lpUrlComponents: LPURL_COMPONENTSW,
        dwFlags: DWORD,
        lpszUrl: LPWSTR,
        lpdwUrlLength: LPDWORD,
    ) -> BOOL;
    pub fn InternetDialA(
        hwndParent: HWND,
        lpszConnectoid: LPSTR,
        dwFlags: DWORD,
        lpdwConnection: *mut DWORD_PTR,
        dwReserved: DWORD,
    ) -> DWORD;
    pub fn InternetDialW(
        hwndParent: HWND,
        lpszConnectoid: LPWSTR,
        dwFlags: DWORD,
        lpdwConnection: *mut DWORD_PTR,
        dwReserved: DWORD,
    ) -> DWORD;
    pub fn InternetEnumPerSiteCookieDecisionA(
        pszSiteName: LPSTR,
        pcSiteNameSize: *mut u32,
        pdwDecision: *mut u32,
        dwIndex: u32,
    ) -> BOOL;
    pub fn InternetEnumPerSiteCookieDecisionW(
        pszSiteName: LPWSTR,
        pcSiteNameSize: *mut u32,
        pdwDecision: *mut u32,
        dwIndex: u32,
    ) -> BOOL;
    pub fn InternetErrorDlg(
        hWnd: HWND,
        hRequest: HINTERNET,
        dwError: DWORD,
        dwFlags: DWORD,
        lppvData: *mut LPVOID,
    ) -> DWORD;
    pub fn InternetFindNextFileA(
        hFind: HINTERNET,
        lpvFindData: LPVOID,
    ) -> BOOL;
    pub fn InternetFindNextFileW(
        hFind: HINTERNET,
        lpvFindData: LPVOID,
    ) -> BOOL;
    pub fn InternetFreeCookies(
        pCookies: *mut INTERNET_COOKIE2,
        dwCookieCount: DWORD,
    ) -> ();
    pub fn InternetGetConnectedState(
        lpdwFlags: LPDWORD,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn InternetGetConnectedStateExA(
        lpdwFlags: LPDWORD,
        lpszConnectionName: LPSTR,
        cchNameLen: DWORD,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn InternetGetConnectedStateExW(
        lpdwFlags: LPDWORD,
        lpszConnectionName: LPWSTR,
        cchNameLen: DWORD,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn InternetGetCookieA(
        lpszUrl: LPCSTR,
        lpszCookieName: LPCSTR,
        lpszCookieData: LPSTR,
        lpdwSize: LPDWORD,
    ) -> BOOL;
    pub fn InternetGetCookieEx2(
        pcwszUrl: PCWSTR,
        pcwszCookieName: PCWSTR,
        dwFlags: DWORD,
        ppCookies: *mut *mut INTERNET_COOKIE2,
        pdwCookieCount: PDWORD,
    ) -> DWORD;
    pub fn InternetGetCookieExA(
        lpszUrl: LPCSTR,
        lpszCookieName: LPCSTR,
        lpszCookieData: LPSTR,
        lpdwSize: LPDWORD,
        dwFlags: DWORD,
        lpReserved: LPVOID,
    ) -> BOOL;
    pub fn InternetGetCookieExW(
        lpszUrl: LPCWSTR,
        lpszCookieName: LPCWSTR,
        lpszCookieData: LPWSTR,
        lpdwSize: LPDWORD,
        dwFlags: DWORD,
        lpReserved: LPVOID,
    ) -> BOOL;
    pub fn InternetGetCookieW(
        lpszUrl: LPCWSTR,
        lpszCookieName: LPCWSTR,
        lpszCookieData: LPWSTR,
        lpdwSize: LPDWORD,
    ) -> BOOL;
    pub fn InternetGetLastResponseInfoA(
        lpdwError: LPDWORD,
        lpszBuffer: LPSTR,
        lpdwBufferLength: LPDWORD,
    ) -> BOOL;
    pub fn InternetGetLastResponseInfoW(
        lpdwError: LPDWORD,
        lpszBuffer: LPWSTR,
        lpdwBufferLength: LPDWORD,
    ) -> BOOL;
    pub fn InternetGetPerSiteCookieDecisionA(
        pchHostName: LPCSTR,
        pResult: *mut u32,
    ) -> BOOL;
    pub fn InternetGetPerSiteCookieDecisionW(
        pchHostName: LPCWSTR,
        pResult: *mut u32,
    ) -> BOOL;
    pub fn InternetGoOnlineA(
        lpszURL: LPCSTR,
        hwndParent: HWND,
        dwFlags: DWORD,
    ) -> BOOL;
    pub fn InternetGoOnlineW(
        lpszURL: LPCWSTR,
        hwndParent: HWND,
        dwFlags: DWORD,
    ) -> BOOL;
    pub fn InternetHangUp(
        dwConnection: DWORD_PTR,
        dwReserved: DWORD,
    ) -> DWORD;
    pub fn InternetInitializeAutoProxyDll(
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn InternetLockRequestFile(
        hInternet: HINTERNET,
        lphLockRequestInfo: *mut HANDLE,
    ) -> BOOL;
    pub fn InternetOpenA(
        lpszAgent: LPCSTR,
        dwAccessType: DWORD,
        lpszProxy: LPCSTR,
        lpszProxyBypass: LPCSTR,
        dwFlags: DWORD,
    ) -> HINTERNET;
    pub fn InternetOpenUrlA(
        hInternet: HINTERNET,
        lpszUrl: LPCSTR,
        lpszHeaders: LPCSTR,
        dwHeadersLength: DWORD,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn InternetOpenUrlW(
        hInternet: HINTERNET,
        lpszUrl: LPCWSTR,
        lpszHeaders: LPCWSTR,
        dwHeadersLength: DWORD,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> HINTERNET;
    pub fn InternetOpenW(
        lpszAgent: LPCWSTR,
        dwAccessType: DWORD,
        lpszProxy: LPCWSTR,
        lpszProxyBypass: LPCWSTR,
        dwFlags: DWORD,
    ) -> HINTERNET;
    pub fn InternetQueryDataAvailable(
        hFile: HINTERNET,
        lpdwNumberOfBytesAvailable: LPDWORD,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn InternetQueryOptionA(
        hInternet: HINTERNET,
        dwOption: DWORD,
        lpBuffer: LPVOID,
        lpdwBufferLength: LPDWORD,
    ) -> BOOL;
    pub fn InternetQueryOptionW(
        hInternet: HINTERNET,
        dwOption: DWORD,
        lpBuffer: LPVOID,
        lpdwBufferLength: LPDWORD,
    ) -> BOOL;
    pub fn InternetReadFile(
        hFile: HINTERNET,
        lpBuffer: LPVOID,
        dwNumberOfBytesToRead: DWORD,
        lpdwNumberOfBytesRead: LPDWORD,
    ) -> BOOL;
    pub fn InternetReadFileExA(
        hFile: HINTERNET,
        lpBuffersOut: LPINTERNET_BUFFERSA,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn InternetReadFileExW(
        hFile: HINTERNET,
        lpBuffersOut: LPINTERNET_BUFFERSW,
        dwFlags: DWORD,
        dwContext: DWORD_PTR,
    ) -> BOOL;
    pub fn InternetSetCookieA(
        lpszUrl: LPCSTR,
        lpszCookieName: LPCSTR,
        lpszCookieData: LPCSTR,
    ) -> BOOL;
    pub fn InternetSetCookieEx2(
        pcwszUrl: PCWSTR,
        pCookie: *const INTERNET_COOKIE2,
        pcwszP3PPolicy: PCWSTR,
        dwFlags: DWORD,
        pdwCookieState: PDWORD,
    ) -> DWORD;
    pub fn InternetSetCookieExA(
        lpszUrl: LPCSTR,
        lpszCookieName: LPCSTR,
        lpszCookieData: LPCSTR,
        dwFlags: DWORD,
        dwReserved: DWORD_PTR,
    ) -> DWORD;
    pub fn InternetSetCookieExW(
        lpszUrl: LPCWSTR,
        lpszCookieName: LPCWSTR,
        lpszCookieData: LPCWSTR,
        dwFlags: DWORD,
        dwReserved: DWORD_PTR,
    ) -> DWORD;
    pub fn InternetSetCookieW(
        lpszUrl: LPCWSTR,
        lpszCookieName: LPCWSTR,
        lpszCookieData: LPCWSTR,
    ) -> BOOL;
    pub fn InternetSetDialStateA(
        lpszConnectoid: LPCSTR,
        dwState: DWORD,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn InternetSetDialStateW(
        lpszConnectoid: LPCWSTR,
        dwState: DWORD,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn InternetSetFilePointer(
        hFile: HINTERNET,
        lDistanceToMove: LONG,
        lpDistanceToMoveHigh: PLONG,
        dwMoveMethod: DWORD,
        dwContext: DWORD_PTR,
    ) -> DWORD;
    pub fn InternetSetOptionA(
        hInternet: HINTERNET,
        dwOption: DWORD,
        lpBuffer: LPVOID,
        dwBufferLength: DWORD,
    ) -> BOOL;
    pub fn InternetSetOptionExA(
        hInternet: HINTERNET,
        dwOption: DWORD,
        lpBuffer: LPVOID,
        dwBufferLength: DWORD,
        dwFlags: DWORD,
    ) -> BOOL;
    pub fn InternetSetOptionExW(
        hInternet: HINTERNET,
        dwOption: DWORD,
        lpBuffer: LPVOID,
        dwBufferLength: DWORD,
        dwFlags: DWORD,
    ) -> BOOL;
    pub fn InternetSetOptionW(
        hInternet: HINTERNET,
        dwOption: DWORD,
        lpBuffer: LPVOID,
        dwBufferLength: DWORD,
    ) -> BOOL;
    pub fn InternetSetPerSiteCookieDecisionA(
        pchHostName: LPCSTR,
        dwDecision: DWORD,
    ) -> BOOL;
    pub fn InternetSetPerSiteCookieDecisionW(
        pchHostName: LPCWSTR,
        dwDecision: DWORD,
    ) -> BOOL;
    pub fn InternetSetStatusCallbackA(
        hInternet: HINTERNET,
        lpfnInternetCallback: INTERNET_STATUS_CALLBACK,
    ) -> INTERNET_STATUS_CALLBACK;
    pub fn InternetSetStatusCallbackW(
        hInternet: HINTERNET,
        lpfnInternetCallback: INTERNET_STATUS_CALLBACK,
    ) -> INTERNET_STATUS_CALLBACK;
    pub fn InternetTimeFromSystemTimeA(
        pst: *const SYSTEMTIME,
        dwRFC: DWORD,
        lpszTime: LPSTR,
        cbTime: DWORD,
    ) -> BOOL;
    pub fn InternetTimeFromSystemTimeW(
        pst: *const SYSTEMTIME,
        dwRFC: DWORD,
        lpszTime: LPWSTR,
        cbTime: DWORD,
    ) -> BOOL;
    pub fn InternetTimeToSystemTimeA(
        lpszTime: LPCSTR,
        pst: *mut SYSTEMTIME,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn InternetTimeToSystemTimeW(
        lpszTime: LPCWSTR,
        pst: *mut SYSTEMTIME,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn InternetUnlockRequestFile(
        hLockRequestInfo: HANDLE,
    ) -> BOOL;
    pub fn InternetWriteFile(
        hFile: HINTERNET,
        lpBuffer: LPCVOID,
        dwNumberOfBytesToWrite: DWORD,
        lpdwNumberOfBytesWritten: LPDWORD,
    ) -> BOOL;
    pub fn PrivacyGetZonePreferenceW(
        dwZone: DWORD,
        dwType: DWORD,
        pdwTemplate: LPDWORD,
        pszBuffer: LPWSTR,
        pdwBufferLength: LPDWORD,
    ) -> DWORD;
    pub fn PrivacySetZonePreferenceW(
        dwZone: DWORD,
        dwType: DWORD,
        dwTemplate: DWORD,
        pszPreference: LPCWSTR,
    ) -> DWORD;
    pub fn ReadUrlCacheEntryStream(
        hUrlCacheStream: HANDLE,
        dwLocation: DWORD,
        lpBuffer: LPVOID,
        lpdwLen: LPDWORD,
        Reserved: DWORD,
    ) -> BOOL;
    pub fn ReadUrlCacheEntryStreamEx(
        hUrlCacheStream: HANDLE,
        qwLocation: DWORDLONG,
        lpBuffer: LPVOID,
        lpdwLen: LPDWORD,
    ) -> BOOL;
    pub fn ResumeSuspendedDownload(
        hRequest: HINTERNET,
        dwResultCode: DWORD,
    ) -> BOOL;
    pub fn RetrieveUrlCacheEntryFileA(
        lpszUrlName: LPCSTR,
        lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA,
        lpcbCacheEntryInfo: LPDWORD,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn RetrieveUrlCacheEntryFileW(
        lpszUrlName: LPCWSTR,
        lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW,
        lpcbCacheEntryInfo: LPDWORD,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn RetrieveUrlCacheEntryStreamA(
        lpszUrlName: LPCSTR,
        lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA,
        lpcbCacheEntryInfo: LPDWORD,
        fRandomRead: BOOL,
        dwReserved: DWORD,
    ) -> HANDLE;
    pub fn RetrieveUrlCacheEntryStreamW(
        lpszUrlName: LPCWSTR,
        lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW,
        lpcbCacheEntryInfo: LPDWORD,
        fRandomRead: BOOL,
        dwReserved: DWORD,
    ) -> HANDLE;
    pub fn SetUrlCacheEntryGroupA(
        lpszUrlName: LPCSTR,
        dwFlags: DWORD,
        GroupId: GROUPID,
        pbGroupAttributes: LPBYTE,
        cbGroupAttributes: DWORD,
        lpReserved: LPVOID,
    ) -> BOOL;
    pub fn SetUrlCacheEntryGroupW(
        lpszUrlName: LPCWSTR,
        dwFlags: DWORD,
        GroupId: GROUPID,
        pbGroupAttributes: LPBYTE,
        cbGroupAttributes: DWORD,
        lpReserved: LPVOID,
    ) -> BOOL;
    pub fn SetUrlCacheEntryInfoA(
        lpszUrlName: LPCSTR,
        lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA,
        dwFieldControl: DWORD,
    ) -> BOOL;
    pub fn SetUrlCacheEntryInfoW(
        lpszUrlName: LPCWSTR,
        lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW,
        dwFieldControl: DWORD,
    ) -> BOOL;
    pub fn SetUrlCacheGroupAttributeA(
        gid: GROUPID,
        dwFlags: DWORD,
        dwAttributes: DWORD,
        lpGroupInfo: LPINTERNET_CACHE_GROUP_INFOA,
        lpReserved: LPVOID,
    ) -> BOOL;
    pub fn SetUrlCacheGroupAttributeW(
        gid: GROUPID,
        dwFlags: DWORD,
        dwAttributes: DWORD,
        lpGroupInfo: LPINTERNET_CACHE_GROUP_INFOW,
        lpReserved: LPVOID,
    ) -> BOOL;
    pub fn UnlockUrlCacheEntryFileA(
        lpszUrlName: LPCSTR,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn UnlockUrlCacheEntryFileW(
        lpszUrlName: LPCWSTR,
        dwReserved: DWORD,
    ) -> BOOL;
    pub fn UnlockUrlCacheEntryStream(
        hUrlCacheStream: HANDLE,
        Reserved: DWORD,
    ) -> BOOL;
}
