/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.zaproxy.zap.utils.BoyerMooreMatcher;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class ContentMatcher {
    private static final String TAG_PATTERN = "Pattern";
    private static final String ATTRIBUTE_TYPE = "[@type]";
    private static final String TAG_PATTERN_TYPE_REGEX = "regex";
    private List<BoyerMooreMatcher> strings;
    private List<Pattern> patterns;

    public static ContentMatcher getInstance(String xmlFileName) {
        ContentMatcher cm = new ContentMatcher();
        try {
            cm.loadXMLPatternDefinitions(cm.getClass().getResourceAsStream(xmlFileName));
        }
        catch (ConfigurationException ex) {
            throw new IllegalArgumentException("Failed to initialize the ContentMatcher object using: " + xmlFileName, ex);
        }
        return cm;
    }

    public static ContentMatcher getInstance(InputStream xmlInputStream) {
        ContentMatcher cm = new ContentMatcher();
        try {
            cm.loadXMLPatternDefinitions(xmlInputStream);
        }
        catch (ConfigurationException ex) {
            throw new IllegalArgumentException("Failed to initialize the ContentMatcher object using that stream", ex);
        }
        return cm;
    }

    protected void loadXMLPatternDefinitions(InputStream xmlInputStream) throws ConfigurationException {
        this.strings = new ArrayList<BoyerMooreMatcher>();
        this.patterns = new ArrayList<Pattern>();
        ZapXmlConfiguration configuration = new ZapXmlConfiguration(xmlInputStream);
        for (HierarchicalConfiguration entry : configuration.configurationsAt(TAG_PATTERN)) {
            String value = entry.getString("", "");
            if (value.isEmpty()) continue;
            if (TAG_PATTERN_TYPE_REGEX.equalsIgnoreCase(entry.getString(ATTRIBUTE_TYPE))) {
                this.patterns.add(Pattern.compile(value));
                continue;
            }
            this.strings.add(new BoyerMooreMatcher(value));
        }
    }

    public String findInContent(String content) {
        for (BoyerMooreMatcher matcher : this.strings) {
            if (matcher.findInContent(content) < 0) continue;
            return matcher.getPattern();
        }
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            return matcher.group();
        }
        return null;
    }

    public List<String> findAllInContent(String content) {
        LinkedList<String> results = new LinkedList<String>();
        for (BoyerMooreMatcher matcher : this.strings) {
            if (matcher.findInContent(content) < 0) continue;
            results.add(matcher.getPattern());
        }
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            results.add(content);
        }
        return results;
    }

    List<Pattern> getPatterns() {
        return this.patterns;
    }

    List<BoyerMooreMatcher> getStrings() {
        return this.strings;
    }
}

