/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.properties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.Positionable;
import org.graalvm.visualvm.core.properties.PropertiesPanel;
import org.graalvm.visualvm.core.properties.PropertiesProvider;
import org.graalvm.visualvm.core.properties.PropertiesSupport;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.core.ui.components.SectionSeparator;
import org.graalvm.visualvm.core.ui.components.Spacer;

public final class PropertiesCustomizer<X extends DataSource>
extends PropertiesPanel {
    private final X dataSource;
    private final List<List<PropertiesProvider<X>>> groups;
    private final List<PropertiesPanel> panels;
    private final ChangeListener listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            PropertiesCustomizer.this.update();
        }
    };
    private JTabbedPane tabbedPane;
    private final Map<Integer, Integer> categories;

    PropertiesCustomizer(X dataSource, Class<X> type) {
        this.dataSource = dataSource;
        this.groups = PropertiesCustomizer.createGroups(PropertiesSupport.sharedInstance().getProviders(dataSource, type));
        this.panels = PropertiesCustomizer.createPanels(this.groups, dataSource);
        this.categories = new HashMap<Integer, Integer>();
        this.initComponents();
        this.update();
        this.registerListeners();
    }

    public void propertiesDefined(X dataSource) {
        this.unregisterListeners();
        for (int i = 0; i < this.groups.size(); ++i) {
            List<PropertiesProvider<X>> providers = this.groups.get(i);
            ArrayList<PropertiesPanel> categoriesPanels = new ArrayList<PropertiesPanel>();
            if (providers.size() == 1) {
                categoriesPanels.add(this.panels.get(i));
            } else {
                MultiPropertiesPanel multiPanel = (MultiPropertiesPanel)this.panels.get(i);
                categoriesPanels.addAll(multiPanel.getPanels());
            }
            for (int j = 0; j < providers.size(); ++j) {
                providers.get(j).propertiesDefined((PropertiesPanel)categoriesPanels.get(j), dataSource);
            }
        }
    }

    public void propertiesCancelled() {
        this.unregisterListeners();
        for (int i = 0; i < this.groups.size(); ++i) {
            List<PropertiesProvider<X>> providers = this.groups.get(i);
            ArrayList<PropertiesPanel> categoriesPanels = new ArrayList<PropertiesPanel>();
            if (providers.size() == 1) {
                categoriesPanels.add(this.panels.get(i));
            } else {
                MultiPropertiesPanel multiPanel = (MultiPropertiesPanel)this.panels.get(i);
                categoriesPanels.addAll(multiPanel.getPanels());
            }
            for (int j = 0; j < providers.size(); ++j) {
                providers.get(j).propertiesCancelled((PropertiesPanel)categoriesPanels.get(j), this.dataSource);
            }
        }
    }

    void propertiesChanged() {
        this.unregisterListeners();
        for (int i = 0; i < this.groups.size(); ++i) {
            List<PropertiesProvider<X>> providers = this.groups.get(i);
            ArrayList<PropertiesPanel> categoriesPanels = new ArrayList<PropertiesPanel>();
            if (providers.size() == 1) {
                categoriesPanels.add(this.panels.get(i));
            } else {
                MultiPropertiesPanel multiPanel = (MultiPropertiesPanel)this.panels.get(i);
                categoriesPanels.addAll(multiPanel.getPanels());
            }
            for (int j = 0; j < providers.size(); ++j) {
                providers.get(j).propertiesChanged((PropertiesPanel)categoriesPanels.get(j), this.dataSource);
            }
        }
    }

    void selectCategory(int category) {
        Integer tabIndex = this.categories.get(category);
        if (tabIndex != null) {
            this.tabbedPane.setSelectedIndex(tabIndex);
        }
    }

    private void registerListeners() {
        for (PropertiesPanel panel : this.panels) {
            panel.addChangeListener(this.listener);
        }
    }

    private void unregisterListeners() {
        for (PropertiesPanel panel : this.panels) {
            panel.removeChangeListener(this.listener);
        }
    }

    private void update() {
        for (PropertiesPanel panel : this.panels) {
            if (panel.settingsValid()) continue;
            this.setSettingsValid(false);
            return;
        }
        this.setSettingsValid(true);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFocusable(false);
        for (int i = 0; i < this.panels.size(); ++i) {
            PropertiesPanel panel = this.panels.get(i);
            PropertiesProvider<X> provider = this.groups.get(i).get(0);
            ScrollableContainer c = new ScrollableContainer(panel);
            c.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            c.setViewportBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.categories.put(provider.getPropertiesCategory(), this.tabbedPane.getTabCount());
            this.tabbedPane.addTab(provider.getPropertiesName(), null, c, provider.getPropertiesDescription());
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    private static <Y extends DataSource> List<List<PropertiesProvider<Y>>> createGroups(List<PropertiesProvider<Y>> providers) {
        providers.sort(new CategoriesComparator());
        ArrayList<List<PropertiesProvider<Y>>> groupedProviders = new ArrayList<List<PropertiesProvider<Y>>>();
        int currentCategory = -1;
        ArrayList<PropertiesProvider<Y>> currentGroup = null;
        for (PropertiesProvider<Y> provider : providers) {
            int providerCategory = provider.getPropertiesCategory();
            if (currentGroup == null || providerCategory != currentCategory) {
                currentCategory = providerCategory;
                if (currentGroup != null) {
                    Collections.sort(currentGroup, Positionable.COMPARATOR);
                }
                currentGroup = new ArrayList<PropertiesProvider<Y>>();
                groupedProviders.add(currentGroup);
            }
            if (currentGroup == null || currentCategory != providerCategory) continue;
            currentGroup.add(provider);
        }
        if (currentGroup != null) {
            Collections.sort(currentGroup, Positionable.COMPARATOR);
        }
        return groupedProviders;
    }

    private static <Y extends DataSource> List<PropertiesPanel> createPanels(List<List<PropertiesProvider<Y>>> groups, Y dataSource) {
        ArrayList<PropertiesPanel> panels = new ArrayList<PropertiesPanel>(groups.size());
        for (List<PropertiesProvider<Y>> group : groups) {
            if (group.size() == 1) {
                panels.add(group.get(0).createPanel(dataSource));
                continue;
            }
            panels.add(new MultiPropertiesPanel<Y>(group, dataSource));
        }
        return panels;
    }

    private static Color separatorColor() {
        Color color = UIManager.getColor("TitledBorder.titleColor");
        if (color == null) {
            color = new JLabel().getForeground();
        }
        return color;
    }

    private static Font separatorFont() {
        Font font = UIManager.getFont("TitledBorder.font");
        if (font == null) {
            font = new JLabel().getFont();
        }
        return font;
    }

    static /* synthetic */ Color access$200() {
        return PropertiesCustomizer.separatorColor();
    }

    static /* synthetic */ Font access$300() {
        return PropertiesCustomizer.separatorFont();
    }

    private static class CategoriesComparator
    implements Comparator {
        private CategoriesComparator() {
        }

        public int compare(Object o1, Object o2) {
            int category2;
            PropertiesProvider p1 = (PropertiesProvider)o1;
            PropertiesProvider p2 = (PropertiesProvider)o2;
            int category1 = p1.getPropertiesCategory();
            if (category1 > (category2 = p2.getPropertiesCategory())) {
                return 1;
            }
            if (category1 < category2) {
                return -1;
            }
            return p1.getPropertiesName().compareTo(p2.getPropertiesName());
        }
    }

    private static class MultiPropertiesPanel<Y extends DataSource>
    extends PropertiesPanel {
        private static final Color separatorColor = PropertiesCustomizer.access$200();
        private static final Font separatorFont = PropertiesCustomizer.access$300();
        private final List<PropertiesPanel> panels;
        private final ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                this.update();
            }
        };

        MultiPropertiesPanel(List<PropertiesProvider<Y>> providers, Y dataSource) {
            this.panels = new ArrayList<PropertiesPanel>(providers.size());
            for (PropertiesProvider<Y> provider : providers) {
                this.panels.add(provider.createPanel(dataSource));
            }
            this.initComponents(providers);
            this.update();
        }

        public List<PropertiesPanel> getPanels() {
            return this.panels;
        }

        private void update() {
            boolean valid = true;
            for (PropertiesPanel panel : this.panels) {
                if (panel.settingsValid()) continue;
                valid = false;
                break;
            }
            this.setSettingsValid(valid);
        }

        private void initComponents(List<PropertiesProvider<Y>> providers) {
            GridBagConstraints constraints;
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setLayout(new GridBagLayout());
            int currentRow = 0;
            int providerIndex = 1;
            for (PropertiesPanel panel : this.panels) {
                constraints = MultiPropertiesPanel.createConstraints(currentRow++);
                this.add((Component)panel, constraints);
                panel.addChangeListener(this.listener);
                if (providerIndex >= providers.size()) continue;
                PropertiesProvider<Y> provider = providers.get(providerIndex++);
                SectionSeparator separator = new SectionSeparator(provider.getPropertiesName());
                separator.setForeground(separatorColor);
                separator.setFont(separatorFont);
                separator.setToolTipText(provider.getPropertiesDescription());
                constraints = MultiPropertiesPanel.createConstraints(currentRow++);
                constraints.insets = new Insets(10, 0, 5, 0);
                this.add((Component)separator, constraints);
            }
            constraints = MultiPropertiesPanel.createConstraints(currentRow++);
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            this.add((Component)Spacer.create(), constraints);
        }

        private static GridBagConstraints createConstraints(int row) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = row;
            c.gridwidth = 0;
            c.anchor = 18;
            c.fill = 1;
            return c;
        }
    }
}

