/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.monitor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.graalvm.visualvm.lib.jfluid.results.monitor.VMTelemetryDataManager;
import org.graalvm.visualvm.lib.ui.graphs.CPUGraphPanel;
import org.graalvm.visualvm.lib.ui.graphs.GraphPanel;
import org.graalvm.visualvm.lib.ui.graphs.MemoryGraphPanel;
import org.graalvm.visualvm.lib.ui.graphs.SurvivingGenerationsGraphPanel;
import org.graalvm.visualvm.lib.ui.graphs.ThreadsGraphPanel;
import org.graalvm.visualvm.lib.ui.monitor.VMTelemetryModels;

public class MonitorView
extends JPanel {
    private VMTelemetryModels models;
    private GraphPanel cpuPanel;
    private GraphPanel memoryPanel;
    private GraphPanel gcPanel;
    private GraphPanel threadsPanel;

    public MonitorView(VMTelemetryDataManager dataManager) {
        this.initUI(dataManager);
    }

    public void setupCPUView(boolean visible) {
        this.cpuPanel.setVisible(visible);
    }

    public void setupMemoryView(boolean visible) {
        this.memoryPanel.setVisible(visible);
    }

    public void setupGCView(boolean visible) {
        this.gcPanel.setVisible(visible);
    }

    public void setupThreadsView(boolean visible) {
        this.threadsPanel.setVisible(visible);
    }

    public void cleanup() {
        this.cpuPanel.cleanup();
        this.memoryPanel.cleanup();
        this.gcPanel.cleanup();
        this.threadsPanel.cleanup();
        this.models.cleanup();
    }

    private void initUI(VMTelemetryDataManager dataManager) {
        this.setLayout(new GraphsLayout());
        this.models = new VMTelemetryModels(dataManager);
        this.cpuPanel = CPUGraphPanel.createBigPanel(this.models);
        this.add(this.cpuPanel);
        this.memoryPanel = MemoryGraphPanel.createBigPanel(this.models);
        this.add(this.memoryPanel);
        this.gcPanel = SurvivingGenerationsGraphPanel.createBigPanel(this.models);
        this.add(this.gcPanel);
        this.threadsPanel = ThreadsGraphPanel.createBigPanel(this.models);
        this.add(this.threadsPanel);
    }

    private class GraphsLayout
    implements LayoutManager {
        private GraphsLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int w2;
            int w1;
            int w = MonitorView.this.getWidth();
            int h = MonitorView.this.getHeight();
            boolean c = MonitorView.this.cpuPanel.isVisible();
            boolean m = MonitorView.this.memoryPanel.isVisible();
            boolean g = MonitorView.this.gcPanel.isVisible();
            boolean t = MonitorView.this.threadsPanel.isVisible();
            int h1 = c || m ? (g || t ? h / 2 : h) : 0;
            int h2 = h - h1;
            if (h1 > 0) {
                if (c && m) {
                    w1 = w / 2;
                    w2 = w - w1;
                    MonitorView.this.cpuPanel.setBounds(0, 0, w1, h1);
                    MonitorView.this.memoryPanel.setBounds(w1, 0, w2, h1);
                } else if (c) {
                    MonitorView.this.cpuPanel.setBounds(0, 0, w, h1);
                } else {
                    MonitorView.this.memoryPanel.setBounds(0, 0, w, h1);
                }
            }
            if (h2 > 0) {
                if (g && t) {
                    w1 = w / 2;
                    w2 = w - w1;
                    MonitorView.this.gcPanel.setBounds(0, h1, w1, h2);
                    MonitorView.this.threadsPanel.setBounds(w1, h1, w2, h2);
                } else if (g) {
                    MonitorView.this.gcPanel.setBounds(0, h1, w, h2);
                } else {
                    MonitorView.this.threadsPanel.setBounds(0, h1, w, h2);
                }
            }
        }
    }
}

