/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.coredump.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.DataChangeEvent;
import org.graalvm.visualvm.core.datasupport.DataChangeListener;
import org.graalvm.visualvm.core.datasupport.Positionable;
import org.graalvm.visualvm.core.snapshot.RegisteredSnapshotCategories;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.NotSupportedDisplayer;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.uisupport.HTMLTextArea;
import org.openide.util.NbBundle;

public final class OverviewViewSupport {

    static class SystemPropertiesViewSupport
    extends JPanel {
        SystemPropertiesViewSupport(Properties properties) {
            this.initComponents(properties);
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_System_properties"), null, 20, (JComponent)this, null);
        }

        private void initComponents(Properties properties) {
            NotSupportedDisplayer contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (properties != null) {
                HTMLTextArea area = new HTMLTextArea("<nobr>" + this.formatSystemProperties(properties) + "</nobr>");
                area.setCaretPosition(0);
                area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                contents = area;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.JVM);
            }
            this.add((Component)new ScrollableContainer((JComponent)contents), "Center");
        }

        private String formatSystemProperties(Properties properties) {
            StringBuilder text = new StringBuilder(200);
            ArrayList<Object> keys = new ArrayList<Object>();
            Enumeration<?> en = properties.propertyNames();
            while (en.hasMoreElements()) {
                keys.add(en.nextElement());
            }
            keys.sort(null);
            for (String string : keys) {
                String val = properties.getProperty(string);
                if ("line.separator".equals(string) && val != null) {
                    val = val.replace("\n", "\\n");
                    val = val.replace("\r", "\\r");
                }
                text.append("<b>");
                text.append(string);
                text.append("</b>=");
                text.append(val);
                text.append("<br>");
            }
            return text.toString();
        }
    }

    static class JVMArgumentsViewSupport
    extends JPanel {
        JVMArgumentsViewSupport(String jvmargs) {
            this.initComponents(jvmargs);
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_JVM_arguments"), null, 10, (JComponent)this, null);
        }

        private void initComponents(String jvmargs) {
            NotSupportedDisplayer contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (jvmargs != null) {
                HTMLTextArea area = new HTMLTextArea("<nobr>" + this.formatJVMArgs(jvmargs) + "</nobr>");
                area.setCaretPosition(0);
                area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                contents = area;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.JVM);
            }
            this.add((Component)new ScrollableContainer((JComponent)contents), "Center");
        }

        private String formatJVMArgs(String jvmargs) {
            String mangledString = " ".concat(jvmargs).replace(" -", "\n");
            StringTokenizer tok = new StringTokenizer(mangledString, "\n");
            StringBuilder text = new StringBuilder(100);
            while (tok.hasMoreTokens()) {
                String arg = tok.nextToken().replace(" ", "&nbsp;");
                int equalsSign = arg.indexOf(61);
                text.append("<b>");
                text.append("-");
                if (equalsSign != -1) {
                    text.append(arg, 0, equalsSign);
                    text.append("</b>");
                    text.append(arg.substring(equalsSign));
                } else {
                    text.append(arg);
                    text.append("</b>");
                }
                text.append("<br>");
            }
            return text.toString();
        }
    }

    static class SnapshotsViewSupport
    extends JPanel {
        private static final String LINK_TOGGLE_CATEGORY = "file:/toggle_category";
        private static final String LINK_OPEN_SNAPSHOT = "file:/open_snapshot";
        private final Map<Integer, Snapshot> snapshotsMap = new HashMap<Integer, Snapshot>();
        private final Map<String, Boolean> expansionMap = new HashMap<String, Boolean>();

        SnapshotsViewSupport(DataSource ds) {
            this.initComponents(ds);
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Saved_data"), null, 10, (JComponent)this, null);
        }

        private void initComponents(final DataSource ds) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            final HTMLTextArea area = new HTMLTextArea(){

                protected void showURL(URL url) {
                    String link = url.toString();
                    if (link.startsWith(SnapshotsViewSupport.LINK_TOGGLE_CATEGORY)) {
                        link = link.substring(SnapshotsViewSupport.LINK_TOGGLE_CATEGORY.length());
                        this.toggleExpanded(link);
                        this.setText(this.getSavedData(ds));
                    } else if (link.startsWith(SnapshotsViewSupport.LINK_OPEN_SNAPSHOT)) {
                        link = link.substring(SnapshotsViewSupport.LINK_OPEN_SNAPSHOT.length());
                        Snapshot s = (Snapshot)snapshotsMap.get(Integer.parseInt(link));
                        if (s != null) {
                            DataSourceWindowManager.sharedInstance().openDataSource((DataSource)s);
                        }
                    }
                }
            };
            area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            ds.getRepository().addDataChangeListener((DataChangeListener)new DataChangeListener<Snapshot>(){

                public void dataChanged(DataChangeEvent<Snapshot> event) {
                    area.setText(this.getSavedData(ds));
                }
            }, Snapshot.class);
            this.add((Component)new ScrollableContainer((JComponent)area), "Center");
        }

        private String getSavedData(DataSource dataSource) {
            this.snapshotsMap.clear();
            StringBuilder data = new StringBuilder();
            List snapshotCategories = RegisteredSnapshotCategories.sharedInstance().getVisibleCategories();
            for (SnapshotCategory category : snapshotCategories) {
                DataSourceDescriptor dsd;
                Set snapshots = dataSource.getRepository().getDataSources(category.getType());
                if (snapshots.isEmpty()) {
                    data.append("<b>" + category.getName() + ":</b> " + snapshots.size() + "<br>");
                    continue;
                }
                String categoryName = category.getName();
                data.append("<b>" + categoryName + ":</b> <a href='" + LINK_TOGGLE_CATEGORY + categoryName + "'>" + snapshots.size() + "</a><br>");
                if (!this.isExpanded(categoryName)) continue;
                ArrayList<DataSourceDescriptor> descriptors = new ArrayList<DataSourceDescriptor>();
                HashMap<DataSourceDescriptor, Snapshot> dataSources = new HashMap<DataSourceDescriptor, Snapshot>();
                for (Snapshot s : snapshots) {
                    dsd = DataSourceDescriptorFactory.getDescriptor((DataSource)s);
                    descriptors.add(dsd);
                    dataSources.put(dsd, s);
                }
                descriptors.sort(Positionable.STRONG_COMPARATOR);
                int size = this.snapshotsMap.size();
                for (int i = 0; i < descriptors.size(); ++i) {
                    dsd = (DataSourceDescriptor)descriptors.get(i);
                    Snapshot s = (Snapshot)dataSources.get(dsd);
                    this.snapshotsMap.put(i + size, s);
                    data.append("&nbsp;&nbsp;&nbsp;<a href='file:/open_snapshot" + (i + size) + "'>" + dsd.getName() + "</a><br>");
                }
                data.append("<br>");
            }
            return "<nobr>" + data.toString() + "</nobr>";
        }

        private boolean isExpanded(String categoryName) {
            Boolean expanded = this.expansionMap.computeIfAbsent(categoryName, k -> false);
            return expanded;
        }

        private void toggleExpanded(String categoryName) {
            this.expansionMap.put(categoryName, !this.isExpanded(categoryName));
        }
    }
}

