/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DeleteShareGroupStateRequestData;
import org.apache.kafka.common.message.DeleteShareGroupStateResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class DeleteShareGroupStateResponse
extends AbstractResponse {
    private final DeleteShareGroupStateResponseData data;

    public DeleteShareGroupStateResponse(DeleteShareGroupStateResponseData data) {
        super(ApiKeys.DELETE_SHARE_GROUP_STATE);
        this.data = data;
    }

    @Override
    public DeleteShareGroupStateResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.data.results().forEach(result -> result.partitions().forEach(partitionResult -> DeleteShareGroupStateResponse.updateErrorCounts(counts, Errors.forCode(partitionResult.errorCode()))));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
    }

    public static DeleteShareGroupStateResponse parse(Readable readable, short version) {
        return new DeleteShareGroupStateResponse(new DeleteShareGroupStateResponseData(readable, version));
    }

    public static DeleteShareGroupStateResponseData toResponseData(Uuid topicId, int partitionId) {
        return new DeleteShareGroupStateResponseData().setResults(List.of(new DeleteShareGroupStateResponseData.DeleteStateResult().setTopicId(topicId).setPartitions(List.of(new DeleteShareGroupStateResponseData.PartitionResult().setPartition(partitionId)))));
    }

    public static DeleteShareGroupStateResponseData.PartitionResult toErrorResponsePartitionResult(int partitionId, Errors error, String errorMessage) {
        return new DeleteShareGroupStateResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage);
    }

    public static DeleteShareGroupStateResponseData.DeleteStateResult toResponseDeleteStateResult(Uuid topicId, List<DeleteShareGroupStateResponseData.PartitionResult> partitionResults) {
        return new DeleteShareGroupStateResponseData.DeleteStateResult().setTopicId(topicId).setPartitions(partitionResults);
    }

    public static DeleteShareGroupStateResponseData.PartitionResult toResponsePartitionResult(int partitionId) {
        return new DeleteShareGroupStateResponseData.PartitionResult().setPartition(partitionId);
    }

    public static DeleteShareGroupStateResponseData toErrorResponseData(Uuid topicId, int partitionId, Errors error, String errorMessage) {
        return new DeleteShareGroupStateResponseData().setResults(List.of(new DeleteShareGroupStateResponseData.DeleteStateResult().setTopicId(topicId).setPartitions(List.of(new DeleteShareGroupStateResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage)))));
    }

    public static DeleteShareGroupStateResponseData toGlobalErrorResponse(DeleteShareGroupStateRequestData request, Errors error) {
        ArrayList<DeleteShareGroupStateResponseData.DeleteStateResult> deleteStateResults = new ArrayList<DeleteShareGroupStateResponseData.DeleteStateResult>();
        request.topics().forEach(topicData -> {
            ArrayList<DeleteShareGroupStateResponseData.PartitionResult> partitionResults = new ArrayList<DeleteShareGroupStateResponseData.PartitionResult>();
            topicData.partitions().forEach(partitionData -> partitionResults.add(DeleteShareGroupStateResponse.toErrorResponsePartitionResult(partitionData.partition(), error, error.message())));
            deleteStateResults.add(DeleteShareGroupStateResponse.toResponseDeleteStateResult(topicData.topicId(), partitionResults));
        });
        return new DeleteShareGroupStateResponseData().setResults(deleteStateResults);
    }
}

