/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.http;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpExperimentalMetricsAdvice;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpMessageBodySizeUtil;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpServerExperimentalMetrics
implements OperationListener {
    private static final ContextKey<Attributes> HTTP_SERVER_EXPERIMENTAL_METRICS_START_ATTRIBUTES = ContextKey.named((String)"http-server-experimental-metrics-start-attributes");
    private static final Logger logger = Logger.getLogger(HttpServerExperimentalMetrics.class.getName());
    private final LongUpDownCounter activeRequests;
    private final LongHistogram requestSize;
    private final LongHistogram responseSize;

    public static OperationMetrics get() {
        return HttpServerExperimentalMetrics::new;
    }

    private HttpServerExperimentalMetrics(Meter meter) {
        LongUpDownCounterBuilder activeRequestsBuilder = meter.upDownCounterBuilder("http.server.active_requests").setUnit("{requests}").setDescription("Number of active HTTP server requests.");
        HttpExperimentalMetricsAdvice.applyServerActiveRequestsAdvice(activeRequestsBuilder);
        this.activeRequests = activeRequestsBuilder.build();
        LongHistogramBuilder requestSizeBuilder = meter.histogramBuilder("http.server.request.size").setUnit("By").setDescription("Size of HTTP server request bodies.").ofLongs();
        HttpExperimentalMetricsAdvice.applyServerRequestSizeAdvice(requestSizeBuilder);
        this.requestSize = requestSizeBuilder.build();
        LongHistogramBuilder responseSizeBuilder = meter.histogramBuilder("http.server.response.size").setUnit("By").setDescription("Size of HTTP server response bodies.").ofLongs();
        HttpExperimentalMetricsAdvice.applyServerRequestSizeAdvice(responseSizeBuilder);
        this.responseSize = responseSizeBuilder.build();
    }

    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        this.activeRequests.add(1L, startAttributes, context);
        return context.with(HTTP_SERVER_EXPERIMENTAL_METRICS_START_ATTRIBUTES, (Object)startAttributes);
    }

    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long responseBodySize;
        Attributes startAttributes = (Attributes)context.get(HTTP_SERVER_EXPERIMENTAL_METRICS_START_ATTRIBUTES);
        if (startAttributes == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        this.activeRequests.add(-1L, startAttributes, context);
        Attributes sizeAttributes = startAttributes.toBuilder().putAll(endAttributes).build();
        Long requestBodySize = HttpMessageBodySizeUtil.getHttpRequestBodySize(endAttributes, startAttributes);
        if (requestBodySize != null) {
            this.requestSize.record(requestBodySize.longValue(), sizeAttributes, context);
        }
        if ((responseBodySize = HttpMessageBodySizeUtil.getHttpResponseBodySize(endAttributes, startAttributes)) != null) {
            this.responseSize.record(responseBodySize.longValue(), sizeAttributes, context);
        }
    }
}

