/*
 * Decompiled with CFR 0.152.
 */
package liqp.spi;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import liqp.filters.date.CustomDateFormatSupport;
import liqp.spi.BasicTypesSupport;

public class Java7DateTypesSupport
extends BasicTypesSupport {
    @Override
    public void configureTypesForReferencing(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule("liqp java 7 date type support");
        this.registerType(module, Date.class);
        this.registerType(module, Calendar.class);
        mapper.registerModule((Module)module);
    }

    @Override
    public void configureCustomDateTypes() {
        this.addCustomDateType(new CustomDateFormatSupport<Date>(){

            @Override
            public ZonedDateTime getValue(Date value) {
                return ZonedDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault());
            }

            @Override
            public boolean support(Object in) {
                return in instanceof Date;
            }
        });
        this.addCustomDateType(new CustomDateFormatSupport<Calendar>(){

            @Override
            public ZonedDateTime getValue(Calendar value) {
                return ZonedDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault());
            }

            @Override
            public boolean support(Object in) {
                return in instanceof Calendar;
            }
        });
    }
}

