/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractIterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.StringParsers$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$DurationIsOrdered$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.RichChar$;
import scala.runtime.RichDouble$;

public final class Duration$
implements Serializable {
    private static final Map<TimeUnit, String> timeUnitName;
    private static final Map<String, TimeUnit> timeUnit;
    private static final FiniteDuration Zero;
    private static final Duration.Infinite Undefined;
    private static final Duration.Infinite Inf;
    private static final Duration.Infinite MinusInf;
    public static final Duration$DurationIsOrdered$ DurationIsOrdered;
    public static final Duration$ MODULE$;

    private Duration$() {
    }

    static {
        MODULE$ = new Duration$();
        TimeUnit timeUnit = (TimeUnit)((Object)Predef$.MODULE$.ArrowAssoc(package$.MODULE$.DAYS()));
        TimeUnit timeUnit2 = (TimeUnit)((Object)Predef$.MODULE$.ArrowAssoc(package$.MODULE$.HOURS()));
        TimeUnit timeUnit3 = (TimeUnit)((Object)Predef$.MODULE$.ArrowAssoc(package$.MODULE$.MINUTES()));
        TimeUnit timeUnit4 = (TimeUnit)((Object)Predef$.MODULE$.ArrowAssoc(package$.MODULE$.SECONDS()));
        TimeUnit timeUnit5 = (TimeUnit)((Object)Predef$.MODULE$.ArrowAssoc(package$.MODULE$.MILLISECONDS()));
        TimeUnit timeUnit6 = (TimeUnit)((Object)Predef$.MODULE$.ArrowAssoc(package$.MODULE$.MICROSECONDS()));
        TimeUnit timeUnit7 = (TimeUnit)((Object)Predef$.MODULE$.ArrowAssoc(package$.MODULE$.NANOSECONDS()));
        List timeUnitLabels = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension((Object)timeUnit, "d day")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension((Object)timeUnit2, "h hr hour")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension((Object)timeUnit3, "m min minute")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension((Object)timeUnit4, "s sec second")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension((Object)timeUnit5, "ms milli millisecond")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension((Object)timeUnit6, "\u00b5s micro microsecond")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension((Object)timeUnit7, "ns nano nanosecond")), Nil$.MODULE$))))))));
        timeUnitName = timeUnitLabels.toMap($less$colon$less$.MODULE$.refl()).view().mapValues((Function1<String, String> & Serializable)s -> this.words((String)s).last()).toMap($less$colon$less$.MODULE$.refl());
        Duration$.timeUnit = ((AbstractIterable)timeUnitLabels.flatMap((Function1<Tuple2, IterableOnce> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            TimeUnit unit = (TimeUnit)((Object)((Object)tuple2._1()));
            String names = (String)tuple2._2();
            return this.expandLabels(names).map((Function1<String, Tuple2> & Serializable)_$4 -> {
                String string2 = (String)Predef$.MODULE$.ArrowAssoc(_$4);
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, unit);
            });
        })).toMap($less$colon$less$.MODULE$.refl());
        long ns_per_\u00b5s = 1000L;
        long ns_per_ms = 1000000L;
        long ns_per_s = 1000000000L;
        long ns_per_min = 60000000000L;
        long ns_per_h = 3600000000000L;
        long ns_per_d = 86400000000000L;
        Zero = new FiniteDuration(0L, package$.MODULE$.DAYS());
        Undefined = new Duration.Infinite(){

            public String toString() {
                return "Duration.Undefined";
            }

            public boolean equals(Object other) {
                return false;
            }

            public Duration $plus(Duration other) {
                return this;
            }

            public Duration $minus(Duration other) {
                return this;
            }

            public Duration $times(double factor) {
                return this;
            }

            public Duration $div(double factor) {
                return this;
            }

            public double $div(Duration other) {
                return Double.NaN;
            }

            public int compare(Duration other) {
                if (other == this) {
                    return 0;
                }
                return 1;
            }

            public Duration unary_$minus() {
                return this;
            }

            public double toUnit(TimeUnit unit) {
                return Double.NaN;
            }

            private Object readResolve() {
                return Duration$.MODULE$.Undefined();
            }
        };
        Inf = new Duration.Infinite(){

            public String toString() {
                return "Duration.Inf";
            }

            public int compare(Duration other) {
                Duration duration = other;
                Duration x = duration;
                if (x == Duration$.MODULE$.Undefined()) {
                    return -1;
                }
                Duration x2 = duration;
                if (x2 == this) {
                    return 0;
                }
                return 1;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.MinusInf();
            }

            public double toUnit(TimeUnit unit) {
                return Double.POSITIVE_INFINITY;
            }

            private Object readResolve() {
                return Duration$.MODULE$.Inf();
            }
        };
        MinusInf = new Duration.Infinite(){

            public String toString() {
                return "Duration.MinusInf";
            }

            public int compare(Duration other) {
                if (other == this) {
                    return 0;
                }
                return -1;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.Inf();
            }

            public double toUnit(TimeUnit unit) {
                return Double.NEGATIVE_INFINITY;
            }

            private Object readResolve() {
                return Duration$.MODULE$.MinusInf();
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Duration$.class);
    }

    public Duration apply(double length, TimeUnit unit) {
        return this.fromNanos((double)unit.toNanos(1L) * length);
    }

    public FiniteDuration apply(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public FiniteDuration apply(long length, String unit) {
        return new FiniteDuration(length, (TimeUnit)((Object)this.timeUnit().apply(unit)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Duration apply(String s) {
        String s1 = StringOps$.MODULE$.filterNot$extension(Predef$.MODULE$.augmentString(s), (Function1<Object, Object>)(Function1<Object, Boolean> & Serializable)_$1 -> RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar(_$1))));
        String string2 = s1;
        switch (string2 == null ? 0 : string2.hashCode()) {
            case -1772306297: {
                if ("Duration.Inf".equals(string2)) return this.Inf();
                break;
            }
            case -1283193487: {
                if ("MinusInf".equals(string2)) return this.MinusInf();
                break;
            }
            case 73665: {
                if ("Inf".equals(string2)) return this.Inf();
                break;
            }
            case 1354678: {
                if ("+Inf".equals(string2)) return this.Inf();
                break;
            }
            case 1414260: {
                if ("-Inf".equals(string2)) return this.MinusInf();
                break;
            }
            case 784790902: {
                if (!"Duration.Undefined".equals(string2)) break;
                return this.Undefined();
            }
            case 927723627: {
                if ("Duration.MinusInf".equals(string2)) return this.MinusInf();
                break;
            }
            case 1189350343: {
                if (!"PlusInf".equals(string2)) break;
                return this.Inf();
            }
        }
        String unitName = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(s1))), (Function1<Object, Object>)(Function1<Object, Boolean> & Serializable)_$2 -> RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar(_$2))))));
        Option option = this.timeUnit().get(unitName);
        if (!(option instanceof Some)) throw new NumberFormatException("format error " + s);
        Some some = (Some)option;
        TimeUnit unit = (TimeUnit)((Object)some.value());
        String valueStr = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(s1), unitName.length());
        return (Duration)StringParsers$.MODULE$.parseLong(valueStr).map((Function1<Object, FiniteDuration> & Serializable)_$3 -> Duration$.MODULE$.apply(BoxesRunTime.unboxToLong(_$3), unit)).getOrElse(() -> Duration$.apply$$anonfun$2(valueStr, unit));
    }

    private List<String> words(String s) {
        return Predef$.MODULE$.wrapRefArray(s.trim().split("\\s+")).toList();
    }

    private List<String> expandLabels(String labels) {
        List<String> list = this.words(labels);
        if (!(list instanceof $colon$colon)) {
            throw new MatchError(list);
        }
        $colon$colon $colon$colon = ($colon$colon)list;
        List list2 = $colon$colon.next();
        String hd = (String)$colon$colon.head();
        List rest = list2;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(hd, rest);
        String hd2 = tuple2._1();
        List rest2 = tuple2._2();
        return ((List)rest2.flatMap((Function1<String, IterableOnce> & Serializable)s -> (IterableOnce)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)s), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)(s + "s")), Nil$.MODULE$))))).$colon$colon(hd2);
    }

    public Map<TimeUnit, String> timeUnitName() {
        return timeUnitName;
    }

    public Map<String, TimeUnit> timeUnit() {
        return timeUnit;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(String s) {
        Option option;
        try {
            option = Some$.MODULE$.apply(this.apply(s));
        }
        catch (RuntimeException runtimeException) {
            option = None$.MODULE$;
        }
        return option.flatMap((Function1<Duration, Option> & Serializable)d -> MODULE$.unapply((Duration)d));
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(Duration d) {
        if (d.isFinite()) {
            return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(BoxesRunTime.boxToLong(d.length()), d.unit()));
        }
        return None$.MODULE$;
    }

    public Duration fromNanos(double nanos) {
        if (Predef$.MODULE$.double2Double(nanos).isInfinite()) {
            if (nanos > 0.0) {
                return this.Inf();
            }
            return this.MinusInf();
        }
        if (Double.isNaN(nanos)) {
            return this.Undefined();
        }
        if (nanos > (double)Long.MAX_VALUE || nanos < (double)Long.MIN_VALUE) {
            throw new IllegalArgumentException("trying to construct too large duration with " + nanos + "ns");
        }
        return this.fromNanos(RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(nanos)));
    }

    public FiniteDuration fromNanos(long nanos) {
        if (nanos % 86400000000000L == 0L) {
            return this.apply(nanos / 86400000000000L, package$.MODULE$.DAYS());
        }
        if (nanos % 3600000000000L == 0L) {
            return this.apply(nanos / 3600000000000L, package$.MODULE$.HOURS());
        }
        if (nanos % 60000000000L == 0L) {
            return this.apply(nanos / 60000000000L, package$.MODULE$.MINUTES());
        }
        if (nanos % 1000000000L == 0L) {
            return this.apply(nanos / 1000000000L, package$.MODULE$.SECONDS());
        }
        if (nanos % 1000000L == 0L) {
            return this.apply(nanos / 1000000L, package$.MODULE$.MILLISECONDS());
        }
        if (nanos % 1000L == 0L) {
            return this.apply(nanos / 1000L, package$.MODULE$.MICROSECONDS());
        }
        return this.apply(nanos, package$.MODULE$.NANOSECONDS());
    }

    public FiniteDuration Zero() {
        return Zero;
    }

    public Duration.Infinite Undefined() {
        return Undefined;
    }

    public Duration.Infinite Inf() {
        return Inf;
    }

    public Duration.Infinite MinusInf() {
        return MinusInf;
    }

    public FiniteDuration create(long length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public Duration create(double length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(long length, String unit) {
        return this.apply(length, unit);
    }

    public Duration create(String s) {
        return this.apply(s);
    }

    private static final Duration apply$$anonfun$2(String valueStr$1, TimeUnit unit$3) {
        return MODULE$.apply(Double.parseDouble(valueStr$1), unit$3);
    }
}

