/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import net.sf.mpxj.Day;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.common.NumberHelper;

public class RecurringData {
    private static final String[] ORDINAL = new String[]{null, "every", "every other", "every 3rd"};
    private static final String[] DAY_ORDINAL = new String[]{null, "First", "Second", "Third", "Fourth", "Last"};
    private Date m_startDate;
    private Date m_finishDate;
    private Integer m_occurrences;
    private RecurrenceType m_recurrenceType;
    private boolean m_relative;
    private boolean m_workingDaysOnly;
    private boolean m_useEndDate;
    private Integer m_frequency;
    private Integer m_dayNumber;
    private Integer m_monthNumber;
    private EnumSet<Day> m_days = EnumSet.noneOf(Day.class);

    public Date getStartDate() {
        return this.m_startDate;
    }

    public void setStartDate(Date date) {
        this.m_startDate = date;
    }

    public Date getFinishDate() {
        return this.m_finishDate;
    }

    public void setFinishDate(Date date) {
        this.m_finishDate = date;
    }

    public Integer getOccurrences() {
        return this.m_occurrences;
    }

    public void setOccurrences(Integer n) {
        this.m_occurrences = n;
    }

    public RecurrenceType getRecurrenceType() {
        return this.m_recurrenceType;
    }

    public void setRecurrenceType(RecurrenceType recurrenceType) {
        this.m_recurrenceType = recurrenceType;
    }

    public boolean getUseEndDate() {
        return this.m_useEndDate;
    }

    public void setUseEndDate(boolean bl) {
        this.m_useEndDate = bl;
    }

    public boolean isWorkingDaysOnly() {
        return this.m_workingDaysOnly;
    }

    public void setWorkingDaysOnly(boolean bl) {
        this.m_workingDaysOnly = bl;
    }

    public boolean getWeeklyDay(Day day) {
        return this.m_days.contains(day);
    }

    public void setWeeklyDay(Day day, boolean bl) {
        if (bl) {
            this.m_days.add(day);
        } else {
            this.m_days.remove(day);
        }
    }

    public void setWeeklyDaysFromBitmap(Integer n, int[] nArray) {
        if (n != null) {
            int n2 = n;
            for (Day day : Day.values()) {
                this.setWeeklyDay(day, (n2 & nArray[day.getValue()]) != 0);
            }
        }
    }

    public boolean getRelative() {
        return this.m_relative;
    }

    public void setRelative(boolean bl) {
        this.m_relative = bl;
    }

    public Integer getFrequency() {
        return this.m_frequency;
    }

    public void setFrequency(Integer n) {
        this.m_frequency = n;
    }

    public Day getDayOfWeek() {
        Day day = null;
        if (!this.m_days.isEmpty()) {
            day = (Day)this.m_days.iterator().next();
        }
        return day;
    }

    public void setDayOfWeek(Day day) {
        this.m_days.clear();
        this.m_days.add(day);
    }

    public Integer getDayNumber() {
        return this.m_dayNumber;
    }

    public void setDayNumber(Integer n) {
        this.m_dayNumber = n;
    }

    public Integer getMonthNumber() {
        return this.m_monthNumber;
    }

    public void setMonthNumber(Integer n) {
        this.m_monthNumber = n;
    }

    public Date[] getDates() {
        int n = NumberHelper.getInt(this.m_frequency);
        if (n < 1) {
            n = 1;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.m_startDate);
        ArrayList<Date> arrayList = new ArrayList<Date>();
        switch (this.m_recurrenceType) {
            case DAILY: {
                this.getDailyDates(calendar, n, arrayList);
                break;
            }
            case WEEKLY: {
                this.getWeeklyDates(calendar, n, arrayList);
                break;
            }
            case MONTHLY: {
                this.getMonthlyDates(calendar, n, arrayList);
                break;
            }
            case YEARLY: {
                this.getYearlyDates(calendar, arrayList);
            }
        }
        return arrayList.toArray(new Date[arrayList.size()]);
    }

    private boolean moreDates(Calendar calendar, List<Date> list) {
        boolean bl;
        if (this.m_finishDate == null) {
            int n = NumberHelper.getInt(this.m_occurrences);
            if (n < 1) {
                n = 1;
            }
            bl = list.size() < n;
        } else {
            bl = calendar.getTimeInMillis() <= this.m_finishDate.getTime();
        }
        return bl;
    }

    private void getDailyDates(Calendar calendar, int n, List<Date> list) {
        while (this.moreDates(calendar, list)) {
            list.add(calendar.getTime());
            calendar.add(6, n);
        }
    }

    private void getWeeklyDates(Calendar calendar, int n, List<Date> list) {
        int n2 = calendar.get(7);
        while (this.moreDates(calendar, list)) {
            int n3 = 0;
            for (int i = 0; i < 7; ++i) {
                if (this.getWeeklyDay(Day.getInstance(n2))) {
                    if (n3 != 0) {
                        calendar.add(6, n3);
                        n3 = 0;
                    }
                    if (!this.moreDates(calendar, list)) break;
                    list.add(calendar.getTime());
                }
                ++n3;
                if (++n2 <= 7) continue;
                n2 = 1;
            }
            if (n > 1) {
                n3 += 7 * (n - 1);
            }
            calendar.add(6, n3);
        }
    }

    private void getMonthlyDates(Calendar calendar, int n, List<Date> list) {
        if (this.m_relative) {
            this.getMonthlyRelativeDates(calendar, n, list);
        } else {
            this.getMonthlyAbsoluteDates(calendar, n, list);
        }
    }

    private void getMonthlyRelativeDates(Calendar calendar, int n, List<Date> list) {
        long l = calendar.getTimeInMillis();
        calendar.set(5, 1);
        int n2 = NumberHelper.getInt(this.m_dayNumber);
        while (this.moreDates(calendar, list)) {
            if (n2 > 4) {
                this.setCalendarToLastRelativeDay(calendar);
            } else {
                this.setCalendarToOrdinalRelativeDay(calendar, n2);
            }
            if (calendar.getTimeInMillis() > l) {
                list.add(calendar.getTime());
                if (!this.moreDates(calendar, list)) break;
            }
            calendar.set(5, 1);
            calendar.add(2, n);
        }
    }

    private void getMonthlyAbsoluteDates(Calendar calendar, int n, List<Date> list) {
        int n2 = calendar.get(5);
        calendar.set(5, 1);
        int n3 = NumberHelper.getInt(this.m_dayNumber);
        if (n3 < n2) {
            calendar.add(2, 1);
        }
        while (this.moreDates(calendar, list)) {
            int n4 = n3;
            int n5 = calendar.getActualMaximum(5);
            if (n4 > n5) {
                n4 = n5;
            }
            calendar.set(5, n4);
            list.add(calendar.getTime());
            calendar.set(5, 1);
            calendar.add(2, n);
        }
    }

    private void getYearlyDates(Calendar calendar, List<Date> list) {
        if (this.m_relative) {
            this.getYearlyRelativeDates(calendar, list);
        } else {
            this.getYearlyAbsoluteDates(calendar, list);
        }
    }

    private void getYearlyRelativeDates(Calendar calendar, List<Date> list) {
        long l = calendar.getTimeInMillis();
        calendar.set(5, 1);
        calendar.set(2, NumberHelper.getInt(this.m_monthNumber) - 1);
        int n = NumberHelper.getInt(this.m_dayNumber);
        while (this.moreDates(calendar, list)) {
            if (n > 4) {
                this.setCalendarToLastRelativeDay(calendar);
            } else {
                this.setCalendarToOrdinalRelativeDay(calendar, n);
            }
            if (calendar.getTimeInMillis() > l) {
                list.add(calendar.getTime());
                if (!this.moreDates(calendar, list)) break;
            }
            calendar.set(5, 1);
            calendar.add(1, 1);
        }
    }

    private void getYearlyAbsoluteDates(Calendar calendar, List<Date> list) {
        long l = calendar.getTimeInMillis();
        calendar.set(5, 1);
        calendar.set(2, NumberHelper.getInt(this.m_monthNumber) - 1);
        int n = NumberHelper.getInt(this.m_dayNumber);
        while (this.moreDates(calendar, list)) {
            int n2 = n;
            int n3 = calendar.getActualMaximum(5);
            if (n2 > n3) {
                n2 = n3;
            }
            calendar.set(5, n2);
            if (calendar.getTimeInMillis() < l) {
                calendar.add(1, 1);
            }
            list.add(calendar.getTime());
            calendar.set(5, 1);
            calendar.add(1, 1);
        }
    }

    private void setCalendarToOrdinalRelativeDay(Calendar calendar, int n) {
        int n2 = calendar.get(7);
        int n3 = this.getDayOfWeek().getValue();
        int n4 = 0;
        if (n3 > n2) {
            n4 = n3 - n2;
        } else if (n3 < n2) {
            n4 = 7 - (n2 - n3);
        }
        if (n4 != 0) {
            calendar.add(6, n4);
        }
        if (n > 1) {
            calendar.add(6, 7 * (n - 1));
        }
    }

    private void setCalendarToLastRelativeDay(Calendar calendar) {
        calendar.set(5, calendar.getActualMaximum(5));
        int n = calendar.get(7);
        int n2 = this.getDayOfWeek().getValue();
        int n3 = 0;
        if (n > n2) {
            n3 = n2 - n;
        } else if (n < n2) {
            n3 = -7 + (n2 - n);
        }
        if (n3 != 0) {
            calendar.add(6, n3);
        }
    }

    public void setYearlyAbsoluteFromDate(Date date) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.m_dayNumber = calendar.get(5);
            this.m_monthNumber = calendar.get(2) + 1;
        }
    }

    private String getOrdinal(Integer n) {
        int n2 = n;
        Object object = n2 >= ORDINAL.length ? "every " + n2 + "th" : ORDINAL[n2];
        return object;
    }

    public String toString() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.print("[RecurringData");
        printWriter.print(this.m_recurrenceType);
        switch (this.m_recurrenceType) {
            case DAILY: {
                printWriter.print(" " + this.getOrdinal(this.m_frequency));
                printWriter.print(this.m_workingDaysOnly ? " Working day" : " Day");
                break;
            }
            case WEEKLY: {
                printWriter.print(" " + this.getOrdinal(this.m_frequency));
                printWriter.print(" week on ");
                StringBuilder stringBuilder = new StringBuilder();
                for (Day day : Day.values()) {
                    if (!this.getWeeklyDay(day)) continue;
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(dateFormatSymbols.getWeekdays()[day.getValue()]);
                }
                printWriter.print(stringBuilder.toString());
                break;
            }
            case MONTHLY: {
                if (this.m_relative) {
                    printWriter.print(" on The ");
                    printWriter.print(DAY_ORDINAL[this.m_dayNumber]);
                    printWriter.print(" ");
                    printWriter.print(dateFormatSymbols.getWeekdays()[this.getDayOfWeek().getValue()]);
                    printWriter.print(" of ");
                    printWriter.print(this.getOrdinal(this.m_frequency));
                } else {
                    printWriter.print(" on Day ");
                    printWriter.print(this.m_dayNumber);
                    printWriter.print(" of ");
                    printWriter.print(this.getOrdinal(this.m_frequency));
                }
                printWriter.print(" month");
                break;
            }
            case YEARLY: {
                printWriter.print(" on the ");
                if (this.m_relative) {
                    printWriter.print(DAY_ORDINAL[this.m_dayNumber]);
                    printWriter.print(" ");
                    printWriter.print(dateFormatSymbols.getWeekdays()[this.getDayOfWeek().getValue()]);
                    printWriter.print(" of ");
                    printWriter.print(dateFormatSymbols.getMonths()[this.m_monthNumber - 1]);
                    break;
                }
                printWriter.print(this.m_dayNumber + " " + dateFormatSymbols.getMonths()[this.m_monthNumber - 1]);
            }
        }
        printWriter.print(" From " + String.valueOf(this.m_startDate));
        printWriter.print(" For " + this.m_occurrences + " occurrences");
        printWriter.print(" To " + String.valueOf(this.m_finishDate));
        printWriter.println("]");
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }
}

