/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * round(dvec2(-2.0lf, -1.4285714285714286lf)) => dvec2(-2.0lf, -1.0lf)
 * round(dvec2(-0.8571428571428572lf, -0.2857142857142858lf)) => dvec2(-1.0lf, -0.0lf)
 * round(dvec2(0.2857142857142856lf, 0.8571428571428568lf)) => dvec2(0.0lf, 1.0lf)
 * round(dvec2(1.4285714285714284lf, 2.0lf)) => dvec2(1.0lf, 2.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(round(dvec2(-2.0lf, -1.4285714285714286lf)), dvec2(-2.0lf, -1.0lf)) <= 2.2360679774997898e-05lf ? 1 : -1] array0;
  double[distance(round(dvec2(-0.8571428571428572lf, -0.2857142857142858lf)), dvec2(-1.0lf, -0.0lf)) <= 1e-05lf ? 1 : -1] array1;
  double[distance(round(dvec2(0.2857142857142856lf, 0.8571428571428568lf)), dvec2(0.0lf, 1.0lf)) <= 1e-05lf ? 1 : -1] array2;
  double[distance(round(dvec2(1.4285714285714284lf, 2.0lf)), dvec2(1.0lf, 2.0lf)) <= 2.2360679774997898e-05lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
