/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * roundEven(dvec4(-2.0lf, -1.8333333333333333lf, -1.6666666666666667lf, -1.5lf)) => dvec4(-2.0lf, -2.0lf, -2.0lf, -2.0lf)
 * roundEven(dvec4(-1.3333333333333335lf, -1.1666666666666667lf, -1.0lf, -0.8333333333333335lf)) => dvec4(-1.0lf, -1.0lf, -1.0lf, -1.0lf)
 * roundEven(dvec4(-0.6666666666666667lf, -0.5lf, -0.3333333333333335lf, -0.16666666666666674lf)) => dvec4(-1.0lf, -0.0lf, -0.0lf, -0.0lf)
 * roundEven(dvec4(0.0lf, 0.16666666666666652lf, 0.33333333333333304lf, 0.5lf)) => dvec4(0.0lf, 0.0lf, 0.0lf, 0.0lf)
 * roundEven(dvec4(0.6666666666666665lf, 0.833333333333333lf, 1.0lf, 1.1666666666666665lf)) => dvec4(1.0lf, 1.0lf, 1.0lf, 1.0lf)
 * roundEven(dvec4(1.333333333333333lf, 1.5lf, 1.6666666666666665lf, 1.833333333333333lf)) => dvec4(1.0lf, 2.0lf, 2.0lf, 2.0lf)
 * roundEven(dvec4(2.0lf, -2.0lf, -1.8333333333333333lf, -1.6666666666666667lf)) => dvec4(2.0lf, -2.0lf, -2.0lf, -2.0lf)
 */
#version 400

void main()
{
  double[distance(roundEven(dvec4(-2.0lf, -1.8333333333333333lf, -1.6666666666666667lf, -1.5lf)), dvec4(-2.0lf, -2.0lf, -2.0lf, -2.0lf)) <= 4e-05lf ? 1 : -1] array0;
  double[distance(roundEven(dvec4(-1.3333333333333335lf, -1.1666666666666667lf, -1.0lf, -0.8333333333333335lf)), dvec4(-1.0lf, -1.0lf, -1.0lf, -1.0lf)) <= 2e-05lf ? 1 : -1] array1;
  double[distance(roundEven(dvec4(-0.6666666666666667lf, -0.5lf, -0.3333333333333335lf, -0.16666666666666674lf)), dvec4(-1.0lf, -0.0lf, -0.0lf, -0.0lf)) <= 1e-05lf ? 1 : -1] array2;
  double[distance(roundEven(dvec4(0.0lf, 0.16666666666666652lf, 0.33333333333333304lf, 0.5lf)), dvec4(0.0lf, 0.0lf, 0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array3;
  double[distance(roundEven(dvec4(0.6666666666666665lf, 0.833333333333333lf, 1.0lf, 1.1666666666666665lf)), dvec4(1.0lf, 1.0lf, 1.0lf, 1.0lf)) <= 2e-05lf ? 1 : -1] array4;
  double[distance(roundEven(dvec4(1.333333333333333lf, 1.5lf, 1.6666666666666665lf, 1.833333333333333lf)), dvec4(1.0lf, 2.0lf, 2.0lf, 2.0lf)) <= 3.6055512754639895e-05lf ? 1 : -1] array5;
  double[distance(roundEven(dvec4(2.0lf, -2.0lf, -1.8333333333333333lf, -1.6666666666666667lf)), dvec4(2.0lf, -2.0lf, -2.0lf, -2.0lf)) <= 4e-05lf ? 1 : -1] array6;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length());
}
