/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.internal.engine.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.model.script.actions.Semantics;
import org.openhab.core.model.script.engine.action.ActionService;
import org.openhab.core.semantics.SemanticsPredicates;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component
public class SemanticsActionService
implements ActionService {
    private static @Nullable ItemRegistry itemRegistry;

    @Activate
    public SemanticsActionService(@Reference ItemRegistry itemRegistry) {
        SemanticsActionService.itemRegistry = itemRegistry;
    }

    @Override
    public Class<?> getActionClass() {
        return Semantics.class;
    }

    public static boolean isLocation(Item item) {
        return SemanticsPredicates.isLocation().test(item);
    }

    public static boolean isEquipment(Item item) {
        return SemanticsPredicates.isEquipment().test(item);
    }

    public static boolean isPoint(Item item) {
        return SemanticsPredicates.isPoint().test(item);
    }

    public static @Nullable Item getLocationItemFromGroupNames(List<String> groupNames) {
        ItemRegistry ir = itemRegistry;
        if (ir != null) {
            ArrayList<Item> groupItems = new ArrayList<Item>();
            for (String groupName : groupNames) {
                try {
                    Item group = ir.getItem(groupName);
                    if (SemanticsActionService.isLocation(group)) {
                        return group;
                    }
                    groupItems.add(group);
                }
                catch (ItemNotFoundException group) {
                    // empty catch block
                }
            }
            for (Item group : groupItems) {
                Item locationItem = SemanticsActionService.getLocationItemFromGroupNames(group.getGroupNames());
                if (locationItem == null) continue;
                return locationItem;
            }
        }
        return null;
    }

    public static @Nullable Item getEquipmentItemFromGroupNames(List<String> groupNames) {
        ItemRegistry ir = itemRegistry;
        if (ir != null) {
            ArrayList<Item> groupItems = new ArrayList<Item>();
            for (String groupName : groupNames) {
                try {
                    Item group = ir.getItem(groupName);
                    if (SemanticsActionService.isEquipment(group)) {
                        return group;
                    }
                    groupItems.add(group);
                }
                catch (ItemNotFoundException group) {
                    // empty catch block
                }
            }
            for (Item group : groupItems) {
                Item equipmentItem = SemanticsActionService.getEquipmentItemFromGroupNames(group.getGroupNames());
                if (equipmentItem == null) continue;
                return equipmentItem;
            }
        }
        return null;
    }
}

