/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.containers;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.containers.IAllContainersState;

public class LiveShadowedAllContainerState
implements IAllContainersState {
    private IAllContainersState globalState;
    private IResourceDescriptions localDescriptions;

    @Override
    public Collection<URI> getContainedURIs(String containerHandle) {
        final LinkedHashSet localContainedURIs = Sets.newLinkedHashSet();
        for (IResourceDescription descriptions : this.localDescriptions.getAllResourceDescriptions()) {
            String computedHandle = this.getContainerHandle(descriptions.getURI());
            if (computedHandle == null || !computedHandle.equals(containerHandle)) continue;
            localContainedURIs.add(descriptions.getURI());
        }
        final Collection<URI> globalContainedURIs = this.globalState.getContainedURIs(containerHandle);
        return new Collection<URI>(){

            @Override
            public int size() {
                return localContainedURIs.size() + globalContainedURIs.size();
            }

            @Override
            public boolean isEmpty() {
                throw new UnsupportedOperationException("not expected");
            }

            @Override
            public boolean contains(Object o) {
                return localContainedURIs.contains(o) || globalContainedURIs.contains(o);
            }

            @Override
            public Iterator<URI> iterator() {
                return Iterators.concat(localContainedURIs.iterator(), globalContainedURIs.iterator());
            }

            @Override
            public Object[] toArray() {
                LinkedHashSet result = new LinkedHashSet();
                result.addAll(localContainedURIs);
                result.addAll(globalContainedURIs);
                return result.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException("not expected");
            }

            @Override
            public boolean add(URI e) {
                throw new UnsupportedOperationException("not expected");
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("not expected");
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException("not expected");
            }

            @Override
            public boolean addAll(Collection<? extends URI> c) {
                throw new UnsupportedOperationException("not expected");
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException("not expected");
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException("not expected");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("not expected");
            }
        };
    }

    @Override
    public boolean containsURI(String containerHandle, URI candidateURI) {
        String computedHandle;
        if (this.localDescriptions.getResourceDescription(candidateURI) != null && (computedHandle = this.getContainerHandle(candidateURI)) != null && computedHandle.equals(containerHandle)) {
            return true;
        }
        return this.globalState.containsURI(containerHandle, candidateURI);
    }

    @Override
    public String getContainerHandle(URI uri) {
        return this.globalState.getContainerHandle(uri);
    }

    @Override
    public List<String> getVisibleContainerHandles(String handle) {
        return this.globalState.getVisibleContainerHandles(handle);
    }

    @Override
    public boolean isEmpty(String containerHandle) {
        for (IResourceDescription descriptions : this.localDescriptions.getAllResourceDescriptions()) {
            String computedHandle = this.getContainerHandle(descriptions.getURI());
            if (computedHandle == null || !computedHandle.equals(containerHandle)) continue;
            return false;
        }
        return this.globalState.isEmpty(containerHandle);
    }

    public static class Provider {
        @Inject
        private com.google.inject.Provider<LiveShadowedAllContainerState> provider;

        public IAllContainersState get(IResourceDescriptions localDescriptions, IAllContainersState globalState) {
            LiveShadowedAllContainerState result = (LiveShadowedAllContainerState)this.provider.get();
            result.globalState = globalState;
            result.localDescriptions = localDescriptions;
            return result;
        }
    }
}

