/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher.hashing;

import io.methvin.watcher.hashing.FileHash;
import java.util.Arrays;
import java.util.Base64;

class ByteArrayFileHash
implements FileHash {
    private final byte[] value;

    ByteArrayFileHash(byte[] byArray) {
        this.value = byArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ByteArrayFileHash byteArrayFileHash = (ByteArrayFileHash)object;
        return Arrays.equals(this.value, byteArrayFileHash.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        return Base64.getEncoder().encodeToString(this.value);
    }

    @Override
    public byte[] asBytes() {
        return Arrays.copyOf(this.value, this.value.length);
    }
}

