/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.converters;

import io.smallrye.reactive.converters.ReactiveTypeConverter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.StreamSupport;

public class Registry {
    private static final List<ReactiveTypeConverter> converters = new CopyOnWriteArrayList<ReactiveTypeConverter>();

    private Registry() {
    }

    public static <T> Optional<ReactiveTypeConverter<T>> lookup(Class<T> input) {
        return converters.stream().filter(entry -> entry.type().isAssignableFrom(Objects.requireNonNull(input))).map(fc -> fc).findAny();
    }

    public static void register(ReactiveTypeConverter ... fcs) {
        Collections.addAll(converters, fcs);
    }

    static {
        StreamSupport.stream(ServiceLoader.load(ReactiveTypeConverter.class).spliterator(), false).forEach(converters::add);
    }
}

