/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import java.security.cert.CertificateEncodingException;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBody;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.SdJwtCredentialBody;
import org.keycloak.protocol.oid4vc.issuance.signing.AbstractCredentialSigner;
import org.keycloak.protocol.oid4vc.issuance.signing.CredentialSignerException;
import org.keycloak.protocol.oid4vc.model.CredentialBuildConfig;

public class SdJwtCredentialSigner
extends AbstractCredentialSigner<String> {
    private static final Logger LOGGER = Logger.getLogger(SdJwtCredentialSigner.class);

    public SdJwtCredentialSigner(KeycloakSession keycloakSession) {
        super(keycloakSession);
    }

    @Override
    public String signCredential(CredentialBody credentialBody, CredentialBuildConfig credentialBuildConfig) throws CredentialSignerException {
        if (!(credentialBody instanceof SdJwtCredentialBody)) {
            throw new CredentialSignerException("Credential body unexpectedly not of type SdJwtCredentialBody");
        }
        SdJwtCredentialBody sdJwtCredentialBody = (SdJwtCredentialBody)credentialBody;
        LOGGER.debugf("Sign credentials to sd-jwt format.", new Object[0]);
        SignatureSignerContext signer = this.getSigner(credentialBuildConfig);
        this.addX5cHeader(sdJwtCredentialBody, signer);
        return sdJwtCredentialBody.sign(signer);
    }

    private void addX5cHeader(SdJwtCredentialBody sdJwtCredentialBody, SignatureSignerContext signer) {
        List certificateChain = signer.getCertificateChain();
        if (certificateChain != null && !certificateChain.isEmpty()) {
            List x5cList = certificateChain.stream().filter(Objects::nonNull).map(cert -> {
                try {
                    return Base64.getEncoder().encodeToString(cert.getEncoded());
                }
                catch (CertificateEncodingException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            if (!x5cList.isEmpty()) {
                sdJwtCredentialBody.getIssuerSignedJWT().getJwsHeader().setX5c(x5cList);
            } else {
                LOGGER.debugf("No valid certificates found in certificate chain for x5c header in SD-JWT credential.", new Object[0]);
            }
        } else {
            LOGGER.debugf("No certificate or certificate chain available for x5c header in SD-JWT credential.", new Object[0]);
        }
    }
}

