/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserCacheInvalidationEvent;

@ProtoTypeId(value=65593)
public class UserFullInvalidationEvent
extends InvalidationEvent
implements UserCacheInvalidationEvent {
    @ProtoField(value=2)
    final String username;
    @ProtoField(value=3)
    final String email;
    @ProtoField(value=4)
    final String realmId;
    @ProtoField(value=5)
    final boolean identityFederationEnabled;
    @ProtoField(value=6, mapImplementation=HashMap.class)
    final Map<String, String> federatedIdentities;

    private UserFullInvalidationEvent(String id, String username, String email, String realmId, boolean identityFederationEnabled, Map<String, String> federatedIdentities) {
        super(id);
        this.username = Objects.requireNonNull(username);
        this.email = email;
        this.realmId = Objects.requireNonNull(realmId);
        this.federatedIdentities = federatedIdentities;
        this.identityFederationEnabled = identityFederationEnabled;
    }

    public static UserFullInvalidationEvent create(String userId, String username, String email, String realmId, boolean identityFederationEnabled, Stream<FederatedIdentityModel> federatedIdentities) {
        Map<String, String> federatedIdentitiesMap = null;
        if (identityFederationEnabled) {
            federatedIdentitiesMap = federatedIdentities.collect(Collectors.toMap(FederatedIdentityModel::getIdentityProvider, FederatedIdentityModel::getUserId));
        }
        return new UserFullInvalidationEvent(userId, username, email, realmId, identityFederationEnabled, federatedIdentitiesMap);
    }

    @ProtoFactory
    static UserFullInvalidationEvent protoFactory(String id, String username, String email, String realmId, boolean identityFederationEnabled, Map<String, String> federatedIdentities) {
        return new UserFullInvalidationEvent(id, username, email, realmId, identityFederationEnabled, federatedIdentities);
    }

    public Map<String, String> getFederatedIdentities() {
        return this.federatedIdentities;
    }

    public String toString() {
        return String.format("UserFullInvalidationEvent [ userId=%s, username=%s, email=%s ]", this.getId(), this.username, this.email);
    }

    @Override
    public void addInvalidations(UserCacheManager userCache, Set<String> invalidations) {
        userCache.fullUserInvalidation(this.getId(), this.username, this.email, this.realmId, this.identityFederationEnabled, this.federatedIdentities, invalidations);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserFullInvalidationEvent that = (UserFullInvalidationEvent)o;
        return this.identityFederationEnabled == that.identityFederationEnabled && Objects.equals(this.username, that.username) && Objects.equals(this.email, that.email) && Objects.equals(this.realmId, that.realmId) && Objects.equals(this.federatedIdentities, that.federatedIdentities);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.username, this.email, this.realmId, this.identityFederationEnabled, this.federatedIdentities);
    }
}

