/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cookie;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.cookie.CookiePathResolver;
import org.keycloak.cookie.CookieProvider;
import org.keycloak.cookie.CookieType;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.utils.SecureContextResolver;

public class DefaultCookieProvider
implements CookieProvider {
    private static final Logger logger = Logger.getLogger(DefaultCookieProvider.class);
    private final KeycloakSession session;
    private final CookiePathResolver pathResolver;
    private final boolean secure;
    private boolean warned;
    private final Map<String, Cookie> cookies;

    public DefaultCookieProvider(KeycloakSession session) {
        KeycloakContext context = session.getContext();
        this.session = session;
        this.cookies = context.getRequestHeaders().getCookies();
        this.pathResolver = new CookiePathResolver(context);
        this.secure = SecureContextResolver.isSecureContext(session);
        if (logger.isTraceEnabled()) {
            logger.tracef("Received cookies: %s, path: %s", (Object)String.join((CharSequence)", ", this.cookies.keySet()), (Object)context.getUri().getRequestUri().getRawPath());
        }
        this.expireOldUnusedCookies();
    }

    public void set(CookieType cookieType, String value) {
        if (cookieType.getDefaultMaxAge() == null) {
            throw new IllegalArgumentException(String.valueOf(cookieType) + " has no default max-age");
        }
        this.set(cookieType, value, cookieType.getDefaultMaxAge());
    }

    public void set(CookieType cookieType, String value, int maxAge) {
        String name = cookieType.getName();
        NewCookie.SameSite sameSite = cookieType.getScope().getSameSite();
        if (NewCookie.SameSite.NONE.equals((Object)sameSite) && !this.secure) {
            sameSite = NewCookie.SameSite.LAX;
        }
        String path = this.pathResolver.resolvePath(cookieType);
        boolean httpOnly = cookieType.getScope().isHttpOnly();
        NewCookie newCookie = ((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(name).version(1)).value(value)).path(path)).maxAge(maxAge)).secure(this.secure)).httpOnly(httpOnly)).sameSite(sameSite)).build();
        this.session.getContext().getHttpResponse().setCookieIfAbsent(newCookie);
        logger.tracef("Setting cookie: name: %s, path: %s, same-site: %s, secure: %s, http-only: %s, max-age: %d", new Object[]{name, path, sameSite, this.secure, httpOnly, maxAge});
        if (!this.secure && !this.warned) {
            this.warned = true;
            StringBuilder warning = new StringBuilder("Non-secure context detected; cookies are not secured, and will not be available in cross-origin POST requests.");
            String forwarded = this.session.getContext().getRequestHeaders().getHeaderString("Forwarded");
            String xForwarded = this.session.getContext().getRequestHeaders().getHeaderString("X-Forwarded-Proto");
            if (forwarded != null || xForwarded != null) {
                if (this.session.getContext().getHttpRequest().isProxyTrusted()) {
                    warning.append(" Please review your proxy settings as the request appears to have originated from a proxy.");
                } else {
                    warning.append(" This is likely due to the proxy not being trusted.");
                }
            } else {
                warning.append(" Please review whether this direct HTTP usage is expected.");
            }
            logger.warnf(warning.toString(), new Object[0]);
        }
    }

    public String get(CookieType cookieType) {
        Cookie cookie = this.cookies.get(cookieType.getName());
        return cookie != null ? cookie.getValue() : null;
    }

    public void expire(CookieType cookieType) {
        String cookieName = cookieType.getName();
        Cookie cookie = this.cookies.get(cookieName);
        if (cookie != null) {
            String path = this.pathResolver.resolvePath(cookieType);
            NewCookie newCookie = ((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(cookieName).version(1)).path(path)).maxAge(0)).build();
            this.session.getContext().getHttpResponse().setCookieIfAbsent(newCookie);
            logger.tracef("Expiring cookie: name: %s, path: %s", (Object)cookie.getName(), (Object)path);
        }
    }

    private void expireOldUnusedCookies() {
        for (CookieType cookieType : CookieType.OLD_UNUSED_COOKIES) {
            this.expire(cookieType);
        }
    }

    public void close() {
    }
}

