/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;

final class ObjectMethods {
    private static final BinaryOperator<Method> ignoreMultipleMethodsWithSameName = (first, second) -> first;
    private final Map<String, Method> writeMethods;
    private final Map<String, Method> readMethods;

    ObjectMethods(Class klass) {
        this(klass.getMethods());
    }

    ObjectMethods(Method[] methods) {
        this.readMethods = new HashMap<String, Method>(methods.length);
        this.readMethods.putAll(this.find(methods, 0, "get"));
        this.readMethods.putAll(this.find(methods, 0, "is"));
        this.writeMethods = this.find(methods, 1, "set");
    }

    private Map<String, Method> find(Method[] methods, int parametersCount, String prefix) {
        return Arrays.stream(methods).filter(m -> m.getParameterTypes().length == parametersCount).filter(m -> m.getName().startsWith(prefix)).collect(Collectors.toMap(m -> this.propertyName(m.getName(), prefix), m -> m, ignoreMultipleMethodsWithSameName));
    }

    private String propertyName(String methodName, String prefix) {
        int length = prefix.length();
        return methodName.substring(length, length + 1).toLowerCase(Locale.ROOT) + methodName.substring(length + 1);
    }

    Method getReadMethod(String propertyName) {
        return this.readMethods.get(propertyName);
    }

    Method getWriteMethod(String propertyName) {
        return this.writeMethods.get(propertyName);
    }
}

