/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.opto.Node_List;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.JFloatField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class Block
extends VMObject {
    private static AddressField nodesField;
    private static AddressField succsField;
    private static CIntField numSuccsField;
    private static CIntField preOrderField;
    private static CIntField domDepthField;
    private static AddressField idomField;
    private static JFloatField freqField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("Block");
        nodesField = type.getAddressField("_nodes");
        succsField = type.getAddressField("_succs");
        numSuccsField = new CIntField(type.getCIntegerField("_num_succs"), 0L);
        preOrderField = new CIntField(type.getCIntegerField("_pre_order"), 0L);
        domDepthField = new CIntField(type.getCIntegerField("_dom_depth"), 0L);
        idomField = type.getAddressField("_idom");
        freqField = type.getJFloatField("_freq");
    }

    public Block(Address addr) {
        super(addr);
    }

    public int preOrder() {
        return (int)preOrderField.getValue(this.getAddress());
    }

    public float freq() {
        return freqField.getValue(this.getAddress());
    }

    public Node_List nodes() {
        return new Node_List(this.getAddress().addOffsetTo(nodesField.getOffset()));
    }

    public void dump(PrintStream out) {
        out.print("B" + this.preOrder());
        out.print(" Freq: " + this.freq());
        out.println();
        Node_List nl = this.nodes();
        int cnt = nl.size();
        for (int i = 0; i < cnt; ++i) {
            nl.at(i).dump(out);
        }
        out.print("\n");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                Block.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

