# -*- coding: utf-8 -*- #
# Copyright 2025 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Flags and helpers for the compute recoverable snapshots commands."""


from googlecloudsdk.command_lib.compute import completers as compute_completers
from googlecloudsdk.command_lib.compute import flags as compute_flags


def MakeRecoverableSnapshotArg(plural=False):
  """Makes an argument for recoverable snapshots."""
  return compute_flags.ResourceArgument(
      resource_name='recoverable-snapshot',
      name='recoverable_snapshot_name',
      completer=compute_completers.RoutesCompleter,
      plural=plural,
      global_collection='compute.recoverableSnapshots',
  )
