"""Generated message classes for dataplex version v1.

A unified, intelligent governance solution for data and AI assets.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'dataplex'


class DataplexOrganizationsLocationsEncryptionConfigsCreateRequest(_messages.Message):
  r"""A DataplexOrganizationsLocationsEncryptionConfigsCreateRequest object.

  Fields:
    encryptionConfigId: Required. The ID of the EncryptionConfig to create.
      Currently, only a value of "default" is supported.
    googleCloudDataplexV1EncryptionConfig: A
      GoogleCloudDataplexV1EncryptionConfig resource to be passed as the
      request body.
    parent: Required. The location at which the EncryptionConfig is to be
      created.
  """

  encryptionConfigId = _messages.StringField(1)
  googleCloudDataplexV1EncryptionConfig = _messages.MessageField('GoogleCloudDataplexV1EncryptionConfig', 2)
  parent = _messages.StringField(3, required=True)


class DataplexOrganizationsLocationsEncryptionConfigsDeleteRequest(_messages.Message):
  r"""A DataplexOrganizationsLocationsEncryptionConfigsDeleteRequest object.

  Fields:
    etag: Optional. Etag of the EncryptionConfig. This is a strong etag.
    name: Required. The name of the EncryptionConfig to delete.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class DataplexOrganizationsLocationsEncryptionConfigsGetIamPolicyRequest(_messages.Message):
  r"""A DataplexOrganizationsLocationsEncryptionConfigsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexOrganizationsLocationsEncryptionConfigsGetRequest(_messages.Message):
  r"""A DataplexOrganizationsLocationsEncryptionConfigsGetRequest object.

  Fields:
    name: Required. The name of the EncryptionConfig to fetch.
  """

  name = _messages.StringField(1, required=True)


class DataplexOrganizationsLocationsEncryptionConfigsListRequest(_messages.Message):
  r"""A DataplexOrganizationsLocationsEncryptionConfigsListRequest object.

  Fields:
    filter: Optional. Filter the EncryptionConfigs to be returned. Using bare
      literals: (These values will be matched anywhere it may appear in the
      object's field values) * filter=some_value Using fields: (These values
      will be matched only in the specified field) *
      filter=some_field=some_value Supported fields: * name, key, create_time,
      update_time, encryption_state Example: *
      filter=name=organizations/123/locations/us-
      central1/encryptionConfigs/test-config conjunctions: (AND, OR, NOT) *
      filter=name=organizations/123/locations/us-
      central1/encryptionConfigs/test-config AND mode=CMEK logical operators:
      (>, <, >=, <=, !=, =, :), * filter=create_time>2024-05-01T00:00:00.000Z
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. Maximum number of EncryptionConfigs to return. The
      service may return fewer than this value. If unspecified, at most 10
      EncryptionConfigs will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. Page token received from a previous
      ListEncryptionConfigs call. Provide this to retrieve the subsequent
      page. When paginating, the parameters - filter and order_by provided to
      ListEncryptionConfigs must match the call that provided the page token.
    parent: Required. The location for which the EncryptionConfig is to be
      listed.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexOrganizationsLocationsEncryptionConfigsPatchRequest(_messages.Message):
  r"""A DataplexOrganizationsLocationsEncryptionConfigsPatchRequest object.

  Fields:
    googleCloudDataplexV1EncryptionConfig: A
      GoogleCloudDataplexV1EncryptionConfig resource to be passed as the
      request body.
    name: Identifier. The resource name of the EncryptionConfig. Format: organ
      izations/{organization}/locations/{location}/encryptionConfigs/{encrypti
      on_config} Global location is not supported.
    updateMask: Optional. Mask of fields to update. The service treats an
      omitted field mask as an implied field mask equivalent to all fields
      that are populated (have a non-empty value).
  """

  googleCloudDataplexV1EncryptionConfig = _messages.MessageField('GoogleCloudDataplexV1EncryptionConfig', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DataplexOrganizationsLocationsEncryptionConfigsSetIamPolicyRequest(_messages.Message):
  r"""A DataplexOrganizationsLocationsEncryptionConfigsSetIamPolicyRequest
  object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexOrganizationsLocationsEncryptionConfigsTestIamPermissionsRequest(_messages.Message):
  r"""A
  DataplexOrganizationsLocationsEncryptionConfigsTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexOrganizationsLocationsOperationsCancelRequest(_messages.Message):
  r"""A DataplexOrganizationsLocationsOperationsCancelRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class DataplexOrganizationsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A DataplexOrganizationsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DataplexOrganizationsLocationsOperationsGetRequest(_messages.Message):
  r"""A DataplexOrganizationsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DataplexOrganizationsLocationsOperationsListRequest(_messages.Message):
  r"""A DataplexOrganizationsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to true, operations that are reachable are
      returned as normal, and those that are unreachable are returned in the
      ListOperationsResponse.unreachable field.This can only be true when
      reading across collections. For example, when parent is set to
      "projects/example/locations/-".This field is not supported by default
      and will result in an UNIMPLEMENTED error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class DataplexProjectsLocationsAspectTypesCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsAspectTypesCreateRequest object.

  Fields:
    aspectTypeId: Required. AspectType identifier.
    googleCloudDataplexV1AspectType: A GoogleCloudDataplexV1AspectType
      resource to be passed as the request body.
    parent: Required. The resource name of the AspectType, of the form:
      projects/{project_number}/locations/{location_id} where location_id
      refers to a Google Cloud region.
    validateOnly: Optional. The service validates the request without
      performing any mutations. The default is false.
  """

  aspectTypeId = _messages.StringField(1)
  googleCloudDataplexV1AspectType = _messages.MessageField('GoogleCloudDataplexV1AspectType', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsAspectTypesDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsAspectTypesDeleteRequest object.

  Fields:
    etag: Optional. If the client provided etag value does not match the
      current etag value, the DeleteAspectTypeRequest method returns an
      ABORTED error response.
    name: Required. The resource name of the AspectType: projects/{project_num
      ber}/locations/{location_id}/aspectTypes/{aspect_type_id}.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsAspectTypesGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsAspectTypesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsAspectTypesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsAspectTypesGetRequest object.

  Fields:
    name: Required. The resource name of the AspectType: projects/{project_num
      ber}/locations/{location_id}/aspectTypes/{aspect_type_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsAspectTypesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsAspectTypesListRequest object.

  Fields:
    filter: Optional. Filter request. Filters are case-sensitive. The service
      supports the following formats: labels.key1 = "value1" labels:key1 name
      = "value"These restrictions can be conjoined with AND, OR, and NOT
      conjunctions.
    orderBy: Optional. Orders the result by name or create_time fields. If not
      specified, the ordering is undefined.
    pageSize: Optional. Maximum number of AspectTypes to return. The service
      may return fewer than this value. If unspecified, the service returns at
      most 10 AspectTypes. The maximum value is 1000; values above 1000 will
      be coerced to 1000.
    pageToken: Optional. Page token received from a previous ListAspectTypes
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters you provide to ListAspectTypes must match the call that
      provided the page token.
    parent: Required. The resource name of the AspectType location, of the
      form: projects/{project_number}/locations/{location_id} where
      location_id refers to a Google Cloud region.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsAspectTypesPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsAspectTypesPatchRequest object.

  Fields:
    googleCloudDataplexV1AspectType: A GoogleCloudDataplexV1AspectType
      resource to be passed as the request body.
    name: Output only. The relative resource name of the AspectType, of the
      form: projects/{project_number}/locations/{location_id}/aspectTypes/{asp
      ect_type_id}.
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1AspectType = _messages.MessageField('GoogleCloudDataplexV1AspectType', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsAspectTypesSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsAspectTypesSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsAspectTypesTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsAspectTypesTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsChangeRequestsGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsChangeRequestsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsChangeRequestsSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsChangeRequestsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsChangeRequestsTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsChangeRequestsTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataAttributeBindingsCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataAttributeBindingsCreateRequest object.

  Fields:
    dataAttributeBindingId: Required. DataAttributeBinding identifier. * Must
      contain only lowercase letters, numbers and hyphens. * Must start with a
      letter. * Must be between 1-63 characters. * Must end with a number or a
      letter. * Must be unique within the Location.
    googleCloudDataplexV1DataAttributeBinding: A
      GoogleCloudDataplexV1DataAttributeBinding resource to be passed as the
      request body.
    parent: Required. The resource name of the parent data taxonomy
      projects/{project_number}/locations/{location_id}
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  dataAttributeBindingId = _messages.StringField(1)
  googleCloudDataplexV1DataAttributeBinding = _messages.MessageField('GoogleCloudDataplexV1DataAttributeBinding', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsDataAttributeBindingsDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataAttributeBindingsDeleteRequest object.

  Fields:
    etag: Required. If the client provided etag value does not match the
      current etag value, the DeleteDataAttributeBindingRequest method returns
      an ABORTED error response. Etags must be used when calling the
      DeleteDataAttributeBinding.
    name: Required. The resource name of the DataAttributeBinding: projects/{p
      roject_number}/locations/{location_id}/dataAttributeBindings/{data_attri
      bute_binding_id}
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataAttributeBindingsGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataAttributeBindingsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataAttributeBindingsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataAttributeBindingsGetRequest object.

  Fields:
    name: Required. The resource name of the DataAttributeBinding: projects/{p
      roject_number}/locations/{location_id}/dataAttributeBindings/{data_attri
      bute_binding_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsDataAttributeBindingsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataAttributeBindingsListRequest object.

  Fields:
    filter: Optional. Filter request. Filter using resource:
      filter=resource:"resource-name" Filter using attribute:
      filter=attributes:"attribute-name" Filter using attribute in paths list:
      filter=paths.attributes:"attribute-name"
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. Maximum number of DataAttributeBindings to return. The
      service may return fewer than this value. If unspecified, at most 10
      DataAttributeBindings will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000.
    pageToken: Optional. Page token received from a previous
      ListDataAttributeBindings call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      ListDataAttributeBindings must match the call that provided the page
      token.
    parent: Required. The resource name of the Location:
      projects/{project_number}/locations/{location_id}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsDataAttributeBindingsPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataAttributeBindingsPatchRequest object.

  Fields:
    googleCloudDataplexV1DataAttributeBinding: A
      GoogleCloudDataplexV1DataAttributeBinding resource to be passed as the
      request body.
    name: Output only. The relative resource name of the Data Attribute
      Binding, of the form: projects/{project_number}/locations/{location}/dat
      aAttributeBindings/{data_attribute_binding_id}
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1DataAttributeBinding = _messages.MessageField('GoogleCloudDataplexV1DataAttributeBinding', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsDataAttributeBindingsSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataAttributeBindingsSetIamPolicyRequest
  object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataAttributeBindingsTestIamPermissionsRequest(_messages.Message):
  r"""A
  DataplexProjectsLocationsDataAttributeBindingsTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataProductsCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataProductsCreateRequest object.

  Fields:
    dataProductId: Optional. The ID of the Data Product to create.The ID must
      conform to RFC-1034 and contain only lower-case letters (a-z), numbers
      (0-9), or hyphens, with the first character a letter, the last a letter
      or a number, and a 63 character maximum. Characters outside of ASCII are
      not permitted. Valid format regex: (^a-z?$) If not provided, a system
      generated ID will be used.
    googleCloudDataplexV1DataProduct: A GoogleCloudDataplexV1DataProduct
      resource to be passed as the request body.
    parent: Required. The parent resource where this Data Product will be
      created. Format: projects/{project_id_or_number}/locations/{location_id}
    validateOnly: Optional. Validates the request without actually creating
      the Data Product. Default: false.
  """

  dataProductId = _messages.StringField(1)
  googleCloudDataplexV1DataProduct = _messages.MessageField('GoogleCloudDataplexV1DataProduct', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsDataProductsDataAssetsCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataProductsDataAssetsCreateRequest object.

  Fields:
    dataAssetId: Optional. The ID of the Data Asset to create.The ID must
      conform to RFC-1034 and contain only lower-case letters (a-z), numbers
      (0-9), or hyphens, with the first character a letter, the last a letter
      or a number, and a 63 character maximum. Characters outside of ASCII are
      not permitted. Valid format regex: (^a-z?$) If not provided, a system
      generated ID will be used.
    googleCloudDataplexV1DataAsset: A GoogleCloudDataplexV1DataAsset resource
      to be passed as the request body.
    parent: Required. The parent resource where this Data Asset will be
      created. Format: projects/{project_id_or_number}/locations/{location_id}
      /dataProducts/{data_product_id}
    validateOnly: Optional. Validates the request without actually creating
      the Data Asset. Defaults to false.
  """

  dataAssetId = _messages.StringField(1)
  googleCloudDataplexV1DataAsset = _messages.MessageField('GoogleCloudDataplexV1DataAsset', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsDataProductsDataAssetsDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataProductsDataAssetsDeleteRequest object.

  Fields:
    etag: Optional. The etag of the Data Asset. If this is provided, it must
      match the server's etag. If the etag is provided and does not match the
      server-computed etag, the request must fail with a ABORTED error code.
    name: Required. The name of the Data Asset to delete. Format: projects/{pr
      oject_id_or_number}/locations/{location_id}/dataProducts/{data_product_i
      d}/dataAssets/{data_asset_id}
    validateOnly: Optional. Validates the request without actually deleting
      the Data Asset. Defaults to false.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class DataplexProjectsLocationsDataProductsDataAssetsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataProductsDataAssetsGetRequest object.

  Fields:
    name: Required. The name of the Data Asset to retrieve. Format: projects/{
      project_id_or_number}/locations/{location_id}/dataProducts/{data_product
      _id}/dataAssets/{data_asset_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsDataProductsDataAssetsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataProductsDataAssetsListRequest object.

  Fields:
    filter: Optional. Filter expression that filters DataAssets listed in the
      response.
    orderBy: Optional. Order by expression that orders DataAssets listed in
      the response.Supported Order by fields are: name or create_time.If not
      specified, the ordering is undefined.
    pageSize: Optional. The maximum number of Data Assets to return. The
      service may return fewer than this value. If unspecified, at most 50
      Data Assets will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous ListDataAssets
      call. Provide this to retrieve the subsequent page.When paginating, all
      other parameters provided to ListDataAssets must match the call that
      provided the page token.
    parent: Required. The parent, which has this collection of Data Assets.
      Format: projects/{project_id_or_number}/locations/{location_id}/dataProd
      ucts/{data_product_id}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsDataProductsDataAssetsPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataProductsDataAssetsPatchRequest object.

  Fields:
    googleCloudDataplexV1DataAsset: A GoogleCloudDataplexV1DataAsset resource
      to be passed as the request body.
    name: Identifier. Resource name of the Data Asset. Format: projects/{proje
      ct_id_or_number}/locations/{location_id}/dataProducts/{data_product_id}/
      dataAssets/{data_asset_id}
    updateMask: Optional. The list of fields to update. If this is empty or
      not set, then all fields that are populated (have a non-empty value) in
      data_asset above will be updated.
    validateOnly: Optional. Validates the request without actually updating
      the Data Asset. Defaults to false.
  """

  googleCloudDataplexV1DataAsset = _messages.MessageField('GoogleCloudDataplexV1DataAsset', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsDataProductsDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataProductsDeleteRequest object.

  Fields:
    etag: Optional. The etag of the Data Product.If an etag is provided and
      does not match the current etag of the Data Product, then the deletion
      will be blocked and an ABORTED error will be returned.
    name: Required. The name of the Data Product to delete. Format: projects/{
      project_id_or_number}/locations/{location_id}/dataProducts/{data_product
      _id}
    validateOnly: Optional. Validates the request without actually deleting
      the Data Product. Default: false.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class DataplexProjectsLocationsDataProductsGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataProductsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataProductsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataProductsGetRequest object.

  Fields:
    name: Required. The name of the Data Product to retrieve. Format: projects
      /{project_id_or_number}/locations/{location_id}/dataProducts/{data_produ
      ct_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsDataProductsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataProductsListRequest object.

  Fields:
    filter: Optional. Filter expression that filters Data Products listed in
      the response.Example of using this filter is: display_name="my-data-
      product"
    orderBy: Optional. Order by expression that orders Data Products listed in
      the response.Supported Order by fields are: name or create_time.If not
      specified, the ordering is undefined.Ordering by create_time is not
      supported when listing resources across locations (i.e. when request
      contains /locations/-).
    pageSize: Optional. The maximum number of Data Products to return. The
      service may return fewer than this value. If unspecified, at most 50
      Data Products will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      ListDataProducts call. Provide this to retrieve the subsequent page.When
      paginating, all other parameters provided to ListDataProducts must match
      the call that provided the page token.
    parent: Required. The parent, which has this collection of Data
      Products.Format:
      projects/{project_id_or_number}/locations/{location_id}.Supports listing
      across all locations with the wildcard - (hyphen) character. Example:
      projects/{project_id_or_number}/locations/-
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsDataProductsPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataProductsPatchRequest object.

  Fields:
    googleCloudDataplexV1DataProduct: A GoogleCloudDataplexV1DataProduct
      resource to be passed as the request body.
    name: Identifier. Resource name of the Data Product. Format: projects/{pro
      ject_id_or_number}/locations/{location_id}/dataProducts/{data_product_id
      }.
    updateMask: Optional. The list of fields to update. If this is empty or
      not set, then all the fields will be updated.
    validateOnly: Optional. Validates the request without actually updating
      the Data Product. Default: false.
  """

  googleCloudDataplexV1DataProduct = _messages.MessageField('GoogleCloudDataplexV1DataProduct', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsDataProductsSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataProductsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataProductsTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataProductsTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataScansCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataScansCreateRequest object.

  Fields:
    dataScanId: Required. DataScan identifier. Must contain only lowercase
      letters, numbers and hyphens. Must start with a letter. Must end with a
      number or a letter. Must be between 1-63 characters. Must be unique
      within the customer project / location.
    googleCloudDataplexV1DataScan: A GoogleCloudDataplexV1DataScan resource to
      be passed as the request body.
    parent: Required. The resource name of the parent location:
      projects/{project}/locations/{location_id} where project refers to a
      project_id or project_number and location_id refers to a Google Cloud
      region.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  dataScanId = _messages.StringField(1)
  googleCloudDataplexV1DataScan = _messages.MessageField('GoogleCloudDataplexV1DataScan', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsDataScansDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataScansDeleteRequest object.

  Fields:
    force: Optional. If set to true, any child resources of this data scan
      will also be deleted. (Otherwise, the request will only work if the data
      scan has no child resources.)
    name: Required. The resource name of the dataScan:
      projects/{project}/locations/{location_id}/dataScans/{data_scan_id}
      where project refers to a project_id or project_number and location_id
      refers to a Google Cloud region.
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataScansGenerateDataQualityRulesRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataScansGenerateDataQualityRulesRequest
  object.

  Fields:
    googleCloudDataplexV1GenerateDataQualityRulesRequest: A
      GoogleCloudDataplexV1GenerateDataQualityRulesRequest resource to be
      passed as the request body.
    name: Required. The name must be one of the following: The name of a data
      scan with at least one successful, completed data profiling job The name
      of a successful, completed data profiling job (a data scan job where the
      job type is data profiling)
  """

  googleCloudDataplexV1GenerateDataQualityRulesRequest = _messages.MessageField('GoogleCloudDataplexV1GenerateDataQualityRulesRequest', 1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataScansGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataScansGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataScansGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataScansGetRequest object.

  Enums:
    ViewValueValuesEnum: Optional. Select the DataScan view to return.
      Defaults to BASIC.

  Fields:
    name: Required. The resource name of the dataScan:
      projects/{project}/locations/{location_id}/dataScans/{data_scan_id}
      where project refers to a project_id or project_number and location_id
      refers to a Google Cloud region.
    view: Optional. Select the DataScan view to return. Defaults to BASIC.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. Select the DataScan view to return. Defaults to BASIC.

    Values:
      DATA_SCAN_VIEW_UNSPECIFIED: The API will default to the BASIC view.
      BASIC: Basic view that does not include spec and result.
      FULL: Include everything.
    """
    DATA_SCAN_VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class DataplexProjectsLocationsDataScansJobsGenerateDataQualityRulesRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataScansJobsGenerateDataQualityRulesRequest
  object.

  Fields:
    googleCloudDataplexV1GenerateDataQualityRulesRequest: A
      GoogleCloudDataplexV1GenerateDataQualityRulesRequest resource to be
      passed as the request body.
    name: Required. The name must be one of the following: The name of a data
      scan with at least one successful, completed data profiling job The name
      of a successful, completed data profiling job (a data scan job where the
      job type is data profiling)
  """

  googleCloudDataplexV1GenerateDataQualityRulesRequest = _messages.MessageField('GoogleCloudDataplexV1GenerateDataQualityRulesRequest', 1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataScansJobsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataScansJobsGetRequest object.

  Enums:
    ViewValueValuesEnum: Optional. Select the DataScanJob view to return.
      Defaults to BASIC.

  Fields:
    name: Required. The resource name of the DataScanJob: projects/{project}/l
      ocations/{location_id}/dataScans/{data_scan_id}/jobs/{data_scan_job_id}
      where project refers to a project_id or project_number and location_id
      refers to a Google Cloud region.
    view: Optional. Select the DataScanJob view to return. Defaults to BASIC.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. Select the DataScanJob view to return. Defaults to BASIC.

    Values:
      DATA_SCAN_JOB_VIEW_UNSPECIFIED: The API will default to the BASIC view.
      BASIC: Basic view that does not include spec and result.
      FULL: Include everything.
    """
    DATA_SCAN_JOB_VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class DataplexProjectsLocationsDataScansJobsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataScansJobsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the
      ListDataScanJobs request.If unspecified, all datascan jobs will be
      returned. Multiple filters can be applied (with AND, OR logical
      operators). Filters are case-sensitive.Allowed fields are: start_time
      end_timestart_time and end_time expect RFC-3339 formatted strings (e.g.
      2018-10-08T18:30:00-07:00).For instance, 'start_time >
      2018-10-08T00:00:00.123456789Z AND end_time <
      2018-10-09T00:00:00.123456789Z' limits results to DataScanJobs between
      specified start and end times.
    pageSize: Optional. Maximum number of DataScanJobs to return. The service
      may return fewer than this value. If unspecified, at most 10
      DataScanJobs will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. Page token received from a previous ListDataScanJobs
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListDataScanJobs must match the call that
      provided the page token.
    parent: Required. The resource name of the parent environment:
      projects/{project}/locations/{location_id}/dataScans/{data_scan_id}
      where project refers to a project_id or project_number and location_id
      refers to a Google Cloud region.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DataplexProjectsLocationsDataScansListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataScansListRequest object.

  Fields:
    filter: Optional. Filter request.
    orderBy: Optional. Order by fields (name or create_time) for the result.
      If not specified, the ordering is undefined.
    pageSize: Optional. Maximum number of dataScans to return. The service may
      return fewer than this value. If unspecified, at most 500 scans will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListDataScans
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListDataScans must match the call that
      provided the page token.
    parent: Required. The resource name of the parent location:
      projects/{project}/locations/{location_id} where project refers to a
      project_id or project_number and location_id refers to a Google Cloud
      region.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsDataScansPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataScansPatchRequest object.

  Fields:
    googleCloudDataplexV1DataScan: A GoogleCloudDataplexV1DataScan resource to
      be passed as the request body.
    name: Output only. Identifier. The relative resource name of the scan, of
      the form:
      projects/{project}/locations/{location_id}/dataScans/{datascan_id},
      where project refers to a project_id or project_number and location_id
      refers to a Google Cloud region.
    updateMask: Optional. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1DataScan = _messages.MessageField('GoogleCloudDataplexV1DataScan', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsDataScansRunRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataScansRunRequest object.

  Fields:
    googleCloudDataplexV1RunDataScanRequest: A
      GoogleCloudDataplexV1RunDataScanRequest resource to be passed as the
      request body.
    name: Required. The resource name of the DataScan:
      projects/{project}/locations/{location_id}/dataScans/{data_scan_id}.
      where project refers to a project_id or project_number and location_id
      refers to a Google Cloud region.Only OnDemand data scans are allowed.
  """

  googleCloudDataplexV1RunDataScanRequest = _messages.MessageField('GoogleCloudDataplexV1RunDataScanRequest', 1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataScansSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataScansSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataScansTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataScansTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataTaxonomiesAttributesCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesAttributesCreateRequest object.

  Fields:
    dataAttributeId: Required. DataAttribute identifier. * Must contain only
      lowercase letters, numbers and hyphens. * Must start with a letter. *
      Must be between 1-63 characters. * Must end with a number or a letter. *
      Must be unique within the DataTaxonomy.
    googleCloudDataplexV1DataAttribute: A GoogleCloudDataplexV1DataAttribute
      resource to be passed as the request body.
    parent: Required. The resource name of the parent data taxonomy projects/{
      project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id
      }
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  dataAttributeId = _messages.StringField(1)
  googleCloudDataplexV1DataAttribute = _messages.MessageField('GoogleCloudDataplexV1DataAttribute', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsDataTaxonomiesAttributesDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesAttributesDeleteRequest object.

  Fields:
    etag: Optional. If the client provided etag value does not match the
      current etag value, the DeleteDataAttribute method returns an ABORTED
      error response.
    name: Required. The resource name of the DataAttribute: projects/{project_
      number}/locations/{location_id}/dataTaxonomies/{dataTaxonomy}/attributes
      /{data_attribute_id}
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataTaxonomiesAttributesGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesAttributesGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataTaxonomiesAttributesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesAttributesGetRequest object.

  Fields:
    name: Required. The resource name of the dataAttribute: projects/{project_
      number}/locations/{location_id}/dataTaxonomies/{dataTaxonomy}/attributes
      /{data_attribute_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsDataTaxonomiesAttributesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesAttributesListRequest object.

  Fields:
    filter: Optional. Filter request.
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. Maximum number of DataAttributes to return. The
      service may return fewer than this value. If unspecified, at most 10
      dataAttributes will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. Page token received from a previous
      ListDataAttributes call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to ListDataAttributes
      must match the call that provided the page token.
    parent: Required. The resource name of the DataTaxonomy: projects/{project
      _number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsDataTaxonomiesAttributesPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesAttributesPatchRequest object.

  Fields:
    googleCloudDataplexV1DataAttribute: A GoogleCloudDataplexV1DataAttribute
      resource to be passed as the request body.
    name: Output only. The relative resource name of the dataAttribute, of the
      form: projects/{project_number}/locations/{location_id}/dataTaxonomies/{
      dataTaxonomy}/attributes/{data_attribute_id}.
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1DataAttribute = _messages.MessageField('GoogleCloudDataplexV1DataAttribute', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsDataTaxonomiesAttributesSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesAttributesSetIamPolicyRequest
  object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataTaxonomiesAttributesTestIamPermissionsRequest(_messages.Message):
  r"""A
  DataplexProjectsLocationsDataTaxonomiesAttributesTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataTaxonomiesCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesCreateRequest object.

  Fields:
    dataTaxonomyId: Required. DataTaxonomy identifier. * Must contain only
      lowercase letters, numbers and hyphens. * Must start with a letter. *
      Must be between 1-63 characters. * Must end with a number or a letter. *
      Must be unique within the Project.
    googleCloudDataplexV1DataTaxonomy: A GoogleCloudDataplexV1DataTaxonomy
      resource to be passed as the request body.
    parent: A string attribute.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  dataTaxonomyId = _messages.StringField(1)
  googleCloudDataplexV1DataTaxonomy = _messages.MessageField('GoogleCloudDataplexV1DataTaxonomy', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsDataTaxonomiesDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesDeleteRequest object.

  Fields:
    etag: Optional. If the client provided etag value does not match the
      current etag value,the DeleteDataTaxonomy method returns an ABORTED
      error.
    name: Required. The resource name of the DataTaxonomy: projects/{project_n
      umber}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataTaxonomiesGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataTaxonomiesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesGetRequest object.

  Fields:
    name: A string attribute.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsDataTaxonomiesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesListRequest object.

  Fields:
    filter: Optional. Filter request.
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. Maximum number of DataTaxonomies to return. The
      service may return fewer than this value. If unspecified, at most 10
      DataTaxonomies will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. Page token received from a previous
      ListDataTaxonomies call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to ListDataTaxonomies
      must match the call that provided the page token.
    parent: Required. The resource name of the DataTaxonomy location, of the
      form: projects/{project_number}/locations/{location_id} where
      location_id refers to a Google Cloud region.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsDataTaxonomiesPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesPatchRequest object.

  Fields:
    googleCloudDataplexV1DataTaxonomy: A GoogleCloudDataplexV1DataTaxonomy
      resource to be passed as the request body.
    name: Output only. The relative resource name of the DataTaxonomy, of the
      form: projects/{project_number}/locations/{location_id}/dataTaxonomies/{
      data_taxonomy_id}.
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1DataTaxonomy = _messages.MessageField('GoogleCloudDataplexV1DataTaxonomy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsDataTaxonomiesSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsDataTaxonomiesTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsDataTaxonomiesTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsEntryGroupsCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsCreateRequest object.

  Fields:
    entryGroupId: Required. EntryGroup identifier.
    googleCloudDataplexV1EntryGroup: A GoogleCloudDataplexV1EntryGroup
      resource to be passed as the request body.
    parent: Required. The resource name of the entryGroup, of the form:
      projects/{project_number}/locations/{location_id} where location_id
      refers to a Google Cloud region.
    validateOnly: Optional. The service validates the request without
      performing any mutations. The default is false.
  """

  entryGroupId = _messages.StringField(1)
  googleCloudDataplexV1EntryGroup = _messages.MessageField('GoogleCloudDataplexV1EntryGroup', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsEntryGroupsDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsDeleteRequest object.

  Fields:
    etag: Optional. If the client provided etag value does not match the
      current etag value, the DeleteEntryGroupRequest method returns an
      ABORTED error response.
    name: Required. The resource name of the EntryGroup: projects/{project_num
      ber}/locations/{location_id}/entryGroups/{entry_group_id}.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsEntryGroupsEntriesCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsEntriesCreateRequest object.

  Fields:
    entryId: Required. Entry identifier. It has to be unique within an Entry
      Group.Entries corresponding to Google Cloud resources use an Entry ID
      format based on full resource names (https://cloud.google.com/apis/desig
      n/resource_names#full_resource_name). The format is a full resource name
      of the resource without the prefix double slashes in the API service
      name part of the full resource name. This allows retrieval of entries
      using their associated resource name.For example, if the full resource
      name of a resource is
      //library.googleapis.com/shelves/shelf1/books/book2, then the suggested
      entry_id is library.googleapis.com/shelves/shelf1/books/book2.It is also
      suggested to follow the same convention for entries corresponding to
      resources from providers or systems other than Google Cloud.The maximum
      size of the field is 4000 characters.
    googleCloudDataplexV1Entry: A GoogleCloudDataplexV1Entry resource to be
      passed as the request body.
    parent: Required. The resource name of the parent Entry Group:
      projects/{project}/locations/{location}/entryGroups/{entry_group}.
  """

  entryId = _messages.StringField(1)
  googleCloudDataplexV1Entry = _messages.MessageField('GoogleCloudDataplexV1Entry', 2)
  parent = _messages.StringField(3, required=True)


class DataplexProjectsLocationsEntryGroupsEntriesDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsEntriesDeleteRequest object.

  Fields:
    name: Required. The resource name of the Entry: projects/{project}/locatio
      ns/{location}/entryGroups/{entry_group}/entries/{entry}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsEntryGroupsEntriesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsEntriesGetRequest object.

  Enums:
    ViewValueValuesEnum: Optional. View to control which parts of an entry the
      service should return.

  Fields:
    aspectTypes: Optional. Limits the aspects returned to the provided aspect
      types. It only works for CUSTOM view.
    name: Required. The resource name of the Entry: projects/{project}/locatio
      ns/{location}/entryGroups/{entry_group}/entries/{entry}.
    paths: Optional. Limits the aspects returned to those associated with the
      provided paths within the Entry. It only works for CUSTOM view.
    view: Optional. View to control which parts of an entry the service should
      return.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. View to control which parts of an entry the service should
    return.

    Values:
      ENTRY_VIEW_UNSPECIFIED: Unspecified EntryView. Defaults to FULL.
      BASIC: Returns entry only, without aspects.
      FULL: Returns all required aspects as well as the keys of all non-
        required aspects.
      CUSTOM: Returns aspects matching custom fields in GetEntryRequest. If
        the number of aspects exceeds 100, the first 100 will be returned.
      ALL: Returns all aspects. If the number of aspects exceeds 100, the
        first 100 will be returned.
    """
    ENTRY_VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2
    CUSTOM = 3
    ALL = 4

  aspectTypes = _messages.StringField(1, repeated=True)
  name = _messages.StringField(2, required=True)
  paths = _messages.StringField(3, repeated=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class DataplexProjectsLocationsEntryGroupsEntriesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsEntriesListRequest object.

  Fields:
    filter: Optional. A filter on the entries to return. Filters are case-
      sensitive. You can filter the request by the following fields:
      entry_type entry_source.display_name parent_entryThe comparison
      operators are =, !=, <, >, <=, >=. The service compares strings
      according to lexical order.You can use the logical operators AND, OR,
      NOT in the filter.You can use Wildcard "*", but for entry_type and
      parent_entry you need to provide the full project id or number.You
      cannot use parent_entry in conjunction with other fields.Example filter
      expressions: "entry_source.display_name=AnExampleDisplayName"
      "entry_type=projects/example-
      project/locations/global/entryTypes/example-entry_type"
      "entry_type=projects/example-project/locations/us/entryTypes/a* OR
      entry_type=projects/another-project/locations/*" "NOT
      entry_source.display_name=AnotherExampleDisplayName"
      "parent_entry=projects/example-project/locations/us/entryGroups/example-
      entry-group/entries/example-entry"
    pageSize: Optional. Number of items to return per page. If there are
      remaining results, the service returns a next_page_token. If
      unspecified, the service returns at most 10 Entries. The maximum value
      is 100; values above 100 will be coerced to 100.
    pageToken: Optional. Page token received from a previous ListEntries call.
      Provide this to retrieve the subsequent page.
    parent: Required. The resource name of the parent Entry Group:
      projects/{project}/locations/{location}/entryGroups/{entry_group}.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DataplexProjectsLocationsEntryGroupsEntriesPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsEntriesPatchRequest object.

  Fields:
    allowMissing: Optional. If set to true and the entry doesn't exist, the
      service will create it.
    aspectKeys: Optional. The map keys of the Aspects which the service should
      modify. It supports the following syntaxes: - matches an aspect of the
      given type and empty path. @path - matches an aspect of the given type
      and specified path. For example, to attach an aspect to a field that is
      specified by the schema aspect, the path should have the format Schema..
      @* - matches aspects of the given type for all paths. *@path - matches
      aspects of all types on the given path.The service will not remove
      existing aspects matching the syntax unless delete_missing_aspects is
      set to true.If this field is left empty, the service treats it as
      specifying exactly those Aspects present in the request.
    deleteMissingAspects: Optional. If set to true and the aspect_keys specify
      aspect ranges, the service deletes any existing aspects from that range
      that weren't provided in the request.
    googleCloudDataplexV1Entry: A GoogleCloudDataplexV1Entry resource to be
      passed as the request body.
    name: Identifier. The relative resource name of the entry, in the format p
      rojects/{project_id_or_number}/locations/{location_id}/entryGroups/{entr
      y_group_id}/entries/{entry_id}.
    updateMask: Optional. Mask of fields to update. To update Aspects, the
      update_mask must contain the value "aspects".If the update_mask is
      empty, the service will update all modifiable fields present in the
      request.
  """

  allowMissing = _messages.BooleanField(1)
  aspectKeys = _messages.StringField(2, repeated=True)
  deleteMissingAspects = _messages.BooleanField(3)
  googleCloudDataplexV1Entry = _messages.MessageField('GoogleCloudDataplexV1Entry', 4)
  name = _messages.StringField(5, required=True)
  updateMask = _messages.StringField(6)


class DataplexProjectsLocationsEntryGroupsEntryLinksCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsEntryLinksCreateRequest object.

  Fields:
    entryLinkId: Required. Entry Link identifier * Must contain only lowercase
      letters, numbers and hyphens. * Must start with a letter. * Must be
      between 1-63 characters. * Must end with a number or a letter. * Must be
      unique within the EntryGroup.
    googleCloudDataplexV1EntryLink: A GoogleCloudDataplexV1EntryLink resource
      to be passed as the request body.
    parent: Required. The resource name of the parent Entry Group: projects/{p
      roject_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id
      }.
  """

  entryLinkId = _messages.StringField(1)
  googleCloudDataplexV1EntryLink = _messages.MessageField('GoogleCloudDataplexV1EntryLink', 2)
  parent = _messages.StringField(3, required=True)


class DataplexProjectsLocationsEntryGroupsEntryLinksDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsEntryLinksDeleteRequest object.

  Fields:
    name: Required. The resource name of the Entry Link: projects/{project_id_
      or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLin
      ks/{entry_link_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsEntryGroupsEntryLinksGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsEntryLinksGetRequest object.

  Fields:
    name: Required. The resource name of the Entry Link: projects/{project_id_
      or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLin
      ks/{entry_link_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsEntryGroupsGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsEntryGroupsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsGetRequest object.

  Fields:
    name: Required. The resource name of the EntryGroup: projects/{project_num
      ber}/locations/{location_id}/entryGroups/{entry_group_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsEntryGroupsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsListRequest object.

  Fields:
    filter: Optional. Filter request.
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. Maximum number of EntryGroups to return. The service
      may return fewer than this value. If unspecified, the service returns at
      most 10 EntryGroups. The maximum value is 1000; values above 1000 will
      be coerced to 1000.
    pageToken: Optional. Page token received from a previous ListEntryGroups
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters you provide to ListEntryGroups must match the call that
      provided the page token.
    parent: Required. The resource name of the entryGroup location, of the
      form: projects/{project_number}/locations/{location_id} where
      location_id refers to a Google Cloud region.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsEntryGroupsPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsPatchRequest object.

  Fields:
    googleCloudDataplexV1EntryGroup: A GoogleCloudDataplexV1EntryGroup
      resource to be passed as the request body.
    name: Output only. The relative resource name of the EntryGroup, in the
      format projects/{project_id_or_number}/locations/{location_id}/entryGrou
      ps/{entry_group_id}.
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. The service validates the request, without
      performing any mutations. The default is false.
  """

  googleCloudDataplexV1EntryGroup = _messages.MessageField('GoogleCloudDataplexV1EntryGroup', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsEntryGroupsSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsEntryGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryGroupsTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsEntryLinkTypesGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryLinkTypesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsEntryLinkTypesSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryLinkTypesSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsEntryLinkTypesTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryLinkTypesTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsEntryTypesCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryTypesCreateRequest object.

  Fields:
    entryTypeId: Required. EntryType identifier.
    googleCloudDataplexV1EntryType: A GoogleCloudDataplexV1EntryType resource
      to be passed as the request body.
    parent: Required. The resource name of the EntryType, of the form:
      projects/{project_number}/locations/{location_id} where location_id
      refers to a Google Cloud region.
    validateOnly: Optional. The service validates the request without
      performing any mutations. The default is false.
  """

  entryTypeId = _messages.StringField(1)
  googleCloudDataplexV1EntryType = _messages.MessageField('GoogleCloudDataplexV1EntryType', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsEntryTypesDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryTypesDeleteRequest object.

  Fields:
    etag: Optional. If the client provided etag value does not match the
      current etag value, the DeleteEntryTypeRequest method returns an ABORTED
      error response.
    name: Required. The resource name of the EntryType: projects/{project_numb
      er}/locations/{location_id}/entryTypes/{entry_type_id}.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsEntryTypesGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryTypesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsEntryTypesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryTypesGetRequest object.

  Fields:
    name: Required. The resource name of the EntryType: projects/{project_numb
      er}/locations/{location_id}/entryTypes/{entry_type_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsEntryTypesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryTypesListRequest object.

  Fields:
    filter: Optional. Filter request. Filters are case-sensitive. The service
      supports the following formats: labels.key1 = "value1" labels:key1 name
      = "value"These restrictions can be conjoined with AND, OR, and NOT
      conjunctions.
    orderBy: Optional. Orders the result by name or create_time fields. If not
      specified, the ordering is undefined.
    pageSize: Optional. Maximum number of EntryTypes to return. The service
      may return fewer than this value. If unspecified, the service returns at
      most 10 EntryTypes. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. Page token received from a previous ListEntryTypes
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters you provided to ListEntryTypes must match the call that
      provided the page token.
    parent: Required. The resource name of the EntryType location, of the
      form: projects/{project_number}/locations/{location_id} where
      location_id refers to a Google Cloud region.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsEntryTypesPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryTypesPatchRequest object.

  Fields:
    googleCloudDataplexV1EntryType: A GoogleCloudDataplexV1EntryType resource
      to be passed as the request body.
    name: Output only. The relative resource name of the EntryType, of the
      form: projects/{project_number}/locations/{location_id}/entryTypes/{entr
      y_type_id}.
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. The service validates the request without
      performing any mutations. The default is false.
  """

  googleCloudDataplexV1EntryType = _messages.MessageField('GoogleCloudDataplexV1EntryType', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsEntryTypesSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryTypesSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsEntryTypesTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsEntryTypesTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsGlossariesCategoriesCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesCategoriesCreateRequest object.

  Fields:
    categoryId: Required. GlossaryCategory identifier.
    googleCloudDataplexV1GlossaryCategory: A
      GoogleCloudDataplexV1GlossaryCategory resource to be passed as the
      request body.
    parent: Required. The parent resource where this GlossaryCategory will be
      created. Format: projects/{project_id_or_number}/locations/{location_id}
      /glossaries/{glossary_id} where locationId refers to a Google Cloud
      region.
  """

  categoryId = _messages.StringField(1)
  googleCloudDataplexV1GlossaryCategory = _messages.MessageField('GoogleCloudDataplexV1GlossaryCategory', 2)
  parent = _messages.StringField(3, required=True)


class DataplexProjectsLocationsGlossariesCategoriesDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesCategoriesDeleteRequest object.

  Fields:
    name: Required. The name of the GlossaryCategory to delete. Format: projec
      ts/{project_id_or_number}/locations/{location_id}/glossaries/{glossary_i
      d}/categories/{category_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsGlossariesCategoriesGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesCategoriesGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsGlossariesCategoriesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesCategoriesGetRequest object.

  Fields:
    name: Required. The name of the GlossaryCategory to retrieve. Format: proj
      ects/{project_id_or_number}/locations/{location_id}/glossaries/{glossary
      _id}/categories/{category_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsGlossariesCategoriesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesCategoriesListRequest object.

  Fields:
    filter: Optional. Filter expression that filters GlossaryCategories listed
      in the response. Filters are supported on the following fields: -
      immediate_parentExamples of using a filter are: - immediate_parent="proj
      ects/{project_id_or_number}/locations/{location_id}/glossaries/{glossary
      _id}" - immediate_parent="projects/{project_id_or_number}/locations/{loc
      ation_id}/glossaries/{glossary_id}/categories/{category_id}"This will
      only return the GlossaryCategories that are directly nested under the
      specified parent.
    orderBy: Optional. Order by expression that orders GlossaryCategories
      listed in the response. Order by fields are: name or create_time for the
      result. If not specified, the ordering is undefined.
    pageSize: Optional. The maximum number of GlossaryCategories to return.
      The service may return fewer than this value. If unspecified, at most 50
      GlossaryCategories will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      ListGlossaryCategories call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      ListGlossaryCategories must match the call that provided the page token.
    parent: Required. The parent, which has this collection of
      GlossaryCategories. Format: projects/{project_id_or_number}/locations/{l
      ocation_id}/glossaries/{glossary_id} Location is the Google Cloud
      region.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsGlossariesCategoriesPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesCategoriesPatchRequest object.

  Fields:
    googleCloudDataplexV1GlossaryCategory: A
      GoogleCloudDataplexV1GlossaryCategory resource to be passed as the
      request body.
    name: Output only. Identifier. The resource name of the GlossaryCategory.
      Format: projects/{project_id_or_number}/locations/{location_id}/glossari
      es/{glossary_id}/categories/{category_id}
    updateMask: Required. The list of fields to update.
  """

  googleCloudDataplexV1GlossaryCategory = _messages.MessageField('GoogleCloudDataplexV1GlossaryCategory', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DataplexProjectsLocationsGlossariesCategoriesSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesCategoriesSetIamPolicyRequest
  object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsGlossariesCategoriesTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesCategoriesTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsGlossariesCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesCreateRequest object.

  Fields:
    glossaryId: Required. Glossary ID: Glossary identifier.
    googleCloudDataplexV1Glossary: A GoogleCloudDataplexV1Glossary resource to
      be passed as the request body.
    parent: Required. The parent resource where this Glossary will be created.
      Format: projects/{project_id_or_number}/locations/{location_id} where
      location_id refers to a Google Cloud region.
    validateOnly: Optional. Validates the request without actually creating
      the Glossary. Default: false.
  """

  glossaryId = _messages.StringField(1)
  googleCloudDataplexV1Glossary = _messages.MessageField('GoogleCloudDataplexV1Glossary', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsGlossariesDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesDeleteRequest object.

  Fields:
    etag: Optional. The etag of the Glossary. If this is provided, it must
      match the server's etag. If the etag is provided and does not match the
      server-computed etag, the request must fail with a ABORTED error code.
    name: Required. The name of the Glossary to delete. Format: projects/{proj
      ect_id_or_number}/locations/{location_id}/glossaries/{glossary_id}
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsGlossariesGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsGlossariesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesGetRequest object.

  Fields:
    name: Required. The name of the Glossary to retrieve. Format: projects/{pr
      oject_id_or_number}/locations/{location_id}/glossaries/{glossary_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsGlossariesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesListRequest object.

  Fields:
    filter: Optional. Filter expression that filters Glossaries listed in the
      response. Filters on proto fields of Glossary are supported. Examples of
      using a filter are: - display_name="my-glossary" - categoryCount=1 -
      termCount=0
    orderBy: Optional. Order by expression that orders Glossaries listed in
      the response. Order by fields are: name or create_time for the result.
      If not specified, the ordering is undefined.
    pageSize: Optional. The maximum number of Glossaries to return. The
      service may return fewer than this value. If unspecified, at most 50
      Glossaries will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous ListGlossaries
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListGlossaries must match the call that
      provided the page token.
    parent: Required. The parent, which has this collection of Glossaries.
      Format: projects/{project_id_or_number}/locations/{location_id} where
      location_id refers to a Google Cloud region.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsGlossariesPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesPatchRequest object.

  Fields:
    googleCloudDataplexV1Glossary: A GoogleCloudDataplexV1Glossary resource to
      be passed as the request body.
    name: Output only. Identifier. The resource name of the Glossary. Format:
      projects/{project_id_or_number}/locations/{location_id}/glossaries/{glos
      sary_id}
    updateMask: Required. The list of fields to update.
    validateOnly: Optional. Validates the request without actually updating
      the Glossary. Default: false.
  """

  googleCloudDataplexV1Glossary = _messages.MessageField('GoogleCloudDataplexV1Glossary', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsGlossariesSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsGlossariesTermsCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesTermsCreateRequest object.

  Fields:
    googleCloudDataplexV1GlossaryTerm: A GoogleCloudDataplexV1GlossaryTerm
      resource to be passed as the request body.
    parent: Required. The parent resource where the GlossaryTerm will be
      created. Format: projects/{project_id_or_number}/locations/{location_id}
      /glossaries/{glossary_id} where location_id refers to a Google Cloud
      region.
    termId: Required. GlossaryTerm identifier.
  """

  googleCloudDataplexV1GlossaryTerm = _messages.MessageField('GoogleCloudDataplexV1GlossaryTerm', 1)
  parent = _messages.StringField(2, required=True)
  termId = _messages.StringField(3)


class DataplexProjectsLocationsGlossariesTermsDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesTermsDeleteRequest object.

  Fields:
    name: Required. The name of the GlossaryTerm to delete. Format: projects/{
      project_id_or_number}/locations/{location_id}/glossaries/{glossary_id}/t
      erms/{term_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsGlossariesTermsGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesTermsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsGlossariesTermsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesTermsGetRequest object.

  Fields:
    name: Required. The name of the GlossaryTerm to retrieve. Format: projects
      /{project_id_or_number}/locations/{location_id}/glossaries/{glossary_id}
      /terms/{term_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsGlossariesTermsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesTermsListRequest object.

  Fields:
    filter: Optional. Filter expression that filters GlossaryTerms listed in
      the response. Filters are supported on the following fields: -
      immediate_parentExamples of using a filter are: - immediate_parent="proj
      ects/{project_id_or_number}/locations/{location_id}/glossaries/{glossary
      _id}" - immediate_parent="projects/{project_id_or_number}/locations/{loc
      ation_id}/glossaries/{glossary_id}/categories/{category_id}"This will
      only return the GlossaryTerms that are directly nested under the
      specified parent.
    orderBy: Optional. Order by expression that orders GlossaryTerms listed in
      the response. Order by fields are: name or create_time for the result.
      If not specified, the ordering is undefined.
    pageSize: Optional. The maximum number of GlossaryTerms to return. The
      service may return fewer than this value. If unspecified, at most 50
      GlossaryTerms will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      ListGlossaryTerms call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to ListGlossaryTerms must
      match the call that provided the page token.
    parent: Required. The parent, which has this collection of GlossaryTerms.
      Format: projects/{project_id_or_number}/locations/{location_id}/glossari
      es/{glossary_id} where location_id refers to a Google Cloud region.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsGlossariesTermsPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesTermsPatchRequest object.

  Fields:
    googleCloudDataplexV1GlossaryTerm: A GoogleCloudDataplexV1GlossaryTerm
      resource to be passed as the request body.
    name: Output only. Identifier. The resource name of the GlossaryTerm.
      Format: projects/{project_id_or_number}/locations/{location_id}/glossari
      es/{glossary_id}/terms/{term_id}
    updateMask: Required. The list of fields to update.
  """

  googleCloudDataplexV1GlossaryTerm = _messages.MessageField('GoogleCloudDataplexV1GlossaryTerm', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DataplexProjectsLocationsGlossariesTermsSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesTermsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsGlossariesTermsTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesTermsTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsGlossariesTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGlossariesTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsGovernanceRulesCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGovernanceRulesCreateRequest object.

  Fields:
    googleCloudDataplexV1GovernanceRule: A GoogleCloudDataplexV1GovernanceRule
      resource to be passed as the request body.
    governanceRuleId: Required. GovernanceRule identifier. * Must contain only
      lowercase letters, numbers and hyphens. * Must start with a letter. *
      Must be between 1-63 characters. * Must end with a number or a letter. *
      Must be unique within the Project.
    parent: Required. The resource name of the governance rule location, of
      the form: projects/{project_number}/locations/{location_id} where
      location_id refers to a Google Cloud region.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1GovernanceRule = _messages.MessageField('GoogleCloudDataplexV1GovernanceRule', 1)
  governanceRuleId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsGovernanceRulesDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGovernanceRulesDeleteRequest object.

  Fields:
    name: Required. The resource name of the GovernanceRule. projects/{project
      _number}/locations/{location_id}/governanceRules/{governance_rule_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsGovernanceRulesGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGovernanceRulesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsGovernanceRulesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGovernanceRulesGetRequest object.

  Fields:
    name: Required. The resource name of the GovernanceRule: projects/{project
      _number}/locations/{location_id}/governanceRules/{governance_rule_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsGovernanceRulesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGovernanceRulesListRequest object.

  Fields:
    filter: Optional. Filter request.
    pageSize: Optional. Maximum number of GovernanceRules to return. The
      service may return fewer than this value. If unspecified, at most 10
      GovernanceRules will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. Page token received from a previous
      ListGovernanceRules call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to ListGovernanceRules
      must match the call that provided the page token.
    parent: Required. The resource name of the GovernanceRule location, of the
      form: projects/{project_number}/locations/{location_id} where
      location_id refers to a Google Cloud region.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DataplexProjectsLocationsGovernanceRulesPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGovernanceRulesPatchRequest object.

  Fields:
    googleCloudDataplexV1GovernanceRule: A GoogleCloudDataplexV1GovernanceRule
      resource to be passed as the request body.
    name: Output only. The relative resource name of the Rule, of the form:
      projects/{project_number}/locations/{location}/rules/{rule_id}
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1GovernanceRule = _messages.MessageField('GoogleCloudDataplexV1GovernanceRule', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsGovernanceRulesSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGovernanceRulesSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsGovernanceRulesTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGovernanceRulesTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesActionsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesActionsListRequest object.

  Fields:
    pageSize: Optional. Maximum number of actions to return. The service may
      return fewer than this value. If unspecified, at most 10 actions will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListLakeActions
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListLakeActions must match the call that
      provided the page token.
    parent: Required. The resource name of the parent lake:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DataplexProjectsLocationsLakesContentCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentCreateRequest object.

  Fields:
    googleCloudDataplexV1Content: A GoogleCloudDataplexV1Content resource to
      be passed as the request body.
    parent: Required. The resource name of the parent lake:
      projects/{project_id}/locations/{location_id}/lakes/{lake_id}
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Content = _messages.MessageField('GoogleCloudDataplexV1Content', 1)
  parent = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class DataplexProjectsLocationsLakesContentDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentDeleteRequest object.

  Fields:
    name: Required. The resource name of the content: projects/{project_id}/lo
      cations/{location_id}/lakes/{lake_id}/content/{content_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesContentGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesContentGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentGetRequest object.

  Enums:
    ViewValueValuesEnum: Optional. Specify content view to make a partial
      request.

  Fields:
    name: Required. The resource name of the content: projects/{project_id}/lo
      cations/{location_id}/lakes/{lake_id}/content/{content_id}
    view: Optional. Specify content view to make a partial request.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. Specify content view to make a partial request.

    Values:
      CONTENT_VIEW_UNSPECIFIED: Content view not specified. Defaults to BASIC.
        The API will default to the BASIC view.
      BASIC: Will not return the data_text field.
      FULL: Returns the complete proto.
    """
    CONTENT_VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class DataplexProjectsLocationsLakesContentListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentListRequest object.

  Fields:
    filter: Optional. Filter request. Filters are case-sensitive. The
      following formats are supported:labels.key1 = "value1" labels:key1 type
      = "NOTEBOOK" type = "SQL_SCRIPT"These restrictions can be coinjoined
      with AND, OR and NOT conjunctions.
    pageSize: Optional. Maximum number of content to return. The service may
      return fewer than this value. If unspecified, at most 10 content will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListContent call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to ListContent must match the call that provided the
      page token.
    parent: Required. The resource name of the parent lake:
      projects/{project_id}/locations/{location_id}/lakes/{lake_id}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DataplexProjectsLocationsLakesContentPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentPatchRequest object.

  Fields:
    googleCloudDataplexV1Content: A GoogleCloudDataplexV1Content resource to
      be passed as the request body.
    name: Output only. The relative resource name of the content, of the form:
      projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{c
      ontent_id}
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Content = _messages.MessageField('GoogleCloudDataplexV1Content', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesContentSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesContentTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesContentitemsCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentitemsCreateRequest object.

  Fields:
    googleCloudDataplexV1Content: A GoogleCloudDataplexV1Content resource to
      be passed as the request body.
    parent: Required. The resource name of the parent lake:
      projects/{project_id}/locations/{location_id}/lakes/{lake_id}
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Content = _messages.MessageField('GoogleCloudDataplexV1Content', 1)
  parent = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class DataplexProjectsLocationsLakesContentitemsDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentitemsDeleteRequest object.

  Fields:
    name: Required. The resource name of the content: projects/{project_id}/lo
      cations/{location_id}/lakes/{lake_id}/content/{content_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesContentitemsGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentitemsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesContentitemsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentitemsGetRequest object.

  Enums:
    ViewValueValuesEnum: Optional. Specify content view to make a partial
      request.

  Fields:
    name: Required. The resource name of the content: projects/{project_id}/lo
      cations/{location_id}/lakes/{lake_id}/content/{content_id}
    view: Optional. Specify content view to make a partial request.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. Specify content view to make a partial request.

    Values:
      CONTENT_VIEW_UNSPECIFIED: Content view not specified. Defaults to BASIC.
        The API will default to the BASIC view.
      BASIC: Will not return the data_text field.
      FULL: Returns the complete proto.
    """
    CONTENT_VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class DataplexProjectsLocationsLakesContentitemsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentitemsListRequest object.

  Fields:
    filter: Optional. Filter request. Filters are case-sensitive. The
      following formats are supported:labels.key1 = "value1" labels:key1 type
      = "NOTEBOOK" type = "SQL_SCRIPT"These restrictions can be coinjoined
      with AND, OR and NOT conjunctions.
    pageSize: Optional. Maximum number of content to return. The service may
      return fewer than this value. If unspecified, at most 10 content will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListContent call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to ListContent must match the call that provided the
      page token.
    parent: Required. The resource name of the parent lake:
      projects/{project_id}/locations/{location_id}/lakes/{lake_id}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DataplexProjectsLocationsLakesContentitemsPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentitemsPatchRequest object.

  Fields:
    googleCloudDataplexV1Content: A GoogleCloudDataplexV1Content resource to
      be passed as the request body.
    name: Output only. The relative resource name of the content, of the form:
      projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{c
      ontent_id}
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Content = _messages.MessageField('GoogleCloudDataplexV1Content', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesContentitemsSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentitemsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesContentitemsTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentitemsTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesCreateRequest object.

  Fields:
    googleCloudDataplexV1Lake: A GoogleCloudDataplexV1Lake resource to be
      passed as the request body.
    lakeId: Required. Lake identifier. This ID will be used to generate names
      such as database and dataset names when publishing metadata to Hive
      Metastore and BigQuery. * Must contain only lowercase letters, numbers
      and hyphens. * Must start with a letter. * Must end with a number or a
      letter. * Must be between 1-63 characters. * Must be unique within the
      customer project / location.
    parent: Required. The resource name of the lake location, of the form:
      projects/{project_number}/locations/{location_id} where location_id
      refers to a Google Cloud region.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Lake = _messages.MessageField('GoogleCloudDataplexV1Lake', 1)
  lakeId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesDeleteRequest object.

  Fields:
    name: Required. The resource name of the lake:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesEnvironmentsCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesEnvironmentsCreateRequest object.

  Fields:
    environmentId: Required. Environment identifier. * Must contain only
      lowercase letters, numbers and hyphens. * Must start with a letter. *
      Must be between 1-63 characters. * Must end with a number or a letter. *
      Must be unique within the lake.
    googleCloudDataplexV1Environment: A GoogleCloudDataplexV1Environment
      resource to be passed as the request body.
    parent: Required. The resource name of the parent lake:
      projects/{project_id}/locations/{location_id}/lakes/{lake_id}.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  environmentId = _messages.StringField(1)
  googleCloudDataplexV1Environment = _messages.MessageField('GoogleCloudDataplexV1Environment', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesEnvironmentsDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesEnvironmentsDeleteRequest object.

  Fields:
    name: Required. The resource name of the environment: projects/{project_id
      }/locations/{location_id}/lakes/{lake_id}/environments/{environment_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesEnvironmentsGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesEnvironmentsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesEnvironmentsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesEnvironmentsGetRequest object.

  Fields:
    name: Required. The resource name of the environment: projects/{project_id
      }/locations/{location_id}/lakes/{lake_id}/environments/{environment_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesEnvironmentsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesEnvironmentsListRequest object.

  Fields:
    filter: Optional. Filter request.
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. Maximum number of environments to return. The service
      may return fewer than this value. If unspecified, at most 10
      environments will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. Page token received from a previous ListEnvironments
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListEnvironments must match the call that
      provided the page token.
    parent: Required. The resource name of the parent lake:
      projects/{project_id}/locations/{location_id}/lakes/{lake_id}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsLakesEnvironmentsPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesEnvironmentsPatchRequest object.

  Fields:
    googleCloudDataplexV1Environment: A GoogleCloudDataplexV1Environment
      resource to be passed as the request body.
    name: Output only. The relative resource name of the environment, of the
      form: projects/{project_id}/locations/{location_id}/lakes/{lake_id}/envi
      ronment/{environment_id}
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Environment = _messages.MessageField('GoogleCloudDataplexV1Environment', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesEnvironmentsSessionsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesEnvironmentsSessionsListRequest object.

  Fields:
    filter: Optional. Filter request. The following mode filter is supported
      to return only the sessions belonging to the requester when the mode is
      USER and return sessions of all the users when the mode is ADMIN. When
      no filter is sent default to USER mode. NOTE: When the mode is ADMIN,
      the requester should have dataplex.environments.listAllSessions
      permission to list all sessions, in absence of the permission, the
      request fails.mode = ADMIN | USER
    pageSize: Optional. Maximum number of sessions to return. The service may
      return fewer than this value. If unspecified, at most 10 sessions will
      be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. Page token received from a previous ListSessions
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListSessions must match the call that
      provided the page token.
    parent: Required. The resource name of the parent environment: projects/{p
      roject_number}/locations/{location_id}/lakes/{lake_id}/environment/{envi
      ronment_id}.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DataplexProjectsLocationsLakesEnvironmentsSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesEnvironmentsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesEnvironmentsTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesEnvironmentsTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesGetRequest object.

  Fields:
    name: Required. The resource name of the lake:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesListRequest object.

  Fields:
    filter: Optional. Filter request.
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. Maximum number of Lakes to return. The service may
      return fewer than this value. If unspecified, at most 10 lakes will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListLakes call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to ListLakes must match the call that provided the
      page token.
    parent: Required. The resource name of the lake location, of the form:
      projects/{project_number}/locations/{location_id} where location_id
      refers to a Google Cloud region.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsLakesPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesPatchRequest object.

  Fields:
    googleCloudDataplexV1Lake: A GoogleCloudDataplexV1Lake resource to be
      passed as the request body.
    name: Output only. The relative resource name of the lake, of the form:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Lake = _messages.MessageField('GoogleCloudDataplexV1Lake', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesTasksCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksCreateRequest object.

  Fields:
    googleCloudDataplexV1Task: A GoogleCloudDataplexV1Task resource to be
      passed as the request body.
    parent: Required. The resource name of the parent lake:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
    taskId: Required. Task identifier.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Task = _messages.MessageField('GoogleCloudDataplexV1Task', 1)
  parent = _messages.StringField(2, required=True)
  taskId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesTasksDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksDeleteRequest object.

  Fields:
    name: Required. The resource name of the task: projects/{project_number}/l
      ocations/{location_id}/lakes/{lake_id}/task/{task_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesTasksGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesTasksGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksGetRequest object.

  Fields:
    name: Required. The resource name of the task: projects/{project_number}/l
      ocations/{location_id}/lakes/{lake_id}/tasks/{tasks_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesTasksJobsCancelRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksJobsCancelRequest object.

  Fields:
    googleCloudDataplexV1CancelJobRequest: A
      GoogleCloudDataplexV1CancelJobRequest resource to be passed as the
      request body.
    name: Required. The resource name of the job: projects/{project_number}/lo
      cations/{location_id}/lakes/{lake_id}/task/{task_id}/job/{job_id}.
  """

  googleCloudDataplexV1CancelJobRequest = _messages.MessageField('GoogleCloudDataplexV1CancelJobRequest', 1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesTasksJobsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksJobsGetRequest object.

  Fields:
    name: Required. The resource name of the job: projects/{project_number}/lo
      cations/{location_id}/lakes/{lake_id}/tasks/{task_id}/jobs/{job_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesTasksJobsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksJobsListRequest object.

  Fields:
    pageSize: Optional. Maximum number of jobs to return. The service may
      return fewer than this value. If unspecified, at most 10 jobs will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListJobs call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to ListJobs must match the call that provided the
      page token.
    parent: Required. The resource name of the parent environment: projects/{p
      roject_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DataplexProjectsLocationsLakesTasksListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksListRequest object.

  Fields:
    filter: Optional. Filter request.
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. Maximum number of tasks to return. The service may
      return fewer than this value. If unspecified, at most 10 tasks will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListZones call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to ListZones must match the call that provided the
      page token.
    parent: Required. The resource name of the parent lake:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsLakesTasksPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksPatchRequest object.

  Fields:
    googleCloudDataplexV1Task: A GoogleCloudDataplexV1Task resource to be
      passed as the request body.
    name: Output only. The relative resource name of the task, of the form:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}/
      tasks/{task_id}.
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Task = _messages.MessageField('GoogleCloudDataplexV1Task', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesTasksRunRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksRunRequest object.

  Fields:
    googleCloudDataplexV1RunTaskRequest: A GoogleCloudDataplexV1RunTaskRequest
      resource to be passed as the request body.
    name: Required. The resource name of the task: projects/{project_number}/l
      ocations/{location_id}/lakes/{lake_id}/tasks/{task_id}.
  """

  googleCloudDataplexV1RunTaskRequest = _messages.MessageField('GoogleCloudDataplexV1RunTaskRequest', 1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesTasksSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesTasksTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesActionsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesActionsListRequest object.

  Fields:
    pageSize: Optional. Maximum number of actions to return. The service may
      return fewer than this value. If unspecified, at most 10 actions will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListZoneActions
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListZoneActions must match the call that
      provided the page token.
    parent: Required. The resource name of the parent zone: projects/{project_
      number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DataplexProjectsLocationsLakesZonesAssetsActionsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsActionsListRequest object.

  Fields:
    pageSize: Optional. Maximum number of actions to return. The service may
      return fewer than this value. If unspecified, at most 10 actions will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListAssetActions
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListAssetActions must match the call that
      provided the page token.
    parent: Required. The resource name of the parent asset: projects/{project
      _number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/
      {asset_id}.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DataplexProjectsLocationsLakesZonesAssetsCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsCreateRequest object.

  Fields:
    assetId: Required. Asset identifier. This ID will be used to generate
      names such as table names when publishing metadata to Hive Metastore and
      BigQuery. * Must contain only lowercase letters, numbers and hyphens. *
      Must start with a letter. * Must end with a number or a letter. * Must
      be between 1-63 characters. * Must be unique within the zone.
    googleCloudDataplexV1Asset: A GoogleCloudDataplexV1Asset resource to be
      passed as the request body.
    parent: Required. The resource name of the parent zone: projects/{project_
      number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  assetId = _messages.StringField(1)
  googleCloudDataplexV1Asset = _messages.MessageField('GoogleCloudDataplexV1Asset', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesZonesAssetsDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsDeleteRequest object.

  Fields:
    name: Required. The resource name of the asset: projects/{project_number}/
      locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id
      }.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesZonesAssetsGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesAssetsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsGetRequest object.

  Fields:
    name: Required. The resource name of the asset: projects/{project_number}/
      locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id
      }.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesZonesAssetsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsListRequest object.

  Fields:
    filter: Optional. Filter request.
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. Maximum number of asset to return. The service may
      return fewer than this value. If unspecified, at most 10 assets will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListAssets call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to ListAssets must match the call that provided the
      page token.
    parent: Required. The resource name of the parent zone: projects/{project_
      number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsLakesZonesAssetsPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsPatchRequest object.

  Fields:
    googleCloudDataplexV1Asset: A GoogleCloudDataplexV1Asset resource to be
      passed as the request body.
    name: Output only. The relative resource name of the asset, of the form: p
      rojects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{
      zone_id}/assets/{asset_id}.
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Asset = _messages.MessageField('GoogleCloudDataplexV1Asset', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesZonesAssetsSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesAssetsTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesCreateRequest object.

  Fields:
    googleCloudDataplexV1Zone: A GoogleCloudDataplexV1Zone resource to be
      passed as the request body.
    parent: Required. The resource name of the parent lake:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
    zoneId: Required. Zone identifier. This ID will be used to generate names
      such as database and dataset names when publishing metadata to Hive
      Metastore and BigQuery. * Must contain only lowercase letters, numbers
      and hyphens. * Must start with a letter. * Must end with a number or a
      letter. * Must be between 1-63 characters. * Must be unique across all
      lakes from all locations in a project. * Must not be one of the reserved
      IDs (i.e. "default", "global-temp")
  """

  googleCloudDataplexV1Zone = _messages.MessageField('GoogleCloudDataplexV1Zone', 1)
  parent = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)
  zoneId = _messages.StringField(4)


class DataplexProjectsLocationsLakesZonesDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesDeleteRequest object.

  Fields:
    name: Required. The resource name of the zone: projects/{project_number}/l
      ocations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesZonesEntitiesCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesEntitiesCreateRequest object.

  Fields:
    googleCloudDataplexV1Entity: A GoogleCloudDataplexV1Entity resource to be
      passed as the request body.
    parent: Required. The resource name of the parent zone: projects/{project_
      number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Entity = _messages.MessageField('GoogleCloudDataplexV1Entity', 1)
  parent = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class DataplexProjectsLocationsLakesZonesEntitiesDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesEntitiesDeleteRequest object.

  Fields:
    etag: Required. The etag associated with the entity, which can be
      retrieved with a GetEntity request.
    name: Required. The resource name of the entity: projects/{project_number}
      /locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entit
      y_id}.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesEntitiesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesEntitiesGetRequest object.

  Enums:
    ViewValueValuesEnum: Optional. Used to select the subset of entity
      information to return. Defaults to BASIC.

  Fields:
    name: Required. The resource name of the entity: projects/{project_number}
      /locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entit
      y_id}.
    view: Optional. Used to select the subset of entity information to return.
      Defaults to BASIC.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. Used to select the subset of entity information to return.
    Defaults to BASIC.

    Values:
      ENTITY_VIEW_UNSPECIFIED: The API will default to the BASIC view.
      BASIC: Minimal view that does not include the schema.
      SCHEMA: Include basic information and schema.
      FULL: Include everything. Currently, this is the same as the SCHEMA
        view.
    """
    ENTITY_VIEW_UNSPECIFIED = 0
    BASIC = 1
    SCHEMA = 2
    FULL = 3

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class DataplexProjectsLocationsLakesZonesEntitiesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesEntitiesListRequest object.

  Enums:
    ViewValueValuesEnum: Required. Specify the entity view to make a partial
      list request.

  Fields:
    filter: Optional. The following filter parameters can be added to the URL
      to limit the entities returned by the API: Entity ID:
      ?filter="id=entityID" Asset ID: ?filter="asset=assetID" Data path
      ?filter="data_path=gs://my-bucket" Is HIVE compatible:
      ?filter="hive_compatible=true" Is BigQuery compatible:
      ?filter="bigquery_compatible=true"
    pageSize: Optional. Maximum number of entities to return. The service may
      return fewer than this value. If unspecified, 100 entities will be
      returned by default. The maximum value is 500; larger values will will
      be truncated to 500.
    pageToken: Optional. Page token received from a previous ListEntities
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListEntities must match the call that
      provided the page token.
    parent: Required. The resource name of the parent zone: projects/{project_
      number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
    view: Required. Specify the entity view to make a partial list request.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Required. Specify the entity view to make a partial list request.

    Values:
      ENTITY_VIEW_UNSPECIFIED: The default unset value. Return both table and
        fileset entities if unspecified.
      TABLES: Only list table entities.
      FILESETS: Only list fileset entities.
    """
    ENTITY_VIEW_UNSPECIFIED = 0
    TABLES = 1
    FILESETS = 2

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 5)


class DataplexProjectsLocationsLakesZonesEntitiesPartitionsCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesEntitiesPartitionsCreateRequest
  object.

  Fields:
    googleCloudDataplexV1Partition: A GoogleCloudDataplexV1Partition resource
      to be passed as the request body.
    parent: Required. The resource name of the parent zone: projects/{project_
      number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities
      /{entity_id}.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Partition = _messages.MessageField('GoogleCloudDataplexV1Partition', 1)
  parent = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class DataplexProjectsLocationsLakesZonesEntitiesPartitionsDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesEntitiesPartitionsDeleteRequest
  object.

  Fields:
    etag: Optional. The etag associated with the partition.
    name: Required. The resource name of the partition. format: projects/{proj
      ect_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/enti
      ties/{entity_id}/partitions/{partition_value_path}. The
      {partition_value_path} segment consists of an ordered sequence of
      partition values separated by "/". All values must be provided.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesEntitiesPartitionsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesEntitiesPartitionsGetRequest
  object.

  Fields:
    name: Required. The resource name of the partition: projects/{project_numb
      er}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{en
      tity_id}/partitions/{partition_value_path}. The {partition_value_path}
      segment consists of an ordered sequence of partition values separated by
      "/". All values must be provided.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesZonesEntitiesPartitionsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesEntitiesPartitionsListRequest
  object.

  Fields:
    filter: Optional. Filter the partitions returned to the caller using a key
      value pair expression. Supported operators and syntax: logic operators:
      AND, OR comparison operators: <, >, >=, <= ,=, != LIKE operators: The
      right hand of a LIKE operator supports "." and "*" for wildcard
      searches, for example "value1 LIKE ".*oo.*" parenthetical grouping: (
      )Sample filter expression: `?filter="key1 < value1 OR key2 >
      value2"Notes: Keys to the left of operators are case insensitive.
      Partition results are sorted first by creation time, then by
      lexicographic order. Up to 20 key value filter pairs are allowed, but
      due to performance considerations, only the first 10 will be used as a
      filter.
    pageSize: Optional. Maximum number of partitions to return. The service
      may return fewer than this value. If unspecified, 100 partitions will be
      returned by default. The maximum page size is 500; larger values will
      will be truncated to 500.
    pageToken: Optional. Page token received from a previous ListPartitions
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListPartitions must match the call that
      provided the page token.
    parent: Required. The resource name of the parent entity: projects/{projec
      t_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entiti
      es/{entity_id}.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DataplexProjectsLocationsLakesZonesEntitiesUpdateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesEntitiesUpdateRequest object.

  Fields:
    googleCloudDataplexV1Entity: A GoogleCloudDataplexV1Entity resource to be
      passed as the request body.
    name: Output only. The resource name of the entity, of the form: projects/
      {project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}
      /entities/{id}.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Entity = _messages.MessageField('GoogleCloudDataplexV1Entity', 1)
  name = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class DataplexProjectsLocationsLakesZonesGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesGetRequest object.

  Fields:
    name: Required. The resource name of the zone: projects/{project_number}/l
      ocations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesZonesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesListRequest object.

  Fields:
    filter: Optional. Filter request.
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. Maximum number of zones to return. The service may
      return fewer than this value. If unspecified, at most 10 zones will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListZones call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to ListZones must match the call that provided the
      page token.
    parent: Required. The resource name of the parent lake:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsLakesZonesPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesPatchRequest object.

  Fields:
    googleCloudDataplexV1Zone: A GoogleCloudDataplexV1Zone resource to be
      passed as the request body.
    name: Output only. The relative resource name of the zone, of the form: pr
      ojects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{z
      one_id}.
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Zone = _messages.MessageField('GoogleCloudDataplexV1Zone', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesZonesSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See Resource names (https://cloud.google.com/apis/design/resource_names)
      for the appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See Resource names
      (https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in AIP-160 (https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the next_page_token field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class DataplexProjectsLocationsLookupEntryRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLookupEntryRequest object.

  Enums:
    ViewValueValuesEnum: Optional. View to control which parts of an entry the
      service should return.

  Fields:
    aspectTypes: Optional. Limits the aspects returned to the provided aspect
      types. It only works for CUSTOM view.
    entry: Required. The resource name of the Entry: projects/{project}/locati
      ons/{location}/entryGroups/{entry_group}/entries/{entry}.
    name: Required. The project to which the request should be attributed in
      the following form: projects/{project}/locations/{location}.
    paths: Optional. Limits the aspects returned to those associated with the
      provided paths within the Entry. It only works for CUSTOM view.
    view: Optional. View to control which parts of an entry the service should
      return.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. View to control which parts of an entry the service should
    return.

    Values:
      ENTRY_VIEW_UNSPECIFIED: Unspecified EntryView. Defaults to FULL.
      BASIC: Returns entry only, without aspects.
      FULL: Returns all required aspects as well as the keys of all non-
        required aspects.
      CUSTOM: Returns aspects matching custom fields in GetEntryRequest. If
        the number of aspects exceeds 100, the first 100 will be returned.
      ALL: Returns all aspects. If the number of aspects exceeds 100, the
        first 100 will be returned.
    """
    ENTRY_VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2
    CUSTOM = 3
    ALL = 4

  aspectTypes = _messages.StringField(1, repeated=True)
  entry = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  paths = _messages.StringField(4, repeated=True)
  view = _messages.EnumField('ViewValueValuesEnum', 5)


class DataplexProjectsLocationsMetadataJobsCancelRequest(_messages.Message):
  r"""A DataplexProjectsLocationsMetadataJobsCancelRequest object.

  Fields:
    googleCloudDataplexV1CancelMetadataJobRequest: A
      GoogleCloudDataplexV1CancelMetadataJobRequest resource to be passed as
      the request body.
    name: Required. The resource name of the job, in the format projects/{proj
      ect_id_or_number}/locations/{location_id}/metadataJobs/{metadata_job_id}
  """

  googleCloudDataplexV1CancelMetadataJobRequest = _messages.MessageField('GoogleCloudDataplexV1CancelMetadataJobRequest', 1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsMetadataJobsCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsMetadataJobsCreateRequest object.

  Fields:
    googleCloudDataplexV1MetadataJob: A GoogleCloudDataplexV1MetadataJob
      resource to be passed as the request body.
    metadataJobId: Optional. The metadata job ID. If not provided, a unique ID
      is generated with the prefix metadata-job-.
    parent: Required. The resource name of the parent location, in the format
      projects/{project_id_or_number}/locations/{location_id}
    validateOnly: Optional. The service validates the request without
      performing any mutations. The default is false.
  """

  googleCloudDataplexV1MetadataJob = _messages.MessageField('GoogleCloudDataplexV1MetadataJob', 1)
  metadataJobId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsMetadataJobsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsMetadataJobsGetRequest object.

  Fields:
    name: Required. The resource name of the metadata job, in the format proje
      cts/{project_id_or_number}/locations/{location_id}/metadataJobs/{metadat
      a_job_id}.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsMetadataJobsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsMetadataJobsListRequest object.

  Fields:
    filter: Optional. Filter request. Filters are case-sensitive. The service
      supports the following formats: labels.key1 = "value1" labels:key1 name
      = "value"You can combine filters with AND, OR, and NOT operators.
    orderBy: Optional. The field to sort the results by, either name or
      create_time. If not specified, the ordering is undefined.
    pageSize: Optional. The maximum number of metadata jobs to return. The
      service might return fewer jobs than this value. If unspecified, at most
      10 jobs are returned. The maximum value is 1,000.
    pageToken: Optional. The page token received from a previous
      ListMetadataJobs call. Provide this token to retrieve the subsequent
      page of results. When paginating, all other parameters that are provided
      to the ListMetadataJobs request must match the call that provided the
      page token.
    parent: Required. The resource name of the parent location, in the format
      projects/{project_id_or_number}/locations/{location_id}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A DataplexProjectsLocationsOperationsCancelRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to true, operations that are reachable are
      returned as normal, and those that are unreachable are returned in the
      ListOperationsResponse.unreachable field.This can only be true when
      reading across collections. For example, when parent is set to
      "projects/example/locations/-".This field is not supported by default
      and will result in an UNIMPLEMENTED error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class DataplexProjectsLocationsSearchEntriesRequest(_messages.Message):
  r"""A DataplexProjectsLocationsSearchEntriesRequest object.

  Fields:
    name: Required. The project to which the request should be attributed in
      the following form: projects/{project}/locations/global.
    orderBy: Optional. Specifies the ordering of results. Supported values
      are: relevance last_modified_timestamp last_modified_timestamp asc
    pageSize: Optional. Number of results in the search page. If <=0, then
      defaults to 10. Max limit for page_size is 1000. Throws an invalid
      argument for page_size > 1000.
    pageToken: Optional. Page token received from a previous SearchEntries
      call. Provide this to retrieve the subsequent page.
    query: Required. The query against which entries in scope should be
      matched. The query syntax is defined in Search syntax for Dataplex
      Universal Catalog (https://cloud.google.com/dataplex/docs/search-
      syntax).
    scope: Optional. The scope under which the search should be operating. It
      must either be organizations/ or projects/. If it is unspecified, it
      defaults to the organization where the project provided in name is
      located.
    semanticSearch: Optional. Specifies whether the search should understand
      the meaning and intent behind the query, rather than just matching
      keywords.
  """

  name = _messages.StringField(1, required=True)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  query = _messages.StringField(5)
  scope = _messages.StringField(6)
  semanticSearch = _messages.BooleanField(7)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class GoogleCloudDataplexV1AccessSpec(_messages.Message):
  r"""AccessSpec holds the access control configuration to be enforced on the
  resources, for example, Cloud Storage bucket, BigQuery dataset, BigQuery
  table.

  Fields:
    owners: Optional. The set of principals to be granted owner role on the
      resource.
    readers: Optional. The format of strings follows the pattern followed by
      IAM in the bindings. user:{email}, serviceAccount:{email} group:{email}.
      The set of principals to be granted reader role on the resource.
    writers: Optional. The set of principals to be granted writer role on the
      resource.
  """

  owners = _messages.StringField(1, repeated=True)
  readers = _messages.StringField(2, repeated=True)
  writers = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1Action(_messages.Message):
  r"""Action represents an issue requiring administrator action for
  resolution.

  Enums:
    CategoryValueValuesEnum: The category of issue associated with the action.

  Fields:
    asset: Output only. The relative resource name of the asset, of the form:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/
      {zone_id}/assets/{asset_id}.
    category: The category of issue associated with the action.
    dataLocations: The list of data locations associated with this action.
      Cloud Storage locations are represented as URI paths(E.g.
      gs://bucket/table1/year=2020/month=Jan/). BigQuery locations refer to
      resource names(E.g. bigquery.googleapis.com/projects/project-
      id/datasets/dataset-id).
    detectTime: The time that the issue was detected.
    failedSecurityPolicyApply: Details for issues related to applying security
      policy.
    incompatibleDataSchema: Details for issues related to incompatible schemas
      detected within data.
    invalidDataFormat: Details for issues related to invalid or unsupported
      data formats.
    invalidDataOrganization: Details for issues related to invalid data
      arrangement.
    invalidDataPartition: Details for issues related to invalid or unsupported
      data partition structure.
    issue: Detailed description of the issue requiring action.
    lake: Output only. The relative resource name of the lake, of the form:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
    missingData: Details for issues related to absence of data within managed
      resources.
    missingResource: Details for issues related to absence of a managed
      resource.
    name: Output only. The relative resource name of the action, of the form:
      projects/{project}/locations/{location}/lakes/{lake}/actions/{action} pr
      ojects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/actions/
      {action} projects/{project}/locations/{location}/lakes/{lake}/zones/{zon
      e}/assets/{asset}/actions/{action}.
    unauthorizedResource: Details for issues related to lack of permissions to
      access data resources.
    zone: Output only. The relative resource name of the zone, of the form: pr
      ojects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{z
      one_id}.
  """

  class CategoryValueValuesEnum(_messages.Enum):
    r"""The category of issue associated with the action.

    Values:
      CATEGORY_UNSPECIFIED: Unspecified category.
      RESOURCE_MANAGEMENT: Resource management related issues.
      SECURITY_POLICY: Security policy related issues.
      DATA_DISCOVERY: Data and discovery related issues.
    """
    CATEGORY_UNSPECIFIED = 0
    RESOURCE_MANAGEMENT = 1
    SECURITY_POLICY = 2
    DATA_DISCOVERY = 3

  asset = _messages.StringField(1)
  category = _messages.EnumField('CategoryValueValuesEnum', 2)
  dataLocations = _messages.StringField(3, repeated=True)
  detectTime = _messages.StringField(4)
  failedSecurityPolicyApply = _messages.MessageField('GoogleCloudDataplexV1ActionFailedSecurityPolicyApply', 5)
  incompatibleDataSchema = _messages.MessageField('GoogleCloudDataplexV1ActionIncompatibleDataSchema', 6)
  invalidDataFormat = _messages.MessageField('GoogleCloudDataplexV1ActionInvalidDataFormat', 7)
  invalidDataOrganization = _messages.MessageField('GoogleCloudDataplexV1ActionInvalidDataOrganization', 8)
  invalidDataPartition = _messages.MessageField('GoogleCloudDataplexV1ActionInvalidDataPartition', 9)
  issue = _messages.StringField(10)
  lake = _messages.StringField(11)
  missingData = _messages.MessageField('GoogleCloudDataplexV1ActionMissingData', 12)
  missingResource = _messages.MessageField('GoogleCloudDataplexV1ActionMissingResource', 13)
  name = _messages.StringField(14)
  unauthorizedResource = _messages.MessageField('GoogleCloudDataplexV1ActionUnauthorizedResource', 15)
  zone = _messages.StringField(16)


class GoogleCloudDataplexV1ActionFailedSecurityPolicyApply(_messages.Message):
  r"""Failed to apply security policy to the managed resource(s) under a lake,
  zone or an asset. For a lake or zone resource, one or more underlying assets
  has a failure applying security policy to the associated managed resource.

  Fields:
    asset: Resource name of one of the assets with failing security policy
      application. Populated for a lake or zone resource only.
  """

  asset = _messages.StringField(1)


class GoogleCloudDataplexV1ActionIncompatibleDataSchema(_messages.Message):
  r"""Action details for incompatible schemas detected by discovery.

  Enums:
    SchemaChangeValueValuesEnum: Whether the action relates to a schema that
      is incompatible or modified.

  Fields:
    existingSchema: The existing and expected schema of the table. The schema
      is provided as a JSON formatted structure listing columns and data
      types.
    newSchema: The new and incompatible schema within the table. The schema is
      provided as a JSON formatted structured listing columns and data types.
    sampledDataLocations: The list of data locations sampled and used for
      format/schema inference.
    schemaChange: Whether the action relates to a schema that is incompatible
      or modified.
    table: The name of the table containing invalid data.
  """

  class SchemaChangeValueValuesEnum(_messages.Enum):
    r"""Whether the action relates to a schema that is incompatible or
    modified.

    Values:
      SCHEMA_CHANGE_UNSPECIFIED: Schema change unspecified.
      INCOMPATIBLE: Newly discovered schema is incompatible with existing
        schema.
      MODIFIED: Newly discovered schema has changed from existing schema for
        data in a curated zone.
    """
    SCHEMA_CHANGE_UNSPECIFIED = 0
    INCOMPATIBLE = 1
    MODIFIED = 2

  existingSchema = _messages.StringField(1)
  newSchema = _messages.StringField(2)
  sampledDataLocations = _messages.StringField(3, repeated=True)
  schemaChange = _messages.EnumField('SchemaChangeValueValuesEnum', 4)
  table = _messages.StringField(5)


class GoogleCloudDataplexV1ActionInvalidDataFormat(_messages.Message):
  r"""Action details for invalid or unsupported data files detected by
  discovery.

  Fields:
    expectedFormat: The expected data format of the entity.
    newFormat: The new unexpected data format within the entity.
    sampledDataLocations: The list of data locations sampled and used for
      format/schema inference.
  """

  expectedFormat = _messages.StringField(1)
  newFormat = _messages.StringField(2)
  sampledDataLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ActionInvalidDataOrganization(_messages.Message):
  r"""Action details for invalid data arrangement."""


class GoogleCloudDataplexV1ActionInvalidDataPartition(_messages.Message):
  r"""Action details for invalid or unsupported partitions detected by
  discovery.

  Enums:
    ExpectedStructureValueValuesEnum: The issue type of InvalidDataPartition.

  Fields:
    expectedStructure: The issue type of InvalidDataPartition.
  """

  class ExpectedStructureValueValuesEnum(_messages.Enum):
    r"""The issue type of InvalidDataPartition.

    Values:
      PARTITION_STRUCTURE_UNSPECIFIED: PartitionStructure unspecified.
      CONSISTENT_KEYS: Consistent hive-style partition definition (both raw
        and curated zone).
      HIVE_STYLE_KEYS: Hive style partition definition (curated zone only).
    """
    PARTITION_STRUCTURE_UNSPECIFIED = 0
    CONSISTENT_KEYS = 1
    HIVE_STYLE_KEYS = 2

  expectedStructure = _messages.EnumField('ExpectedStructureValueValuesEnum', 1)


class GoogleCloudDataplexV1ActionMissingData(_messages.Message):
  r"""Action details for absence of data detected by discovery."""


class GoogleCloudDataplexV1ActionMissingResource(_messages.Message):
  r"""Action details for resource references in assets that cannot be located.
  """



class GoogleCloudDataplexV1ActionUnauthorizedResource(_messages.Message):
  r"""Action details for unauthorized resource issues raised to indicate that
  the service account associated with the lake instance is not authorized to
  access or manage the resource associated with an asset.
  """



class GoogleCloudDataplexV1Aspect(_messages.Message):
  r"""An aspect is a single piece of metadata describing an entry.

  Messages:
    DataValue: Required. The content of the aspect, according to its aspect
      type schema. The maximum size of the field is 120KB (encoded as UTF-8).

  Fields:
    aspectSource: Optional. Information related to the source system of the
      aspect.
    aspectType: Output only. The resource name of the type used to create this
      Aspect.
    createTime: Output only. The time when the Aspect was created.
    data: Required. The content of the aspect, according to its aspect type
      schema. The maximum size of the field is 120KB (encoded as UTF-8).
    path: Output only. The path in the entry under which the aspect is
      attached.
    updateTime: Output only. The time when the Aspect was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DataValue(_messages.Message):
    r"""Required. The content of the aspect, according to its aspect type
    schema. The maximum size of the field is 120KB (encoded as UTF-8).

    Messages:
      AdditionalProperty: An additional property for a DataValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  aspectSource = _messages.MessageField('GoogleCloudDataplexV1AspectSource', 1)
  aspectType = _messages.StringField(2)
  createTime = _messages.StringField(3)
  data = _messages.MessageField('DataValue', 4)
  path = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class GoogleCloudDataplexV1AspectSource(_messages.Message):
  r"""Information related to the source system of the aspect.

  Fields:
    createTime: The time the aspect was created in the source system.
    dataVersion: The version of the data format used to produce this data.
      This field is used to indicated when the underlying data format changes
      (e.g., schema modifications, changes to the source URL format
      definition, etc).
    updateTime: The time the aspect was last updated in the source system.
  """

  createTime = _messages.StringField(1)
  dataVersion = _messages.StringField(2)
  updateTime = _messages.StringField(3)


class GoogleCloudDataplexV1AspectType(_messages.Message):
  r"""AspectType is a template for creating Aspects, and represents the JSON-
  schema for a given Entry, for example, BigQuery Table Schema.

  Enums:
    DataClassificationValueValuesEnum: Optional. Immutable. Stores data
      classification of the aspect.
    TransferStatusValueValuesEnum: Output only. Denotes the transfer status of
      the Aspect Type. It is unspecified for Aspect Types created from
      Dataplex API.

  Messages:
    LabelsValue: Optional. User-defined labels for the AspectType.

  Fields:
    authorization: Immutable. Defines the Authorization for this type.
    createTime: Output only. The time when the AspectType was created.
    dataClassification: Optional. Immutable. Stores data classification of the
      aspect.
    description: Optional. Description of the AspectType.
    displayName: Optional. User friendly display name.
    etag: The service computes this checksum. The client may send it on update
      and delete requests to ensure it has an up-to-date value before
      proceeding.
    labels: Optional. User-defined labels for the AspectType.
    metadataTemplate: Required. MetadataTemplate of the aspect.
    name: Output only. The relative resource name of the AspectType, of the
      form: projects/{project_number}/locations/{location_id}/aspectTypes/{asp
      ect_type_id}.
    transferStatus: Output only. Denotes the transfer status of the Aspect
      Type. It is unspecified for Aspect Types created from Dataplex API.
    uid: Output only. System generated globally unique ID for the AspectType.
      If you delete and recreate the AspectType with the same name, then this
      ID will be different.
    updateTime: Output only. The time when the AspectType was last updated.
  """

  class DataClassificationValueValuesEnum(_messages.Enum):
    r"""Optional. Immutable. Stores data classification of the aspect.

    Values:
      DATA_CLASSIFICATION_UNSPECIFIED: Denotes that the aspect contains only
        metadata.
      METADATA_AND_DATA: Metadata and data classification.
    """
    DATA_CLASSIFICATION_UNSPECIFIED = 0
    METADATA_AND_DATA = 1

  class TransferStatusValueValuesEnum(_messages.Enum):
    r"""Output only. Denotes the transfer status of the Aspect Type. It is
    unspecified for Aspect Types created from Dataplex API.

    Values:
      TRANSFER_STATUS_UNSPECIFIED: The default value. It is set for resources
        that were not subject for migration from Data Catalog service.
      TRANSFER_STATUS_MIGRATED: Indicates that a resource was migrated from
        Data Catalog service but it hasn't been transferred yet. In particular
        the resource cannot be updated from Dataplex API.
      TRANSFER_STATUS_TRANSFERRED: Indicates that a resource was transferred
        from Data Catalog service. The resource can only be updated from
        Dataplex API.
    """
    TRANSFER_STATUS_UNSPECIFIED = 0
    TRANSFER_STATUS_MIGRATED = 1
    TRANSFER_STATUS_TRANSFERRED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the AspectType.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  authorization = _messages.MessageField('GoogleCloudDataplexV1AspectTypeAuthorization', 1)
  createTime = _messages.StringField(2)
  dataClassification = _messages.EnumField('DataClassificationValueValuesEnum', 3)
  description = _messages.StringField(4)
  displayName = _messages.StringField(5)
  etag = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  metadataTemplate = _messages.MessageField('GoogleCloudDataplexV1AspectTypeMetadataTemplate', 8)
  name = _messages.StringField(9)
  transferStatus = _messages.EnumField('TransferStatusValueValuesEnum', 10)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class GoogleCloudDataplexV1AspectTypeAuthorization(_messages.Message):
  r"""Authorization for an AspectType.

  Fields:
    alternateUsePermission: Immutable. The IAM permission grantable on the
      EntryGroup to allow access to instantiate Aspects of Dataplex Universal
      Catalog owned AspectTypes, only settable for Dataplex Universal Catalog
      owned Types.
  """

  alternateUsePermission = _messages.StringField(1)


class GoogleCloudDataplexV1AspectTypeMetadataTemplate(_messages.Message):
  r"""MetadataTemplate definition for an AspectType.

  Fields:
    annotations: Optional. Specifies annotations on this field.
    arrayItems: Optional. If the type is array, set array_items. array_items
      can refer to a primitive field or a complex (record only) field. To
      specify a primitive field, you only need to set name and type in the
      nested MetadataTemplate. The recommended value for the name field is
      item, as this isn't used in the actual payload.
    constraints: Optional. Specifies the constraints on this field.
    enumValues: Optional. The list of values for an enum type. You must define
      it if the type is enum.
    index: Optional. Index is used to encode Template messages. The value of
      index can range between 1 and 2,147,483,647. Index must be unique within
      all fields in a Template. (Nested Templates can reuse indexes). Once a
      Template is defined, the index cannot be changed, because it identifies
      the field in the actual storage format. Index is a mandatory field, but
      it is optional for top level fields, and map/array "values" definitions.
    mapItems: Optional. If the type is map, set map_items. map_items can refer
      to a primitive field or a complex (record only) field. To specify a
      primitive field, you only need to set name and type in the nested
      MetadataTemplate. The recommended value for the name field is item, as
      this isn't used in the actual payload.
    name: Required. The name of the field.
    recordFields: Optional. Field definition. You must specify it if the type
      is record. It defines the nested fields.
    type: Required. The datatype of this field. The following values are
      supported:Primitive types: string int bool double datetime. Must be of
      the format RFC3339 UTC "Zulu" (Examples: "2014-10-02T15:01:23Z" and
      "2014-10-02T15:01:23.045123456Z").Complex types: enum array map record
    typeId: Optional. You can use type id if this definition of the field
      needs to be reused later. The type id must be unique across the entire
      template. You can only specify it if the field type is record.
    typeRef: Optional. A reference to another field definition (not an inline
      definition). The value must be equal to the value of an id field defined
      elsewhere in the MetadataTemplate. Only fields with record type can
      refer to other fields.
  """

  annotations = _messages.MessageField('GoogleCloudDataplexV1AspectTypeMetadataTemplateAnnotations', 1)
  arrayItems = _messages.MessageField('GoogleCloudDataplexV1AspectTypeMetadataTemplate', 2)
  constraints = _messages.MessageField('GoogleCloudDataplexV1AspectTypeMetadataTemplateConstraints', 3)
  enumValues = _messages.MessageField('GoogleCloudDataplexV1AspectTypeMetadataTemplateEnumValue', 4, repeated=True)
  index = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  mapItems = _messages.MessageField('GoogleCloudDataplexV1AspectTypeMetadataTemplate', 6)
  name = _messages.StringField(7)
  recordFields = _messages.MessageField('GoogleCloudDataplexV1AspectTypeMetadataTemplate', 8, repeated=True)
  type = _messages.StringField(9)
  typeId = _messages.StringField(10)
  typeRef = _messages.StringField(11)


class GoogleCloudDataplexV1AspectTypeMetadataTemplateAnnotations(_messages.Message):
  r"""Definition of the annotations of a field.

  Fields:
    deprecated: Optional. Marks a field as deprecated. You can include a
      deprecation message.
    description: Optional. Description for a field.
    displayName: Optional. Display name for a field.
    displayOrder: Optional. Display order for a field. You can use this to
      reorder where a field is rendered.
    stringType: Optional. You can use String Type annotations to specify
      special meaning to string fields. The following values are supported:
      richText: The field must be interpreted as a rich text field. url: A
      fully qualified URL link. resource: A service qualified resource
      reference.
    stringValues: Optional. Suggested hints for string fields. You can use
      them to suggest values to users through console.
  """

  deprecated = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  displayOrder = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  stringType = _messages.StringField(5)
  stringValues = _messages.StringField(6, repeated=True)


class GoogleCloudDataplexV1AspectTypeMetadataTemplateConstraints(_messages.Message):
  r"""Definition of the constraints of a field.

  Fields:
    required: Optional. Marks this field as optional or required.
  """

  required = _messages.BooleanField(1)


class GoogleCloudDataplexV1AspectTypeMetadataTemplateEnumValue(_messages.Message):
  r"""Definition of Enumvalue, to be used for enum fields.

  Fields:
    deprecated: Optional. You can set this message if you need to deprecate an
      enum value.
    index: Required. Index for the enum value. It can't be modified.
    name: Required. Name of the enumvalue. This is the actual value that the
      aspect can contain.
  """

  deprecated = _messages.StringField(1)
  index = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  name = _messages.StringField(3)


class GoogleCloudDataplexV1Asset(_messages.Message):
  r"""An asset represents a cloud resource that is being managed within a lake
  as a member of a zone.

  Enums:
    StateValueValuesEnum: Output only. Current state of the asset.

  Messages:
    LabelsValue: Optional. User defined labels for the asset.

  Fields:
    createTime: Output only. The time when the asset was created.
    description: Optional. Description of the asset.
    discoverySpec: Optional. Specification of the discovery feature applied to
      data referenced by this asset. When this spec is left unset, the asset
      will use the spec set on the parent zone.
    discoveryStatus: Output only. Status of the discovery feature applied to
      data referenced by this asset.
    displayName: Optional. User friendly display name.
    labels: Optional. User defined labels for the asset.
    name: Output only. The relative resource name of the asset, of the form: p
      rojects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{
      zone_id}/assets/{asset_id}.
    resourceSpec: Required. Specification of the resource that is referenced
      by this asset.
    resourceStatus: Output only. Status of the resource referenced by this
      asset.
    securityStatus: Output only. Status of the security policy applied to
      resource referenced by this asset.
    state: Output only. Current state of the asset.
    uid: Output only. System generated globally unique ID for the asset. This
      ID will be different if the asset is deleted and re-created with the
      same name.
    updateTime: Output only. The time when the asset was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the asset.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User defined labels for the asset.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  discoverySpec = _messages.MessageField('GoogleCloudDataplexV1AssetDiscoverySpec', 3)
  discoveryStatus = _messages.MessageField('GoogleCloudDataplexV1AssetDiscoveryStatus', 4)
  displayName = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  resourceSpec = _messages.MessageField('GoogleCloudDataplexV1AssetResourceSpec', 8)
  resourceStatus = _messages.MessageField('GoogleCloudDataplexV1AssetResourceStatus', 9)
  securityStatus = _messages.MessageField('GoogleCloudDataplexV1AssetSecurityStatus', 10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  uid = _messages.StringField(12)
  updateTime = _messages.StringField(13)


class GoogleCloudDataplexV1AssetDiscoverySpec(_messages.Message):
  r"""Settings to manage the metadata discovery and publishing for an asset.

  Fields:
    csvOptions: Optional. Configuration for CSV data.
    enabled: Optional. Whether discovery is enabled.
    excludePatterns: Optional. The list of patterns to apply for selecting
      data to exclude during discovery. For Cloud Storage bucket assets, these
      are interpreted as glob patterns used to match object names. For
      BigQuery dataset assets, these are interpreted as patterns to match
      table names.
    includePatterns: Optional. The list of patterns to apply for selecting
      data to include during discovery if only a subset of the data should
      considered. For Cloud Storage bucket assets, these are interpreted as
      glob patterns used to match object names. For BigQuery dataset assets,
      these are interpreted as patterns to match table names.
    jsonOptions: Optional. Configuration for Json data.
    schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for
      running discovery periodically. Successive discovery runs must be
      scheduled at least 60 minutes apart. The default value is to run
      discovery every 60 minutes.To explicitly set a timezone to the cron tab,
      apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or
      TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string
      from IANA time zone database. For example, CRON_TZ=America/New_York 1 *
      * * *, or TZ=America/New_York 1 * * * *.
  """

  csvOptions = _messages.MessageField('GoogleCloudDataplexV1AssetDiscoverySpecCsvOptions', 1)
  enabled = _messages.BooleanField(2)
  excludePatterns = _messages.StringField(3, repeated=True)
  includePatterns = _messages.StringField(4, repeated=True)
  jsonOptions = _messages.MessageField('GoogleCloudDataplexV1AssetDiscoverySpecJsonOptions', 5)
  schedule = _messages.StringField(6)


class GoogleCloudDataplexV1AssetDiscoverySpecCsvOptions(_messages.Message):
  r"""Describe CSV and similar semi-structured data formats.

  Fields:
    delimiter: Optional. The delimiter being used to separate values. This
      defaults to ','.
    disableTypeInference: Optional. Whether to disable the inference of data
      type for CSV data. If true, all columns will be registered as strings.
    encoding: Optional. The character encoding of the data. The default is
      UTF-8.
    headerRows: Optional. The number of rows to interpret as header rows that
      should be skipped when reading data rows.
  """

  delimiter = _messages.StringField(1)
  disableTypeInference = _messages.BooleanField(2)
  encoding = _messages.StringField(3)
  headerRows = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudDataplexV1AssetDiscoverySpecJsonOptions(_messages.Message):
  r"""Describe JSON data format.

  Fields:
    disableTypeInference: Optional. Whether to disable the inference of data
      type for Json data. If true, all columns will be registered as their
      primitive types (strings, number or boolean).
    encoding: Optional. The character encoding of the data. The default is
      UTF-8.
  """

  disableTypeInference = _messages.BooleanField(1)
  encoding = _messages.StringField(2)


class GoogleCloudDataplexV1AssetDiscoveryStatus(_messages.Message):
  r"""Status of discovery for an asset.

  Enums:
    StateValueValuesEnum: The current status of the discovery feature.

  Fields:
    lastRunDuration: The duration of the last discovery run.
    lastRunTime: The start time of the last discovery run.
    message: Additional information about the current state.
    state: The current status of the discovery feature.
    stats: Data Stats of the asset reported by discovery.
    updateTime: Last update time of the status.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current status of the discovery feature.

    Values:
      STATE_UNSPECIFIED: State is unspecified.
      SCHEDULED: Discovery for the asset is scheduled.
      IN_PROGRESS: Discovery for the asset is running.
      PAUSED: Discovery for the asset is currently paused (e.g. due to a lack
        of available resources). It will be automatically resumed.
      DISABLED: Discovery for the asset is disabled.
    """
    STATE_UNSPECIFIED = 0
    SCHEDULED = 1
    IN_PROGRESS = 2
    PAUSED = 3
    DISABLED = 4

  lastRunDuration = _messages.StringField(1)
  lastRunTime = _messages.StringField(2)
  message = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  stats = _messages.MessageField('GoogleCloudDataplexV1AssetDiscoveryStatusStats', 5)
  updateTime = _messages.StringField(6)


class GoogleCloudDataplexV1AssetDiscoveryStatusStats(_messages.Message):
  r"""The aggregated data statistics for the asset reported by discovery.

  Fields:
    dataItems: The count of data items within the referenced resource.
    dataSize: The number of stored data bytes within the referenced resource.
    filesets: The count of fileset entities within the referenced resource.
    tables: The count of table entities within the referenced resource.
  """

  dataItems = _messages.IntegerField(1)
  dataSize = _messages.IntegerField(2)
  filesets = _messages.IntegerField(3)
  tables = _messages.IntegerField(4)


class GoogleCloudDataplexV1AssetResourceSpec(_messages.Message):
  r"""Identifies the cloud resource that is referenced by this asset.

  Enums:
    ReadAccessModeValueValuesEnum: Optional. Determines how read permissions
      are handled for each asset and their associated tables. Only available
      to storage buckets assets.
    TypeValueValuesEnum: Required. Immutable. Type of resource.

  Fields:
    name: Immutable. Relative name of the cloud resource that contains the
      data that is being managed within a lake. For example:
      projects/{project_number}/buckets/{bucket_id}
      projects/{project_number}/datasets/{dataset_id}
    readAccessMode: Optional. Determines how read permissions are handled for
      each asset and their associated tables. Only available to storage
      buckets assets.
    type: Required. Immutable. Type of resource.
  """

  class ReadAccessModeValueValuesEnum(_messages.Enum):
    r"""Optional. Determines how read permissions are handled for each asset
    and their associated tables. Only available to storage buckets assets.

    Values:
      ACCESS_MODE_UNSPECIFIED: Access mode unspecified.
      DIRECT: Default. Data is accessed directly using storage APIs.
      MANAGED: Data is accessed through a managed interface using BigQuery
        APIs.
    """
    ACCESS_MODE_UNSPECIFIED = 0
    DIRECT = 1
    MANAGED = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. Type of resource.

    Values:
      TYPE_UNSPECIFIED: Type not specified.
      STORAGE_BUCKET: Cloud Storage bucket.
      BIGQUERY_DATASET: BigQuery dataset.
    """
    TYPE_UNSPECIFIED = 0
    STORAGE_BUCKET = 1
    BIGQUERY_DATASET = 2

  name = _messages.StringField(1)
  readAccessMode = _messages.EnumField('ReadAccessModeValueValuesEnum', 2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class GoogleCloudDataplexV1AssetResourceStatus(_messages.Message):
  r"""Status of the resource referenced by an asset.

  Enums:
    StateValueValuesEnum: The current state of the managed resource.

  Fields:
    managedAccessIdentity: Output only. Service account associated with the
      BigQuery Connection.
    message: Additional information about the current state.
    state: The current state of the managed resource.
    updateTime: Last update time of the status.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the managed resource.

    Values:
      STATE_UNSPECIFIED: State unspecified.
      READY: Resource does not have any errors.
      ERROR: Resource has errors.
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    ERROR = 2

  managedAccessIdentity = _messages.StringField(1)
  message = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  updateTime = _messages.StringField(4)


class GoogleCloudDataplexV1AssetSecurityStatus(_messages.Message):
  r"""Security policy status of the asset. Data security policy, i.e.,
  readers, writers & owners, should be specified in the lake/zone/asset IAM
  policy.

  Enums:
    StateValueValuesEnum: The current state of the security policy applied to
      the attached resource.

  Fields:
    message: Additional information about the current state.
    state: The current state of the security policy applied to the attached
      resource.
    updateTime: Last update time of the status.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the security policy applied to the attached
    resource.

    Values:
      STATE_UNSPECIFIED: State unspecified.
      READY: Security policy has been successfully applied to the attached
        resource.
      APPLYING: Security policy is in the process of being applied to the
        attached resource.
      ERROR: Security policy could not be applied to the attached resource due
        to errors.
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    APPLYING = 2
    ERROR = 3

  message = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)
  updateTime = _messages.StringField(3)


class GoogleCloudDataplexV1AssetStatus(_messages.Message):
  r"""Aggregated status of the underlying assets of a lake or zone.

  Fields:
    activeAssets: Number of active assets.
    securityPolicyApplyingAssets: Number of assets that are in process of
      updating the security policy on attached resources.
    updateTime: Last update time of the status.
  """

  activeAssets = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  securityPolicyApplyingAssets = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  updateTime = _messages.StringField(3)


class GoogleCloudDataplexV1BusinessGlossaryEvent(_messages.Message):
  r"""Payload associated with Business Glossary related log events.

  Enums:
    EventTypeValueValuesEnum: The type of the event.

  Fields:
    eventType: The type of the event.
    message: The log message.
    resource: Name of the resource.
  """

  class EventTypeValueValuesEnum(_messages.Enum):
    r"""The type of the event.

    Values:
      EVENT_TYPE_UNSPECIFIED: An unspecified event type.
      GLOSSARY_CREATE: Glossary create event.
      GLOSSARY_UPDATE: Glossary update event.
      GLOSSARY_DELETE: Glossary delete event.
      GLOSSARY_CATEGORY_CREATE: Glossary category create event.
      GLOSSARY_CATEGORY_UPDATE: Glossary category update event.
      GLOSSARY_CATEGORY_DELETE: Glossary category delete event.
      GLOSSARY_TERM_CREATE: Glossary term create event.
      GLOSSARY_TERM_UPDATE: Glossary term update event.
      GLOSSARY_TERM_DELETE: Glossary term delete event.
    """
    EVENT_TYPE_UNSPECIFIED = 0
    GLOSSARY_CREATE = 1
    GLOSSARY_UPDATE = 2
    GLOSSARY_DELETE = 3
    GLOSSARY_CATEGORY_CREATE = 4
    GLOSSARY_CATEGORY_UPDATE = 5
    GLOSSARY_CATEGORY_DELETE = 6
    GLOSSARY_TERM_CREATE = 7
    GLOSSARY_TERM_UPDATE = 8
    GLOSSARY_TERM_DELETE = 9

  eventType = _messages.EnumField('EventTypeValueValuesEnum', 1)
  message = _messages.StringField(2)
  resource = _messages.StringField(3)


class GoogleCloudDataplexV1CancelJobRequest(_messages.Message):
  r"""Cancel task jobs."""


class GoogleCloudDataplexV1CancelMetadataJobRequest(_messages.Message):
  r"""Cancel metadata job request."""


class GoogleCloudDataplexV1Content(_messages.Message):
  r"""Content represents a user-visible notebook or a sql script

  Messages:
    LabelsValue: Optional. User defined labels for the content.

  Fields:
    createTime: Output only. Content creation time.
    dataText: Required. Content data in string format.
    description: Optional. Description of the content.
    labels: Optional. User defined labels for the content.
    name: Output only. The relative resource name of the content, of the form:
      projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{c
      ontent_id}
    notebook: Notebook related configurations.
    path: Required. The path for the Content file, represented as directory
      structure. Unique within a lake. Limited to alphanumerics, hyphens,
      underscores, dots and slashes.
    sqlScript: Sql Script related configurations.
    uid: Output only. System generated globally unique ID for the content.
      This ID will be different if the content is deleted and re-created with
      the same name.
    updateTime: Output only. The time when the content was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User defined labels for the content.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  dataText = _messages.StringField(2)
  description = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  notebook = _messages.MessageField('GoogleCloudDataplexV1ContentNotebook', 6)
  path = _messages.StringField(7)
  sqlScript = _messages.MessageField('GoogleCloudDataplexV1ContentSqlScript', 8)
  uid = _messages.StringField(9)
  updateTime = _messages.StringField(10)


class GoogleCloudDataplexV1ContentNotebook(_messages.Message):
  r"""Configuration for Notebook content.

  Enums:
    KernelTypeValueValuesEnum: Required. Kernel Type of the notebook.

  Fields:
    kernelType: Required. Kernel Type of the notebook.
  """

  class KernelTypeValueValuesEnum(_messages.Enum):
    r"""Required. Kernel Type of the notebook.

    Values:
      KERNEL_TYPE_UNSPECIFIED: Kernel Type unspecified.
      PYTHON3: Python 3 Kernel.
    """
    KERNEL_TYPE_UNSPECIFIED = 0
    PYTHON3 = 1

  kernelType = _messages.EnumField('KernelTypeValueValuesEnum', 1)


class GoogleCloudDataplexV1ContentSqlScript(_messages.Message):
  r"""Configuration for the Sql Script content.

  Enums:
    EngineValueValuesEnum: Required. Query Engine to be used for the Sql
      Query.

  Fields:
    engine: Required. Query Engine to be used for the Sql Query.
  """

  class EngineValueValuesEnum(_messages.Enum):
    r"""Required. Query Engine to be used for the Sql Query.

    Values:
      QUERY_ENGINE_UNSPECIFIED: Value was unspecified.
      SPARK: Spark SQL Query.
    """
    QUERY_ENGINE_UNSPECIFIED = 0
    SPARK = 1

  engine = _messages.EnumField('EngineValueValuesEnum', 1)


class GoogleCloudDataplexV1DataAccessSpec(_messages.Message):
  r"""DataAccessSpec holds the access control configuration to be enforced on
  data stored within resources (eg: rows, columns in BigQuery Tables). When
  associated with data, the data is only accessible to principals explicitly
  granted access through the DataAccessSpec. Principals with access to the
  containing resource are not implicitly granted access.

  Fields:
    readers: Optional. The format of strings follows the pattern followed by
      IAM in the bindings. user:{email}, serviceAccount:{email} group:{email}.
      The set of principals to be granted reader role on data stored within
      resources.
  """

  readers = _messages.StringField(1, repeated=True)


class GoogleCloudDataplexV1DataAsset(_messages.Message):
  r"""Represents a Data Asset resource that can be packaged and shared via a
  Data Product.

  Messages:
    AccessGroupConfigsValue: Optional. Access groups configurations for this
      Data Asset. The key is DataProduct.AccessGroup.id and the value is
      AccessGroupConfig. Example: key: "analyst" value: { AccessGroupConfig :
      { iam_roles : "roles/bigquery.dataViewer" } } Currently, at most one IAM
      role is allowed per access group. For providing multiple predefined IAM
      roles, wrap them in a custom IAM role as per
      https://cloud.google.com/iam/docs/creating-custom-roles.
    LabelsValue: Optional. User-defined labels for the Data Asset.

  Fields:
    accessGroupConfigs: Optional. Access groups configurations for this Data
      Asset. The key is DataProduct.AccessGroup.id and the value is
      AccessGroupConfig. Example: key: "analyst" value: { AccessGroupConfig :
      { iam_roles : "roles/bigquery.dataViewer" } } Currently, at most one IAM
      role is allowed per access group. For providing multiple predefined IAM
      roles, wrap them in a custom IAM role as per
      https://cloud.google.com/iam/docs/creating-custom-roles.
    createTime: Output only. The time at which the Data Asset was created.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding.
    labels: Optional. User-defined labels for the Data Asset.
    name: Identifier. Resource name of the Data Asset. Format: projects/{proje
      ct_id_or_number}/locations/{location_id}/dataProducts/{data_product_id}/
      dataAssets/{data_asset_id}
    resource: Required. Immutable. Full resource name of the cloud resource
      represented by the Data Asset. This must follow
      https://cloud.google.com/iam/docs/full-resource-names. Example: //bigque
      ry.googleapis.com/projects/my_project_123/datasets/dataset_456/tables/ta
      ble_789 Only BigQuery tables and datasets are currently supported. Data
      Asset creator must have getIamPolicy and setIamPolicy permissions on the
      resource. Data Asset creator must also have resource specific get
      permission, for instance, bigquery.tables.get for BigQuery tables.
    uid: Output only. System generated globally unique ID for the Data Asset.
      This ID will be different if the Data Asset is deleted and re-created
      with the same name.
    updateTime: Output only. The time at which the Data Asset was last
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AccessGroupConfigsValue(_messages.Message):
    r"""Optional. Access groups configurations for this Data Asset. The key is
    DataProduct.AccessGroup.id and the value is AccessGroupConfig. Example:
    key: "analyst" value: { AccessGroupConfig : { iam_roles :
    "roles/bigquery.dataViewer" } } Currently, at most one IAM role is allowed
    per access group. For providing multiple predefined IAM roles, wrap them
    in a custom IAM role as per https://cloud.google.com/iam/docs/creating-
    custom-roles.

    Messages:
      AdditionalProperty: An additional property for a AccessGroupConfigsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        AccessGroupConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AccessGroupConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudDataplexV1DataAssetAccessGroupConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudDataplexV1DataAssetAccessGroupConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the Data Asset.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accessGroupConfigs = _messages.MessageField('AccessGroupConfigsValue', 1)
  createTime = _messages.StringField(2)
  etag = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  resource = _messages.StringField(6)
  uid = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudDataplexV1DataAssetAccessGroupConfig(_messages.Message):
  r"""Configuration for access group inherited from the parent Data Product.

  Fields:
    iamRoles: Optional. IAM roles granted on the resource to this access
      group. Role name follows
      https://cloud.google.com/iam/docs/reference/rest/v1/roles. Example:
      "roles/bigquery.dataViewer"
  """

  iamRoles = _messages.StringField(1, repeated=True)


class GoogleCloudDataplexV1DataAttribute(_messages.Message):
  r"""Denotes one dataAttribute in a dataTaxonomy, for example, PII.
  DataAttribute resources can be defined in a hierarchy. A single
  dataAttribute resource can contain specs of multiple types PII -
  ResourceAccessSpec : - readers :foo@bar.com - DataAccessSpec : - readers
  :bar@foo.com

  Messages:
    LabelsValue: Optional. User-defined labels for the DataAttribute.

  Fields:
    attributeCount: Output only. The number of child attributes present for
      this attribute.
    createTime: Output only. The time when the DataAttribute was created.
    dataAccessSpec: Optional. Specified when applied to data stored on the
      resource (eg: rows, columns in BigQuery Tables).
    description: Optional. Description of the DataAttribute.
    displayName: Optional. User friendly display name.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding.
    labels: Optional. User-defined labels for the DataAttribute.
    name: Output only. The relative resource name of the dataAttribute, of the
      form: projects/{project_number}/locations/{location_id}/dataTaxonomies/{
      dataTaxonomy}/attributes/{data_attribute_id}.
    parentId: Optional. The ID of the parent DataAttribute resource, should
      belong to the same data taxonomy. Circular dependency in parent chain is
      not valid. Maximum depth of the hierarchy allowed is 4. a -> b -> c -> d
      -> e, depth = 4
    resourceAccessSpec: Optional. Specified when applied to a resource (eg:
      Cloud Storage bucket, BigQuery dataset, BigQuery table).
    uid: Output only. System generated globally unique ID for the
      DataAttribute. This ID will be different if the DataAttribute is deleted
      and re-created with the same name.
    updateTime: Output only. The time when the DataAttribute was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the DataAttribute.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributeCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  createTime = _messages.StringField(2)
  dataAccessSpec = _messages.MessageField('GoogleCloudDataplexV1DataAccessSpec', 3)
  description = _messages.StringField(4)
  displayName = _messages.StringField(5)
  etag = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  parentId = _messages.StringField(9)
  resourceAccessSpec = _messages.MessageField('GoogleCloudDataplexV1ResourceAccessSpec', 10)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class GoogleCloudDataplexV1DataAttributeBinding(_messages.Message):
  r"""DataAttributeBinding represents binding of attributes to resources. Eg:
  Bind 'CustomerInfo' entity with 'PII' attribute.

  Messages:
    LabelsValue: Optional. User-defined labels for the DataAttributeBinding.

  Fields:
    attributes: Optional. List of attributes to be associated with the
      resource, provided in the form: projects/{project}/locations/{location}/
      dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}
    createTime: Output only. The time when the DataAttributeBinding was
      created.
    description: Optional. Description of the DataAttributeBinding.
    displayName: Optional. User friendly display name.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding. Etags must be used
      when calling the DeleteDataAttributeBinding and the
      UpdateDataAttributeBinding method.
    labels: Optional. User-defined labels for the DataAttributeBinding.
    name: Output only. The relative resource name of the Data Attribute
      Binding, of the form: projects/{project_number}/locations/{location}/dat
      aAttributeBindings/{data_attribute_binding_id}
    paths: Optional. The list of paths for items within the associated
      resource (eg. columns and partitions within a table) along with
      attribute bindings.
    resource: Optional. Immutable. The resource name of the resource that is
      associated to attributes. Presently, only entity resource is supported
      in the form: projects/{project}/locations/{location}/lakes/{lake}/zones/
      {zone}/entities/{entity_id} Must belong in the same project and region
      as the attribute binding, and there can only exist one active binding
      for a resource.
    uid: Output only. System generated globally unique ID for the
      DataAttributeBinding. This ID will be different if the
      DataAttributeBinding is deleted and re-created with the same name.
    updateTime: Output only. The time when the DataAttributeBinding was last
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the DataAttributeBinding.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributes = _messages.StringField(1, repeated=True)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  etag = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  paths = _messages.MessageField('GoogleCloudDataplexV1DataAttributeBindingPath', 8, repeated=True)
  resource = _messages.StringField(9)
  uid = _messages.StringField(10)
  updateTime = _messages.StringField(11)


class GoogleCloudDataplexV1DataAttributeBindingPath(_messages.Message):
  r"""Represents a subresource of the given resource, and associated bindings
  with it. Currently supported subresources are column and partition schema
  fields within a table.

  Fields:
    attributes: Optional. List of attributes to be associated with the path of
      the resource, provided in the form: projects/{project}/locations/{locati
      on}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}
    name: Required. The name identifier of the path. Nested columns should be
      of the form: 'address.city'.
  """

  attributes = _messages.StringField(1, repeated=True)
  name = _messages.StringField(2)


class GoogleCloudDataplexV1DataDiscoveryResult(_messages.Message):
  r"""The output of a data discovery scan.

  Fields:
    bigqueryPublishing: Output only. Configuration for metadata publishing.
    scanStatistics: Output only. Describes result statistics of a data scan
      discovery job.
  """

  bigqueryPublishing = _messages.MessageField('GoogleCloudDataplexV1DataDiscoveryResultBigQueryPublishing', 1)
  scanStatistics = _messages.MessageField('GoogleCloudDataplexV1DataDiscoveryResultScanStatistics', 2)


class GoogleCloudDataplexV1DataDiscoveryResultBigQueryPublishing(_messages.Message):
  r"""Describes BigQuery publishing configurations.

  Fields:
    dataset: Output only. The BigQuery dataset the discovered tables are
      published to.
    location: Output only. The location of the BigQuery publishing dataset.
  """

  dataset = _messages.StringField(1)
  location = _messages.StringField(2)


class GoogleCloudDataplexV1DataDiscoveryResultScanStatistics(_messages.Message):
  r"""Describes result statistics of a data scan discovery job.

  Fields:
    dataProcessedBytes: The data processed in bytes.
    filesExcluded: The number of files excluded.
    filesetsCreated: The number of filesets created.
    filesetsDeleted: The number of filesets deleted.
    filesetsUpdated: The number of filesets updated.
    scannedFileCount: The number of files scanned.
    tablesCreated: The number of tables created.
    tablesDeleted: The number of tables deleted.
    tablesUpdated: The number of tables updated.
  """

  dataProcessedBytes = _messages.IntegerField(1)
  filesExcluded = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  filesetsCreated = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  filesetsDeleted = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  filesetsUpdated = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  scannedFileCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  tablesCreated = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  tablesDeleted = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  tablesUpdated = _messages.IntegerField(9, variant=_messages.Variant.INT32)


class GoogleCloudDataplexV1DataDiscoverySpec(_messages.Message):
  r"""Spec for a data discovery scan.

  Fields:
    bigqueryPublishingConfig: Optional. Configuration for metadata publishing.
    storageConfig: Cloud Storage related configurations.
  """

  bigqueryPublishingConfig = _messages.MessageField('GoogleCloudDataplexV1DataDiscoverySpecBigQueryPublishingConfig', 1)
  storageConfig = _messages.MessageField('GoogleCloudDataplexV1DataDiscoverySpecStorageConfig', 2)


class GoogleCloudDataplexV1DataDiscoverySpecBigQueryPublishingConfig(_messages.Message):
  r"""Describes BigQuery publishing configurations.

  Enums:
    TableTypeValueValuesEnum: Optional. Determines whether to publish
      discovered tables as BigLake external tables or non-BigLake external
      tables.

  Fields:
    connection: Optional. The BigQuery connection used to create BigLake
      tables. Must be in the form projects/{project_id}/locations/{location_id
      }/connections/{connection_id}
    location: Optional. The location of the BigQuery dataset to publish
      BigLake external or non-BigLake external tables to. 1. If the Cloud
      Storage bucket is located in a multi-region bucket, then BigQuery
      dataset can be in the same multi-region bucket or any single region that
      is included in the same multi-region bucket. The datascan can be created
      in any single region that is included in the same multi-region bucket 2.
      If the Cloud Storage bucket is located in a dual-region bucket, then
      BigQuery dataset can be located in regions that are included in the
      dual-region bucket, or in a multi-region that includes the dual-region.
      The datascan can be created in any single region that is included in the
      same dual-region bucket. 3. If the Cloud Storage bucket is located in a
      single region, then BigQuery dataset can be in the same single region or
      any multi-region bucket that includes the same single region. The
      datascan will be created in the same single region as the bucket. 4. If
      the BigQuery dataset is in single region, it must be in the same single
      region as the datascan.For supported values, refer to
      https://cloud.google.com/bigquery/docs/locations#supported_locations.
    project: Optional. The project of the BigQuery dataset to publish BigLake
      external or non-BigLake external tables to. If not specified, the
      project of the Cloud Storage bucket will be used. The format is
      "projects/{project_id_or_number}".
    tableType: Optional. Determines whether to publish discovered tables as
      BigLake external tables or non-BigLake external tables.
  """

  class TableTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Determines whether to publish discovered tables as BigLake
    external tables or non-BigLake external tables.

    Values:
      TABLE_TYPE_UNSPECIFIED: Table type unspecified.
      EXTERNAL: Default. Discovered tables are published as BigQuery external
        tables whose data is accessed using the credentials of the user
        querying the table.
      BIGLAKE: Discovered tables are published as BigLake external tables
        whose data is accessed using the credentials of the associated
        BigQuery connection.
    """
    TABLE_TYPE_UNSPECIFIED = 0
    EXTERNAL = 1
    BIGLAKE = 2

  connection = _messages.StringField(1)
  location = _messages.StringField(2)
  project = _messages.StringField(3)
  tableType = _messages.EnumField('TableTypeValueValuesEnum', 4)


class GoogleCloudDataplexV1DataDiscoverySpecStorageConfig(_messages.Message):
  r"""Configurations related to Cloud Storage as the data source.

  Fields:
    csvOptions: Optional. Configuration for CSV data.
    excludePatterns: Optional. Defines the data to exclude during discovery.
      Provide a list of patterns that identify the data to exclude. For Cloud
      Storage bucket assets, these patterns are interpreted as glob patterns
      used to match object names. For BigQuery dataset assets, these patterns
      are interpreted as patterns to match table names.
    includePatterns: Optional. Defines the data to include during discovery
      when only a subset of the data should be considered. Provide a list of
      patterns that identify the data to include. For Cloud Storage bucket
      assets, these patterns are interpreted as glob patterns used to match
      object names. For BigQuery dataset assets, these patterns are
      interpreted as patterns to match table names.
    jsonOptions: Optional. Configuration for JSON data.
  """

  csvOptions = _messages.MessageField('GoogleCloudDataplexV1DataDiscoverySpecStorageConfigCsvOptions', 1)
  excludePatterns = _messages.StringField(2, repeated=True)
  includePatterns = _messages.StringField(3, repeated=True)
  jsonOptions = _messages.MessageField('GoogleCloudDataplexV1DataDiscoverySpecStorageConfigJsonOptions', 4)


class GoogleCloudDataplexV1DataDiscoverySpecStorageConfigCsvOptions(_messages.Message):
  r"""Describes CSV and similar semi-structured data formats.

  Fields:
    delimiter: Optional. The delimiter that is used to separate values. The
      default is , (comma).
    encoding: Optional. The character encoding of the data. The default is
      UTF-8.
    headerRows: Optional. The number of rows to interpret as header rows that
      should be skipped when reading data rows.
    quote: Optional. The character used to quote column values. Accepts "
      (double quotation mark) or ' (single quotation mark). If unspecified,
      defaults to " (double quotation mark).
    typeInferenceDisabled: Optional. Whether to disable the inference of data
      types for CSV data. If true, all columns are registered as strings.
  """

  delimiter = _messages.StringField(1)
  encoding = _messages.StringField(2)
  headerRows = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  quote = _messages.StringField(4)
  typeInferenceDisabled = _messages.BooleanField(5)


class GoogleCloudDataplexV1DataDiscoverySpecStorageConfigJsonOptions(_messages.Message):
  r"""Describes JSON data format.

  Fields:
    encoding: Optional. The character encoding of the data. The default is
      UTF-8.
    typeInferenceDisabled: Optional. Whether to disable the inference of data
      types for JSON data. If true, all columns are registered as their
      primitive types (strings, number, or boolean).
  """

  encoding = _messages.StringField(1)
  typeInferenceDisabled = _messages.BooleanField(2)


class GoogleCloudDataplexV1DataDocumentationResult(_messages.Message):
  r"""The output of a DataDocumentation scan.

  Fields:
    tableResult: Output only. Table result for insights.
  """

  tableResult = _messages.MessageField('GoogleCloudDataplexV1DataDocumentationResultTableResult', 1)


class GoogleCloudDataplexV1DataDocumentationResultField(_messages.Message):
  r"""Column of a table with generated metadata and nested fields.

  Fields:
    description: Output only. Generated description for columns and fields.
    fields: Output only. Nested fields.
    name: Output only. The name of the column.
  """

  description = _messages.StringField(1)
  fields = _messages.MessageField('GoogleCloudDataplexV1DataDocumentationResultField', 2, repeated=True)
  name = _messages.StringField(3)


class GoogleCloudDataplexV1DataDocumentationResultQuery(_messages.Message):
  r"""A sample SQL query in data documentation.

  Fields:
    description: Output only. The description for the query.
    sql: Output only. The SQL query string which can be executed.
  """

  description = _messages.StringField(1)
  sql = _messages.StringField(2)


class GoogleCloudDataplexV1DataDocumentationResultSchema(_messages.Message):
  r"""Schema of the table with generated metadata of columns.

  Fields:
    fields: Output only. The list of columns.
  """

  fields = _messages.MessageField('GoogleCloudDataplexV1DataDocumentationResultField', 1, repeated=True)


class GoogleCloudDataplexV1DataDocumentationResultTableResult(_messages.Message):
  r"""Generated metadata about the table.

  Fields:
    name: Output only. The service-qualified full resource name of the cloud
      resource. Ex: //bigquery.googleapis.com/projects/PROJECT_ID/datasets/DAT
      ASET_ID/tables/TABLE_ID
    overview: Output only. Generated description of the table.
    queries: Output only. Sample SQL queries for the table.
    schema: Output only. Schema of the table with generated metadata of the
      columns in the schema.
  """

  name = _messages.StringField(1)
  overview = _messages.StringField(2)
  queries = _messages.MessageField('GoogleCloudDataplexV1DataDocumentationResultQuery', 3, repeated=True)
  schema = _messages.MessageField('GoogleCloudDataplexV1DataDocumentationResultSchema', 4)


class GoogleCloudDataplexV1DataDocumentationSpec(_messages.Message):
  r"""DataDocumentation scan related spec.

  Fields:
    catalogPublishingEnabled: Optional. Whether to publish result to Dataplex
      Catalog.
  """

  catalogPublishingEnabled = _messages.BooleanField(1)


class GoogleCloudDataplexV1DataProduct(_messages.Message):
  r"""A Data Product is a curated collection of Data Assets, packaged to
  address specific use cases. It's a way to manage and share data in a more
  organized, product-like manner.

  Messages:
    AccessGroupsValue: Optional. Data Product access groups by access group id
      as key. If Data Product is used only for packaging Data Assets, then
      access groups may be empty. However, if a Data Product is used for
      sharing Data Assets, then at least one access group must be specified.
    LabelsValue: Optional. User-defined labels for the Data Product.

  Fields:
    accessGroups: Optional. Data Product access groups by access group id as
      key. If Data Product is used only for packaging Data Assets, then access
      groups may be empty. However, if a Data Product is used for sharing Data
      Assets, then at least one access group must be specified.
    assetCount: Output only. Number of Data Assets associated with this Data
      Product.
    createTime: Output only. The time at which the Data Product was created.
    description: Optional. Description of the Data Product.
    displayName: Required. User-friendly display name of the Data Product.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding.
    icon: Optional. Base64 encoded image representing the Data Product. Max
      Size: 3.0MiB Expected image dimensions are 512x512 pixels, however the
      API only performs validation on size of the encoded data. Note: For byte
      fields, the content of the fields are base64-encoded (which increases
      the size of the data by 33-36%) when using JSON on the wire.
    labels: Optional. User-defined labels for the Data Product.
    name: Identifier. Resource name of the Data Product. Format: projects/{pro
      ject_id_or_number}/locations/{location_id}/dataProducts/{data_product_id
      }.
    ownerEmails: Required. Emails of the Data Product owners.
    uid: Output only. System generated unique ID for the Data Product. This ID
      will be different if the Data Product is deleted and re-created with the
      same name.
    updateTime: Output only. The time at which the Data Product was last
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AccessGroupsValue(_messages.Message):
    r"""Optional. Data Product access groups by access group id as key. If
    Data Product is used only for packaging Data Assets, then access groups
    may be empty. However, if a Data Product is used for sharing Data Assets,
    then at least one access group must be specified.

    Messages:
      AdditionalProperty: An additional property for a AccessGroupsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AccessGroupsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AccessGroupsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudDataplexV1DataProductAccessGroup attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudDataplexV1DataProductAccessGroup', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the Data Product.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accessGroups = _messages.MessageField('AccessGroupsValue', 1)
  assetCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  displayName = _messages.StringField(5)
  etag = _messages.StringField(6)
  icon = _messages.BytesField(7)
  labels = _messages.MessageField('LabelsValue', 8)
  name = _messages.StringField(9)
  ownerEmails = _messages.StringField(10, repeated=True)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class GoogleCloudDataplexV1DataProductAccessGroup(_messages.Message):
  r"""Custom user defined access groups at the Data Product level. These are
  used for granting different levels of access (IAM roles) on the individual
  Data Product's Data Assets.

  Fields:
    description: Optional. Description of the access group.
    displayName: Required. User friendly display name of the access group. Eg.
      "Analyst", "Developer", etc.
    id: Required. Unique identifier of the access group within the Data
      Product. User defined. Eg. "analyst", "developer", etc.
    principal: Required. The principal entity associated with this access
      group.
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)
  principal = _messages.MessageField('GoogleCloudDataplexV1DataProductPrincipal', 4)


class GoogleCloudDataplexV1DataProductPrincipal(_messages.Message):
  r"""Represents the principal entity associated with an access group, as per
  https://cloud.google.com/iam/docs/principals-overview.

  Fields:
    googleGroup: Email of the Google Group, as per
      https://cloud.google.com/iam/docs/principals-overview#google-group.
  """

  googleGroup = _messages.StringField(1)


class GoogleCloudDataplexV1DataProfileResult(_messages.Message):
  r"""DataProfileResult defines the output of DataProfileScan. Each field of
  the table will have field type specific profile result.

  Fields:
    catalogPublishingStatus: Output only. The status of publishing the data
      scan as Dataplex Universal Catalog metadata.
    postScanActionsResult: Output only. The result of post scan actions.
    profile: Output only. The profile information per field.
    rowCount: Output only. The count of rows scanned.
    scannedData: Output only. The data scanned for this result.
  """

  catalogPublishingStatus = _messages.MessageField('GoogleCloudDataplexV1DataScanCatalogPublishingStatus', 1)
  postScanActionsResult = _messages.MessageField('GoogleCloudDataplexV1DataProfileResultPostScanActionsResult', 2)
  profile = _messages.MessageField('GoogleCloudDataplexV1DataProfileResultProfile', 3)
  rowCount = _messages.IntegerField(4)
  scannedData = _messages.MessageField('GoogleCloudDataplexV1ScannedData', 5)


class GoogleCloudDataplexV1DataProfileResultPostScanActionsResult(_messages.Message):
  r"""The result of post scan actions of DataProfileScan job.

  Fields:
    bigqueryExportResult: Output only. The result of BigQuery export post scan
      action.
  """

  bigqueryExportResult = _messages.MessageField('GoogleCloudDataplexV1DataProfileResultPostScanActionsResultBigQueryExportResult', 1)


class GoogleCloudDataplexV1DataProfileResultPostScanActionsResultBigQueryExportResult(_messages.Message):
  r"""The result of BigQuery export post scan action.

  Enums:
    StateValueValuesEnum: Output only. Execution state for the BigQuery
      exporting.

  Fields:
    message: Output only. Additional information about the BigQuery exporting.
    state: Output only. Execution state for the BigQuery exporting.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Execution state for the BigQuery exporting.

    Values:
      STATE_UNSPECIFIED: The exporting state is unspecified.
      SUCCEEDED: The exporting completed successfully.
      FAILED: The exporting is no longer running due to an error.
      SKIPPED: The exporting is skipped due to no valid scan result to export
        (usually caused by scan failed).
    """
    STATE_UNSPECIFIED = 0
    SUCCEEDED = 1
    FAILED = 2
    SKIPPED = 3

  message = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudDataplexV1DataProfileResultProfile(_messages.Message):
  r"""Contains name, type, mode and field type specific profile information.

  Fields:
    fields: Output only. List of fields with structural and profile
      information for each field.
  """

  fields = _messages.MessageField('GoogleCloudDataplexV1DataProfileResultProfileField', 1, repeated=True)


class GoogleCloudDataplexV1DataProfileResultProfileField(_messages.Message):
  r"""A field within a table.

  Fields:
    mode: Output only. The mode of the field. Possible values include:
      REQUIRED, if it is a required field. NULLABLE, if it is an optional
      field. REPEATED, if it is a repeated field.
    name: Output only. The name of the field.
    profile: Output only. Profile information for the corresponding field.
    type: Output only. The data type retrieved from the schema of the data
      source. For instance, for a BigQuery native table, it is the BigQuery
      Table Schema (https://cloud.google.com/bigquery/docs/reference/rest/v2/t
      ables#tablefieldschema). For a Dataplex Universal Catalog Entity, it is
      the Entity Schema (https://cloud.google.com/dataplex/docs/reference/rpc/
      google.cloud.dataplex.v1#type_3).
  """

  mode = _messages.StringField(1)
  name = _messages.StringField(2)
  profile = _messages.MessageField('GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo', 3)
  type = _messages.StringField(4)


class GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo(_messages.Message):
  r"""The profile information for each field type.

  Fields:
    distinctRatio: Output only. Ratio of rows with distinct values against
      total scanned rows. Not available for complex non-groupable field type,
      including RECORD, ARRAY, GEOGRAPHY, and JSON, as well as fields with
      REPEATABLE mode.
    doubleProfile: Double type field information.
    integerProfile: Integer type field information.
    nullRatio: Output only. Ratio of rows with null value against total
      scanned rows.
    stringProfile: String type field information.
    topNValues: Output only. The list of top N non-null values, frequency and
      ratio with which they occur in the scanned data. N is 10 or equal to the
      number of distinct values in the field, whichever is smaller. Not
      available for complex non-groupable field type, including RECORD, ARRAY,
      GEOGRAPHY, and JSON, as well as fields with REPEATABLE mode.
  """

  distinctRatio = _messages.FloatField(1)
  doubleProfile = _messages.MessageField('GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFieldInfo', 2)
  integerProfile = _messages.MessageField('GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFieldInfo', 3)
  nullRatio = _messages.FloatField(4)
  stringProfile = _messages.MessageField('GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFieldInfo', 5)
  topNValues = _messages.MessageField('GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue', 6, repeated=True)


class GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFieldInfo(_messages.Message):
  r"""The profile information for a double type field.

  Fields:
    average: Output only. Average of non-null values in the scanned data. NaN,
      if the field has a NaN.
    max: Output only. Maximum of non-null values in the scanned data. NaN, if
      the field has a NaN.
    min: Output only. Minimum of non-null values in the scanned data. NaN, if
      the field has a NaN.
    quartiles: Output only. A quartile divides the number of data points into
      four parts, or quarters, of more-or-less equal size. Three main
      quartiles used are: The first quartile (Q1) splits off the lowest 25% of
      data from the highest 75%. It is also known as the lower or 25th
      empirical quartile, as 25% of the data is below this point. The second
      quartile (Q2) is the median of a data set. So, 50% of the data lies
      below this point. The third quartile (Q3) splits off the highest 25% of
      data from the lowest 75%. It is known as the upper or 75th empirical
      quartile, as 75% of the data lies below this point. Here, the quartiles
      is provided as an ordered list of quartile values for the scanned data,
      occurring in order Q1, median, Q3.
    standardDeviation: Output only. Standard deviation of non-null values in
      the scanned data. NaN, if the field has a NaN.
  """

  average = _messages.FloatField(1)
  max = _messages.FloatField(2)
  min = _messages.FloatField(3)
  quartiles = _messages.FloatField(4, repeated=True)
  standardDeviation = _messages.FloatField(5)


class GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFieldInfo(_messages.Message):
  r"""The profile information for an integer type field.

  Fields:
    average: Output only. Average of non-null values in the scanned data. NaN,
      if the field has a NaN.
    max: Output only. Maximum of non-null values in the scanned data. NaN, if
      the field has a NaN.
    min: Output only. Minimum of non-null values in the scanned data. NaN, if
      the field has a NaN.
    quartiles: Output only. A quartile divides the number of data points into
      four parts, or quarters, of more-or-less equal size. Three main
      quartiles used are: The first quartile (Q1) splits off the lowest 25% of
      data from the highest 75%. It is also known as the lower or 25th
      empirical quartile, as 25% of the data is below this point. The second
      quartile (Q2) is the median of a data set. So, 50% of the data lies
      below this point. The third quartile (Q3) splits off the highest 25% of
      data from the lowest 75%. It is known as the upper or 75th empirical
      quartile, as 75% of the data lies below this point. Here, the quartiles
      is provided as an ordered list of approximate quartile values for the
      scanned data, occurring in order Q1, median, Q3.
    standardDeviation: Output only. Standard deviation of non-null values in
      the scanned data. NaN, if the field has a NaN.
  """

  average = _messages.FloatField(1)
  max = _messages.IntegerField(2)
  min = _messages.IntegerField(3)
  quartiles = _messages.IntegerField(4, repeated=True)
  standardDeviation = _messages.FloatField(5)


class GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFieldInfo(_messages.Message):
  r"""The profile information for a string type field.

  Fields:
    averageLength: Output only. Average length of non-null values in the
      scanned data.
    maxLength: Output only. Maximum length of non-null values in the scanned
      data.
    minLength: Output only. Minimum length of non-null values in the scanned
      data.
  """

  averageLength = _messages.FloatField(1)
  maxLength = _messages.IntegerField(2)
  minLength = _messages.IntegerField(3)


class GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue(_messages.Message):
  r"""Top N non-null values in the scanned data.

  Fields:
    count: Output only. Count of the corresponding value in the scanned data.
    ratio: Output only. Ratio of the corresponding value in the field against
      the total number of rows in the scanned data.
    value: Output only. String value of a top N non-null value.
  """

  count = _messages.IntegerField(1)
  ratio = _messages.FloatField(2)
  value = _messages.StringField(3)


class GoogleCloudDataplexV1DataProfileSpec(_messages.Message):
  r"""DataProfileScan related setting.

  Fields:
    catalogPublishingEnabled: Optional. If set, the latest DataScan job result
      will be published as Dataplex Universal Catalog metadata.
    excludeFields: Optional. The fields to exclude from data profile.If
      specified, the fields will be excluded from data profile, regardless of
      include_fields value.
    includeFields: Optional. The fields to include in data profile.If not
      specified, all fields at the time of profile scan job execution are
      included, except for ones listed in exclude_fields.
    postScanActions: Optional. Actions to take upon job completion..
    rowFilter: Optional. A filter applied to all rows in a single DataScan
      job. The filter needs to be a valid SQL expression for a WHERE clause in
      BigQuery standard SQL syntax. Example: col1 >= 0 AND col2 < 10
    samplingPercent: Optional. The percentage of the records to be selected
      from the dataset for DataScan. Value can range between 0.0 and 100.0
      with up to 3 significant decimal digits. Sampling is not applied if
      sampling_percent is not specified, 0 or 100.
  """

  catalogPublishingEnabled = _messages.BooleanField(1)
  excludeFields = _messages.MessageField('GoogleCloudDataplexV1DataProfileSpecSelectedFields', 2)
  includeFields = _messages.MessageField('GoogleCloudDataplexV1DataProfileSpecSelectedFields', 3)
  postScanActions = _messages.MessageField('GoogleCloudDataplexV1DataProfileSpecPostScanActions', 4)
  rowFilter = _messages.StringField(5)
  samplingPercent = _messages.FloatField(6, variant=_messages.Variant.FLOAT)


class GoogleCloudDataplexV1DataProfileSpecPostScanActions(_messages.Message):
  r"""The configuration of post scan actions of DataProfileScan job.

  Fields:
    bigqueryExport: Optional. If set, results will be exported to the provided
      BigQuery table.
  """

  bigqueryExport = _messages.MessageField('GoogleCloudDataplexV1DataProfileSpecPostScanActionsBigQueryExport', 1)


class GoogleCloudDataplexV1DataProfileSpecPostScanActionsBigQueryExport(_messages.Message):
  r"""The configuration of BigQuery export post scan action.

  Fields:
    resultsTable: Optional. The BigQuery table to export DataProfileScan
      results to. Format: //bigquery.googleapis.com/projects/PROJECT_ID/datase
      ts/DATASET_ID/tables/TABLE_ID
  """

  resultsTable = _messages.StringField(1)


class GoogleCloudDataplexV1DataProfileSpecSelectedFields(_messages.Message):
  r"""The specification for fields to include or exclude in data profile scan.

  Fields:
    fieldNames: Optional. Expected input is a list of fully qualified names of
      fields as in the schema.Only top-level field names for nested fields are
      supported. For instance, if 'x' is of nested field type, listing 'x' is
      supported but 'x.y.z' is not supported. Here 'y' and 'y.z' are nested
      fields of 'x'.
  """

  fieldNames = _messages.StringField(1, repeated=True)


class GoogleCloudDataplexV1DataQualityColumnResult(_messages.Message):
  r"""DataQualityColumnResult provides a more detailed, per-column view of the
  results.

  Fields:
    column: Output only. The column specified in the DataQualityRule.
    dimensions: Output only. The dimension-level results for this column.
    passed: Output only. Whether the column passed or failed.
    score: Output only. The column-level data quality score for this data scan
      job if and only if the 'column' field is set.The score ranges between
      between 0, 100 (up to two decimal points).
  """

  column = _messages.StringField(1)
  dimensions = _messages.MessageField('GoogleCloudDataplexV1DataQualityDimensionResult', 2, repeated=True)
  passed = _messages.BooleanField(3)
  score = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleCloudDataplexV1DataQualityDimension(_messages.Message):
  r"""A dimension captures data quality intent about a defined subset of the
  rules specified.

  Fields:
    name: Output only. The dimension name a rule belongs to. Custom dimension
      name is supported with all uppercase letters and maximum length of 30
      characters.
  """

  name = _messages.StringField(1)


class GoogleCloudDataplexV1DataQualityDimensionResult(_messages.Message):
  r"""DataQualityDimensionResult provides a more detailed, per-dimension view
  of the results.

  Fields:
    dimension: Output only. The dimension config specified in the
      DataQualitySpec, as is.
    passed: Output only. Whether the dimension passed or failed.
    score: Output only. The dimension-level data quality score for this data
      scan job if and only if the 'dimension' field is set.The score ranges
      between 0, 100 (up to two decimal points).
  """

  dimension = _messages.MessageField('GoogleCloudDataplexV1DataQualityDimension', 1)
  passed = _messages.BooleanField(2)
  score = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class GoogleCloudDataplexV1DataQualityResult(_messages.Message):
  r"""The output of a DataQualityScan.

  Fields:
    anomalyDetectionGeneratedAssets: Output only. The generated assets for
      anomaly detection.
    catalogPublishingStatus: Output only. The status of publishing the data
      scan as Dataplex Universal Catalog metadata.
    columns: Output only. A list of results at the column level.A column will
      have a corresponding DataQualityColumnResult if and only if there is at
      least one rule with the 'column' field set to it.
    dimensions: Output only. A list of results at the dimension level.A
      dimension will have a corresponding DataQualityDimensionResult if and
      only if there is at least one rule with the 'dimension' field set to it.
    passed: Output only. Overall data quality result -- true if all rules
      passed.
    postScanActionsResult: Output only. The result of post scan actions.
    rowCount: Output only. The count of rows processed.
    rules: Output only. A list of all the rules in a job, and their results.
    scannedData: Output only. The data scanned for this result.
    score: Output only. The overall data quality score.The score ranges
      between 0, 100 (up to two decimal points).
  """

  anomalyDetectionGeneratedAssets = _messages.MessageField('GoogleCloudDataplexV1DataQualityResultAnomalyDetectionGeneratedAssets', 1)
  catalogPublishingStatus = _messages.MessageField('GoogleCloudDataplexV1DataScanCatalogPublishingStatus', 2)
  columns = _messages.MessageField('GoogleCloudDataplexV1DataQualityColumnResult', 3, repeated=True)
  dimensions = _messages.MessageField('GoogleCloudDataplexV1DataQualityDimensionResult', 4, repeated=True)
  passed = _messages.BooleanField(5)
  postScanActionsResult = _messages.MessageField('GoogleCloudDataplexV1DataQualityResultPostScanActionsResult', 6)
  rowCount = _messages.IntegerField(7)
  rules = _messages.MessageField('GoogleCloudDataplexV1DataQualityRuleResult', 8, repeated=True)
  scannedData = _messages.MessageField('GoogleCloudDataplexV1ScannedData', 9)
  score = _messages.FloatField(10, variant=_messages.Variant.FLOAT)


class GoogleCloudDataplexV1DataQualityResultAnomalyDetectionGeneratedAssets(_messages.Message):
  r"""The assets generated by Anomaly Detection Data Scan.

  Fields:
    dataIntermediateTable: Output only. The intermediate table for data
      anomaly detection. Format: PROJECT_ID.DATASET_ID.TABLE_ID
    freshnessIntermediateTable: Output only. The intermediate table for
      freshness anomaly detection. Format: PROJECT_ID.DATASET_ID.TABLE_ID
    resultTable: Output only. The result table for anomaly detection. Format:
      PROJECT_ID.DATASET_ID.TABLE_ID If the result table is set at
      AnomalyDetectionAssets, the result table here would be the same as the
      one set in the AnomalyDetectionAssets.result_table.
    volumeIntermediateTable: Output only. The intermediate table for volume
      anomaly detection. Format: PROJECT_ID.DATASET_ID.TABLE_ID
  """

  dataIntermediateTable = _messages.StringField(1)
  freshnessIntermediateTable = _messages.StringField(2)
  resultTable = _messages.StringField(3)
  volumeIntermediateTable = _messages.StringField(4)


class GoogleCloudDataplexV1DataQualityResultPostScanActionsResult(_messages.Message):
  r"""The result of post scan actions of DataQualityScan job.

  Fields:
    bigqueryExportResult: Output only. The result of BigQuery export post scan
      action.
  """

  bigqueryExportResult = _messages.MessageField('GoogleCloudDataplexV1DataQualityResultPostScanActionsResultBigQueryExportResult', 1)


class GoogleCloudDataplexV1DataQualityResultPostScanActionsResultBigQueryExportResult(_messages.Message):
  r"""The result of BigQuery export post scan action.

  Enums:
    StateValueValuesEnum: Output only. Execution state for the BigQuery
      exporting.

  Fields:
    message: Output only. Additional information about the BigQuery exporting.
    state: Output only. Execution state for the BigQuery exporting.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Execution state for the BigQuery exporting.

    Values:
      STATE_UNSPECIFIED: The exporting state is unspecified.
      SUCCEEDED: The exporting completed successfully.
      FAILED: The exporting is no longer running due to an error.
      SKIPPED: The exporting is skipped due to no valid scan result to export
        (usually caused by scan failed).
    """
    STATE_UNSPECIFIED = 0
    SUCCEEDED = 1
    FAILED = 2
    SKIPPED = 3

  message = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudDataplexV1DataQualityRule(_messages.Message):
  r"""A rule captures data quality intent about a data source.

  Fields:
    column: Optional. The unnested column which this rule is evaluated
      against.
    description: Optional. Description of the rule. The maximum length is
      1,024 characters.
    dimension: Required. The dimension a rule belongs to. Results are also
      aggregated at the dimension level. Custom dimension name is supported
      with all uppercase letters and maximum length of 30 characters.
    ignoreNull: Optional. Rows with null values will automatically fail a
      rule, unless ignore_null is true. In that case, such null rows are
      trivially considered passing.This field is only valid for the following
      type of rules: RangeExpectation RegexExpectation SetExpectation
      UniquenessExpectation
    name: Optional. A mutable name for the rule. The name must contain only
      letters (a-z, A-Z), numbers (0-9), or hyphens (-). The maximum length is
      63 characters. Must start with a letter. Must end with a number or a
      letter.
    nonNullExpectation: Row-level rule which evaluates whether each column
      value is null.
    rangeExpectation: Row-level rule which evaluates whether each column value
      lies between a specified range.
    regexExpectation: Row-level rule which evaluates whether each column value
      matches a specified regex.
    rowConditionExpectation: Row-level rule which evaluates whether each row
      in a table passes the specified condition.
    setExpectation: Row-level rule which evaluates whether each column value
      is contained by a specified set.
    sqlAssertion: Aggregate rule which evaluates the number of rows returned
      for the provided statement. If any rows are returned, this rule fails.
    statisticRangeExpectation: Aggregate rule which evaluates whether the
      column aggregate statistic lies between a specified range.
    suspended: Optional. Whether the Rule is active or suspended. Default is
      false.
    tableConditionExpectation: Aggregate rule which evaluates whether the
      provided expression is true for a table.
    threshold: Optional. The minimum ratio of passing_rows / total_rows
      required to pass this rule, with a range of 0.0, 1.0.0 indicates default
      value (i.e. 1.0).This field is only valid for row-level type rules.
    uniquenessExpectation: Row-level rule which evaluates whether each column
      value is unique.
  """

  column = _messages.StringField(1)
  description = _messages.StringField(2)
  dimension = _messages.StringField(3)
  ignoreNull = _messages.BooleanField(4)
  name = _messages.StringField(5)
  nonNullExpectation = _messages.MessageField('GoogleCloudDataplexV1DataQualityRuleNonNullExpectation', 6)
  rangeExpectation = _messages.MessageField('GoogleCloudDataplexV1DataQualityRuleRangeExpectation', 7)
  regexExpectation = _messages.MessageField('GoogleCloudDataplexV1DataQualityRuleRegexExpectation', 8)
  rowConditionExpectation = _messages.MessageField('GoogleCloudDataplexV1DataQualityRuleRowConditionExpectation', 9)
  setExpectation = _messages.MessageField('GoogleCloudDataplexV1DataQualityRuleSetExpectation', 10)
  sqlAssertion = _messages.MessageField('GoogleCloudDataplexV1DataQualityRuleSqlAssertion', 11)
  statisticRangeExpectation = _messages.MessageField('GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectation', 12)
  suspended = _messages.BooleanField(13)
  tableConditionExpectation = _messages.MessageField('GoogleCloudDataplexV1DataQualityRuleTableConditionExpectation', 14)
  threshold = _messages.FloatField(15)
  uniquenessExpectation = _messages.MessageField('GoogleCloudDataplexV1DataQualityRuleUniquenessExpectation', 16)


class GoogleCloudDataplexV1DataQualityRuleNonNullExpectation(_messages.Message):
  r"""Evaluates whether each column value is null."""


class GoogleCloudDataplexV1DataQualityRuleRangeExpectation(_messages.Message):
  r"""Evaluates whether each column value lies between a specified range.

  Fields:
    maxValue: Optional. The maximum column value allowed for a row to pass
      this validation. At least one of min_value and max_value need to be
      provided.
    minValue: Optional. The minimum column value allowed for a row to pass
      this validation. At least one of min_value and max_value need to be
      provided.
    strictMaxEnabled: Optional. Whether each value needs to be strictly lesser
      than ('<') the maximum, or if equality is allowed.Only relevant if a
      max_value has been defined. Default = false.
    strictMinEnabled: Optional. Whether each value needs to be strictly
      greater than ('>') the minimum, or if equality is allowed.Only relevant
      if a min_value has been defined. Default = false.
  """

  maxValue = _messages.StringField(1)
  minValue = _messages.StringField(2)
  strictMaxEnabled = _messages.BooleanField(3)
  strictMinEnabled = _messages.BooleanField(4)


class GoogleCloudDataplexV1DataQualityRuleRegexExpectation(_messages.Message):
  r"""Evaluates whether each column value matches a specified regex.

  Fields:
    regex: Optional. A regular expression the column value is expected to
      match.
  """

  regex = _messages.StringField(1)


class GoogleCloudDataplexV1DataQualityRuleResult(_messages.Message):
  r"""DataQualityRuleResult provides a more detailed, per-rule view of the
  results.

  Fields:
    assertionRowCount: Output only. The number of rows returned by the SQL
      statement in a SQL assertion rule.This field is only valid for SQL
      assertion rules.
    evaluatedCount: Output only. The number of rows a rule was evaluated
      against.This field is only valid for row-level type rules.Evaluated
      count can be configured to either include all rows (default) - with null
      rows automatically failing rule evaluation, or exclude null rows from
      the evaluated_count, by setting ignore_nulls = true.This field is not
      set for rule SqlAssertion.
    failingRowsQuery: Output only. The query to find rows that did not pass
      this rule.This field is only valid for row-level type rules.
    nullCount: Output only. The number of rows with null values in the
      specified column.
    passRatio: Output only. The ratio of passed_count / evaluated_count.This
      field is only valid for row-level type rules.
    passed: Output only. Whether the rule passed or failed.
    passedCount: Output only. The number of rows which passed a rule
      evaluation.This field is only valid for row-level type rules.This field
      is not set for rule SqlAssertion.
    rule: Output only. The rule specified in the DataQualitySpec, as is.
  """

  assertionRowCount = _messages.IntegerField(1)
  evaluatedCount = _messages.IntegerField(2)
  failingRowsQuery = _messages.StringField(3)
  nullCount = _messages.IntegerField(4)
  passRatio = _messages.FloatField(5)
  passed = _messages.BooleanField(6)
  passedCount = _messages.IntegerField(7)
  rule = _messages.MessageField('GoogleCloudDataplexV1DataQualityRule', 8)


class GoogleCloudDataplexV1DataQualityRuleRowConditionExpectation(_messages.Message):
  r"""Evaluates whether each row passes the specified condition.The SQL
  expression needs to use GoogleSQL syntax
  (https://cloud.google.com/bigquery/docs/reference/standard-sql/query-syntax)
  and should produce a boolean value per row as the result.Example: col1 >= 0
  AND col2 < 10

  Fields:
    sqlExpression: Optional. The SQL expression.
  """

  sqlExpression = _messages.StringField(1)


class GoogleCloudDataplexV1DataQualityRuleSetExpectation(_messages.Message):
  r"""Evaluates whether each column value is contained by a specified set.

  Fields:
    values: Optional. Expected values for the column value.
  """

  values = _messages.StringField(1, repeated=True)


class GoogleCloudDataplexV1DataQualityRuleSqlAssertion(_messages.Message):
  r"""A SQL statement that is evaluated to return rows that match an invalid
  state. If any rows are are returned, this rule fails.The SQL statement must
  use GoogleSQL syntax
  (https://cloud.google.com/bigquery/docs/reference/standard-sql/query-
  syntax), and must not contain any semicolons.You can use the data reference
  parameter ${data()} to reference the source table with all of its
  precondition filters applied. Examples of precondition filters include row
  filters, incremental data filters, and sampling. For more information, see
  Data reference parameter (https://cloud.google.com/dataplex/docs/auto-data-
  quality-overview#data-reference-parameter).Example: SELECT * FROM ${data()}
  WHERE price < 0

  Fields:
    sqlStatement: Optional. The SQL statement.
  """

  sqlStatement = _messages.StringField(1)


class GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectation(_messages.Message):
  r"""Evaluates whether the column aggregate statistic lies between a
  specified range.

  Enums:
    StatisticValueValuesEnum: Optional. The aggregate metric to evaluate.

  Fields:
    maxValue: Optional. The maximum column statistic value allowed for a row
      to pass this validation.At least one of min_value and max_value need to
      be provided.
    minValue: Optional. The minimum column statistic value allowed for a row
      to pass this validation.At least one of min_value and max_value need to
      be provided.
    statistic: Optional. The aggregate metric to evaluate.
    strictMaxEnabled: Optional. Whether column statistic needs to be strictly
      lesser than ('<') the maximum, or if equality is allowed.Only relevant
      if a max_value has been defined. Default = false.
    strictMinEnabled: Optional. Whether column statistic needs to be strictly
      greater than ('>') the minimum, or if equality is allowed.Only relevant
      if a min_value has been defined. Default = false.
  """

  class StatisticValueValuesEnum(_messages.Enum):
    r"""Optional. The aggregate metric to evaluate.

    Values:
      STATISTIC_UNDEFINED: Unspecified statistic type
      MEAN: Evaluate the column mean
      MIN: Evaluate the column min
      MAX: Evaluate the column max
    """
    STATISTIC_UNDEFINED = 0
    MEAN = 1
    MIN = 2
    MAX = 3

  maxValue = _messages.StringField(1)
  minValue = _messages.StringField(2)
  statistic = _messages.EnumField('StatisticValueValuesEnum', 3)
  strictMaxEnabled = _messages.BooleanField(4)
  strictMinEnabled = _messages.BooleanField(5)


class GoogleCloudDataplexV1DataQualityRuleTableConditionExpectation(_messages.Message):
  r"""Evaluates whether the provided expression is true.The SQL expression
  needs to use GoogleSQL syntax
  (https://cloud.google.com/bigquery/docs/reference/standard-sql/query-syntax)
  and should produce a scalar boolean result.Example: MIN(col1) >= 0

  Fields:
    sqlExpression: Optional. The SQL expression.
  """

  sqlExpression = _messages.StringField(1)


class GoogleCloudDataplexV1DataQualityRuleUniquenessExpectation(_messages.Message):
  r"""Evaluates whether the column has duplicates."""


class GoogleCloudDataplexV1DataQualityScanRuleResult(_messages.Message):
  r"""Information about the result of a data quality rule for data quality
  scan. The monitored resource is 'DataScan'.

  Enums:
    EvalutionTypeValueValuesEnum: The evaluation type of the data quality
      rule.
    ResultValueValuesEnum: The result of the data quality rule.
    RuleTypeValueValuesEnum: The type of the data quality rule.

  Fields:
    assertionRowCount: The number of rows returned by the SQL statement in a
      SQL assertion rule. This field is only valid for SQL assertion rules.
    column: The column which this rule is evaluated against.
    dataSource: The data source of the data scan (e.g. BigQuery table name).
    evaluatedRowCount: The number of rows evaluated against the data quality
      rule. This field is only valid for rules of PER_ROW evaluation type.
    evalutionType: The evaluation type of the data quality rule.
    jobId: Identifier of the specific data scan job this log entry is for.
    nullRowCount: The number of rows with null values in the specified column.
    passedRowCount: The number of rows which passed a rule evaluation. This
      field is only valid for rules of PER_ROW evaluation type.
    result: The result of the data quality rule.
    ruleDimension: The dimension of the data quality rule.
    ruleName: The name of the data quality rule.
    ruleType: The type of the data quality rule.
    thresholdPercent: The passing threshold (0.0, 100.0) of the data quality
      rule.
  """

  class EvalutionTypeValueValuesEnum(_messages.Enum):
    r"""The evaluation type of the data quality rule.

    Values:
      EVALUATION_TYPE_UNSPECIFIED: An unspecified evaluation type.
      PER_ROW: The rule evaluation is done at per row level.
      AGGREGATE: The rule evaluation is done for an aggregate of rows.
    """
    EVALUATION_TYPE_UNSPECIFIED = 0
    PER_ROW = 1
    AGGREGATE = 2

  class ResultValueValuesEnum(_messages.Enum):
    r"""The result of the data quality rule.

    Values:
      RESULT_UNSPECIFIED: An unspecified result.
      PASSED: The data quality rule passed.
      FAILED: The data quality rule failed.
    """
    RESULT_UNSPECIFIED = 0
    PASSED = 1
    FAILED = 2

  class RuleTypeValueValuesEnum(_messages.Enum):
    r"""The type of the data quality rule.

    Values:
      RULE_TYPE_UNSPECIFIED: An unspecified rule type.
      NON_NULL_EXPECTATION: See DataQualityRule.NonNullExpectation.
      RANGE_EXPECTATION: See DataQualityRule.RangeExpectation.
      REGEX_EXPECTATION: See DataQualityRule.RegexExpectation.
      ROW_CONDITION_EXPECTATION: See DataQualityRule.RowConditionExpectation.
      SET_EXPECTATION: See DataQualityRule.SetExpectation.
      STATISTIC_RANGE_EXPECTATION: See
        DataQualityRule.StatisticRangeExpectation.
      TABLE_CONDITION_EXPECTATION: See
        DataQualityRule.TableConditionExpectation.
      UNIQUENESS_EXPECTATION: See DataQualityRule.UniquenessExpectation.
      SQL_ASSERTION: See DataQualityRule.SqlAssertion.
    """
    RULE_TYPE_UNSPECIFIED = 0
    NON_NULL_EXPECTATION = 1
    RANGE_EXPECTATION = 2
    REGEX_EXPECTATION = 3
    ROW_CONDITION_EXPECTATION = 4
    SET_EXPECTATION = 5
    STATISTIC_RANGE_EXPECTATION = 6
    TABLE_CONDITION_EXPECTATION = 7
    UNIQUENESS_EXPECTATION = 8
    SQL_ASSERTION = 9

  assertionRowCount = _messages.IntegerField(1)
  column = _messages.StringField(2)
  dataSource = _messages.StringField(3)
  evaluatedRowCount = _messages.IntegerField(4)
  evalutionType = _messages.EnumField('EvalutionTypeValueValuesEnum', 5)
  jobId = _messages.StringField(6)
  nullRowCount = _messages.IntegerField(7)
  passedRowCount = _messages.IntegerField(8)
  result = _messages.EnumField('ResultValueValuesEnum', 9)
  ruleDimension = _messages.StringField(10)
  ruleName = _messages.StringField(11)
  ruleType = _messages.EnumField('RuleTypeValueValuesEnum', 12)
  thresholdPercent = _messages.FloatField(13)


class GoogleCloudDataplexV1DataQualitySpec(_messages.Message):
  r"""DataQualityScan related setting.

  Fields:
    catalogPublishingEnabled: Optional. If set, the latest DataScan job result
      will be published as Dataplex Universal Catalog metadata.
    postScanActions: Optional. Actions to take upon job completion.
    rowFilter: Optional. A filter applied to all rows in a single DataScan
      job. The filter needs to be a valid SQL expression for a WHERE clause in
      GoogleSQL syntax
      (https://cloud.google.com/bigquery/docs/reference/standard-sql/query-
      syntax#where_clause).Example: col1 >= 0 AND col2 < 10
    rules: Required. The list of rules to evaluate against a data source. At
      least one rule is required.
    samplingPercent: Optional. The percentage of the records to be selected
      from the dataset for DataScan. Value can range between 0.0 and 100.0
      with up to 3 significant decimal digits. Sampling is not applied if
      sampling_percent is not specified, 0 or 100.
  """

  catalogPublishingEnabled = _messages.BooleanField(1)
  postScanActions = _messages.MessageField('GoogleCloudDataplexV1DataQualitySpecPostScanActions', 2)
  rowFilter = _messages.StringField(3)
  rules = _messages.MessageField('GoogleCloudDataplexV1DataQualityRule', 4, repeated=True)
  samplingPercent = _messages.FloatField(5, variant=_messages.Variant.FLOAT)


class GoogleCloudDataplexV1DataQualitySpecPostScanActions(_messages.Message):
  r"""The configuration of post scan actions of DataQualityScan.

  Fields:
    bigqueryExport: Optional. If set, results will be exported to the provided
      BigQuery table.
    notificationReport: Optional. If set, results will be sent to the provided
      notification receipts upon triggers.
  """

  bigqueryExport = _messages.MessageField('GoogleCloudDataplexV1DataQualitySpecPostScanActionsBigQueryExport', 1)
  notificationReport = _messages.MessageField('GoogleCloudDataplexV1DataQualitySpecPostScanActionsNotificationReport', 2)


class GoogleCloudDataplexV1DataQualitySpecPostScanActionsBigQueryExport(_messages.Message):
  r"""The configuration of BigQuery export post scan action.

  Fields:
    resultsTable: Optional. The BigQuery table to export DataQualityScan
      results to. Format: //bigquery.googleapis.com/projects/PROJECT_ID/datase
      ts/DATASET_ID/tables/TABLE_ID or
      projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
  """

  resultsTable = _messages.StringField(1)


class GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobEndTrigger(_messages.Message):
  r"""This trigger is triggered whenever a scan job run ends, regardless of
  the result.
  """



class GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobFailureTrigger(_messages.Message):
  r"""This trigger is triggered when the scan job itself fails, regardless of
  the result.
  """



class GoogleCloudDataplexV1DataQualitySpecPostScanActionsNotificationReport(_messages.Message):
  r"""The configuration of notification report post scan action.

  Fields:
    jobEndTrigger: Optional. If set, report will be sent when a scan job ends.
    jobFailureTrigger: Optional. If set, report will be sent when a scan job
      fails.
    recipients: Required. The recipients who will receive the notification
      report.
    scoreThresholdTrigger: Optional. If set, report will be sent when score
      threshold is met.
  """

  jobEndTrigger = _messages.MessageField('GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobEndTrigger', 1)
  jobFailureTrigger = _messages.MessageField('GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobFailureTrigger', 2)
  recipients = _messages.MessageField('GoogleCloudDataplexV1DataQualitySpecPostScanActionsRecipients', 3)
  scoreThresholdTrigger = _messages.MessageField('GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigger', 4)


class GoogleCloudDataplexV1DataQualitySpecPostScanActionsRecipients(_messages.Message):
  r"""The individuals or groups who are designated to receive notifications
  upon triggers.

  Fields:
    emails: Optional. The email recipients who will receive the
      DataQualityScan results report.
  """

  emails = _messages.StringField(1, repeated=True)


class GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigger(_messages.Message):
  r"""This trigger is triggered when the DQ score in the job result is less
  than a specified input score.

  Fields:
    scoreThreshold: Optional. The score range is in 0,100.
  """

  scoreThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)


class GoogleCloudDataplexV1DataScan(_messages.Message):
  r"""Represents a user-visible job which provides the insights for the
  related data source.For example: Data quality: generates queries based on
  the rules and runs against the data to get data quality check results. For
  more information, see Auto data quality overview
  (https://cloud.google.com/dataplex/docs/auto-data-quality-overview). Data
  profile: analyzes the data in tables and generates insights about the
  structure, content and relationships (such as null percent, cardinality,
  min/max/mean, etc). For more information, see About data profiling
  (https://cloud.google.com/dataplex/docs/data-profiling-overview). Data
  discovery: scans data in Cloud Storage buckets to extract and then catalog
  metadata. For more information, see Discover and catalog Cloud Storage data
  (https://cloud.google.com/bigquery/docs/automatic-discovery). Data
  documentation: analyzes the table details and generates insights including
  descriptions and sample SQL queries for the table. For more information, see
  Generate data insights in BigQuery
  (https://cloud.google.com/bigquery/docs/data-insights).

  Enums:
    StateValueValuesEnum: Output only. Current state of the DataScan.
    TypeValueValuesEnum: Output only. The type of DataScan.

  Messages:
    LabelsValue: Optional. User-defined labels for the scan.

  Fields:
    createTime: Output only. The time when the scan was created.
    data: Required. The data source for DataScan.
    dataDiscoveryResult: Output only. The result of a data discovery scan.
    dataDiscoverySpec: Settings for a data discovery scan.
    dataDocumentationResult: Output only. The result of a data documentation
      scan.
    dataDocumentationSpec: Settings for a data documentation scan.
    dataProfileResult: Output only. The result of a data profile scan.
    dataProfileSpec: Settings for a data profile scan.
    dataQualityResult: Output only. The result of a data quality scan.
    dataQualitySpec: Settings for a data quality scan.
    description: Optional. Description of the scan. Must be between 1-1024
      characters.
    displayName: Optional. User friendly display name. Must be between 1-256
      characters.
    executionSpec: Optional. DataScan execution settings.If not specified, the
      fields in it will use their default values.
    executionStatus: Output only. Status of the data scan execution.
    labels: Optional. User-defined labels for the scan.
    name: Output only. Identifier. The relative resource name of the scan, of
      the form:
      projects/{project}/locations/{location_id}/dataScans/{datascan_id},
      where project refers to a project_id or project_number and location_id
      refers to a Google Cloud region.
    state: Output only. Current state of the DataScan.
    type: Output only. The type of DataScan.
    uid: Output only. System generated globally unique ID for the scan. This
      ID will be different if the scan is deleted and re-created with the same
      name.
    updateTime: Output only. The time when the scan was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the DataScan.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of DataScan.

    Values:
      DATA_SCAN_TYPE_UNSPECIFIED: The data scan type is unspecified.
      DATA_QUALITY: Data quality scan.
      DATA_PROFILE: Data profile scan.
      DATA_DISCOVERY: Data discovery scan.
      DATA_DOCUMENTATION: Data documentation scan.
    """
    DATA_SCAN_TYPE_UNSPECIFIED = 0
    DATA_QUALITY = 1
    DATA_PROFILE = 2
    DATA_DISCOVERY = 3
    DATA_DOCUMENTATION = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the scan.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  data = _messages.MessageField('GoogleCloudDataplexV1DataSource', 2)
  dataDiscoveryResult = _messages.MessageField('GoogleCloudDataplexV1DataDiscoveryResult', 3)
  dataDiscoverySpec = _messages.MessageField('GoogleCloudDataplexV1DataDiscoverySpec', 4)
  dataDocumentationResult = _messages.MessageField('GoogleCloudDataplexV1DataDocumentationResult', 5)
  dataDocumentationSpec = _messages.MessageField('GoogleCloudDataplexV1DataDocumentationSpec', 6)
  dataProfileResult = _messages.MessageField('GoogleCloudDataplexV1DataProfileResult', 7)
  dataProfileSpec = _messages.MessageField('GoogleCloudDataplexV1DataProfileSpec', 8)
  dataQualityResult = _messages.MessageField('GoogleCloudDataplexV1DataQualityResult', 9)
  dataQualitySpec = _messages.MessageField('GoogleCloudDataplexV1DataQualitySpec', 10)
  description = _messages.StringField(11)
  displayName = _messages.StringField(12)
  executionSpec = _messages.MessageField('GoogleCloudDataplexV1DataScanExecutionSpec', 13)
  executionStatus = _messages.MessageField('GoogleCloudDataplexV1DataScanExecutionStatus', 14)
  labels = _messages.MessageField('LabelsValue', 15)
  name = _messages.StringField(16)
  state = _messages.EnumField('StateValueValuesEnum', 17)
  type = _messages.EnumField('TypeValueValuesEnum', 18)
  uid = _messages.StringField(19)
  updateTime = _messages.StringField(20)


class GoogleCloudDataplexV1DataScanCatalogPublishingStatus(_messages.Message):
  r"""The status of publishing the data scan result as Dataplex Universal
  Catalog metadata. Multiple DataScan log events may exist, each with
  different publishing information depending on the type of publishing
  triggered.

  Enums:
    StateValueValuesEnum: Output only. Execution state for publishing.

  Fields:
    state: Output only. Execution state for publishing.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Execution state for publishing.

    Values:
      STATE_UNSPECIFIED: The publishing state is unspecified.
      SUCCEEDED: Publishing to catalog completed successfully.
      FAILED: Publish to catalog failed.
      SKIPPED: Publishing to catalog was skipped.
    """
    STATE_UNSPECIFIED = 0
    SUCCEEDED = 1
    FAILED = 2
    SKIPPED = 3

  state = _messages.EnumField('StateValueValuesEnum', 1)


class GoogleCloudDataplexV1DataScanEvent(_messages.Message):
  r"""These messages contain information about the execution of a datascan.
  The monitored resource is 'DataScan'

  Enums:
    ScopeValueValuesEnum: The scope of the data scan (e.g. full, incremental).
    StateValueValuesEnum: The status of the data scan job.
    TriggerValueValuesEnum: The trigger type of the data scan job.
    TypeValueValuesEnum: The type of the data scan.

  Fields:
    catalogPublishingStatus: The status of publishing the data scan as
      Dataplex Universal Catalog metadata.
    createTime: The time when the data scan job was created.
    dataProfile: Data profile result for data profile type data scan.
    dataProfileConfigs: Applied configs for data profile type data scan.
    dataQuality: Data quality result for data quality type data scan.
    dataQualityConfigs: Applied configs for data quality type data scan.
    dataSource: The data source of the data scan
    endTime: The time when the data scan job finished.
    jobId: The identifier of the specific data scan job this log entry is for.
    message: The message describing the data scan job event.
    postScanActionsResult: The result of post scan actions.
    scope: The scope of the data scan (e.g. full, incremental).
    specVersion: A version identifier of the spec which was used to execute
      this job.
    startTime: The time when the data scan job started to run.
    state: The status of the data scan job.
    trigger: The trigger type of the data scan job.
    type: The type of the data scan.
  """

  class ScopeValueValuesEnum(_messages.Enum):
    r"""The scope of the data scan (e.g. full, incremental).

    Values:
      SCOPE_UNSPECIFIED: An unspecified scope type.
      FULL: Data scan runs on all of the data.
      INCREMENTAL: Data scan runs on incremental data.
    """
    SCOPE_UNSPECIFIED = 0
    FULL = 1
    INCREMENTAL = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""The status of the data scan job.

    Values:
      STATE_UNSPECIFIED: Unspecified job state.
      STARTED: Data scan job started.
      SUCCEEDED: Data scan job successfully completed.
      FAILED: Data scan job was unsuccessful.
      CANCELLED: Data scan job was cancelled.
      CREATED: Data scan job was created.
    """
    STATE_UNSPECIFIED = 0
    STARTED = 1
    SUCCEEDED = 2
    FAILED = 3
    CANCELLED = 4
    CREATED = 5

  class TriggerValueValuesEnum(_messages.Enum):
    r"""The trigger type of the data scan job.

    Values:
      TRIGGER_UNSPECIFIED: An unspecified trigger type.
      ON_DEMAND: Data scan triggers on demand.
      SCHEDULE: Data scan triggers as per schedule.
      ONE_TIME: Data scan is run one time on creation.
    """
    TRIGGER_UNSPECIFIED = 0
    ON_DEMAND = 1
    SCHEDULE = 2
    ONE_TIME = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the data scan.

    Values:
      SCAN_TYPE_UNSPECIFIED: An unspecified data scan type.
      DATA_PROFILE: Data scan for data profile.
      DATA_QUALITY: Data scan for data quality.
      DATA_DISCOVERY: Data scan for data discovery.
    """
    SCAN_TYPE_UNSPECIFIED = 0
    DATA_PROFILE = 1
    DATA_QUALITY = 2
    DATA_DISCOVERY = 3

  catalogPublishingStatus = _messages.MessageField('GoogleCloudDataplexV1DataScanCatalogPublishingStatus', 1)
  createTime = _messages.StringField(2)
  dataProfile = _messages.MessageField('GoogleCloudDataplexV1DataScanEventDataProfileResult', 3)
  dataProfileConfigs = _messages.MessageField('GoogleCloudDataplexV1DataScanEventDataProfileAppliedConfigs', 4)
  dataQuality = _messages.MessageField('GoogleCloudDataplexV1DataScanEventDataQualityResult', 5)
  dataQualityConfigs = _messages.MessageField('GoogleCloudDataplexV1DataScanEventDataQualityAppliedConfigs', 6)
  dataSource = _messages.StringField(7)
  endTime = _messages.StringField(8)
  jobId = _messages.StringField(9)
  message = _messages.StringField(10)
  postScanActionsResult = _messages.MessageField('GoogleCloudDataplexV1DataScanEventPostScanActionsResult', 11)
  scope = _messages.EnumField('ScopeValueValuesEnum', 12)
  specVersion = _messages.StringField(13)
  startTime = _messages.StringField(14)
  state = _messages.EnumField('StateValueValuesEnum', 15)
  trigger = _messages.EnumField('TriggerValueValuesEnum', 16)
  type = _messages.EnumField('TypeValueValuesEnum', 17)


class GoogleCloudDataplexV1DataScanEventDataProfileAppliedConfigs(_messages.Message):
  r"""Applied configs for data profile type data scan job.

  Fields:
    columnFilterApplied: Boolean indicating whether a column filter was
      applied in the DataScan job.
    rowFilterApplied: Boolean indicating whether a row filter was applied in
      the DataScan job.
    samplingPercent: The percentage of the records selected from the dataset
      for DataScan. Value ranges between 0.0 and 100.0. Value 0.0 or 100.0
      imply that sampling was not applied.
  """

  columnFilterApplied = _messages.BooleanField(1)
  rowFilterApplied = _messages.BooleanField(2)
  samplingPercent = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class GoogleCloudDataplexV1DataScanEventDataProfileResult(_messages.Message):
  r"""Data profile result for data scan job.

  Fields:
    rowCount: The count of rows processed in the data scan job.
  """

  rowCount = _messages.IntegerField(1)


class GoogleCloudDataplexV1DataScanEventDataQualityAppliedConfigs(_messages.Message):
  r"""Applied configs for data quality type data scan job.

  Fields:
    rowFilterApplied: Boolean indicating whether a row filter was applied in
      the DataScan job.
    samplingPercent: The percentage of the records selected from the dataset
      for DataScan. Value ranges between 0.0 and 100.0. Value 0.0 or 100.0
      imply that sampling was not applied.
  """

  rowFilterApplied = _messages.BooleanField(1)
  samplingPercent = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudDataplexV1DataScanEventDataQualityResult(_messages.Message):
  r"""Data quality result for data scan job.

  Messages:
    ColumnScoreValue: The score of each column scanned in the data scan job.
      The key of the map is the name of the column. The value is the data
      quality score for the column.The score ranges between 0, 100 (up to two
      decimal points).
    DimensionPassedValue: The result of each dimension for data quality
      result. The key of the map is the name of the dimension. The value is
      the bool value depicting whether the dimension result was pass or not.
    DimensionScoreValue: The score of each dimension for data quality result.
      The key of the map is the name of the dimension. The value is the data
      quality score for the dimension.The score ranges between 0, 100 (up to
      two decimal points).

  Fields:
    columnScore: The score of each column scanned in the data scan job. The
      key of the map is the name of the column. The value is the data quality
      score for the column.The score ranges between 0, 100 (up to two decimal
      points).
    dimensionPassed: The result of each dimension for data quality result. The
      key of the map is the name of the dimension. The value is the bool value
      depicting whether the dimension result was pass or not.
    dimensionScore: The score of each dimension for data quality result. The
      key of the map is the name of the dimension. The value is the data
      quality score for the dimension.The score ranges between 0, 100 (up to
      two decimal points).
    passed: Whether the data quality result was pass or not.
    rowCount: The count of rows processed in the data scan job.
    score: The table-level data quality score for the data scan job.The data
      quality score ranges between 0, 100 (up to two decimal points).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ColumnScoreValue(_messages.Message):
    r"""The score of each column scanned in the data scan job. The key of the
    map is the name of the column. The value is the data quality score for the
    column.The score ranges between 0, 100 (up to two decimal points).

    Messages:
      AdditionalProperty: An additional property for a ColumnScoreValue
        object.

    Fields:
      additionalProperties: Additional properties of type ColumnScoreValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ColumnScoreValue object.

      Fields:
        key: Name of the additional property.
        value: A number attribute.
      """

      key = _messages.StringField(1)
      value = _messages.FloatField(2, variant=_messages.Variant.FLOAT)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DimensionPassedValue(_messages.Message):
    r"""The result of each dimension for data quality result. The key of the
    map is the name of the dimension. The value is the bool value depicting
    whether the dimension result was pass or not.

    Messages:
      AdditionalProperty: An additional property for a DimensionPassedValue
        object.

    Fields:
      additionalProperties: Additional properties of type DimensionPassedValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DimensionPassedValue object.

      Fields:
        key: Name of the additional property.
        value: A boolean attribute.
      """

      key = _messages.StringField(1)
      value = _messages.BooleanField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DimensionScoreValue(_messages.Message):
    r"""The score of each dimension for data quality result. The key of the
    map is the name of the dimension. The value is the data quality score for
    the dimension.The score ranges between 0, 100 (up to two decimal points).

    Messages:
      AdditionalProperty: An additional property for a DimensionScoreValue
        object.

    Fields:
      additionalProperties: Additional properties of type DimensionScoreValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DimensionScoreValue object.

      Fields:
        key: Name of the additional property.
        value: A number attribute.
      """

      key = _messages.StringField(1)
      value = _messages.FloatField(2, variant=_messages.Variant.FLOAT)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  columnScore = _messages.MessageField('ColumnScoreValue', 1)
  dimensionPassed = _messages.MessageField('DimensionPassedValue', 2)
  dimensionScore = _messages.MessageField('DimensionScoreValue', 3)
  passed = _messages.BooleanField(4)
  rowCount = _messages.IntegerField(5)
  score = _messages.FloatField(6, variant=_messages.Variant.FLOAT)


class GoogleCloudDataplexV1DataScanEventPostScanActionsResult(_messages.Message):
  r"""Post scan actions result for data scan job.

  Fields:
    bigqueryExportResult: The result of BigQuery export post scan action.
  """

  bigqueryExportResult = _messages.MessageField('GoogleCloudDataplexV1DataScanEventPostScanActionsResultBigQueryExportResult', 1)


class GoogleCloudDataplexV1DataScanEventPostScanActionsResultBigQueryExportResult(_messages.Message):
  r"""The result of BigQuery export post scan action.

  Enums:
    StateValueValuesEnum: Execution state for the BigQuery exporting.

  Fields:
    message: Additional information about the BigQuery exporting.
    state: Execution state for the BigQuery exporting.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Execution state for the BigQuery exporting.

    Values:
      STATE_UNSPECIFIED: The exporting state is unspecified.
      SUCCEEDED: The exporting completed successfully.
      FAILED: The exporting is no longer running due to an error.
      SKIPPED: The exporting is skipped due to no valid scan result to export
        (usually caused by scan failed).
    """
    STATE_UNSPECIFIED = 0
    SUCCEEDED = 1
    FAILED = 2
    SKIPPED = 3

  message = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudDataplexV1DataScanExecutionSpec(_messages.Message):
  r"""DataScan execution settings.

  Fields:
    field: Immutable. The unnested field (of type Date or Timestamp) that
      contains values which monotonically increase over time.If not specified,
      a data scan will run for all data in the table.
    trigger: Optional. Spec related to how often and when a scan should be
      triggered.If not specified, the default is OnDemand, which means the
      scan will not run until the user calls RunDataScan API.
  """

  field = _messages.StringField(1)
  trigger = _messages.MessageField('GoogleCloudDataplexV1Trigger', 2)


class GoogleCloudDataplexV1DataScanExecutionStatus(_messages.Message):
  r"""Status of the data scan execution.

  Fields:
    latestJobCreateTime: Optional. The time when the DataScanJob execution was
      created.
    latestJobEndTime: Optional. The time when the latest DataScanJob ended.
    latestJobStartTime: Optional. The time when the latest DataScanJob
      started.
  """

  latestJobCreateTime = _messages.StringField(1)
  latestJobEndTime = _messages.StringField(2)
  latestJobStartTime = _messages.StringField(3)


class GoogleCloudDataplexV1DataScanJob(_messages.Message):
  r"""A DataScanJob represents an instance of DataScan execution.

  Enums:
    StateValueValuesEnum: Output only. Execution state for the DataScanJob.
    TypeValueValuesEnum: Output only. The type of the parent DataScan.

  Fields:
    createTime: Output only. The time when the DataScanJob was created.
    dataDiscoveryResult: Output only. The result of a data discovery scan.
    dataDiscoverySpec: Output only. Settings for a data discovery scan.
    dataDocumentationResult: Output only. The result of a data documentation
      scan.
    dataDocumentationSpec: Output only. Settings for a data documentation
      scan.
    dataProfileResult: Output only. The result of a data profile scan.
    dataProfileSpec: Output only. Settings for a data profile scan.
    dataQualityResult: Output only. The result of a data quality scan.
    dataQualitySpec: Output only. Settings for a data quality scan.
    endTime: Output only. The time when the DataScanJob ended.
    message: Output only. Additional information about the current state.
    name: Output only. Identifier. The relative resource name of the
      DataScanJob, of the form: projects/{project}/locations/{location_id}/dat
      aScans/{datascan_id}/jobs/{job_id}, where project refers to a project_id
      or project_number and location_id refers to a Google Cloud region.
    startTime: Output only. The time when the DataScanJob was started.
    state: Output only. Execution state for the DataScanJob.
    type: Output only. The type of the parent DataScan.
    uid: Output only. System generated globally unique ID for the DataScanJob.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Execution state for the DataScanJob.

    Values:
      STATE_UNSPECIFIED: The DataScanJob state is unspecified.
      RUNNING: The DataScanJob is running.
      CANCELING: The DataScanJob is canceling.
      CANCELLED: The DataScanJob cancellation was successful.
      SUCCEEDED: The DataScanJob completed successfully.
      FAILED: The DataScanJob is no longer running due to an error.
      PENDING: The DataScanJob has been created but not started to run yet.
    """
    STATE_UNSPECIFIED = 0
    RUNNING = 1
    CANCELING = 2
    CANCELLED = 3
    SUCCEEDED = 4
    FAILED = 5
    PENDING = 6

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of the parent DataScan.

    Values:
      DATA_SCAN_TYPE_UNSPECIFIED: The data scan type is unspecified.
      DATA_QUALITY: Data quality scan.
      DATA_PROFILE: Data profile scan.
      DATA_DISCOVERY: Data discovery scan.
      DATA_DOCUMENTATION: Data documentation scan.
    """
    DATA_SCAN_TYPE_UNSPECIFIED = 0
    DATA_QUALITY = 1
    DATA_PROFILE = 2
    DATA_DISCOVERY = 3
    DATA_DOCUMENTATION = 4

  createTime = _messages.StringField(1)
  dataDiscoveryResult = _messages.MessageField('GoogleCloudDataplexV1DataDiscoveryResult', 2)
  dataDiscoverySpec = _messages.MessageField('GoogleCloudDataplexV1DataDiscoverySpec', 3)
  dataDocumentationResult = _messages.MessageField('GoogleCloudDataplexV1DataDocumentationResult', 4)
  dataDocumentationSpec = _messages.MessageField('GoogleCloudDataplexV1DataDocumentationSpec', 5)
  dataProfileResult = _messages.MessageField('GoogleCloudDataplexV1DataProfileResult', 6)
  dataProfileSpec = _messages.MessageField('GoogleCloudDataplexV1DataProfileSpec', 7)
  dataQualityResult = _messages.MessageField('GoogleCloudDataplexV1DataQualityResult', 8)
  dataQualitySpec = _messages.MessageField('GoogleCloudDataplexV1DataQualitySpec', 9)
  endTime = _messages.StringField(10)
  message = _messages.StringField(11)
  name = _messages.StringField(12)
  startTime = _messages.StringField(13)
  state = _messages.EnumField('StateValueValuesEnum', 14)
  type = _messages.EnumField('TypeValueValuesEnum', 15)
  uid = _messages.StringField(16)


class GoogleCloudDataplexV1DataSource(_messages.Message):
  r"""The data source for DataScan.

  Fields:
    entity: Immutable. The Dataplex Universal Catalog entity that represents
      the data source (e.g. BigQuery table) for DataScan, of the form: project
      s/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_i
      d}/entities/{entity_id}.
    resource: Immutable. The service-qualified full resource name of the cloud
      resource for a DataScan job to scan against. The field could either be:
      Cloud Storage bucket for DataDiscoveryScan Format:
      //storage.googleapis.com/projects/PROJECT_ID/buckets/BUCKET_ID or
      BigQuery table of type "TABLE" for
      DataProfileScan/DataQualityScan/DataDocumentationScan Format: //bigquery
      .googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
  """

  entity = _messages.StringField(1)
  resource = _messages.StringField(2)


class GoogleCloudDataplexV1DataTaxonomy(_messages.Message):
  r"""DataTaxonomy represents a set of hierarchical DataAttributes resources,
  grouped with a common theme Eg: 'SensitiveDataTaxonomy' can have attributes
  to manage PII data. It is defined at project level.

  Messages:
    LabelsValue: Optional. User-defined labels for the DataTaxonomy.

  Fields:
    attributeCount: Output only. The number of attributes in the DataTaxonomy.
    classCount: Output only. The number of classes in the DataTaxonomy.
    createTime: Output only. The time when the DataTaxonomy was created.
    description: Optional. Description of the DataTaxonomy.
    displayName: Optional. User friendly display name.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding.
    labels: Optional. User-defined labels for the DataTaxonomy.
    name: Output only. The relative resource name of the DataTaxonomy, of the
      form: projects/{project_number}/locations/{location_id}/dataTaxonomies/{
      data_taxonomy_id}.
    uid: Output only. System generated globally unique ID for the
      dataTaxonomy. This ID will be different if the DataTaxonomy is deleted
      and re-created with the same name.
    updateTime: Output only. The time when the DataTaxonomy was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the DataTaxonomy.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributeCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  classCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  displayName = _messages.StringField(5)
  etag = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  uid = _messages.StringField(9)
  updateTime = _messages.StringField(10)


class GoogleCloudDataplexV1DiscoveryEvent(_messages.Message):
  r"""The payload associated with Discovery data processing.

  Enums:
    TypeValueValuesEnum: The type of the event being logged.

  Fields:
    action: Details about the action associated with the event.
    assetId: The id of the associated asset.
    config: Details about discovery configuration in effect.
    dataLocation: The data location associated with the event.
    datascanId: The id of the associated datascan for standalone discovery.
    entity: Details about the entity associated with the event.
    lakeId: The id of the associated lake.
    message: The log message.
    partition: Details about the partition associated with the event.
    table: Details about the BigQuery table publishing associated with the
      event.
    type: The type of the event being logged.
    zoneId: The id of the associated zone.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the event being logged.

    Values:
      EVENT_TYPE_UNSPECIFIED: An unspecified event type.
      CONFIG: An event representing discovery configuration in effect.
      ENTITY_CREATED: An event representing a metadata entity being created.
      ENTITY_UPDATED: An event representing a metadata entity being updated.
      ENTITY_DELETED: An event representing a metadata entity being deleted.
      PARTITION_CREATED: An event representing a partition being created.
      PARTITION_UPDATED: An event representing a partition being updated.
      PARTITION_DELETED: An event representing a partition being deleted.
      TABLE_PUBLISHED: An event representing a table being published.
      TABLE_UPDATED: An event representing a table being updated.
      TABLE_IGNORED: An event representing a table being skipped in
        publishing.
      TABLE_DELETED: An event representing a table being deleted.
    """
    EVENT_TYPE_UNSPECIFIED = 0
    CONFIG = 1
    ENTITY_CREATED = 2
    ENTITY_UPDATED = 3
    ENTITY_DELETED = 4
    PARTITION_CREATED = 5
    PARTITION_UPDATED = 6
    PARTITION_DELETED = 7
    TABLE_PUBLISHED = 8
    TABLE_UPDATED = 9
    TABLE_IGNORED = 10
    TABLE_DELETED = 11

  action = _messages.MessageField('GoogleCloudDataplexV1DiscoveryEventActionDetails', 1)
  assetId = _messages.StringField(2)
  config = _messages.MessageField('GoogleCloudDataplexV1DiscoveryEventConfigDetails', 3)
  dataLocation = _messages.StringField(4)
  datascanId = _messages.StringField(5)
  entity = _messages.MessageField('GoogleCloudDataplexV1DiscoveryEventEntityDetails', 6)
  lakeId = _messages.StringField(7)
  message = _messages.StringField(8)
  partition = _messages.MessageField('GoogleCloudDataplexV1DiscoveryEventPartitionDetails', 9)
  table = _messages.MessageField('GoogleCloudDataplexV1DiscoveryEventTableDetails', 10)
  type = _messages.EnumField('TypeValueValuesEnum', 11)
  zoneId = _messages.StringField(12)


class GoogleCloudDataplexV1DiscoveryEventActionDetails(_messages.Message):
  r"""Details about the action.

  Fields:
    issue: The human readable issue associated with the action.
    type: The type of action. Eg. IncompatibleDataSchema, InvalidDataFormat
  """

  issue = _messages.StringField(1)
  type = _messages.StringField(2)


class GoogleCloudDataplexV1DiscoveryEventConfigDetails(_messages.Message):
  r"""Details about configuration events.

  Messages:
    ParametersValue: A list of discovery configuration parameters in effect.
      The keys are the field paths within DiscoverySpec. Eg. includePatterns,
      excludePatterns, csvOptions.disableTypeInference, etc.

  Fields:
    parameters: A list of discovery configuration parameters in effect. The
      keys are the field paths within DiscoverySpec. Eg. includePatterns,
      excludePatterns, csvOptions.disableTypeInference, etc.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""A list of discovery configuration parameters in effect. The keys are
    the field paths within DiscoverySpec. Eg. includePatterns,
    excludePatterns, csvOptions.disableTypeInference, etc.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  parameters = _messages.MessageField('ParametersValue', 1)


class GoogleCloudDataplexV1DiscoveryEventEntityDetails(_messages.Message):
  r"""Details about the entity.

  Enums:
    TypeValueValuesEnum: The type of the entity resource.

  Fields:
    entity: The name of the entity resource. The name is the fully-qualified
      resource name.
    type: The type of the entity resource.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the entity resource.

    Values:
      ENTITY_TYPE_UNSPECIFIED: An unspecified event type.
      TABLE: Entities representing structured data.
      FILESET: Entities representing unstructured data.
    """
    ENTITY_TYPE_UNSPECIFIED = 0
    TABLE = 1
    FILESET = 2

  entity = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class GoogleCloudDataplexV1DiscoveryEventPartitionDetails(_messages.Message):
  r"""Details about the partition.

  Enums:
    TypeValueValuesEnum: The type of the containing entity resource.

  Fields:
    entity: The name to the containing entity resource. The name is the fully-
      qualified resource name.
    partition: The name to the partition resource. The name is the fully-
      qualified resource name.
    sampledDataLocations: The locations of the data items (e.g., a Cloud
      Storage objects) sampled for metadata inference.
    type: The type of the containing entity resource.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the containing entity resource.

    Values:
      ENTITY_TYPE_UNSPECIFIED: An unspecified event type.
      TABLE: Entities representing structured data.
      FILESET: Entities representing unstructured data.
    """
    ENTITY_TYPE_UNSPECIFIED = 0
    TABLE = 1
    FILESET = 2

  entity = _messages.StringField(1)
  partition = _messages.StringField(2)
  sampledDataLocations = _messages.StringField(3, repeated=True)
  type = _messages.EnumField('TypeValueValuesEnum', 4)


class GoogleCloudDataplexV1DiscoveryEventTableDetails(_messages.Message):
  r"""Details about the published table.

  Enums:
    TypeValueValuesEnum: The type of the table resource.

  Fields:
    table: The fully-qualified resource name of the table resource.
    type: The type of the table resource.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the table resource.

    Values:
      TABLE_TYPE_UNSPECIFIED: An unspecified table type.
      EXTERNAL_TABLE: External table type.
      BIGLAKE_TABLE: BigLake table type.
      OBJECT_TABLE: Object table type for unstructured data.
    """
    TABLE_TYPE_UNSPECIFIED = 0
    EXTERNAL_TABLE = 1
    BIGLAKE_TABLE = 2
    OBJECT_TABLE = 3

  table = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class GoogleCloudDataplexV1EncryptionConfig(_messages.Message):
  r"""A Resource designed to manage encryption configurations for customers to
  support Customer Managed Encryption Keys (CMEK).

  Enums:
    EncryptionStateValueValuesEnum: Output only. The state of encryption of
      the databases.

  Fields:
    createTime: Output only. The time when the Encryption configuration was
      created.
    enableMetastoreEncryption: Optional. Represent the state of CMEK opt-in
      for metastore.
    encryptionState: Output only. The state of encryption of the databases.
    etag: Etag of the EncryptionConfig. This is a strong etag.
    failureDetails: Output only. Details of the failure if anything related to
      Cmek db fails.
    key: Optional. If a key is chosen, it means that the customer is using
      CMEK. If a key is not chosen, it means that the customer is using Google
      managed encryption.
    name: Identifier. The resource name of the EncryptionConfig. Format: organ
      izations/{organization}/locations/{location}/encryptionConfigs/{encrypti
      on_config} Global location is not supported.
    updateTime: Output only. The time when the Encryption configuration was
      last updated.
  """

  class EncryptionStateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of encryption of the databases.

    Values:
      ENCRYPTION_STATE_UNSPECIFIED: State is not specified.
      ENCRYPTING: The encryption state of the database when the
        EncryptionConfig is created or updated. If the encryption fails, it is
        retried indefinitely and the state is shown as ENCRYPTING.
      COMPLETED: The encryption of data has completed successfully.
      FAILED: The encryption of data has failed. The state is set to FAILED
        when the encryption fails due to reasons like permission issues,
        invalid key etc.
    """
    ENCRYPTION_STATE_UNSPECIFIED = 0
    ENCRYPTING = 1
    COMPLETED = 2
    FAILED = 3

  createTime = _messages.StringField(1)
  enableMetastoreEncryption = _messages.BooleanField(2)
  encryptionState = _messages.EnumField('EncryptionStateValueValuesEnum', 3)
  etag = _messages.StringField(4)
  failureDetails = _messages.MessageField('GoogleCloudDataplexV1EncryptionConfigFailureDetails', 5)
  key = _messages.StringField(6)
  name = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudDataplexV1EncryptionConfigFailureDetails(_messages.Message):
  r"""Details of the failure if anything related to Cmek db fails.

  Enums:
    ErrorCodeValueValuesEnum: Output only. The error code for the failure.

  Fields:
    errorCode: Output only. The error code for the failure.
    errorMessage: Output only. The error message will be shown to the user.
      Set only if the error code is REQUIRE_USER_ACTION.
  """

  class ErrorCodeValueValuesEnum(_messages.Enum):
    r"""Output only. The error code for the failure.

    Values:
      UNKNOWN: The error code is not specified
      INTERNAL_ERROR: Error because of internal server error, will be retried
        automatically.
      REQUIRE_USER_ACTION: User action is required to resolve the error.
    """
    UNKNOWN = 0
    INTERNAL_ERROR = 1
    REQUIRE_USER_ACTION = 2

  errorCode = _messages.EnumField('ErrorCodeValueValuesEnum', 1)
  errorMessage = _messages.StringField(2)


class GoogleCloudDataplexV1Entity(_messages.Message):
  r"""Represents tables and fileset metadata contained within a zone.

  Enums:
    SystemValueValuesEnum: Required. Immutable. Identifies the storage system
      of the entity data.
    TypeValueValuesEnum: Required. Immutable. The type of entity.

  Fields:
    access: Output only. Identifies the access mechanism to the entity. Not
      user settable.
    asset: Required. Immutable. The ID of the asset associated with the
      storage location containing the entity data. The entity must be with in
      the same zone with the asset.
    catalogEntry: Output only. The name of the associated Data Catalog entry.
    compatibility: Output only. Metadata stores that the entity is compatible
      with.
    createTime: Output only. The time when the entity was created.
    dataPath: Required. Immutable. The storage path of the entity data. For
      Cloud Storage data, this is the fully-qualified path to the entity, such
      as gs://bucket/path/to/data. For BigQuery data, this is the name of the
      table resource, such as
      projects/project_id/datasets/dataset_id/tables/table_id.
    dataPathPattern: Optional. The set of items within the data path
      constituting the data in the entity, represented as a glob path.
      Example: gs://bucket/path/to/data/**/*.csv.
    description: Optional. User friendly longer description text. Must be
      shorter than or equal to 1024 characters.
    displayName: Optional. Display name must be shorter than or equal to 256
      characters.
    etag: Optional. The etag associated with the entity, which can be
      retrieved with a GetEntity request. Required for update and delete
      requests.
    format: Required. Identifies the storage format of the entity data. It
      does not apply to entities with data stored in BigQuery.
    id: Required. A user-provided entity ID. It is mutable, and will be used
      as the published table name. Specifying a new ID in an update entity
      request will override the existing value. The ID must contain only
      letters (a-z, A-Z), numbers (0-9), and underscores, and consist of 256
      or fewer characters.
    name: Output only. The resource name of the entity, of the form: projects/
      {project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}
      /entities/{id}.
    schema: Required. The description of the data structure and layout. The
      schema is not included in list responses. It is only included in SCHEMA
      and FULL entity views of a GetEntity response.
    system: Required. Immutable. Identifies the storage system of the entity
      data.
    type: Required. Immutable. The type of entity.
    uid: Output only. System generated unique ID for the Entity. This ID will
      be different if the Entity is deleted and re-created with the same name.
    updateTime: Output only. The time when the entity was last updated.
  """

  class SystemValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. Identifies the storage system of the entity data.

    Values:
      STORAGE_SYSTEM_UNSPECIFIED: Storage system unspecified.
      CLOUD_STORAGE: The entity data is contained within a Cloud Storage
        bucket.
      BIGQUERY: The entity data is contained within a BigQuery dataset.
    """
    STORAGE_SYSTEM_UNSPECIFIED = 0
    CLOUD_STORAGE = 1
    BIGQUERY = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The type of entity.

    Values:
      TYPE_UNSPECIFIED: Type unspecified.
      TABLE: Structured and semi-structured data.
      FILESET: Unstructured data.
    """
    TYPE_UNSPECIFIED = 0
    TABLE = 1
    FILESET = 2

  access = _messages.MessageField('GoogleCloudDataplexV1StorageAccess', 1)
  asset = _messages.StringField(2)
  catalogEntry = _messages.StringField(3)
  compatibility = _messages.MessageField('GoogleCloudDataplexV1EntityCompatibilityStatus', 4)
  createTime = _messages.StringField(5)
  dataPath = _messages.StringField(6)
  dataPathPattern = _messages.StringField(7)
  description = _messages.StringField(8)
  displayName = _messages.StringField(9)
  etag = _messages.StringField(10)
  format = _messages.MessageField('GoogleCloudDataplexV1StorageFormat', 11)
  id = _messages.StringField(12)
  name = _messages.StringField(13)
  schema = _messages.MessageField('GoogleCloudDataplexV1Schema', 14)
  system = _messages.EnumField('SystemValueValuesEnum', 15)
  type = _messages.EnumField('TypeValueValuesEnum', 16)
  uid = _messages.StringField(17)
  updateTime = _messages.StringField(18)


class GoogleCloudDataplexV1EntityCompatibilityStatus(_messages.Message):
  r"""Provides compatibility information for various metadata stores.

  Fields:
    bigquery: Output only. Whether this entity is compatible with BigQuery.
    hiveMetastore: Output only. Whether this entity is compatible with Hive
      Metastore.
  """

  bigquery = _messages.MessageField('GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility', 1)
  hiveMetastore = _messages.MessageField('GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility', 2)


class GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility(_messages.Message):
  r"""Provides compatibility information for a specific metadata store.

  Fields:
    compatible: Output only. Whether the entity is compatible and can be
      represented in the metadata store.
    reason: Output only. Provides additional detail if the entity is
      incompatible with the metadata store.
  """

  compatible = _messages.BooleanField(1)
  reason = _messages.StringField(2)


class GoogleCloudDataplexV1Entry(_messages.Message):
  r"""An entry is a representation of a data resource that can be described by
  various metadata.

  Messages:
    AspectsValue: Optional. The aspects that are attached to the entry.
      Depending on how the aspect is attached to the entry, the format of the
      aspect key can be one of the following: If the aspect is attached
      directly to the entry:
      {project_id_or_number}.{location_id}.{aspect_type_id} If the aspect is
      attached to an entry's path:
      {project_id_or_number}.{location_id}.{aspect_type_id}@{path}

  Fields:
    aspects: Optional. The aspects that are attached to the entry. Depending
      on how the aspect is attached to the entry, the format of the aspect key
      can be one of the following: If the aspect is attached directly to the
      entry: {project_id_or_number}.{location_id}.{aspect_type_id} If the
      aspect is attached to an entry's path:
      {project_id_or_number}.{location_id}.{aspect_type_id}@{path}
    createTime: Output only. The time when the entry was created in Dataplex
      Universal Catalog.
    entrySource: Optional. Information related to the source system of the
      data resource that is represented by the entry.
    entryType: Required. Immutable. The relative resource name of the entry
      type that was used to create this entry, in the format projects/{project
      _id_or_number}/locations/{location_id}/entryTypes/{entry_type_id}.
    fullyQualifiedName: Optional. A name for the entry that can be referenced
      by an external system. For more information, see Fully qualified names
      (https://cloud.google.com/data-catalog/docs/fully-qualified-names). The
      maximum size of the field is 4000 characters.
    name: Identifier. The relative resource name of the entry, in the format p
      rojects/{project_id_or_number}/locations/{location_id}/entryGroups/{entr
      y_group_id}/entries/{entry_id}.
    parentEntry: Optional. Immutable. The resource name of the parent entry,
      in the format projects/{project_id_or_number}/locations/{location_id}/en
      tryGroups/{entry_group_id}/entries/{entry_id}.
    updateTime: Output only. The time when the entry was last updated in
      Dataplex Universal Catalog.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AspectsValue(_messages.Message):
    r"""Optional. The aspects that are attached to the entry. Depending on how
    the aspect is attached to the entry, the format of the aspect key can be
    one of the following: If the aspect is attached directly to the entry:
    {project_id_or_number}.{location_id}.{aspect_type_id} If the aspect is
    attached to an entry's path:
    {project_id_or_number}.{location_id}.{aspect_type_id}@{path}

    Messages:
      AdditionalProperty: An additional property for a AspectsValue object.

    Fields:
      additionalProperties: Additional properties of type AspectsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AspectsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudDataplexV1Aspect attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudDataplexV1Aspect', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  aspects = _messages.MessageField('AspectsValue', 1)
  createTime = _messages.StringField(2)
  entrySource = _messages.MessageField('GoogleCloudDataplexV1EntrySource', 3)
  entryType = _messages.StringField(4)
  fullyQualifiedName = _messages.StringField(5)
  name = _messages.StringField(6)
  parentEntry = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudDataplexV1EntryGroup(_messages.Message):
  r"""An Entry Group represents a logical grouping of one or more Entries.

  Enums:
    TransferStatusValueValuesEnum: Output only. Denotes the transfer status of
      the Entry Group. It is unspecified for Entry Group created from Dataplex
      API.

  Messages:
    LabelsValue: Optional. User-defined labels for the EntryGroup.

  Fields:
    createTime: Output only. The time when the EntryGroup was created.
    description: Optional. Description of the EntryGroup.
    displayName: Optional. User friendly display name.
    etag: This checksum is computed by the service, and might be sent on
      update and delete requests to ensure the client has an up-to-date value
      before proceeding.
    labels: Optional. User-defined labels for the EntryGroup.
    name: Output only. The relative resource name of the EntryGroup, in the
      format projects/{project_id_or_number}/locations/{location_id}/entryGrou
      ps/{entry_group_id}.
    transferStatus: Output only. Denotes the transfer status of the Entry
      Group. It is unspecified for Entry Group created from Dataplex API.
    uid: Output only. System generated globally unique ID for the EntryGroup.
      If you delete and recreate the EntryGroup with the same name, this ID
      will be different.
    updateTime: Output only. The time when the EntryGroup was last updated.
  """

  class TransferStatusValueValuesEnum(_messages.Enum):
    r"""Output only. Denotes the transfer status of the Entry Group. It is
    unspecified for Entry Group created from Dataplex API.

    Values:
      TRANSFER_STATUS_UNSPECIFIED: The default value. It is set for resources
        that were not subject for migration from Data Catalog service.
      TRANSFER_STATUS_MIGRATED: Indicates that a resource was migrated from
        Data Catalog service but it hasn't been transferred yet. In particular
        the resource cannot be updated from Dataplex API.
      TRANSFER_STATUS_TRANSFERRED: Indicates that a resource was transferred
        from Data Catalog service. The resource can only be updated from
        Dataplex API.
    """
    TRANSFER_STATUS_UNSPECIFIED = 0
    TRANSFER_STATUS_MIGRATED = 1
    TRANSFER_STATUS_TRANSFERRED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the EntryGroup.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  transferStatus = _messages.EnumField('TransferStatusValueValuesEnum', 7)
  uid = _messages.StringField(8)
  updateTime = _messages.StringField(9)


class GoogleCloudDataplexV1EntryLink(_messages.Message):
  r"""EntryLink represents a link between two Entries.

  Fields:
    createTime: Output only. The time when the Entry Link was created.
    entryLinkType: Required. Immutable. Relative resource name of the Entry
      Link Type used to create this Entry Link. For example: Entry link
      between synonym terms in a glossary: projects/dataplex-
      types/locations/global/entryLinkTypes/synonym Entry link between related
      terms in a glossary: projects/dataplex-
      types/locations/global/entryLinkTypes/related Entry link between
      glossary terms and data assets: projects/dataplex-
      types/locations/global/entryLinkTypes/definition
    entryReferences: Required. Specifies the Entries referenced in the Entry
      Link. There should be exactly two entry references.
    name: Output only. Immutable. Identifier. The relative resource name of
      the Entry Link, of the form: projects/{project_id_or_number}/locations/{
      location_id}/entryGroups/{entry_group_id}/entryLinks/{entry_link_id}
    updateTime: Output only. The time when the Entry Link was last updated.
  """

  createTime = _messages.StringField(1)
  entryLinkType = _messages.StringField(2)
  entryReferences = _messages.MessageField('GoogleCloudDataplexV1EntryLinkEntryReference', 3, repeated=True)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class GoogleCloudDataplexV1EntryLinkEntryReference(_messages.Message):
  r"""Reference to the Entry that is linked through the Entry Link.

  Enums:
    TypeValueValuesEnum: Required. Immutable. The reference type of the Entry.

  Fields:
    name: Required. Immutable. The relative resource name of the referenced
      Entry, of the form: projects/{project_id_or_number}/locations/{location_
      id}/entryGroups/{entry_group_id}/entries/{entry_id}
    path: Immutable. The path in the Entry that is referenced in the Entry
      Link. Empty path denotes that the Entry itself is referenced in the
      Entry Link.
    type: Required. Immutable. The reference type of the Entry.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The reference type of the Entry.

    Values:
      UNSPECIFIED: Unspecified reference type. Implies that the Entry is
        referenced in a non-directional Entry Link.
      SOURCE: The Entry is referenced as the source of the directional Entry
        Link.
      TARGET: The Entry is referenced as the target of the directional Entry
        Link.
    """
    UNSPECIFIED = 0
    SOURCE = 1
    TARGET = 2

  name = _messages.StringField(1)
  path = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class GoogleCloudDataplexV1EntryLinkEvent(_messages.Message):
  r"""Payload associated with Entry related log events.

  Enums:
    EventTypeValueValuesEnum: The type of the event.

  Fields:
    eventType: The type of the event.
    message: The log message.
    resource: Name of the resource.
  """

  class EventTypeValueValuesEnum(_messages.Enum):
    r"""The type of the event.

    Values:
      EVENT_TYPE_UNSPECIFIED: An unspecified event type.
      ENTRY_LINK_CREATE: EntryLink create event.
      ENTRY_LINK_DELETE: EntryLink delete event.
    """
    EVENT_TYPE_UNSPECIFIED = 0
    ENTRY_LINK_CREATE = 1
    ENTRY_LINK_DELETE = 2

  eventType = _messages.EnumField('EventTypeValueValuesEnum', 1)
  message = _messages.StringField(2)
  resource = _messages.StringField(3)


class GoogleCloudDataplexV1EntrySource(_messages.Message):
  r"""Information related to the source system of the data resource that is
  represented by the entry.

  Messages:
    LabelsValue: User-defined labels. The maximum size of keys and values is
      128 characters each.

  Fields:
    ancestors: Immutable. The entries representing the ancestors of the data
      resource in the source system.
    createTime: The time when the resource was created in the source system.
    description: A description of the data resource. Maximum length is 2,000
      characters.
    displayName: A user-friendly display name. Maximum length is 500
      characters.
    labels: User-defined labels. The maximum size of keys and values is 128
      characters each.
    location: Output only. Location of the resource in the source system. You
      can search the entry by this location. By default, this should match the
      location of the entry group containing this entry. A different value
      allows capturing the source location for data external to Google Cloud.
    platform: The platform containing the source system. Maximum length is 64
      characters.
    resource: The name of the resource in the source system. Maximum length is
      4,000 characters.
    system: The name of the source system. Maximum length is 64 characters.
    updateTime: The time when the resource was last updated in the source
      system. If the entry exists in the system and its EntrySource has
      update_time populated, further updates to the EntrySource of the entry
      must provide incremental updates to its update_time.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""User-defined labels. The maximum size of keys and values is 128
    characters each.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  ancestors = _messages.MessageField('GoogleCloudDataplexV1EntrySourceAncestor', 1, repeated=True)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  location = _messages.StringField(6)
  platform = _messages.StringField(7)
  resource = _messages.StringField(8)
  system = _messages.StringField(9)
  updateTime = _messages.StringField(10)


class GoogleCloudDataplexV1EntrySourceAncestor(_messages.Message):
  r"""Information about individual items in the hierarchy that is associated
  with the data resource.

  Fields:
    name: Optional. The name of the ancestor resource.
    type: Optional. The type of the ancestor resource.
  """

  name = _messages.StringField(1)
  type = _messages.StringField(2)


class GoogleCloudDataplexV1EntryType(_messages.Message):
  r"""Entry Type is a template for creating Entries.

  Messages:
    LabelsValue: Optional. User-defined labels for the EntryType.

  Fields:
    authorization: Immutable. Authorization defined for this type.
    createTime: Output only. The time when the EntryType was created.
    description: Optional. Description of the EntryType.
    displayName: Optional. User friendly display name.
    etag: Optional. This checksum is computed by the service, and might be
      sent on update and delete requests to ensure the client has an up-to-
      date value before proceeding.
    labels: Optional. User-defined labels for the EntryType.
    name: Output only. The relative resource name of the EntryType, of the
      form: projects/{project_number}/locations/{location_id}/entryTypes/{entr
      y_type_id}.
    platform: Optional. The platform that Entries of this type belongs to.
    requiredAspects: AspectInfo for the entry type.
    system: Optional. The system that Entries of this type belongs to.
      Examples include CloudSQL, MariaDB etc
    typeAliases: Optional. Indicates the classes this Entry Type belongs to,
      for example, TABLE, DATABASE, MODEL.
    uid: Output only. System generated globally unique ID for the EntryType.
      This ID will be different if the EntryType is deleted and re-created
      with the same name.
    updateTime: Output only. The time when the EntryType was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the EntryType.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  authorization = _messages.MessageField('GoogleCloudDataplexV1EntryTypeAuthorization', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  etag = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  platform = _messages.StringField(8)
  requiredAspects = _messages.MessageField('GoogleCloudDataplexV1EntryTypeAspectInfo', 9, repeated=True)
  system = _messages.StringField(10)
  typeAliases = _messages.StringField(11, repeated=True)
  uid = _messages.StringField(12)
  updateTime = _messages.StringField(13)


class GoogleCloudDataplexV1EntryTypeAspectInfo(_messages.Message):
  r"""A GoogleCloudDataplexV1EntryTypeAspectInfo object.

  Fields:
    type: Required aspect type for the entry type.
  """

  type = _messages.StringField(1)


class GoogleCloudDataplexV1EntryTypeAuthorization(_messages.Message):
  r"""Authorization for an Entry Type.

  Fields:
    alternateUsePermission: Immutable. The IAM permission grantable on the
      Entry Group to allow access to instantiate Entries of Dataplex Universal
      Catalog owned Entry Types, only settable for Dataplex Universal Catalog
      owned Types.
  """

  alternateUsePermission = _messages.StringField(1)


class GoogleCloudDataplexV1Environment(_messages.Message):
  r"""Environment represents a user-visible compute infrastructure for
  analytics within a lake.

  Enums:
    StateValueValuesEnum: Output only. Current state of the environment.

  Messages:
    LabelsValue: Optional. User defined labels for the environment.

  Fields:
    createTime: Output only. Environment creation time.
    description: Optional. Description of the environment.
    displayName: Optional. User friendly display name.
    endpoints: Output only. URI Endpoints to access sessions associated with
      the Environment.
    infrastructureSpec: Required. Infrastructure specification for the
      Environment.
    labels: Optional. User defined labels for the environment.
    name: Output only. The relative resource name of the environment, of the
      form: projects/{project_id}/locations/{location_id}/lakes/{lake_id}/envi
      ronment/{environment_id}
    sessionSpec: Optional. Configuration for sessions created for this
      environment.
    sessionStatus: Output only. Status of sessions created for this
      environment.
    state: Output only. Current state of the environment.
    uid: Output only. System generated globally unique ID for the environment.
      This ID will be different if the environment is deleted and re-created
      with the same name.
    updateTime: Output only. The time when the environment was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the environment.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User defined labels for the environment.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  endpoints = _messages.MessageField('GoogleCloudDataplexV1EnvironmentEndpoints', 4)
  infrastructureSpec = _messages.MessageField('GoogleCloudDataplexV1EnvironmentInfrastructureSpec', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  sessionSpec = _messages.MessageField('GoogleCloudDataplexV1EnvironmentSessionSpec', 8)
  sessionStatus = _messages.MessageField('GoogleCloudDataplexV1EnvironmentSessionStatus', 9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class GoogleCloudDataplexV1EnvironmentEndpoints(_messages.Message):
  r"""URI Endpoints to access sessions associated with the Environment.

  Fields:
    notebooks: Output only. URI to serve notebook APIs
    sql: Output only. URI to serve SQL APIs
  """

  notebooks = _messages.StringField(1)
  sql = _messages.StringField(2)


class GoogleCloudDataplexV1EnvironmentInfrastructureSpec(_messages.Message):
  r"""Configuration for the underlying infrastructure used to run workloads.

  Fields:
    compute: Optional. Compute resources needed for analyze interactive
      workloads.
    osImage: Required. Software Runtime Configuration for analyze interactive
      workloads.
  """

  compute = _messages.MessageField('GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources', 1)
  osImage = _messages.MessageField('GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime', 2)


class GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources(_messages.Message):
  r"""Compute resources associated with the analyze interactive workloads.

  Fields:
    diskSizeGb: Optional. Size in GB of the disk. Default is 100 GB.
    maxNodeCount: Optional. Max configurable nodes. If max_node_count >
      node_count, then auto-scaling is enabled.
    nodeCount: Optional. Total number of nodes in the sessions created for
      this environment.
  """

  diskSizeGb = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  maxNodeCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime(_messages.Message):
  r"""Software Runtime Configuration to run Analyze.

  Messages:
    PropertiesValue: Optional. Spark properties to provide configuration for
      use in sessions created for this environment. The properties to set on
      daemon config files. Property keys are specified in prefix:property
      format. The prefix must be "spark".

  Fields:
    imageVersion: Required. Dataplex Universal Catalog Image version.
    javaLibraries: Optional. List of Java jars to be included in the runtime
      environment. Valid input includes Cloud Storage URIs to Jar binaries.
      For example, gs://bucket-name/my/path/to/file.jar
    properties: Optional. Spark properties to provide configuration for use in
      sessions created for this environment. The properties to set on daemon
      config files. Property keys are specified in prefix:property format. The
      prefix must be "spark".
    pythonPackages: Optional. A list of python packages to be installed. Valid
      formats include Cloud Storage URI to a PIP installable library. For
      example, gs://bucket-name/my/path/to/lib.tar.gz
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. Spark properties to provide configuration for use in
    sessions created for this environment. The properties to set on daemon
    config files. Property keys are specified in prefix:property format. The
    prefix must be "spark".

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  imageVersion = _messages.StringField(1)
  javaLibraries = _messages.StringField(2, repeated=True)
  properties = _messages.MessageField('PropertiesValue', 3)
  pythonPackages = _messages.StringField(4, repeated=True)


class GoogleCloudDataplexV1EnvironmentSessionSpec(_messages.Message):
  r"""Configuration for sessions created for this environment.

  Fields:
    enableFastStartup: Optional. If True, this causes sessions to be pre-
      created and available for faster startup to enable interactive
      exploration use-cases. This defaults to False to avoid additional billed
      charges. These can only be set to True for the environment with name set
      to "default", and with default configuration.
    maxIdleDuration: Optional. The idle time configuration of the session. The
      session will be auto-terminated at the end of this period.
  """

  enableFastStartup = _messages.BooleanField(1)
  maxIdleDuration = _messages.StringField(2)


class GoogleCloudDataplexV1EnvironmentSessionStatus(_messages.Message):
  r"""Status of sessions created for this environment.

  Fields:
    active: Output only. Queries over sessions to mark whether the environment
      is currently active or not
  """

  active = _messages.BooleanField(1)


class GoogleCloudDataplexV1GenerateDataQualityRulesRequest(_messages.Message):
  r"""Request details for generating data quality rule recommendations."""


class GoogleCloudDataplexV1GenerateDataQualityRulesResponse(_messages.Message):
  r"""Response details for data quality rule recommendations.

  Fields:
    rule: The data quality rules that Dataplex Universal Catalog generates
      based on the results of a data profiling scan.
  """

  rule = _messages.MessageField('GoogleCloudDataplexV1DataQualityRule', 1, repeated=True)


class GoogleCloudDataplexV1Glossary(_messages.Message):
  r"""A Glossary represents a collection of GlossaryCategories and
  GlossaryTerms defined by the user. Glossary is a top level resource and is
  the Google Cloud parent resource of all the GlossaryCategories and
  GlossaryTerms within it.

  Messages:
    LabelsValue: Optional. User-defined labels for the Glossary.

  Fields:
    categoryCount: Output only. The number of GlossaryCategories in the
      Glossary.
    createTime: Output only. The time at which the Glossary was created.
    description: Optional. The user-mutable description of the Glossary.
    displayName: Optional. User friendly display name of the Glossary. This is
      user-mutable. This will be same as the GlossaryId, if not specified.
    etag: Optional. Needed for resource freshness validation. This checksum is
      computed by the server based on the value of other fields, and may be
      sent on update and delete requests to ensure the client has an up-to-
      date value before proceeding.
    labels: Optional. User-defined labels for the Glossary.
    name: Output only. Identifier. The resource name of the Glossary. Format:
      projects/{project_id_or_number}/locations/{location_id}/glossaries/{glos
      sary_id}
    termCount: Output only. The number of GlossaryTerms in the Glossary.
    uid: Output only. System generated unique id for the Glossary. This ID
      will be different if the Glossary is deleted and re-created with the
      same name.
    updateTime: Output only. The time at which the Glossary was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the Glossary.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  categoryCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  etag = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  termCount = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  uid = _messages.StringField(9)
  updateTime = _messages.StringField(10)


class GoogleCloudDataplexV1GlossaryCategory(_messages.Message):
  r"""A GlossaryCategory represents a collection of GlossaryCategories and
  GlossaryTerms within a Glossary that are related to each other.

  Messages:
    LabelsValue: Optional. User-defined labels for the GlossaryCategory.

  Fields:
    createTime: Output only. The time at which the GlossaryCategory was
      created.
    description: Optional. The user-mutable description of the
      GlossaryCategory.
    displayName: Optional. User friendly display name of the GlossaryCategory.
      This is user-mutable. This will be same as the GlossaryCategoryId, if
      not specified.
    labels: Optional. User-defined labels for the GlossaryCategory.
    name: Output only. Identifier. The resource name of the GlossaryCategory.
      Format: projects/{project_id_or_number}/locations/{location_id}/glossari
      es/{glossary_id}/categories/{category_id}
    parent: Required. The immediate parent of the GlossaryCategory in the
      resource-hierarchy. It can either be a Glossary or a GlossaryCategory.
      Format: projects/{project_id_or_number}/locations/{location_id}/glossari
      es/{glossary_id} OR projects/{project_id_or_number}/locations/{location_
      id}/glossaries/{glossary_id}/categories/{category_id}
    uid: Output only. System generated unique id for the GlossaryCategory.
      This ID will be different if the GlossaryCategory is deleted and re-
      created with the same name.
    updateTime: Output only. The time at which the GlossaryCategory was last
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the GlossaryCategory.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  parent = _messages.StringField(6)
  uid = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudDataplexV1GlossaryTerm(_messages.Message):
  r"""GlossaryTerms are the core of Glossary. A GlossaryTerm holds a rich text
  description that can be attached to Entries or specific columns to enrich
  them.

  Messages:
    LabelsValue: Optional. User-defined labels for the GlossaryTerm.

  Fields:
    createTime: Output only. The time at which the GlossaryTerm was created.
    description: Optional. The user-mutable description of the GlossaryTerm.
    displayName: Optional. User friendly display name of the GlossaryTerm.
      This is user-mutable. This will be same as the GlossaryTermId, if not
      specified.
    labels: Optional. User-defined labels for the GlossaryTerm.
    name: Output only. Identifier. The resource name of the GlossaryTerm.
      Format: projects/{project_id_or_number}/locations/{location_id}/glossari
      es/{glossary_id}/terms/{term_id}
    parent: Required. The immediate parent of the GlossaryTerm in the
      resource-hierarchy. It can either be a Glossary or a GlossaryCategory.
      Format: projects/{project_id_or_number}/locations/{location_id}/glossari
      es/{glossary_id} OR projects/{project_id_or_number}/locations/{location_
      id}/glossaries/{glossary_id}/categories/{category_id}
    uid: Output only. System generated unique id for the GlossaryTerm. This ID
      will be different if the GlossaryTerm is deleted and re-created with the
      same name.
    updateTime: Output only. The time at which the GlossaryTerm was last
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the GlossaryTerm.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  parent = _messages.StringField(6)
  uid = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudDataplexV1GovernanceEvent(_messages.Message):
  r"""Payload associated with Governance related log events.

  Enums:
    EventTypeValueValuesEnum: The type of the event.

  Fields:
    entity: Entity resource information if the log event is associated with a
      specific entity.
    eventType: The type of the event.
    message: The log message.
  """

  class EventTypeValueValuesEnum(_messages.Enum):
    r"""The type of the event.

    Values:
      EVENT_TYPE_UNSPECIFIED: An unspecified event type.
      RESOURCE_IAM_POLICY_UPDATE: Resource IAM policy update event.
      BIGQUERY_TABLE_CREATE: BigQuery table create event.
      BIGQUERY_TABLE_UPDATE: BigQuery table update event.
      BIGQUERY_TABLE_DELETE: BigQuery table delete event.
      BIGQUERY_CONNECTION_CREATE: BigQuery connection create event.
      BIGQUERY_CONNECTION_UPDATE: BigQuery connection update event.
      BIGQUERY_CONNECTION_DELETE: BigQuery connection delete event.
      BIGQUERY_TAXONOMY_CREATE: BigQuery taxonomy created.
      BIGQUERY_POLICY_TAG_CREATE: BigQuery policy tag created.
      BIGQUERY_POLICY_TAG_DELETE: BigQuery policy tag deleted.
      BIGQUERY_POLICY_TAG_SET_IAM_POLICY: BigQuery set iam policy for policy
        tag.
      ACCESS_POLICY_UPDATE: Access policy update event.
      GOVERNANCE_RULE_MATCHED_RESOURCES: Number of resources matched with
        particular Query.
      GOVERNANCE_RULE_SEARCH_LIMIT_EXCEEDS: Rule processing exceeds the
        allowed limit.
      GOVERNANCE_RULE_ERRORS: Rule processing errors.
      GOVERNANCE_RULE_PROCESSING: Governance rule processing Event.
    """
    EVENT_TYPE_UNSPECIFIED = 0
    RESOURCE_IAM_POLICY_UPDATE = 1
    BIGQUERY_TABLE_CREATE = 2
    BIGQUERY_TABLE_UPDATE = 3
    BIGQUERY_TABLE_DELETE = 4
    BIGQUERY_CONNECTION_CREATE = 5
    BIGQUERY_CONNECTION_UPDATE = 6
    BIGQUERY_CONNECTION_DELETE = 7
    BIGQUERY_TAXONOMY_CREATE = 8
    BIGQUERY_POLICY_TAG_CREATE = 9
    BIGQUERY_POLICY_TAG_DELETE = 10
    BIGQUERY_POLICY_TAG_SET_IAM_POLICY = 11
    ACCESS_POLICY_UPDATE = 12
    GOVERNANCE_RULE_MATCHED_RESOURCES = 13
    GOVERNANCE_RULE_SEARCH_LIMIT_EXCEEDS = 14
    GOVERNANCE_RULE_ERRORS = 15
    GOVERNANCE_RULE_PROCESSING = 16

  entity = _messages.MessageField('GoogleCloudDataplexV1GovernanceEventEntity', 1)
  eventType = _messages.EnumField('EventTypeValueValuesEnum', 2)
  message = _messages.StringField(3)


class GoogleCloudDataplexV1GovernanceEventEntity(_messages.Message):
  r"""Information about Entity resource that the log event is associated with.

  Enums:
    EntityTypeValueValuesEnum: Type of entity.

  Fields:
    entity: The Entity resource the log event is associated with. Format: proj
      ects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zon
      e_id}/entities/{entity_id}
    entityType: Type of entity.
  """

  class EntityTypeValueValuesEnum(_messages.Enum):
    r"""Type of entity.

    Values:
      ENTITY_TYPE_UNSPECIFIED: An unspecified Entity type.
      TABLE: Table entity type.
      FILESET: Fileset entity type.
    """
    ENTITY_TYPE_UNSPECIFIED = 0
    TABLE = 1
    FILESET = 2

  entity = _messages.StringField(1)
  entityType = _messages.EnumField('EntityTypeValueValuesEnum', 2)


class GoogleCloudDataplexV1GovernanceRule(_messages.Message):
  r"""Governance Rules are used to specify governance intent at scale. A rule
  comprises of a query and the list of 'specs' to be applied on the resources
  matching the query. Additionally, specs can also be applied on the sub-
  resources using 'DynamicPaths'. A rule can also be used to specify
  governance intent on a single resource, by applying specs explicitly.

  Messages:
    LabelsValue: Optional. User-defined labels for the Rule.

  Fields:
    createTime: Output only. The time when the Rule was created.
    description: Optional. Description of the Rule.
    displayName: Optional. User friendly display name.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding. Etags must be used
      when calling the DeleteRule and the UpdateRule method.
    fields: Optional. The list of 'fields' to specify the column identifiers
      to apply governance specs on the columns in the matched resources.
    labels: Optional. User-defined labels for the Rule.
    name: Output only. The relative resource name of the Rule, of the form:
      projects/{project_number}/locations/{location}/rules/{rule_id}
    paths: Optional. The list of 'path' to specify the column identifiers to
      apply specs on the columns in the matched resources.
    query: Optional. Query is used to identify resources in a logical
      container using filters and apply specs.
    specs: Optional. Specs to be associated with the resource.
    uid: Output only. System generated globally unique ID for the Rule. This
      ID will be different if the Rule is deleted and re-created with the same
      name.
    updateTime: Output only. The time when the Rule was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the Rule.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  fields = _messages.MessageField('GoogleCloudDataplexV1GovernanceRuleField', 5, repeated=True)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  paths = _messages.MessageField('GoogleCloudDataplexV1GovernanceRulePath', 8, repeated=True)
  query = _messages.MessageField('GoogleCloudDataplexV1GovernanceRuleQuery', 9)
  specs = _messages.MessageField('GoogleCloudDataplexV1GovernanceRuleSpecs', 10)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class GoogleCloudDataplexV1GovernanceRuleField(_messages.Message):
  r"""Field specifies the column identifiers to apply specs on the columns in
  the matched resources.

  Fields:
    expression: Required.
    specs: Required. Spec to be associated with the path of the resource.
  """

  expression = _messages.StringField(1)
  specs = _messages.MessageField('GoogleCloudDataplexV1GovernanceRuleSpecs', 2)


class GoogleCloudDataplexV1GovernanceRulePath(_messages.Message):
  r"""Path specifies the column identifiers to apply specs on the columns in
  the matched resources.

  Fields:
    aspect: A string attribute.
    specs: Required. Specs to be associated with the path of the resource.
  """

  aspect = _messages.StringField(1)
  specs = _messages.MessageField('GoogleCloudDataplexV1GovernanceRuleSpecs', 2)


class GoogleCloudDataplexV1GovernanceRuleQuery(_messages.Message):
  r"""Query is used for governing data at scale. They can be used to identify
  resources in a logical container using filters.

  Enums:
    TypeValueValuesEnum: Required. The metastore system to execute query on.

  Fields:
    entryTypes: Required. The list of entry types to apply the filter on.
      Entry Type format will be as defined below 1. For Dataplex Universal
      Catalog-defined entry types: EntryTypeID 2. For user-defined entry types
      in global region: ProjectID.EntryTypeID 3. For user-defined entry types
      in a specific region (must match region of governance rule):
      ProjectID.LocationID.EntryTypeID For Dataplex Universal Catalog-defined
      entry allowed types are 'bigquery-table', 'bigquery-dataset' ,
      'bigquery-view', 'storage-bucket' and 'storage-folder'
    expression: Required. The query string to match the resources. All the
      resources which are returned as response from the querySystem for this
      filter will have the attributes applied. Expression Format : 1. Query
      expression does only supports aspect facet. a) Aspect type it should be
      fully Qualified aspect aspect:... b) For Dataplex Universal Catalog-
      defined aspect types: projectId will be 'dataplex-types' and location
      will be 'global'. 2. Will accept logical and bracketed expressions (AND,
      NOT, OR)
    scopes: Optional. The full resource name of the resource logical
      container. Should either be organizations/ or projects/. If scope is not
      provided, will be defaulted to project in which rule is ben created.
      Only a single scope can be specified at this time.
    type: Required. The metastore system to execute query on.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The metastore system to execute query on.

    Values:
      TYPE_UNSPECIFIED: DATA_CATALOG is the default system used for querying,
        when unspecified.
      DATAPLEX: <no description>
    """
    TYPE_UNSPECIFIED = 0
    DATAPLEX = 1

  entryTypes = _messages.StringField(1, repeated=True)
  expression = _messages.StringField(2)
  scopes = _messages.StringField(3, repeated=True)
  type = _messages.EnumField('TypeValueValuesEnum', 4)


class GoogleCloudDataplexV1GovernanceRuleSpecs(_messages.Message):
  r"""Specs hold the governance intent to be applied on resources.

  Fields:
    access: Optional. Access Spec hold the Security/Access intent to be
      applied on resources.
    dataAccess: Optional. Specified when applied to data stored on the
      resource (eg: rows, columns in BigQuery Tables).
    resourceAccess: Optional. Specified when applied to a resource (eg: Cloud
      Storage bucket, BigQuery dataset, BigQuery table).
  """

  access = _messages.MessageField('GoogleCloudDataplexV1AccessSpec', 1)
  dataAccess = _messages.MessageField('GoogleCloudDataplexV1DataAccessSpec', 2)
  resourceAccess = _messages.MessageField('GoogleCloudDataplexV1ResourceAccessSpec', 3)


class GoogleCloudDataplexV1ImportItem(_messages.Message):
  r"""An object that describes the values that you want to set for an entry
  and its attached aspects when you import metadata. Used when you run a
  metadata import job. See CreateMetadataJob.You provide a collection of
  import items in a metadata import file. For more information about how to
  create a metadata import file, see Metadata import file
  (https://cloud.google.com/dataplex/docs/import-metadata#metadata-import-
  file).

  Fields:
    aspectKeys: The aspects to modify. Supports the following syntaxes:
      {aspect_type_reference}: matches aspects that belong to the specified
      aspect type and are attached directly to the entry.
      {aspect_type_reference}@{path}: matches aspects that belong to the
      specified aspect type and path. {aspect_type_reference}@* : matches
      aspects of the given type for all paths. *@path : matches aspects of all
      types on the given path.Replace {aspect_type_reference} with a reference
      to the aspect type, in the format
      {project_id_or_number}.{location_id}.{aspect_type_id}.In FULL entry sync
      mode, if you leave this field empty, it is treated as specifying exactly
      those aspects that are present within the specified entry. Dataplex
      Universal Catalog implicitly adds the keys for all of the required
      aspects of an entry.
    entry: Information about an entry and its attached aspects.
    entryLink: Information about the entry link. User should provide either
      one of the entry or entry_link. While providing entry_link, user should
      not provide update_mask and aspect_keys.
    updateMask: The fields to update, in paths that are relative to the Entry
      resource. Separate each field with a comma.In FULL entry sync mode,
      Dataplex Universal Catalog includes the paths of all of the fields for
      an entry that can be modified, including aspects. This means that
      Dataplex Universal Catalog replaces the existing entry with the entry in
      the metadata import file. All modifiable fields are updated, regardless
      of the fields that are listed in the update mask, and regardless of
      whether a field is present in the entry object.The update_mask field is
      ignored when an entry is created or re-created.In an aspect-only
      metadata job (when entry sync mode is NONE), set this value to
      aspects.Dataplex Universal Catalog also determines which entries and
      aspects to modify by comparing the values and timestamps that you
      provide in the metadata import file with the values and timestamps that
      exist in your project. For more information, see Comparison logic
      (https://cloud.google.com/dataplex/docs/import-metadata#data-
      modification-logic).
  """

  aspectKeys = _messages.StringField(1, repeated=True)
  entry = _messages.MessageField('GoogleCloudDataplexV1Entry', 2)
  entryLink = _messages.MessageField('GoogleCloudDataplexV1EntryLink', 3)
  updateMask = _messages.StringField(4)


class GoogleCloudDataplexV1Job(_messages.Message):
  r"""A job represents an instance of a task.

  Enums:
    ServiceValueValuesEnum: Output only. The underlying service running a job.
    StateValueValuesEnum: Output only. Execution state for the job.
    TriggerValueValuesEnum: Output only. Job execution trigger.

  Messages:
    LabelsValue: Output only. User-defined labels for the task.

  Fields:
    endTime: Output only. The time when the job ended.
    executionSpec: Output only. Spec related to how a task is executed.
    labels: Output only. User-defined labels for the task.
    message: Output only. Additional information about the current state.
    name: Output only. The relative resource name of the job, of the form: pro
      jects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{ta
      sk_id}/jobs/{job_id}.
    retryCount: Output only. The number of times the job has been retried
      (excluding the initial attempt).
    service: Output only. The underlying service running a job.
    serviceJob: Output only. The full resource name for the job run under a
      particular service.
    startTime: Output only. The time when the job was started.
    state: Output only. Execution state for the job.
    trigger: Output only. Job execution trigger.
    uid: Output only. System generated globally unique ID for the job.
  """

  class ServiceValueValuesEnum(_messages.Enum):
    r"""Output only. The underlying service running a job.

    Values:
      SERVICE_UNSPECIFIED: Service used to run the job is unspecified.
      DATAPROC: Dataproc service is used to run this job.
    """
    SERVICE_UNSPECIFIED = 0
    DATAPROC = 1

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Execution state for the job.

    Values:
      STATE_UNSPECIFIED: The job state is unknown.
      RUNNING: The job is running.
      CANCELLING: The job is cancelling.
      CANCELLED: The job cancellation was successful.
      SUCCEEDED: The job completed successfully.
      FAILED: The job is no longer running due to an error.
      ABORTED: The job was cancelled outside of Dataplex Universal Catalog.
    """
    STATE_UNSPECIFIED = 0
    RUNNING = 1
    CANCELLING = 2
    CANCELLED = 3
    SUCCEEDED = 4
    FAILED = 5
    ABORTED = 6

  class TriggerValueValuesEnum(_messages.Enum):
    r"""Output only. Job execution trigger.

    Values:
      TRIGGER_UNSPECIFIED: The trigger is unspecified.
      TASK_CONFIG: The job was triggered by Dataplex Universal Catalog based
        on trigger spec from task definition.
      RUN_REQUEST: The job was triggered by the explicit call of Task API.
    """
    TRIGGER_UNSPECIFIED = 0
    TASK_CONFIG = 1
    RUN_REQUEST = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Output only. User-defined labels for the task.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  endTime = _messages.StringField(1)
  executionSpec = _messages.MessageField('GoogleCloudDataplexV1TaskExecutionSpec', 2)
  labels = _messages.MessageField('LabelsValue', 3)
  message = _messages.StringField(4)
  name = _messages.StringField(5)
  retryCount = _messages.IntegerField(6, variant=_messages.Variant.UINT32)
  service = _messages.EnumField('ServiceValueValuesEnum', 7)
  serviceJob = _messages.StringField(8)
  startTime = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  trigger = _messages.EnumField('TriggerValueValuesEnum', 11)
  uid = _messages.StringField(12)


class GoogleCloudDataplexV1JobEvent(_messages.Message):
  r"""The payload associated with Job logs that contains events describing
  jobs that have run within a Lake.

  Enums:
    ExecutionTriggerValueValuesEnum: Job execution trigger.
    ServiceValueValuesEnum: The service used to execute the job.
    StateValueValuesEnum: The job state on completion.
    TypeValueValuesEnum: The type of the job.

  Fields:
    endTime: The time when the job ended running.
    executionTrigger: Job execution trigger.
    jobId: The unique id identifying the job.
    message: The log message.
    retries: The number of retries.
    service: The service used to execute the job.
    serviceJob: The reference to the job within the service.
    startTime: The time when the job started running.
    state: The job state on completion.
    type: The type of the job.
  """

  class ExecutionTriggerValueValuesEnum(_messages.Enum):
    r"""Job execution trigger.

    Values:
      EXECUTION_TRIGGER_UNSPECIFIED: The job execution trigger is unspecified.
      TASK_CONFIG: The job was triggered by Dataplex Universal Catalog based
        on trigger spec from task definition.
      RUN_REQUEST: The job was triggered by the explicit call of Task API.
    """
    EXECUTION_TRIGGER_UNSPECIFIED = 0
    TASK_CONFIG = 1
    RUN_REQUEST = 2

  class ServiceValueValuesEnum(_messages.Enum):
    r"""The service used to execute the job.

    Values:
      SERVICE_UNSPECIFIED: Unspecified service.
      DATAPROC: Cloud Dataproc.
    """
    SERVICE_UNSPECIFIED = 0
    DATAPROC = 1

  class StateValueValuesEnum(_messages.Enum):
    r"""The job state on completion.

    Values:
      STATE_UNSPECIFIED: Unspecified job state.
      SUCCEEDED: Job successfully completed.
      FAILED: Job was unsuccessful.
      CANCELLED: Job was cancelled by the user.
      ABORTED: Job was cancelled or aborted via the service executing the job.
    """
    STATE_UNSPECIFIED = 0
    SUCCEEDED = 1
    FAILED = 2
    CANCELLED = 3
    ABORTED = 4

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the job.

    Values:
      TYPE_UNSPECIFIED: Unspecified job type.
      SPARK: Spark jobs.
      NOTEBOOK: Notebook jobs.
    """
    TYPE_UNSPECIFIED = 0
    SPARK = 1
    NOTEBOOK = 2

  endTime = _messages.StringField(1)
  executionTrigger = _messages.EnumField('ExecutionTriggerValueValuesEnum', 2)
  jobId = _messages.StringField(3)
  message = _messages.StringField(4)
  retries = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  service = _messages.EnumField('ServiceValueValuesEnum', 6)
  serviceJob = _messages.StringField(7)
  startTime = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  type = _messages.EnumField('TypeValueValuesEnum', 10)


class GoogleCloudDataplexV1Lake(_messages.Message):
  r"""A lake is a centralized repository for managing enterprise data across
  the organization distributed across many cloud projects, and stored in a
  variety of storage services such as Google Cloud Storage and BigQuery. The
  resources attached to a lake are referred to as managed resources. Data
  within these managed resources can be structured or unstructured. A lake
  provides data admins with tools to organize, secure and manage their data at
  scale, and provides data scientists and data engineers an integrated
  experience to easily search, discover, analyze and transform data and
  associated metadata.

  Enums:
    StateValueValuesEnum: Output only. Current state of the lake.

  Messages:
    LabelsValue: Optional. User-defined labels for the lake.

  Fields:
    assetStatus: Output only. Aggregated status of the underlying assets of
      the lake.
    createTime: Output only. The time when the lake was created.
    description: Optional. Description of the lake.
    displayName: Optional. User friendly display name.
    labels: Optional. User-defined labels for the lake.
    metastore: Optional. Settings to manage lake and Dataproc Metastore
      service instance association.
    metastoreStatus: Output only. Metastore status of the lake.
    name: Output only. The relative resource name of the lake, of the form:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
    serviceAccount: Output only. Service account associated with this lake.
      This service account must be authorized to access or operate on
      resources managed by the lake.
    state: Output only. Current state of the lake.
    uid: Output only. System generated globally unique ID for the lake. This
      ID will be different if the lake is deleted and re-created with the same
      name.
    updateTime: Output only. The time when the lake was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the lake.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the lake.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  assetStatus = _messages.MessageField('GoogleCloudDataplexV1AssetStatus', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  metastore = _messages.MessageField('GoogleCloudDataplexV1LakeMetastore', 6)
  metastoreStatus = _messages.MessageField('GoogleCloudDataplexV1LakeMetastoreStatus', 7)
  name = _messages.StringField(8)
  serviceAccount = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class GoogleCloudDataplexV1LakeMetastore(_messages.Message):
  r"""Settings to manage association of Dataproc Metastore with a lake.

  Fields:
    service: Optional. A relative reference to the Dataproc Metastore
      (https://cloud.google.com/dataproc-metastore/docs) service associated
      with the lake:
      projects/{project_id}/locations/{location_id}/services/{service_id}
  """

  service = _messages.StringField(1)


class GoogleCloudDataplexV1LakeMetastoreStatus(_messages.Message):
  r"""Status of Lake and Dataproc Metastore service instance association.

  Enums:
    StateValueValuesEnum: Current state of association.

  Fields:
    endpoint: The URI of the endpoint used to access the Metastore service.
    message: Additional information about the current status.
    state: Current state of association.
    updateTime: Last update time of the metastore status of the lake.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Current state of association.

    Values:
      STATE_UNSPECIFIED: Unspecified.
      NONE: A Metastore service instance is not associated with the lake.
      READY: A Metastore service instance is attached to the lake.
      UPDATING: Attach/detach is in progress.
      ERROR: Attach/detach could not be done due to errors.
    """
    STATE_UNSPECIFIED = 0
    NONE = 1
    READY = 2
    UPDATING = 3
    ERROR = 4

  endpoint = _messages.StringField(1)
  message = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  updateTime = _messages.StringField(4)


class GoogleCloudDataplexV1ListActionsResponse(_messages.Message):
  r"""List actions response.

  Fields:
    actions: Actions under the given parent lake/zone/asset.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  actions = _messages.MessageField('GoogleCloudDataplexV1Action', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDataplexV1ListAspectTypesResponse(_messages.Message):
  r"""List AspectTypes response.

  Fields:
    aspectTypes: AspectTypes under the given parent location.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachableLocations: Locations that the service couldn't reach.
  """

  aspectTypes = _messages.MessageField('GoogleCloudDataplexV1AspectType', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListAssetsResponse(_messages.Message):
  r"""List assets response.

  Fields:
    assets: Asset under the given parent zone.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  assets = _messages.MessageField('GoogleCloudDataplexV1Asset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDataplexV1ListContentResponse(_messages.Message):
  r"""List content response.

  Fields:
    content: Content under the given parent lake.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  content = _messages.MessageField('GoogleCloudDataplexV1Content', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDataplexV1ListDataAssetsResponse(_messages.Message):
  r"""Response message for listing Data Assets.

  Fields:
    dataAssets: The Data Assets for the requested filter criteria.
    nextPageToken: A token, which can be sent as page_token to retrieve the
      next page. If this field is empty, then there are no subsequent pages.
  """

  dataAssets = _messages.MessageField('GoogleCloudDataplexV1DataAsset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDataplexV1ListDataAttributeBindingsResponse(_messages.Message):
  r"""List DataAttributeBindings response.

  Fields:
    dataAttributeBindings: DataAttributeBindings under the given parent
      Location.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachableLocations: Locations that could not be reached.
  """

  dataAttributeBindings = _messages.MessageField('GoogleCloudDataplexV1DataAttributeBinding', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListDataAttributesResponse(_messages.Message):
  r"""List DataAttributes response.

  Fields:
    dataAttributes: DataAttributes under the given parent DataTaxonomy.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachableLocations: Locations that could not be reached.
  """

  dataAttributes = _messages.MessageField('GoogleCloudDataplexV1DataAttribute', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListDataProductsResponse(_messages.Message):
  r"""Response message for listing Data Products.

  Fields:
    dataProducts: The Data Products for the requested filter criteria.
    nextPageToken: A token, which can be sent as page_token to retrieve the
      next page. If this field is empty, then there are no subsequent pages.
    unreachable: Unordered list. Locations that the service couldn't reach.
  """

  dataProducts = _messages.MessageField('GoogleCloudDataplexV1DataProduct', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListDataScanJobsResponse(_messages.Message):
  r"""List DataScanJobs response.

  Fields:
    dataScanJobs: DataScanJobs (BASIC view only) under a given dataScan.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  dataScanJobs = _messages.MessageField('GoogleCloudDataplexV1DataScanJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDataplexV1ListDataScansResponse(_messages.Message):
  r"""List dataScans response.

  Fields:
    dataScans: DataScans (BASIC view only) under the given parent location.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachable: Locations that could not be reached.
  """

  dataScans = _messages.MessageField('GoogleCloudDataplexV1DataScan', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListDataTaxonomiesResponse(_messages.Message):
  r"""List DataTaxonomies response.

  Fields:
    dataTaxonomies: DataTaxonomies under the given parent location.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachableLocations: Locations that could not be reached.
  """

  dataTaxonomies = _messages.MessageField('GoogleCloudDataplexV1DataTaxonomy', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListEncryptionConfigsResponse(_messages.Message):
  r"""List EncryptionConfigs Response

  Fields:
    encryptionConfigs: The list of EncryptionConfigs under the given parent
      location.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachableLocations: Locations that could not be reached.
  """

  encryptionConfigs = _messages.MessageField('GoogleCloudDataplexV1EncryptionConfig', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListEntitiesResponse(_messages.Message):
  r"""List metadata entities response.

  Fields:
    entities: Entities in the specified parent zone.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no remaining results in the list.
  """

  entities = _messages.MessageField('GoogleCloudDataplexV1Entity', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDataplexV1ListEntriesResponse(_messages.Message):
  r"""List Entries response.

  Fields:
    entries: The list of entries under the given parent location.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  entries = _messages.MessageField('GoogleCloudDataplexV1Entry', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDataplexV1ListEntryGroupsResponse(_messages.Message):
  r"""List entry groups response.

  Fields:
    entryGroups: Entry groups under the given parent location.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachableLocations: Locations that the service couldn't reach.
  """

  entryGroups = _messages.MessageField('GoogleCloudDataplexV1EntryGroup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListEntryTypesResponse(_messages.Message):
  r"""List EntryTypes response.

  Fields:
    entryTypes: EntryTypes under the given parent location.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachableLocations: Locations that the service couldn't reach.
  """

  entryTypes = _messages.MessageField('GoogleCloudDataplexV1EntryType', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListEnvironmentsResponse(_messages.Message):
  r"""List environments response.

  Fields:
    environments: Environments under the given parent lake.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  environments = _messages.MessageField('GoogleCloudDataplexV1Environment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDataplexV1ListGlossariesResponse(_messages.Message):
  r"""List Glossaries Response

  Fields:
    glossaries: Lists the Glossaries in the specified parent.
    nextPageToken: A token, which can be sent as page_token to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachableLocations: Locations that the service couldn't reach.
  """

  glossaries = _messages.MessageField('GoogleCloudDataplexV1Glossary', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListGlossaryCategoriesResponse(_messages.Message):
  r"""List GlossaryCategories Response

  Fields:
    categories: Lists the GlossaryCategories in the specified parent.
    nextPageToken: A token, which can be sent as page_token to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachableLocations: Locations that the service couldn't reach.
  """

  categories = _messages.MessageField('GoogleCloudDataplexV1GlossaryCategory', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListGlossaryTermsResponse(_messages.Message):
  r"""List GlossaryTerms Response

  Fields:
    nextPageToken: A token, which can be sent as page_token to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    terms: Lists the GlossaryTerms in the specified parent.
    unreachableLocations: Locations that the service couldn't reach.
  """

  nextPageToken = _messages.StringField(1)
  terms = _messages.MessageField('GoogleCloudDataplexV1GlossaryTerm', 2, repeated=True)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListGovernanceRulesResponse(_messages.Message):
  r"""List GovernanceRules response.

  Fields:
    governanceRules: GovernanceRules under the given parent location.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  governanceRules = _messages.MessageField('GoogleCloudDataplexV1GovernanceRule', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDataplexV1ListJobsResponse(_messages.Message):
  r"""List jobs response.

  Fields:
    jobs: Jobs under a given task.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  jobs = _messages.MessageField('GoogleCloudDataplexV1Job', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDataplexV1ListLakesResponse(_messages.Message):
  r"""List lakes response.

  Fields:
    lakes: Lakes under the given parent location.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachableLocations: Locations that could not be reached.
  """

  lakes = _messages.MessageField('GoogleCloudDataplexV1Lake', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListMetadataJobsResponse(_messages.Message):
  r"""List metadata jobs response.

  Fields:
    metadataJobs: Metadata jobs under the specified parent location.
    nextPageToken: A token to retrieve the next page of results. If there are
      no more results in the list, the value is empty.
    unreachableLocations: Locations that the service couldn't reach.
  """

  metadataJobs = _messages.MessageField('GoogleCloudDataplexV1MetadataJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListPartitionsResponse(_messages.Message):
  r"""List metadata partitions response.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no remaining results in the list.
    partitions: Partitions under the specified parent entity.
  """

  nextPageToken = _messages.StringField(1)
  partitions = _messages.MessageField('GoogleCloudDataplexV1Partition', 2, repeated=True)


class GoogleCloudDataplexV1ListSessionsResponse(_messages.Message):
  r"""List sessions response.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    sessions: Sessions under a given environment.
  """

  nextPageToken = _messages.StringField(1)
  sessions = _messages.MessageField('GoogleCloudDataplexV1Session', 2, repeated=True)


class GoogleCloudDataplexV1ListTasksResponse(_messages.Message):
  r"""List tasks response.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    tasks: Tasks under the given parent lake.
    unreachableLocations: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  tasks = _messages.MessageField('GoogleCloudDataplexV1Task', 2, repeated=True)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListZonesResponse(_messages.Message):
  r"""List zones response.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    zones: Zones under the given parent lake.
  """

  nextPageToken = _messages.StringField(1)
  zones = _messages.MessageField('GoogleCloudDataplexV1Zone', 2, repeated=True)


class GoogleCloudDataplexV1MetadataJob(_messages.Message):
  r"""A metadata job resource.

  Enums:
    TypeValueValuesEnum: Required. Metadata job type.

  Messages:
    LabelsValue: Optional. User-defined labels.

  Fields:
    createTime: Output only. The time when the metadata job was created.
    exportResult: Output only. Export job result.
    exportSpec: Export job specification.
    importResult: Output only. Import job result.
    importSpec: Import job specification.
    labels: Optional. User-defined labels.
    name: Output only. Identifier. The name of the resource that the
      configuration is applied to, in the format projects/{project_number}/loc
      ations/{location_id}/metadataJobs/{metadata_job_id}.
    status: Output only. Metadata job status.
    type: Required. Metadata job type.
    uid: Output only. A system-generated, globally unique ID for the metadata
      job. If the metadata job is deleted and then re-created with the same
      name, this ID is different.
    updateTime: Output only. The time when the metadata job was updated.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Metadata job type.

    Values:
      TYPE_UNSPECIFIED: Unspecified.
      IMPORT: Import job.
      EXPORT: Export job.
    """
    TYPE_UNSPECIFIED = 0
    IMPORT = 1
    EXPORT = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  exportResult = _messages.MessageField('GoogleCloudDataplexV1MetadataJobExportJobResult', 2)
  exportSpec = _messages.MessageField('GoogleCloudDataplexV1MetadataJobExportJobSpec', 3)
  importResult = _messages.MessageField('GoogleCloudDataplexV1MetadataJobImportJobResult', 4)
  importSpec = _messages.MessageField('GoogleCloudDataplexV1MetadataJobImportJobSpec', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  status = _messages.MessageField('GoogleCloudDataplexV1MetadataJobStatus', 8)
  type = _messages.EnumField('TypeValueValuesEnum', 9)
  uid = _messages.StringField(10)
  updateTime = _messages.StringField(11)


class GoogleCloudDataplexV1MetadataJobExportJobResult(_messages.Message):
  r"""Summary results from a metadata export job. The results are a snapshot
  of the metadata at the time when the job was created. The exported entries
  are saved to a Cloud Storage bucket.

  Fields:
    errorMessage: Output only. The error message if the metadata export job
      failed.
    exportedEntries: Output only. The number of entries that were exported.
  """

  errorMessage = _messages.StringField(1)
  exportedEntries = _messages.IntegerField(2)


class GoogleCloudDataplexV1MetadataJobExportJobSpec(_messages.Message):
  r"""Job specification for a metadata export job.

  Fields:
    outputPath: Required. The root path of the Cloud Storage bucket to export
      the metadata to, in the format gs://{bucket}/. You can optionally
      specify a custom prefix after the bucket name, in the format
      gs://{bucket}/{prefix}/. The maximum length of the custom prefix is 128
      characters. Dataplex Universal Catalog constructs the object path for
      the exported files by using the bucket name and prefix that you provide,
      followed by a system-generated path.The bucket must be in the same VPC
      Service Controls perimeter as the job.
    scope: Required. The scope of the export job.
  """

  outputPath = _messages.StringField(1)
  scope = _messages.MessageField('GoogleCloudDataplexV1MetadataJobExportJobSpecExportJobScope', 2)


class GoogleCloudDataplexV1MetadataJobExportJobSpecExportJobScope(_messages.Message):
  r"""The scope of the export job.

  Fields:
    aspectTypes: The aspect types that are in scope for the export job,
      specified as relative resource names in the format projects/{project_id_
      or_number}/locations/{location}/aspectTypes/{aspect_type_id}. Only
      aspects that belong to the specified aspect types are affected by the
      job.
    entryGroups: The entry groups whose metadata you want to export, in the
      format projects/{project_id_or_number}/locations/{location_id}/entryGrou
      ps/{entry_group_id}. Only the entries in the specified entry groups are
      exported.The entry groups must be in the same location and the same VPC
      Service Controls perimeter as the job.If you set the job scope to be a
      list of entry groups, then set the organization-level export flag to
      false and don't provide a list of projects.
    entryTypes: The entry types that are in scope for the export job,
      specified as relative resource names in the format projects/{project_id_
      or_number}/locations/{location}/entryTypes/{entry_type_id}. Only entries
      that belong to the specified entry types are affected by the job.
    organizationLevel: Whether the metadata export job is an organization-
      level export job. If true, the job exports the entries from the same
      organization and VPC Service Controls perimeter as the job. The project
      that the job belongs to determines the VPC Service Controls perimeter.
      If you set the job scope to be at the organization level, then don't
      provide a list of projects or entry groups. If false, you must specify a
      list of projects or a list of entry groups whose entries you want to
      export.The default is false.
    projects: The projects whose metadata you want to export, in the format
      projects/{project_id_or_number}. Only the entries from the specified
      projects are exported.The projects must be in the same organization and
      VPC Service Controls perimeter as the job.If you set the job scope to be
      a list of projects, then set the organization-level export flag to false
      and don't provide a list of entry groups.
  """

  aspectTypes = _messages.StringField(1, repeated=True)
  entryGroups = _messages.StringField(2, repeated=True)
  entryTypes = _messages.StringField(3, repeated=True)
  organizationLevel = _messages.BooleanField(4)
  projects = _messages.StringField(5, repeated=True)


class GoogleCloudDataplexV1MetadataJobImportJobResult(_messages.Message):
  r"""Results from a metadata import job.

  Fields:
    createdEntries: Output only. The total number of entries that were
      created.
    createdEntryLinks: Output only. The total number of entry links that were
      successfully created.
    deletedEntries: Output only. The total number of entries that were
      deleted.
    deletedEntryLinks: Output only. The total number of entry links that were
      successfully deleted.
    recreatedEntries: Output only. The total number of entries that were
      recreated.
    unchangedEntries: Output only. The total number of entries that were
      unchanged.
    unchangedEntryLinks: Output only. The total number of entry links that
      were left unchanged.
    updateTime: Output only. The time when the status was updated.
    updatedEntries: Output only. The total number of entries that were
      updated.
  """

  createdEntries = _messages.IntegerField(1)
  createdEntryLinks = _messages.IntegerField(2)
  deletedEntries = _messages.IntegerField(3)
  deletedEntryLinks = _messages.IntegerField(4)
  recreatedEntries = _messages.IntegerField(5)
  unchangedEntries = _messages.IntegerField(6)
  unchangedEntryLinks = _messages.IntegerField(7)
  updateTime = _messages.StringField(8)
  updatedEntries = _messages.IntegerField(9)


class GoogleCloudDataplexV1MetadataJobImportJobSpec(_messages.Message):
  r"""Job specification for a metadata import job.You can run the following
  kinds of metadata import jobs: Full sync of entries with incremental import
  of their aspects. Supported for custom entries. Incremental import of
  aspects only. Supported for aspects that belong to custom entries and system
  entries. For custom entries, you can modify both optional aspects and
  required aspects. For system entries, you can modify optional aspects.

  Enums:
    AspectSyncModeValueValuesEnum: Required. The sync mode for aspects.
    EntrySyncModeValueValuesEnum: Required. The sync mode for entries.
    LogLevelValueValuesEnum: Optional. The level of logs to write to Cloud
      Logging for this job.Debug-level logs provide highly-detailed
      information for troubleshooting, but their increased verbosity could
      incur additional costs (https://cloud.google.com/stackdriver/pricing)
      that might not be merited for all jobs.If unspecified, defaults to INFO.

  Fields:
    aspectSyncMode: Required. The sync mode for aspects.
    entrySyncMode: Required. The sync mode for entries.
    logLevel: Optional. The level of logs to write to Cloud Logging for this
      job.Debug-level logs provide highly-detailed information for
      troubleshooting, but their increased verbosity could incur additional
      costs (https://cloud.google.com/stackdriver/pricing) that might not be
      merited for all jobs.If unspecified, defaults to INFO.
    scope: Required. A boundary on the scope of impact that the metadata
      import job can have.
    sourceCreateTime: Optional. The time when the process that created the
      metadata import files began.
    sourceStorageUri: Optional. The URI of a Cloud Storage bucket or folder
      (beginning with gs:// and ending with /) that contains the metadata
      import files for this job.A metadata import file defines the values to
      set for each of the entries and aspects in a metadata import job. For
      more information about how to create a metadata import file and the file
      requirements, see Metadata import file
      (https://cloud.google.com/dataplex/docs/import-metadata#metadata-import-
      file).You can provide multiple metadata import files in the same
      metadata job. The bucket or folder must contain at least one metadata
      import file, in JSON Lines format (either .json or .jsonl file
      extension).In FULL entry sync mode, don't save the metadata import file
      in a folder named SOURCE_STORAGE_URI/deletions/.Caution: If the metadata
      import file contains no data, all entries and aspects that belong to the
      job's scope are deleted.
  """

  class AspectSyncModeValueValuesEnum(_messages.Enum):
    r"""Required. The sync mode for aspects.

    Values:
      SYNC_MODE_UNSPECIFIED: Sync mode unspecified.
      FULL: All resources in the job's scope are modified. If a resource
        exists in Dataplex Universal Catalog but isn't included in the
        metadata import file, the resource is deleted when you run the
        metadata job. Use this mode to perform a full sync of the set of
        entries in the job scope.This sync mode is supported for entries.
      INCREMENTAL: Only the resources that are explicitly included in the
        metadata import file are modified. Use this mode to modify a subset of
        resources while leaving unreferenced resources unchanged.This sync
        mode is supported for aspects.
      NONE: If entry sync mode is NONE, then aspects are modified according to
        the aspect sync mode. Other metadata that belongs to entries in the
        job's scope isn't modified.This sync mode is supported for entries.
    """
    SYNC_MODE_UNSPECIFIED = 0
    FULL = 1
    INCREMENTAL = 2
    NONE = 3

  class EntrySyncModeValueValuesEnum(_messages.Enum):
    r"""Required. The sync mode for entries.

    Values:
      SYNC_MODE_UNSPECIFIED: Sync mode unspecified.
      FULL: All resources in the job's scope are modified. If a resource
        exists in Dataplex Universal Catalog but isn't included in the
        metadata import file, the resource is deleted when you run the
        metadata job. Use this mode to perform a full sync of the set of
        entries in the job scope.This sync mode is supported for entries.
      INCREMENTAL: Only the resources that are explicitly included in the
        metadata import file are modified. Use this mode to modify a subset of
        resources while leaving unreferenced resources unchanged.This sync
        mode is supported for aspects.
      NONE: If entry sync mode is NONE, then aspects are modified according to
        the aspect sync mode. Other metadata that belongs to entries in the
        job's scope isn't modified.This sync mode is supported for entries.
    """
    SYNC_MODE_UNSPECIFIED = 0
    FULL = 1
    INCREMENTAL = 2
    NONE = 3

  class LogLevelValueValuesEnum(_messages.Enum):
    r"""Optional. The level of logs to write to Cloud Logging for this
    job.Debug-level logs provide highly-detailed information for
    troubleshooting, but their increased verbosity could incur additional
    costs (https://cloud.google.com/stackdriver/pricing) that might not be
    merited for all jobs.If unspecified, defaults to INFO.

    Values:
      LOG_LEVEL_UNSPECIFIED: Log level unspecified.
      DEBUG: Debug-level logging. Captures detailed logs for each import item.
        Use debug-level logging to troubleshoot issues with specific import
        items. For example, use debug-level logging to identify resources that
        are missing from the job scope, entries or aspects that don't conform
        to the associated entry type or aspect type, or other
        misconfigurations with the metadata import file.Depending on the size
        of your metadata job and the number of logs that are generated, debug-
        level logging might incur additional costs
        (https://cloud.google.com/stackdriver/pricing).
      INFO: Info-level logging. Captures logs at the overall job level.
        Includes aggregate logs about import items, but doesn't specify which
        import item has an error.
    """
    LOG_LEVEL_UNSPECIFIED = 0
    DEBUG = 1
    INFO = 2

  aspectSyncMode = _messages.EnumField('AspectSyncModeValueValuesEnum', 1)
  entrySyncMode = _messages.EnumField('EntrySyncModeValueValuesEnum', 2)
  logLevel = _messages.EnumField('LogLevelValueValuesEnum', 3)
  scope = _messages.MessageField('GoogleCloudDataplexV1MetadataJobImportJobSpecImportJobScope', 4)
  sourceCreateTime = _messages.StringField(5)
  sourceStorageUri = _messages.StringField(6)


class GoogleCloudDataplexV1MetadataJobImportJobSpecImportJobScope(_messages.Message):
  r"""A boundary on the scope of impact that the metadata import job can have.

  Fields:
    aspectTypes: Optional. The aspect types that are in scope for the import
      job, specified as relative resource names in the format projects/{projec
      t_number_or_id}/locations/{location_id}/aspectTypes/{aspect_type_id}.
      The job modifies only the aspects that belong to these aspect types.This
      field is required when creating an aspect-only import job.If the
      metadata import file attempts to modify an aspect whose type isn't
      included in this list, the import job is halted before modifying any
      entries or aspects.The location of an aspect type must either match the
      location of the job, or the aspect type must be global.
    entryGroups: Required. The entry groups that are in scope for the import
      job, specified as relative resource names in the format projects/{projec
      t_number_or_id}/locations/{location_id}/entryGroups/{entry_group_id}.
      Only entries and aspects that belong to the specified entry groups are
      affected by the job.The entry groups and the job must be in the same
      location.
    entryLinkTypes: Optional. The entry link types that are in scope for the
      import job, specified as relative resource names in the format projects/
      {project_number_or_id}/locations/{location_id}/entryLinkTypes/{entry_lin
      k_type_id}. The job modifies only the entryLinks that belong to these
      entry link types.If the metadata import file attempts to create or
      delete an entry link whose entry link type isn't included in this list,
      the import job will skip those entry links.
    entryTypes: Required. The entry types that are in scope for the import
      job, specified as relative resource names in the format projects/{projec
      t_number_or_id}/locations/{location_id}/entryTypes/{entry_type_id}. The
      job modifies only the entries and aspects that belong to these entry
      types.If the metadata import file attempts to modify an entry whose type
      isn't included in this list, the import job is halted before modifying
      any entries or aspects.The location of an entry type must either match
      the location of the job, or the entry type must be global.
    glossaries: Optional. The glossaries that are in scope for the import job,
      specified as relative resource names in the format projects/{project_num
      ber_or_id}/locations/{location_id}/glossaries/{glossary_id}.While
      importing Business Glossary entries, the user must provide glossaries.
      While importing entries, the user does not have to provide glossaries.
      If the metadata import file attempts to modify Business Glossary entries
      whose glossary isn't included in this list, the import job will skip
      those entries.The location of a glossary must either match the location
      of the job, or the glossary must be global.
    referencedEntryScopes: Optional. Defines the scope of entries that can be
      referenced in the entry links.Currently, projects are supported as valid
      scopes. Format: projects/{project_number_or_id}If the metadata import
      file attempts to create an entry link which references an entry that is
      not in the scope, the import job will skip that entry link.
  """

  aspectTypes = _messages.StringField(1, repeated=True)
  entryGroups = _messages.StringField(2, repeated=True)
  entryLinkTypes = _messages.StringField(3, repeated=True)
  entryTypes = _messages.StringField(4, repeated=True)
  glossaries = _messages.StringField(5, repeated=True)
  referencedEntryScopes = _messages.StringField(6, repeated=True)


class GoogleCloudDataplexV1MetadataJobStatus(_messages.Message):
  r"""Metadata job status.

  Enums:
    StateValueValuesEnum: Output only. State of the metadata job.

  Fields:
    completionPercent: Output only. Progress tracking.
    message: Output only. Message relating to the progression of a metadata
      job.
    state: Output only. State of the metadata job.
    updateTime: Output only. The time when the status was updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the metadata job.

    Values:
      STATE_UNSPECIFIED: State unspecified.
      QUEUED: The job is queued.
      RUNNING: The job is running.
      CANCELING: The job is being canceled.
      CANCELED: The job is canceled.
      SUCCEEDED: The job succeeded.
      FAILED: The job failed.
      SUCCEEDED_WITH_ERRORS: The job completed with some errors.
    """
    STATE_UNSPECIFIED = 0
    QUEUED = 1
    RUNNING = 2
    CANCELING = 3
    CANCELED = 4
    SUCCEEDED = 5
    FAILED = 6
    SUCCEEDED_WITH_ERRORS = 7

  completionPercent = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  message = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  updateTime = _messages.StringField(4)


class GoogleCloudDataplexV1OperationMetadata(_messages.Message):
  r"""Represents the metadata of a long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to Code.CANCELLED.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class GoogleCloudDataplexV1Partition(_messages.Message):
  r"""Represents partition metadata contained within entity instances.

  Fields:
    etag: Optional. The etag for this partition.
    location: Required. Immutable. The location of the entity data within the
      partition, for example,
      gs://bucket/path/to/entity/key1=value1/key2=value2. Or
      projects//datasets//tables/
    name: Output only. Partition values used in the HTTP URL must be double
      encoded. For example, url_encode(url_encode(value)) can be used to
      encode "US:CA/CA#Sunnyvale so that the request URL ends with
      "/partitions/US%253ACA/CA%2523Sunnyvale". The name field in the response
      retains the encoded format.
    values: Required. Immutable. The set of values representing the partition,
      which correspond to the partition schema defined in the parent entity.
  """

  etag = _messages.StringField(1)
  location = _messages.StringField(2)
  name = _messages.StringField(3)
  values = _messages.StringField(4, repeated=True)


class GoogleCloudDataplexV1ResourceAccessSpec(_messages.Message):
  r"""ResourceAccessSpec holds the access control configuration to be enforced
  on the resources, for example, Cloud Storage bucket, BigQuery dataset,
  BigQuery table.

  Fields:
    owners: Optional. The set of principals to be granted owner role on the
      resource.
    readers: Optional. The format of strings follows the pattern followed by
      IAM in the bindings. user:{email}, serviceAccount:{email} group:{email}.
      The set of principals to be granted reader role on the resource.
    writers: Optional. The set of principals to be granted writer role on the
      resource.
  """

  owners = _messages.StringField(1, repeated=True)
  readers = _messages.StringField(2, repeated=True)
  writers = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1RunDataScanRequest(_messages.Message):
  r"""Run DataScan Request"""


class GoogleCloudDataplexV1RunDataScanResponse(_messages.Message):
  r"""Run DataScan Response.

  Fields:
    job: DataScanJob created by RunDataScan request.
  """

  job = _messages.MessageField('GoogleCloudDataplexV1DataScanJob', 1)


class GoogleCloudDataplexV1RunTaskRequest(_messages.Message):
  r"""A GoogleCloudDataplexV1RunTaskRequest object.

  Messages:
    ArgsValue: Optional. Execution spec arguments. If the map is left empty,
      the task will run with existing execution spec args from task
      definition. If the map contains an entry with a new key, the same will
      be added to existing set of args. If the map contains an entry with an
      existing arg key in task definition, the task will run with new arg
      value for that entry. Clearing an existing arg will require arg value to
      be explicitly set to a hyphen "-". The arg value cannot be empty.
    LabelsValue: Optional. User-defined labels for the task. If the map is
      left empty, the task will run with existing labels from task definition.
      If the map contains an entry with a new key, the same will be added to
      existing set of labels. If the map contains an entry with an existing
      label key in task definition, the task will run with new label value for
      that entry. Clearing an existing label will require label value to be
      explicitly set to a hyphen "-". The label value cannot be empty.

  Fields:
    args: Optional. Execution spec arguments. If the map is left empty, the
      task will run with existing execution spec args from task definition. If
      the map contains an entry with a new key, the same will be added to
      existing set of args. If the map contains an entry with an existing arg
      key in task definition, the task will run with new arg value for that
      entry. Clearing an existing arg will require arg value to be explicitly
      set to a hyphen "-". The arg value cannot be empty.
    labels: Optional. User-defined labels for the task. If the map is left
      empty, the task will run with existing labels from task definition. If
      the map contains an entry with a new key, the same will be added to
      existing set of labels. If the map contains an entry with an existing
      label key in task definition, the task will run with new label value for
      that entry. Clearing an existing label will require label value to be
      explicitly set to a hyphen "-". The label value cannot be empty.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ArgsValue(_messages.Message):
    r"""Optional. Execution spec arguments. If the map is left empty, the task
    will run with existing execution spec args from task definition. If the
    map contains an entry with a new key, the same will be added to existing
    set of args. If the map contains an entry with an existing arg key in task
    definition, the task will run with new arg value for that entry. Clearing
    an existing arg will require arg value to be explicitly set to a hyphen
    "-". The arg value cannot be empty.

    Messages:
      AdditionalProperty: An additional property for a ArgsValue object.

    Fields:
      additionalProperties: Additional properties of type ArgsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ArgsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the task. If the map is left empty,
    the task will run with existing labels from task definition. If the map
    contains an entry with a new key, the same will be added to existing set
    of labels. If the map contains an entry with an existing label key in task
    definition, the task will run with new label value for that entry.
    Clearing an existing label will require label value to be explicitly set
    to a hyphen "-". The label value cannot be empty.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  args = _messages.MessageField('ArgsValue', 1)
  labels = _messages.MessageField('LabelsValue', 2)


class GoogleCloudDataplexV1RunTaskResponse(_messages.Message):
  r"""A GoogleCloudDataplexV1RunTaskResponse object.

  Fields:
    job: Jobs created by RunTask API.
  """

  job = _messages.MessageField('GoogleCloudDataplexV1Job', 1)


class GoogleCloudDataplexV1ScannedData(_messages.Message):
  r"""The data scanned during processing (e.g. in incremental DataScan)

  Fields:
    incrementalField: The range denoted by values of an incremental field
  """

  incrementalField = _messages.MessageField('GoogleCloudDataplexV1ScannedDataIncrementalField', 1)


class GoogleCloudDataplexV1ScannedDataIncrementalField(_messages.Message):
  r"""A data range denoted by a pair of start/end values of a field.

  Fields:
    end: Output only. Value that marks the end of the range.
    field: Output only. The field that contains values which monotonically
      increases over time (e.g. a timestamp column).
    start: Output only. Value that marks the start of the range.
  """

  end = _messages.StringField(1)
  field = _messages.StringField(2)
  start = _messages.StringField(3)


class GoogleCloudDataplexV1Schema(_messages.Message):
  r"""Schema information describing the structure and layout of the data.

  Enums:
    PartitionStyleValueValuesEnum: Optional. The structure of paths containing
      partition data within the entity.

  Fields:
    fields: Optional. The sequence of fields describing data in table
      entities. Note: BigQuery SchemaFields are immutable.
    partitionFields: Optional. The sequence of fields describing the partition
      structure in entities. If this field is empty, there are no partitions
      within the data.
    partitionStyle: Optional. The structure of paths containing partition data
      within the entity.
    userManaged: Required. Set to true if user-managed or false if managed by
      Dataplex Universal Catalog. The default is false (managed by Dataplex
      Universal Catalog). Set to falseto enable Dataplex Universal Catalog
      discovery to update the schema. including new data discovery, schema
      inference, and schema evolution. Users retain the ability to input and
      edit the schema. Dataplex Universal Catalog treats schema input by the
      user as though produced by a previous Dataplex Universal Catalog
      discovery operation, and it will evolve the schema and take action based
      on that treatment. Set to true to fully manage the entity schema. This
      setting guarantees that Dataplex Universal Catalog will not change
      schema fields.
  """

  class PartitionStyleValueValuesEnum(_messages.Enum):
    r"""Optional. The structure of paths containing partition data within the
    entity.

    Values:
      PARTITION_STYLE_UNSPECIFIED: PartitionStyle unspecified
      HIVE_COMPATIBLE: Partitions are hive-compatible. Examples:
        gs://bucket/path/to/table/dt=2019-10-31/lang=en,
        gs://bucket/path/to/table/dt=2019-10-31/lang=en/late.
    """
    PARTITION_STYLE_UNSPECIFIED = 0
    HIVE_COMPATIBLE = 1

  fields = _messages.MessageField('GoogleCloudDataplexV1SchemaSchemaField', 1, repeated=True)
  partitionFields = _messages.MessageField('GoogleCloudDataplexV1SchemaPartitionField', 2, repeated=True)
  partitionStyle = _messages.EnumField('PartitionStyleValueValuesEnum', 3)
  userManaged = _messages.BooleanField(4)


class GoogleCloudDataplexV1SchemaPartitionField(_messages.Message):
  r"""Represents a key field within the entity's partition structure. You
  could have up to 20 partition fields, but only the first 10 partitions have
  the filtering ability due to performance consideration. Note: Partition
  fields are immutable.

  Enums:
    TypeValueValuesEnum: Required. Immutable. The type of field.

  Fields:
    name: Required. Partition field name must consist of letters, numbers, and
      underscores only, with a maximum of length of 256 characters, and must
      begin with a letter or underscore..
    type: Required. Immutable. The type of field.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The type of field.

    Values:
      TYPE_UNSPECIFIED: SchemaType unspecified.
      BOOLEAN: Boolean field.
      BYTE: Single byte numeric field.
      INT16: 16-bit numeric field.
      INT32: 32-bit numeric field.
      INT64: 64-bit numeric field.
      FLOAT: Floating point numeric field.
      DOUBLE: Double precision numeric field.
      DECIMAL: Real value numeric field.
      STRING: Sequence of characters field.
      BINARY: Sequence of bytes field.
      TIMESTAMP: Date and time field.
      DATE: Date field.
      TIME: Time field.
      RECORD: Structured field. Nested fields that define the structure of the
        map. If all nested fields are nullable, this field represents a union.
      NULL: Null field that does not have values.
    """
    TYPE_UNSPECIFIED = 0
    BOOLEAN = 1
    BYTE = 2
    INT16 = 3
    INT32 = 4
    INT64 = 5
    FLOAT = 6
    DOUBLE = 7
    DECIMAL = 8
    STRING = 9
    BINARY = 10
    TIMESTAMP = 11
    DATE = 12
    TIME = 13
    RECORD = 14
    NULL = 15

  name = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class GoogleCloudDataplexV1SchemaSchemaField(_messages.Message):
  r"""Represents a column field within a table schema.

  Enums:
    ModeValueValuesEnum: Required. Additional field semantics.
    TypeValueValuesEnum: Required. The type of field.

  Fields:
    description: Optional. User friendly field description. Must be less than
      or equal to 1024 characters.
    fields: Optional. Any nested field for complex types.
    mode: Required. Additional field semantics.
    name: Required. The name of the field. Must contain only letters, numbers
      and underscores, with a maximum length of 767 characters, and must begin
      with a letter or underscore.
    type: Required. The type of field.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""Required. Additional field semantics.

    Values:
      MODE_UNSPECIFIED: Mode unspecified.
      REQUIRED: The field has required semantics.
      NULLABLE: The field has optional semantics, and may be null.
      REPEATED: The field has repeated (0 or more) semantics, and is a list of
        values.
    """
    MODE_UNSPECIFIED = 0
    REQUIRED = 1
    NULLABLE = 2
    REPEATED = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of field.

    Values:
      TYPE_UNSPECIFIED: SchemaType unspecified.
      BOOLEAN: Boolean field.
      BYTE: Single byte numeric field.
      INT16: 16-bit numeric field.
      INT32: 32-bit numeric field.
      INT64: 64-bit numeric field.
      FLOAT: Floating point numeric field.
      DOUBLE: Double precision numeric field.
      DECIMAL: Real value numeric field.
      STRING: Sequence of characters field.
      BINARY: Sequence of bytes field.
      TIMESTAMP: Date and time field.
      DATE: Date field.
      TIME: Time field.
      RECORD: Structured field. Nested fields that define the structure of the
        map. If all nested fields are nullable, this field represents a union.
      NULL: Null field that does not have values.
    """
    TYPE_UNSPECIFIED = 0
    BOOLEAN = 1
    BYTE = 2
    INT16 = 3
    INT32 = 4
    INT64 = 5
    FLOAT = 6
    DOUBLE = 7
    DECIMAL = 8
    STRING = 9
    BINARY = 10
    TIMESTAMP = 11
    DATE = 12
    TIME = 13
    RECORD = 14
    NULL = 15

  description = _messages.StringField(1)
  fields = _messages.MessageField('GoogleCloudDataplexV1SchemaSchemaField', 2, repeated=True)
  mode = _messages.EnumField('ModeValueValuesEnum', 3)
  name = _messages.StringField(4)
  type = _messages.EnumField('TypeValueValuesEnum', 5)


class GoogleCloudDataplexV1SearchEntriesResponse(_messages.Message):
  r"""A GoogleCloudDataplexV1SearchEntriesResponse object.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    results: The results matching the search query.
    totalSize: The estimated total number of matching entries. This number
      isn't guaranteed to be accurate.
    unreachable: Locations that the service couldn't reach. Search results
      don't include data from these locations.
  """

  nextPageToken = _messages.StringField(1)
  results = _messages.MessageField('GoogleCloudDataplexV1SearchEntriesResult', 2, repeated=True)
  totalSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  unreachable = _messages.StringField(4, repeated=True)


class GoogleCloudDataplexV1SearchEntriesResult(_messages.Message):
  r"""A single result of a SearchEntries request.

  Fields:
    dataplexEntry: A GoogleCloudDataplexV1Entry attribute.
    linkedResource: Linked resource name.
    snippets: Snippets.
  """

  dataplexEntry = _messages.MessageField('GoogleCloudDataplexV1Entry', 1)
  linkedResource = _messages.StringField(2)
  snippets = _messages.MessageField('GoogleCloudDataplexV1SearchEntriesResultSnippets', 3)


class GoogleCloudDataplexV1SearchEntriesResultSnippets(_messages.Message):
  r"""Snippets for the entry, contains HTML-style highlighting for matched
  tokens, will be used in UI.

  Fields:
    dataplexEntry: Entry
  """

  dataplexEntry = _messages.MessageField('GoogleCloudDataplexV1Entry', 1)


class GoogleCloudDataplexV1Session(_messages.Message):
  r"""Represents an active analyze session running for a user.

  Enums:
    StateValueValuesEnum: Output only. State of Session

  Fields:
    createTime: Output only. Session start time.
    name: Output only. The relative resource name of the content, of the form:
      projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environmen
      t/{environment_id}/sessions/{session_id}
    state: Output only. State of Session
    userId: Output only. Email of user running the session.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of Session

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  userId = _messages.StringField(4)


class GoogleCloudDataplexV1SessionEvent(_messages.Message):
  r"""These messages contain information about sessions within an environment.
  The monitored resource is 'Environment'.

  Enums:
    TypeValueValuesEnum: The type of the event.

  Fields:
    eventSucceeded: The status of the event.
    fastStartupEnabled: If the session is associated with an environment with
      fast startup enabled, and was created before being assigned to a user.
    message: The log message.
    query: The execution details of the query.
    sessionId: Unique identifier for the session.
    type: The type of the event.
    unassignedDuration: The idle duration of a warm pooled session before it
      is assigned to user.
    userId: The information about the user that created the session. It will
      be the email address of the user.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the event.

    Values:
      EVENT_TYPE_UNSPECIFIED: An unspecified event type.
      START: Event when the session is assigned to a user.
      STOP: Event for stop of a session.
      QUERY: Query events in the session.
      CREATE: Event for creation of a cluster. It is not yet assigned to a
        user. This comes before START in the sequence
    """
    EVENT_TYPE_UNSPECIFIED = 0
    START = 1
    STOP = 2
    QUERY = 3
    CREATE = 4

  eventSucceeded = _messages.BooleanField(1)
  fastStartupEnabled = _messages.BooleanField(2)
  message = _messages.StringField(3)
  query = _messages.MessageField('GoogleCloudDataplexV1SessionEventQueryDetail', 4)
  sessionId = _messages.StringField(5)
  type = _messages.EnumField('TypeValueValuesEnum', 6)
  unassignedDuration = _messages.StringField(7)
  userId = _messages.StringField(8)


class GoogleCloudDataplexV1SessionEventQueryDetail(_messages.Message):
  r"""Execution details of the query.

  Enums:
    EngineValueValuesEnum: Query Execution engine.

  Fields:
    dataProcessedBytes: The data processed by the query.
    duration: Time taken for execution of the query.
    engine: Query Execution engine.
    queryId: The unique Query id identifying the query.
    queryText: The query text executed.
    resultSizeBytes: The size of results the query produced.
  """

  class EngineValueValuesEnum(_messages.Enum):
    r"""Query Execution engine.

    Values:
      ENGINE_UNSPECIFIED: An unspecified Engine type.
      SPARK_SQL: Spark-sql engine is specified in Query.
      BIGQUERY: BigQuery engine is specified in Query.
    """
    ENGINE_UNSPECIFIED = 0
    SPARK_SQL = 1
    BIGQUERY = 2

  dataProcessedBytes = _messages.IntegerField(1)
  duration = _messages.StringField(2)
  engine = _messages.EnumField('EngineValueValuesEnum', 3)
  queryId = _messages.StringField(4)
  queryText = _messages.StringField(5)
  resultSizeBytes = _messages.IntegerField(6)


class GoogleCloudDataplexV1StorageAccess(_messages.Message):
  r"""Describes the access mechanism of the data within its storage location.

  Enums:
    ReadValueValuesEnum: Output only. Describes the read access mechanism of
      the data. Not user settable.

  Fields:
    read: Output only. Describes the read access mechanism of the data. Not
      user settable.
  """

  class ReadValueValuesEnum(_messages.Enum):
    r"""Output only. Describes the read access mechanism of the data. Not user
    settable.

    Values:
      ACCESS_MODE_UNSPECIFIED: Access mode unspecified.
      DIRECT: Default. Data is accessed directly using storage APIs.
      MANAGED: Data is accessed through a managed interface using BigQuery
        APIs.
    """
    ACCESS_MODE_UNSPECIFIED = 0
    DIRECT = 1
    MANAGED = 2

  read = _messages.EnumField('ReadValueValuesEnum', 1)


class GoogleCloudDataplexV1StorageFormat(_messages.Message):
  r"""Describes the format of the data within its storage location.

  Enums:
    CompressionFormatValueValuesEnum: Optional. The compression type
      associated with the stored data. If unspecified, the data is
      uncompressed.
    FormatValueValuesEnum: Output only. The data format associated with the
      stored data, which represents content type values. The value is inferred
      from mime type.

  Fields:
    compressionFormat: Optional. The compression type associated with the
      stored data. If unspecified, the data is uncompressed.
    csv: Optional. Additional information about CSV formatted data.
    format: Output only. The data format associated with the stored data,
      which represents content type values. The value is inferred from mime
      type.
    iceberg: Optional. Additional information about iceberg tables.
    json: Optional. Additional information about CSV formatted data.
    mimeType: Required. The mime type descriptor for the data. Must match the
      pattern {type}/{subtype}. Supported values: application/x-parquet
      application/x-avro application/x-orc application/x-tfrecord
      application/x-parquet+iceberg application/x-avro+iceberg
      application/x-orc+iceberg application/json application/{subtypes}
      text/csv text/ image/{image subtype} video/{video subtype} audio/{audio
      subtype}
  """

  class CompressionFormatValueValuesEnum(_messages.Enum):
    r"""Optional. The compression type associated with the stored data. If
    unspecified, the data is uncompressed.

    Values:
      COMPRESSION_FORMAT_UNSPECIFIED: CompressionFormat unspecified. Implies
        uncompressed data.
      GZIP: GZip compressed set of files.
      BZIP2: BZip2 compressed set of files.
    """
    COMPRESSION_FORMAT_UNSPECIFIED = 0
    GZIP = 1
    BZIP2 = 2

  class FormatValueValuesEnum(_messages.Enum):
    r"""Output only. The data format associated with the stored data, which
    represents content type values. The value is inferred from mime type.

    Values:
      FORMAT_UNSPECIFIED: Format unspecified.
      PARQUET: Parquet-formatted structured data.
      AVRO: Avro-formatted structured data.
      ORC: Orc-formatted structured data.
      CSV: Csv-formatted semi-structured data.
      JSON: Json-formatted semi-structured data.
      IMAGE: Image data formats (such as jpg and png).
      AUDIO: Audio data formats (such as mp3, and wav).
      VIDEO: Video data formats (such as mp4 and mpg).
      TEXT: Textual data formats (such as txt and xml).
      TFRECORD: TensorFlow record format.
      OTHER: Data that doesn't match a specific format.
      UNKNOWN: Data of an unknown format.
    """
    FORMAT_UNSPECIFIED = 0
    PARQUET = 1
    AVRO = 2
    ORC = 3
    CSV = 4
    JSON = 5
    IMAGE = 6
    AUDIO = 7
    VIDEO = 8
    TEXT = 9
    TFRECORD = 10
    OTHER = 11
    UNKNOWN = 12

  compressionFormat = _messages.EnumField('CompressionFormatValueValuesEnum', 1)
  csv = _messages.MessageField('GoogleCloudDataplexV1StorageFormatCsvOptions', 2)
  format = _messages.EnumField('FormatValueValuesEnum', 3)
  iceberg = _messages.MessageField('GoogleCloudDataplexV1StorageFormatIcebergOptions', 4)
  json = _messages.MessageField('GoogleCloudDataplexV1StorageFormatJsonOptions', 5)
  mimeType = _messages.StringField(6)


class GoogleCloudDataplexV1StorageFormatCsvOptions(_messages.Message):
  r"""Describes CSV and similar semi-structured data formats.

  Fields:
    delimiter: Optional. The delimiter used to separate values. Defaults to
      ','.
    encoding: Optional. The character encoding of the data. Accepts "US-
      ASCII", "UTF-8", and "ISO-8859-1". Defaults to UTF-8 if unspecified.
    headerRows: Optional. The number of rows to interpret as header rows that
      should be skipped when reading data rows. Defaults to 0.
    quote: Optional. The character used to quote column values. Accepts '"'
      (double quotation mark) or ''' (single quotation mark). Defaults to '"'
      (double quotation mark) if unspecified.
  """

  delimiter = _messages.StringField(1)
  encoding = _messages.StringField(2)
  headerRows = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  quote = _messages.StringField(4)


class GoogleCloudDataplexV1StorageFormatIcebergOptions(_messages.Message):
  r"""Describes Iceberg data format.

  Fields:
    metadataLocation: Optional. The location of where the iceberg metadata is
      present, must be within the table path
  """

  metadataLocation = _messages.StringField(1)


class GoogleCloudDataplexV1StorageFormatJsonOptions(_messages.Message):
  r"""Describes JSON data format.

  Fields:
    encoding: Optional. The character encoding of the data. Accepts "US-
      ASCII", "UTF-8" and "ISO-8859-1". Defaults to UTF-8 if not specified.
  """

  encoding = _messages.StringField(1)


class GoogleCloudDataplexV1Task(_messages.Message):
  r"""A task represents a user-visible job.

  Enums:
    StateValueValuesEnum: Output only. Current state of the task.

  Messages:
    LabelsValue: Optional. User-defined labels for the task.

  Fields:
    createTime: Output only. The time when the task was created.
    description: Optional. Description of the task.
    displayName: Optional. User friendly display name.
    executionSpec: Required. Spec related to how a task is executed.
    executionStatus: Output only. Status of the latest task executions.
    labels: Optional. User-defined labels for the task.
    name: Output only. The relative resource name of the task, of the form:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}/
      tasks/{task_id}.
    notebook: Config related to running scheduled Notebooks.
    spark: Config related to running custom Spark tasks.
    state: Output only. Current state of the task.
    triggerSpec: Required. Spec related to how often and when a task should be
      triggered.
    uid: Output only. System generated globally unique ID for the task. This
      ID will be different if the task is deleted and re-created with the same
      name.
    updateTime: Output only. The time when the task was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the task.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the task.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  executionSpec = _messages.MessageField('GoogleCloudDataplexV1TaskExecutionSpec', 4)
  executionStatus = _messages.MessageField('GoogleCloudDataplexV1TaskExecutionStatus', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  notebook = _messages.MessageField('GoogleCloudDataplexV1TaskNotebookTaskConfig', 8)
  spark = _messages.MessageField('GoogleCloudDataplexV1TaskSparkTaskConfig', 9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  triggerSpec = _messages.MessageField('GoogleCloudDataplexV1TaskTriggerSpec', 11)
  uid = _messages.StringField(12)
  updateTime = _messages.StringField(13)


class GoogleCloudDataplexV1TaskExecutionSpec(_messages.Message):
  r"""Execution related settings, like retry and service_account.

  Messages:
    ArgsValue: Optional. The arguments to pass to the task. The args can use
      placeholders of the format ${placeholder} as part of key/value string.
      These will be interpolated before passing the args to the driver.
      Currently supported placeholders: - ${task_id} - ${job_time} To pass
      positional args, set the key as TASK_ARGS. The value should be a comma-
      separated string of all the positional arguments. To use a delimiter
      other than comma, refer to
      https://cloud.google.com/sdk/gcloud/reference/topic/escaping. In case of
      other keys being present in the args, then TASK_ARGS will be passed as
      the last argument.

  Fields:
    args: Optional. The arguments to pass to the task. The args can use
      placeholders of the format ${placeholder} as part of key/value string.
      These will be interpolated before passing the args to the driver.
      Currently supported placeholders: - ${task_id} - ${job_time} To pass
      positional args, set the key as TASK_ARGS. The value should be a comma-
      separated string of all the positional arguments. To use a delimiter
      other than comma, refer to
      https://cloud.google.com/sdk/gcloud/reference/topic/escaping. In case of
      other keys being present in the args, then TASK_ARGS will be passed as
      the last argument.
    kmsKey: Optional. The Cloud KMS key to use for encryption, of the form:
      projects/{project_number}/locations/{location_id}/keyRings/{key-ring-
      name}/cryptoKeys/{key-name}.
    maxJobExecutionLifetime: Optional. The maximum duration after which the
      job execution is expired.
    project: Optional. The project in which jobs are run. By default, the
      project containing the Lake is used. If a project is provided, the
      ExecutionSpec.service_account must belong to this project.
    serviceAccount: Required. Service account to use to execute a task. If not
      provided, the default Compute service account for the project is used.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ArgsValue(_messages.Message):
    r"""Optional. The arguments to pass to the task. The args can use
    placeholders of the format ${placeholder} as part of key/value string.
    These will be interpolated before passing the args to the driver.
    Currently supported placeholders: - ${task_id} - ${job_time} To pass
    positional args, set the key as TASK_ARGS. The value should be a comma-
    separated string of all the positional arguments. To use a delimiter other
    than comma, refer to
    https://cloud.google.com/sdk/gcloud/reference/topic/escaping. In case of
    other keys being present in the args, then TASK_ARGS will be passed as the
    last argument.

    Messages:
      AdditionalProperty: An additional property for a ArgsValue object.

    Fields:
      additionalProperties: Additional properties of type ArgsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ArgsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  args = _messages.MessageField('ArgsValue', 1)
  kmsKey = _messages.StringField(2)
  maxJobExecutionLifetime = _messages.StringField(3)
  project = _messages.StringField(4)
  serviceAccount = _messages.StringField(5)


class GoogleCloudDataplexV1TaskExecutionStatus(_messages.Message):
  r"""Status of the task execution (e.g. Jobs).

  Fields:
    latestJob: Output only. latest job execution
    updateTime: Output only. Last update time of the status.
  """

  latestJob = _messages.MessageField('GoogleCloudDataplexV1Job', 1)
  updateTime = _messages.StringField(2)


class GoogleCloudDataplexV1TaskInfrastructureSpec(_messages.Message):
  r"""Configuration for the underlying infrastructure used to run workloads.

  Fields:
    batch: Compute resources needed for a Task when using Dataproc Serverless.
    containerImage: Container Image Runtime Configuration.
    vpcNetwork: Vpc network.
  """

  batch = _messages.MessageField('GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResources', 1)
  containerImage = _messages.MessageField('GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntime', 2)
  vpcNetwork = _messages.MessageField('GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetwork', 3)


class GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResources(_messages.Message):
  r"""Batch compute resources associated with the task.

  Fields:
    executorsCount: Optional. Total number of job executors. Executor Count
      should be between 2 and 100. Default=2
    maxExecutorsCount: Optional. Max configurable executors. If
      max_executors_count > executors_count, then auto-scaling is enabled. Max
      Executor Count should be between 2 and 1000. Default=1000
  """

  executorsCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  maxExecutorsCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntime(_messages.Message):
  r"""Container Image Runtime Configuration used with Batch execution.

  Messages:
    PropertiesValue: Optional. Override to common configuration of open source
      components installed on the Dataproc cluster. The properties to set on
      daemon config files. Property keys are specified in prefix:property
      format, for example core:hadoop.tmp.dir. For more information, see
      Cluster properties
      (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).

  Fields:
    image: Optional. Container image to use.
    javaJars: Optional. A list of Java JARS to add to the classpath. Valid
      input includes Cloud Storage URIs to Jar binaries. For example,
      gs://bucket-name/my/path/to/file.jar
    properties: Optional. Override to common configuration of open source
      components installed on the Dataproc cluster. The properties to set on
      daemon config files. Property keys are specified in prefix:property
      format, for example core:hadoop.tmp.dir. For more information, see
      Cluster properties
      (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
    pythonPackages: Optional. A list of python packages to be installed. Valid
      formats include Cloud Storage URI to a PIP installable library. For
      example, gs://bucket-name/my/path/to/lib.tar.gz
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. Override to common configuration of open source components
    installed on the Dataproc cluster. The properties to set on daemon config
    files. Property keys are specified in prefix:property format, for example
    core:hadoop.tmp.dir. For more information, see Cluster properties
    (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  image = _messages.StringField(1)
  javaJars = _messages.StringField(2, repeated=True)
  properties = _messages.MessageField('PropertiesValue', 3)
  pythonPackages = _messages.StringField(4, repeated=True)


class GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetwork(_messages.Message):
  r"""Cloud VPC Network used to run the infrastructure.

  Fields:
    network: Optional. The Cloud VPC network in which the job is run. By
      default, the Cloud VPC network named Default within the project is used.
    networkTags: Optional. List of network tags to apply to the job.
    subNetwork: Optional. The Cloud VPC sub-network in which the job is run.
  """

  network = _messages.StringField(1)
  networkTags = _messages.StringField(2, repeated=True)
  subNetwork = _messages.StringField(3)


class GoogleCloudDataplexV1TaskNotebookTaskConfig(_messages.Message):
  r"""Config for running scheduled notebooks.

  Fields:
    archiveUris: Optional. Cloud Storage URIs of archives to be extracted into
      the working directory of each executor. Supported file types: .jar,
      .tar, .tar.gz, .tgz, and .zip.
    fileUris: Optional. Cloud Storage URIs of files to be placed in the
      working directory of each executor.
    infrastructureSpec: Optional. Infrastructure specification for the
      execution.
    notebook: Required. Path to input notebook. This can be the Cloud Storage
      URI of the notebook file or the path to a Notebook Content. The
      execution args are accessible as environment variables (TASK_key=value).
  """

  archiveUris = _messages.StringField(1, repeated=True)
  fileUris = _messages.StringField(2, repeated=True)
  infrastructureSpec = _messages.MessageField('GoogleCloudDataplexV1TaskInfrastructureSpec', 3)
  notebook = _messages.StringField(4)


class GoogleCloudDataplexV1TaskSparkTaskConfig(_messages.Message):
  r"""User-specified config for running a Spark task.

  Fields:
    archiveUris: Optional. Cloud Storage URIs of archives to be extracted into
      the working directory of each executor. Supported file types: .jar,
      .tar, .tar.gz, .tgz, and .zip.
    fileUris: Optional. Cloud Storage URIs of files to be placed in the
      working directory of each executor.
    infrastructureSpec: Optional. Infrastructure specification for the
      execution.
    mainClass: The name of the driver's main class. The jar file that contains
      the class must be in the default CLASSPATH or specified in
      jar_file_uris. The execution args are passed in as a sequence of named
      process arguments (--key=value).
    mainJarFileUri: The Cloud Storage URI of the jar file that contains the
      main class. The execution args are passed in as a sequence of named
      process arguments (--key=value).
    pythonScriptFile: The Gcloud Storage URI of the main Python file to use as
      the driver. Must be a .py file. The execution args are passed in as a
      sequence of named process arguments (--key=value).
    sqlScript: The query text. The execution args are used to declare a set of
      script variables (set key="value";).
    sqlScriptFile: A reference to a query file. This should be the Cloud
      Storage URI of the query file. The execution args are used to declare a
      set of script variables (set key="value";).
  """

  archiveUris = _messages.StringField(1, repeated=True)
  fileUris = _messages.StringField(2, repeated=True)
  infrastructureSpec = _messages.MessageField('GoogleCloudDataplexV1TaskInfrastructureSpec', 3)
  mainClass = _messages.StringField(4)
  mainJarFileUri = _messages.StringField(5)
  pythonScriptFile = _messages.StringField(6)
  sqlScript = _messages.StringField(7)
  sqlScriptFile = _messages.StringField(8)


class GoogleCloudDataplexV1TaskTriggerSpec(_messages.Message):
  r"""Task scheduling and trigger settings.

  Enums:
    TypeValueValuesEnum: Required. Immutable. Trigger type of the user-
      specified Task.

  Fields:
    disabled: Optional. Prevent the task from executing. This does not cancel
      already running tasks. It is intended to temporarily disable RECURRING
      tasks.
    maxRetries: Optional. Number of retry attempts before aborting. Set to
      zero to never attempt to retry a failed task.
    schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for
      running tasks periodically. To explicitly set a timezone to the cron
      tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or
      "TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string
      from IANA time zone database. For example, CRON_TZ=America/New_York 1 *
      * * *, or TZ=America/New_York 1 * * * *. This field is required for
      RECURRING tasks.
    startTime: Optional. The first run of the task will be after this time. If
      not specified, the task will run shortly after being submitted if
      ON_DEMAND and based on the schedule if RECURRING.
    type: Required. Immutable. Trigger type of the user-specified Task.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. Trigger type of the user-specified Task.

    Values:
      TYPE_UNSPECIFIED: Unspecified trigger type.
      ON_DEMAND: The task runs one-time shortly after Task Creation.
      RECURRING: The task is scheduled to run periodically.
    """
    TYPE_UNSPECIFIED = 0
    ON_DEMAND = 1
    RECURRING = 2

  disabled = _messages.BooleanField(1)
  maxRetries = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  schedule = _messages.StringField(3)
  startTime = _messages.StringField(4)
  type = _messages.EnumField('TypeValueValuesEnum', 5)


class GoogleCloudDataplexV1Trigger(_messages.Message):
  r"""DataScan scheduling and trigger settings.

  Fields:
    onDemand: The scan runs once via RunDataScan API.
    oneTime: The scan runs once, and does not create an associated ScanJob
      child resource.
    schedule: The scan is scheduled to run periodically.
  """

  onDemand = _messages.MessageField('GoogleCloudDataplexV1TriggerOnDemand', 1)
  oneTime = _messages.MessageField('GoogleCloudDataplexV1TriggerOneTime', 2)
  schedule = _messages.MessageField('GoogleCloudDataplexV1TriggerSchedule', 3)


class GoogleCloudDataplexV1TriggerOnDemand(_messages.Message):
  r"""The scan runs once via RunDataScan API."""


class GoogleCloudDataplexV1TriggerOneTime(_messages.Message):
  r"""The scan runs once using create API.

  Fields:
    ttlAfterScanCompletion: Optional. Time to live for OneTime scans. default
      value is 24 hours, minimum value is 0 seconds, and maximum value is 365
      days. The time is calculated from the data scan job completion time. If
      value is set as 0 seconds, the scan will be immediately deleted upon job
      completion, regardless of whether the job succeeded or failed.
  """

  ttlAfterScanCompletion = _messages.StringField(1)


class GoogleCloudDataplexV1TriggerSchedule(_messages.Message):
  r"""The scan is scheduled to run periodically.

  Fields:
    cron: Required. Cron (https://en.wikipedia.org/wiki/Cron) schedule for
      running scans periodically.To explicitly set a timezone in the cron tab,
      apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or
      "TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string
      from IANA time zone database (wikipedia
      (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones#List)).
      For example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York
      1 * * * *.This field is required for Schedule scans.
  """

  cron = _messages.StringField(1)


class GoogleCloudDataplexV1Zone(_messages.Message):
  r"""A zone represents a logical group of related assets within a lake. A
  zone can be used to map to organizational structure or represent stages of
  data readiness from raw to curated. It provides managing behavior that is
  shared or inherited by all contained assets.

  Enums:
    StateValueValuesEnum: Output only. Current state of the zone.
    TypeValueValuesEnum: Required. Immutable. The type of the zone.

  Messages:
    LabelsValue: Optional. User defined labels for the zone.

  Fields:
    assetStatus: Output only. Aggregated status of the underlying assets of
      the zone.
    createTime: Output only. The time when the zone was created.
    description: Optional. Description of the zone.
    discoverySpec: Optional. Specification of the discovery feature applied to
      data in this zone.
    displayName: Optional. User friendly display name.
    labels: Optional. User defined labels for the zone.
    name: Output only. The relative resource name of the zone, of the form: pr
      ojects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{z
      one_id}.
    resourceSpec: Required. Specification of the resources that are referenced
      by the assets within this zone.
    state: Output only. Current state of the zone.
    type: Required. Immutable. The type of the zone.
    uid: Output only. System generated globally unique ID for the zone. This
      ID will be different if the zone is deleted and re-created with the same
      name.
    updateTime: Output only. The time when the zone was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the zone.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The type of the zone.

    Values:
      TYPE_UNSPECIFIED: Zone type not specified.
      RAW: A zone that contains data that needs further processing before it
        is considered generally ready for consumption and analytics workloads.
      CURATED: A zone that contains data that is considered to be ready for
        broader consumption and analytics workloads. Curated structured data
        stored in Cloud Storage must conform to certain file formats (parquet,
        avro and orc) and organized in a hive-compatible directory layout.
    """
    TYPE_UNSPECIFIED = 0
    RAW = 1
    CURATED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User defined labels for the zone.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  assetStatus = _messages.MessageField('GoogleCloudDataplexV1AssetStatus', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  discoverySpec = _messages.MessageField('GoogleCloudDataplexV1ZoneDiscoverySpec', 4)
  displayName = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  resourceSpec = _messages.MessageField('GoogleCloudDataplexV1ZoneResourceSpec', 8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  type = _messages.EnumField('TypeValueValuesEnum', 10)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class GoogleCloudDataplexV1ZoneDiscoverySpec(_messages.Message):
  r"""Settings to manage the metadata discovery and publishing in a zone.

  Fields:
    csvOptions: Optional. Configuration for CSV data.
    enabled: Required. Whether discovery is enabled.
    excludePatterns: Optional. The list of patterns to apply for selecting
      data to exclude during discovery. For Cloud Storage bucket assets, these
      are interpreted as glob patterns used to match object names. For
      BigQuery dataset assets, these are interpreted as patterns to match
      table names.
    includePatterns: Optional. The list of patterns to apply for selecting
      data to include during discovery if only a subset of the data should
      considered. For Cloud Storage bucket assets, these are interpreted as
      glob patterns used to match object names. For BigQuery dataset assets,
      these are interpreted as patterns to match table names.
    jsonOptions: Optional. Configuration for Json data.
    schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for
      running discovery periodically. Successive discovery runs must be
      scheduled at least 60 minutes apart. The default value is to run
      discovery every 60 minutes.To explicitly set a timezone to the cron tab,
      apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or
      TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string
      from IANA time zone database. For example, CRON_TZ=America/New_York 1 *
      * * *, or TZ=America/New_York 1 * * * *.
  """

  csvOptions = _messages.MessageField('GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptions', 1)
  enabled = _messages.BooleanField(2)
  excludePatterns = _messages.StringField(3, repeated=True)
  includePatterns = _messages.StringField(4, repeated=True)
  jsonOptions = _messages.MessageField('GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptions', 5)
  schedule = _messages.StringField(6)


class GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptions(_messages.Message):
  r"""Describe CSV and similar semi-structured data formats.

  Fields:
    delimiter: Optional. The delimiter being used to separate values. This
      defaults to ','.
    disableTypeInference: Optional. Whether to disable the inference of data
      type for CSV data. If true, all columns will be registered as strings.
    encoding: Optional. The character encoding of the data. The default is
      UTF-8.
    headerRows: Optional. The number of rows to interpret as header rows that
      should be skipped when reading data rows.
  """

  delimiter = _messages.StringField(1)
  disableTypeInference = _messages.BooleanField(2)
  encoding = _messages.StringField(3)
  headerRows = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptions(_messages.Message):
  r"""Describe JSON data format.

  Fields:
    disableTypeInference: Optional. Whether to disable the inference of data
      type for Json data. If true, all columns will be registered as their
      primitive types (strings, number or boolean).
    encoding: Optional. The character encoding of the data. The default is
      UTF-8.
  """

  disableTypeInference = _messages.BooleanField(1)
  encoding = _messages.StringField(2)


class GoogleCloudDataplexV1ZoneResourceSpec(_messages.Message):
  r"""Settings for resources attached as assets within a zone.

  Enums:
    LocationTypeValueValuesEnum: Required. Immutable. The location type of the
      resources that are allowed to be attached to the assets within this
      zone.

  Fields:
    locationType: Required. Immutable. The location type of the resources that
      are allowed to be attached to the assets within this zone.
  """

  class LocationTypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The location type of the resources that are
    allowed to be attached to the assets within this zone.

    Values:
      LOCATION_TYPE_UNSPECIFIED: Unspecified location type.
      SINGLE_REGION: Resources that are associated with a single region.
      MULTI_REGION: Resources that are associated with a multi-region
        location.
    """
    LOCATION_TYPE_UNSPECIFIED = 0
    SINGLE_REGION = 1
    MULTI_REGION = 2

  locationType = _messages.EnumField('LocationTypeValueValuesEnum', 1)


class GoogleCloudLocationListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('GoogleCloudLocationLocation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudLocationLocation(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: "us-east1".
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: "projects/example-project/locations/us-
      east1"
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class GoogleIamV1AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.If there are AuditConfigs for both allServices and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, storage.googleapis.com, cloudsql.googleapis.com. allServices is
      a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('GoogleIamV1AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class GoogleIamV1AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class GoogleIamV1Binding(_messages.Message):
  r"""Associates members, or principals, with a role.

  Fields:
    condition: The condition that is associated with this binding.If the
      condition evaluates to true, then this binding applies to the current
      request.If the condition evaluates to false, then this binding does not
      apply to the current request. However, a different role binding might
      grant the same role to one or more of the principals in this binding.To
      learn which resources support conditions in their IAM policies, see the
      IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. members can have the following values: allUsers: A special
      identifier that represents anyone who is on the internet; with or
      without a Google account. allAuthenticatedUsers: A special identifier
      that represents anyone who is authenticated with a Google account or a
      service account. Does not include identities that come from external
      identity providers (IdPs) through identity federation. user:{emailid}:
      An email address that represents a specific Google account. For example,
      alice@example.com . serviceAccount:{emailid}: An email address that
      represents a Google service account. For example, my-other-
      app@appspot.gserviceaccount.com.
      serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]: An
      identifier for a Kubernetes service account
      (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-
      service-accounts). For example, my-project.svc.id.goog[my-namespace/my-
      kubernetes-sa]. group:{emailid}: An email address that represents a
      Google group. For example, admins@example.com. domain:{domain}: The G
      Suite domain (primary) that represents all the users of that domain. For
      example, google.com or example.com. principal://iam.googleapis.com/locat
      ions/global/workforcePools/{pool_id}/subject/{subject_attribute_value}:
      A single identity in a workforce identity pool. principalSet://iam.googl
      eapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}:
      All workforce identities in a group. principalSet://iam.googleapis.com/l
      ocations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{att
      ribute_value}: All workforce identities with a specific attribute value.
      principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_
      id}/*: All identities in a workforce identity pool. principal://iam.goog
      leapis.com/projects/{project_number}/locations/global/workloadIdentityPo
      ols/{pool_id}/subject/{subject_attribute_value}: A single identity in a
      workload identity pool. principalSet://iam.googleapis.com/projects/{proj
      ect_number}/locations/global/workloadIdentityPools/{pool_id}/group/{grou
      p_id}: A workload identity pool group. principalSet://iam.googleapis.com
      /projects/{project_number}/locations/global/workloadIdentityPools/{pool_
      id}/attribute.{attribute_name}/{attribute_value}: All identities in a
      workload identity pool with a certain attribute. principalSet://iam.goog
      leapis.com/projects/{project_number}/locations/global/workloadIdentityPo
      ols/{pool_id}/*: All identities in a workload identity pool.
      deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, alice@example.com?uid=123456789012345678901. If the user is
      recovered, this value reverts to user:{emailid} and the recovered user
      retains the role in the binding.
      deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus
      unique identifier) representing a service account that has been recently
      deleted. For example, my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901. If the
      service account is undeleted, this value reverts to
      serviceAccount:{emailid} and the undeleted service account retains the
      role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email
      address (plus unique identifier) representing a Google group that has
      been recently deleted. For example,
      admins@example.com?uid=123456789012345678901. If the group is recovered,
      this value reverts to group:{emailid} and the recovered group retains
      the role in the binding. deleted:principal://iam.googleapis.com/location
      s/global/workforcePools/{pool_id}/subject/{subject_attribute_value}:
      Deleted single identity in a workforce identity pool. For example, delet
      ed:principal://iam.googleapis.com/locations/global/workforcePools/my-
      pool-id/subject/my-subject-attribute-value.
    role: Role that is assigned to the list of members, or principals. For
      example, roles/viewer, roles/editor, or roles/owner.For an overview of
      the IAM roles and permissions, see the IAM documentation
      (https://cloud.google.com/iam/docs/roles-overview). For a list of the
      available pre-defined roles, see here
      (https://cloud.google.com/iam/docs/understanding-roles).
  """

  condition = _messages.MessageField('GoogleTypeExpr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class GoogleIamV1Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources.A Policy is a collection of bindings. A
  binding binds one or more members, or principals, to a single role.
  Principals can be user accounts, service accounts, Google groups, and
  domains (such as G Suite). A role is a named list of permissions; each role
  can be an IAM predefined role or a user-created custom role.For some types
  of Google Cloud resources, a binding can also specify a condition, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to true. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the IAM documentation
  (https://cloud.google.com/iam/help/conditions/resource-policies).JSON
  example: { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } YAML example: bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the IAM
  documentation (https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of members, or principals, with a role.
      Optionally, may specify a condition that determines how and when the
      bindings are applied. Each of the bindings must contain at least one
      principal.The bindings in a Policy can refer to up to 1,500 principals;
      up to 250 of these principals can be Google groups. Each occurrence of a
      principal counts towards these limits. For example, if the bindings
      grant 50 different roles to user:alice@example.com, and not to any other
      principal, then you can add another 1,450 principals to the bindings in
      the Policy.
    etag: etag is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the etag in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An etag is returned in the response to getIamPolicy, and
      systems are expected to put that etag in the request to setIamPolicy to
      ensure that their change will be applied to the same version of the
      policy.Important: If you use IAM Conditions, you must include the etag
      field whenever you call setIamPolicy. If you omit this field, then IAM
      allows you to overwrite a version 3 policy with a version 1 policy, and
      all of the conditions in the version 3 policy are lost.
    version: Specifies the format of the policy.Valid values are 0, 1, and 3.
      Requests that specify an invalid value are rejected.Any operation that
      affects conditional role bindings must specify version 3. This
      requirement applies to the following operations: Getting a policy that
      includes a conditional role binding Adding a conditional role binding to
      a policy Changing a conditional role binding in a policy Removing any
      role binding, with or without a condition, from a policy that includes
      conditionsImportant: If you use IAM Conditions, you must include the
      etag field whenever you call setIamPolicy. If you omit this field, then
      IAM allows you to overwrite a version 3 policy with a version 1 policy,
      and all of the conditions in the version 3 policy are lost.If a policy
      does not include any conditions, operations on that policy may specify
      any valid version or leave the field unset.To learn which resources
      support conditions in their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
  """

  auditConfigs = _messages.MessageField('GoogleIamV1AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('GoogleIamV1Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleIamV1SetIamPolicyRequest(_messages.Message):
  r"""Request message for SetIamPolicy method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the resource. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used:paths: "bindings, etag"
  """

  policy = _messages.MessageField('GoogleIamV1Policy', 1)
  updateMask = _messages.StringField(2)


class GoogleIamV1TestIamPermissionsRequest(_messages.Message):
  r"""Request message for TestIamPermissions method.

  Fields:
    permissions: The set of permissions to check for the resource. Permissions
      with wildcards (such as * or storage.*) are not allowed. For more
      information see IAM Overview
      (https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleIamV1TestIamPermissionsResponse(_messages.Message):
  r"""Response message for TestIamPermissions method.

  Fields:
    permissions: A subset of TestPermissionsRequest.permissions that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleLongrunningCancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets ListOperationsRequest.return_partial_success and reads
      across collections. For example, when attempting to list all resources
      across all supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as Delete, the response
      is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.

  Fields:
    done: If the value is false, it means the operation is still in progress.
      If true, the operation is completed, and either error or response is
      available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the name should be a resource name ending with operations/{unique_id}.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as Delete, the response
      is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as Delete, the response is
    google.protobuf.Empty. If the original method is standard
    Get/Create/Update, the response should be the resource. For other methods,
    the response should have the type XxxResponse, where Xxx is the original
    method name. For example, if the original method name is TakeSnapshot(),
    the inferred response type is TakeSnapshotResponse.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleRpcStatus(_messages.Message):
  r"""The Status type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by gRPC (https://github.com/grpc). Each Status message contains three
  pieces of data: error code, error message, and error details.You can find
  out more about this error model and how to work with it in the API Design
  Guide (https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeExpr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec.Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
encoding.AddCustomJsonFieldMapping(
    DataplexOrganizationsLocationsEncryptionConfigsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsAspectTypesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsChangeRequestsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsDataAttributeBindingsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsDataProductsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsDataScansGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsDataTaxonomiesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsDataTaxonomiesAttributesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsEntryGroupsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsEntryLinkTypesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsEntryTypesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsGlossariesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsGlossariesCategoriesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsGlossariesTermsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsGovernanceRulesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsLakesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsLakesContentGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsLakesContentitemsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsLakesEnvironmentsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsLakesTasksGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsLakesZonesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataplexProjectsLocationsLakesZonesAssetsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
