/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.Bundle;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.TimeDetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class UtilDetailsProvider
extends DetailsProvider.Basic {
    private static final String LOGGER_MASK = "java.util.logging.Logger+";
    private static final String LEVEL_MASK = "java.util.logging.Level+";
    private static final String LOCALE_MASK = "java.util.Locale";
    private static final String DATE_MASK = "java.util.Date+";
    private static final String TIMEZONE_MASK = "java.util.TimeZone+";
    private static final String PATTERN_MASK = "java.util.regex.Pattern";
    private static final String CURRENCY_MASK = "java.util.Currency";
    private static final String ZIPENTRY_MASK = "java.util.zip.ZipEntry+";
    private static final String LOGRECORD_MASK = "java.util.logging.LogRecord";
    private static final String ATTR_NAME_MASK = "java.util.jar.Attributes$Name";
    private static final String COLLECTION_MASK = "java.util.AbstractCollection+";
    private static final String MAP_MASK = "java.util.AbstractMap+";
    private static final String A_SET_MASK = "java.util.AbstractSet+";
    private static final String VECTOR_MASK = "java.util.Vector+";
    private static final String SET_MASK = "java.util.HashSet+";
    private static final String TREESET_MASK = "java.util.TreeSet";
    private static final String HASHTABLE_MASK = "java.util.Hashtable+";
    private static final String PROP_MASK = "java.util.Properties+";
    private static final String UUID_MASK = "java.util.UUID";
    private static final String UNMOD_COLLECTION_MASK = "java.util.Collections$UnmodifiableCollection+";
    private static final String UNMOD_MAP_MASK = "java.util.Collections$UnmodifiableMap+";
    private static final String ARRAYS_LIST_MASK = "java.util.Arrays$ArrayList";
    private static final String EMPTY_LIST_MASK = "java.util.Collections$EmptyList";
    private static final String EMPTY_SET_MASK = "java.util.Collections$EmptySet";
    private static final String EMPTY_MAP_MASK = "java.util.Collections$EmptyMap";
    private static final String SINGLETON_LIST_MASK = "java.util.Collections$SingletonList";
    private static final String SINGLETON_SET_MASK = "java.util.Collections$SingletonSet";
    private static final String SINGLETON_MAP_MASK = "java.util.Collections$SingletonMap";
    private static final String SYN_COLLECTION_MASK = "java.util.Collections$SynchronizedCollection+";
    private static final String SYN_MAP_MASK = "java.util.Collections$SynchronizedMap+";
    private static final String DEQUE_MASK = "java.util.ArrayDeque+";
    private static final String ENUM_SET_MASK = "java.util.RegularEnumSet";
    private static final String CONCURRENT_MAP_MASK = "java.util.concurrent.ConcurrentHashMap";
    private static final String SET12_MASK = "java.util.ImmutableCollections$Set12";
    private static final String LIST12_MASK = "java.util.ImmutableCollections$List12";
    private static final String LISTN_MASK = "java.util.ImmutableCollections$ListN";
    private static final String MAP1_MASK = "java.util.ImmutableCollections$Map1";
    private Formatter formatter = new SimpleFormatter();

    public UtilDetailsProvider() {
        super(LOGGER_MASK, LEVEL_MASK, LOCALE_MASK, DATE_MASK, TIMEZONE_MASK, PATTERN_MASK, CURRENCY_MASK, ZIPENTRY_MASK, LOGRECORD_MASK, ATTR_NAME_MASK, COLLECTION_MASK, MAP_MASK, A_SET_MASK, VECTOR_MASK, SET_MASK, TREESET_MASK, HASHTABLE_MASK, PROP_MASK, UUID_MASK, UNMOD_COLLECTION_MASK, UNMOD_MAP_MASK, ARRAYS_LIST_MASK, EMPTY_LIST_MASK, EMPTY_MAP_MASK, EMPTY_SET_MASK, SINGLETON_LIST_MASK, SINGLETON_MAP_MASK, SINGLETON_SET_MASK, SYN_COLLECTION_MASK, SYN_MAP_MASK, DEQUE_MASK, ENUM_SET_MASK, CONCURRENT_MAP_MASK, SET12_MASK, LIST12_MASK, LISTN_MASK, MAP1_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        switch (className) {
            case "java.util.logging.Logger+": 
            case "java.util.logging.Level+": {
                return DetailsUtils.getInstanceFieldString(instance, "name");
            }
            case "java.util.Locale": {
                String country;
                String language = DetailsUtils.getInstanceFieldString(instance, "language");
                if (language == null) {
                    language = "";
                }
                if ((country = DetailsUtils.getInstanceFieldString(instance, "country")) == null) {
                    country = "";
                }
                if (language.isEmpty() && country.isEmpty()) break;
                if (language.isEmpty() || country.isEmpty()) {
                    return language + country;
                }
                return language + "_" + country;
            }
            case "java.util.Date+": {
                long fastTime = DetailsUtils.getLongFieldValue(instance, "fastTime", -1L);
                return new Date(fastTime).toString();
            }
            case "java.util.TimeZone+": {
                return DetailsUtils.getInstanceFieldString(instance, "ID");
            }
            case "java.util.regex.Pattern": {
                return DetailsUtils.getInstanceFieldString(instance, "pattern");
            }
            case "java.util.Currency": {
                return DetailsUtils.getInstanceFieldString(instance, "currencyCode");
            }
            case "java.util.zip.ZipEntry+": {
                String name = DetailsUtils.getInstanceFieldString(instance, "name");
                long size = DetailsUtils.getLongFieldValue(instance, "size", -1L);
                if (name != null && size != -1L) {
                    return String.format("%s, size=%d", name, size);
                }
                return name;
            }
            case "java.util.logging.LogRecord": {
                return this.formatter.format(new DetailsLogRecord(instance));
            }
            case "java.util.jar.Attributes$Name": {
                return DetailsUtils.getInstanceFieldString(instance, "name");
            }
            case "java.util.AbstractCollection+": 
            case "java.util.AbstractMap+": {
                int size = DetailsUtils.getIntFieldValue(instance, "size", -1);
                if (size == -1) break;
                return UtilDetailsProvider.getElementsString(size);
            }
            case "java.util.Vector+": {
                int elements = DetailsUtils.getIntFieldValue(instance, "elementCount", -1);
                if (elements == -1) break;
                return UtilDetailsProvider.getElementsString(elements);
            }
            case "java.util.HashSet+": {
                return DetailsUtils.getInstanceFieldString(instance, "map");
            }
            case "java.util.AbstractSet+": {
                return DetailsUtils.getInstanceFieldString(instance, "this$0");
            }
            case "java.util.TreeSet": {
                return DetailsUtils.getInstanceFieldString(instance, "m");
            }
            case "java.util.Hashtable+": {
                int elements = DetailsUtils.getIntFieldValue(instance, "count", -1);
                if (elements == -1) break;
                return UtilDetailsProvider.getElementsString(elements);
            }
            case "java.util.Properties+": {
                return DetailsUtils.getInstanceFieldString(instance, "map");
            }
            case "java.util.UUID": {
                long mostSigBits = DetailsUtils.getLongFieldValue(instance, "mostSigBits", -1L);
                long leastSigBits = DetailsUtils.getLongFieldValue(instance, "leastSigBits", -1L);
                if (mostSigBits == -1L || leastSigBits == -1L) break;
                return new UUID(mostSigBits, leastSigBits).toString();
            }
            case "java.util.Collections$UnmodifiableCollection+": {
                return DetailsUtils.getInstanceFieldString(instance, "c");
            }
            case "java.util.Collections$UnmodifiableMap+": {
                return DetailsUtils.getInstanceFieldString(instance, "m");
            }
            case "java.util.Arrays$ArrayList": {
                ObjectArrayInstance arr = (ObjectArrayInstance)instance.getValueOfField("a");
                if (arr == null) break;
                return UtilDetailsProvider.getElementsString(arr.getLength());
            }
            case "java.util.Collections$EmptyList": 
            case "java.util.Collections$EmptyMap": 
            case "java.util.Collections$EmptySet": {
                return UtilDetailsProvider.getElementsString(0);
            }
            case "java.util.Collections$SingletonList": 
            case "java.util.Collections$SingletonMap": 
            case "java.util.Collections$SingletonSet": {
                return UtilDetailsProvider.getElementsString(1);
            }
            case "java.util.ArrayDeque+": {
                int head = DetailsUtils.getIntFieldValue(instance, "head", -1);
                int tail = DetailsUtils.getIntFieldValue(instance, "tail", -1);
                ObjectArrayInstance arr = (ObjectArrayInstance)instance.getValueOfField("elements");
                if (head == -1 || tail == -1 || arr == null) break;
                int size = tail - head & arr.getLength() - 1;
                return UtilDetailsProvider.getElementsString(size);
            }
            case "java.util.Collections$SynchronizedCollection+": {
                return DetailsUtils.getInstanceFieldString(instance, "c");
            }
            case "java.util.Collections$SynchronizedMap+": {
                return DetailsUtils.getInstanceFieldString(instance, "m");
            }
            case "java.util.RegularEnumSet": {
                Object elements = instance.getValueOfField("elements");
                if (!(elements instanceof Long)) break;
                return UtilDetailsProvider.getElementsString(Long.bitCount((Long)elements));
            }
            case "java.util.concurrent.ConcurrentHashMap": {
                long baseCount = DetailsUtils.getLongFieldValue(instance, "baseCount", -1L);
                ObjectArrayInstance counterCells = (ObjectArrayInstance)instance.getValueOfField("counterCells");
                if (baseCount == -1L) break;
                return UtilDetailsProvider.getElementsString(this.getConcurrentMapSize(baseCount, counterCells));
            }
            case "java.util.ImmutableCollections$Set12": 
            case "java.util.ImmutableCollections$List12": {
                Object e1 = instance.getValueOfField("e1");
                return UtilDetailsProvider.getElementsString(e1 != null ? 2 : 1);
            }
            case "java.util.ImmutableCollections$ListN": {
                Object elements = instance.getValueOfField("elements");
                if (!(elements instanceof ObjectArrayInstance)) break;
                return UtilDetailsProvider.getElementsString(((ObjectArrayInstance)elements).getLength());
            }
            case "java.util.ImmutableCollections$Map1": {
                return UtilDetailsProvider.getElementsString(1);
            }
        }
        return null;
    }

    private static String getElementsString(int length) {
        return length == 1 ? Bundle.UtilDetailsProvider_OneItemString() : Bundle.UtilDetailsProvider_ItemsNumberString(length);
    }

    private int getConcurrentMapSize(long baseCount, ObjectArrayInstance counterCells) {
        long n = this.getConcurrentMapSumCount(baseCount, counterCells);
        return n < 0L ? 0 : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
    }

    private long getConcurrentMapSumCount(long baseCount, ObjectArrayInstance counterCells) {
        long sum = baseCount;
        if (counterCells != null) {
            List as = counterCells.getValues();
            for (int i = 0; i < as.size(); ++i) {
                Instance a = (Instance)as.get(i);
                if (a == null) continue;
                sum += DetailsUtils.getLongFieldValue(a, "value", 0L);
            }
        }
        return sum;
    }

    private static class CustomLevel
    extends Level {
        private CustomLevel(String name, int value) {
            super(name, value);
        }
    }

    private static class DetailsLogRecord
    extends LogRecord {
        private final Instance record;

        private DetailsLogRecord(Instance rec) {
            super(Level.ALL, null);
            this.record = rec;
        }

        @Override
        public long getMillis() {
            return this.getInstant().toEpochMilli();
        }

        @Override
        public String getSourceClassName() {
            return DetailsUtils.getInstanceFieldString(this.record, "sourceClassName");
        }

        @Override
        public String getSourceMethodName() {
            return DetailsUtils.getInstanceFieldString(this.record, "sourceMethodName");
        }

        @Override
        public String getLoggerName() {
            return DetailsUtils.getInstanceFieldString(this.record, "loggerName");
        }

        @Override
        public String getMessage() {
            return DetailsUtils.getInstanceFieldString(this.record, "message");
        }

        @Override
        public Instant getInstant() {
            Object instant = this.record.getValueOfField("instant");
            if (instant instanceof Instance) {
                return TimeDetailsProvider.getInstant(instant);
            }
            Object time = this.record.getValueOfField("millis");
            if (time instanceof Number) {
                return Instant.ofEpochMilli(((Number)time).longValue());
            }
            return Instant.EPOCH;
        }

        @Override
        public Object[] getParameters() {
            Object pars = this.record.getValueOfField("parameters");
            if (pars instanceof ObjectArrayInstance) {
                ArrayList<String> parameters = new ArrayList<String>();
                for (Instance o : ((ObjectArrayInstance)pars).getValues()) {
                    String par = null;
                    if (o != null) {
                        par = DetailsUtils.getInstanceString(o);
                    }
                    if (par == null) {
                        par = "";
                    }
                    parameters.add(par);
                }
                return parameters.toArray();
            }
            return null;
        }

        @Override
        public Level getLevel() {
            String level = DetailsUtils.getInstanceFieldString(this.record, "level");
            try {
                return Level.parse(level);
            }
            catch (RuntimeException ex) {
                Instance levelObj = (Instance)this.record.getValueOfField("level");
                Integer value = (Integer)levelObj.getValueOfField("value");
                if (level == null) {
                    level = "NULL";
                }
                return new CustomLevel(level, (int)value);
            }
        }
    }
}

