/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent;

import java.io.Serializable;
import scala.$less$colon$less;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BuildFrom;
import scala.collection.IterableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.concurrent.Awaitable;
import scala.concurrent.BatchingExecutor;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$parasitic$;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public interface Future<T>
extends Awaitable<T> {
    public static <A, M> Function2<Builder<A, M>, A, Builder<A, M>> addToBuilderFun() {
        return Future$.MODULE$.addToBuilderFun();
    }

    public static <T> Future<T> apply(Function0<T> function0, ExecutionContext executionContext) {
        return Future$.MODULE$.apply(function0, executionContext);
    }

    public static Function1<Object, Nothing$> collectFailed() {
        return Future$.MODULE$.collectFailed();
    }

    public static <T> Future<T> delegate(Function0<Future<T>> function0, ExecutionContext executionContext) {
        return Future$.MODULE$.delegate(function0, executionContext);
    }

    public static Future<Nothing$> failedFailureFuture() {
        return Future$.MODULE$.failedFailureFuture();
    }

    public static <T> Function1<Try<T>, Try<Throwable>> failedFun() {
        return Future$.MODULE$.failedFun();
    }

    public static Failure<Nothing$> filterFailure() {
        return Future$.MODULE$.filterFailure();
    }

    public static <T> Future<Option<T>> find(Iterable<Future<T>> iterable, Function1<T, Object> function1, ExecutionContext executionContext) {
        return Future$.MODULE$.find(iterable, function1, executionContext);
    }

    public static <T> Future<T> firstCompletedOf(IterableOnce<Future<T>> iterableOnce, ExecutionContext executionContext) {
        return Future$.MODULE$.firstCompletedOf(iterableOnce, executionContext);
    }

    public static <T, R> Future<R> fold(IterableOnce<Future<T>> iterableOnce, R r, Function2<R, T, R> function2, ExecutionContext executionContext) {
        return Future$.MODULE$.fold(iterableOnce, r, function2, executionContext);
    }

    public static <T, R> Future<R> foldLeft(Iterable<Future<T>> iterable, R r, Function2<R, T, R> function2, ExecutionContext executionContext) {
        return Future$.MODULE$.foldLeft(iterable, r, function2, executionContext);
    }

    public static <T> Future<T> fromTry(Try<T> try_) {
        return Future$.MODULE$.fromTry(try_);
    }

    public static <T> Function1<T, T> id() {
        return Future$.MODULE$.id();
    }

    public static Function1<Throwable, Future<Nothing$>> recoverWithFailed() {
        return Future$.MODULE$.recoverWithFailed();
    }

    public static Future<Nothing$> recoverWithFailedMarker() {
        return Future$.MODULE$.recoverWithFailedMarker();
    }

    public static <T, R> Future<R> reduce(IterableOnce<Future<T>> iterableOnce, Function2<R, T, R> function2, ExecutionContext executionContext) {
        return Future$.MODULE$.reduce(iterableOnce, function2, executionContext);
    }

    public static <T, R> Future<R> reduceLeft(Iterable<Future<T>> iterable, Function2<R, T, R> function2, ExecutionContext executionContext) {
        return Future$.MODULE$.reduceLeft(iterable, function2, executionContext);
    }

    public static <A, CC extends IterableOnce<Object>, To> Future<To> sequence(IterableOnce<Future<A>> iterableOnce, BuildFrom<IterableOnce<Future<A>>, A, To> buildFrom, ExecutionContext executionContext) {
        return Future$.MODULE$.sequence(iterableOnce, buildFrom, executionContext);
    }

    public static <T> Future<T> successful(T t) {
        return Future$.MODULE$.successful(t);
    }

    public static Nothing$ timeoutError(Duration duration) {
        return Future$.MODULE$.timeoutError(duration);
    }

    public static Map<Class<?>, Class<?>> toBoxed() {
        return Future$.MODULE$.toBoxed();
    }

    public static <A, B, M extends IterableOnce<Object>> Future<IterableOnce<B>> traverse(IterableOnce<A> iterableOnce, Function1<A, Future<B>> function1, BuildFrom<IterableOnce<A>, B, IterableOnce<B>> buildFrom, ExecutionContext executionContext) {
        return Future$.MODULE$.traverse(iterableOnce, function1, buildFrom, executionContext);
    }

    public static Future<BoxedUnit> unit() {
        return Future$.MODULE$.unit();
    }

    public static Nothing$ waitUndefinedError() {
        return Future$.MODULE$.waitUndefinedError();
    }

    public static <T, U> Function2<T, U, Tuple2<T, U>> zipWithTuple2Fun() {
        return Future$.MODULE$.zipWithTuple2Fun();
    }

    public static void $init$(Future $this) {
    }

    public <U> void onComplete(Function1<Try<T>, U> var1, ExecutionContext var2);

    public boolean isCompleted();

    public Option<Try<T>> value();

    public static Future failed$(Future $this) {
        return $this.failed();
    }

    default public Future<Throwable> failed() {
        return this.transform(Future$.MODULE$.failedFun(), ExecutionContext$parasitic$.MODULE$);
    }

    public static void foreach$(Future $this, Function1 f, ExecutionContext executor) {
        $this.foreach(f, executor);
    }

    default public <U> void foreach(Function1<T, U> f, ExecutionContext executor) {
        this.onComplete(_$1 -> _$1.foreach(f), executor);
    }

    public static Future transform$(Future $this, Function1 s, Function1 f, ExecutionContext executor) {
        return $this.transform(s, f, executor);
    }

    default public <S> Future<S> transform(Function1<T, S> s, Function1<Throwable, Throwable> f, ExecutionContext executor) {
        return this.transform((Function1<Try, Try> & Serializable)t -> {
            if (t instanceof Success) {
                return t.map(s);
            }
            throw (Throwable)f.apply(((Failure)t).exception());
        }, executor);
    }

    public <S> Future<S> transform(Function1<Try<T>, Try<S>> var1, ExecutionContext var2);

    public <S> Future<S> transformWith(Function1<Try<T>, Future<S>> var1, ExecutionContext var2);

    public static Future map$(Future $this, Function1 f, ExecutionContext executor) {
        return $this.map(f, executor);
    }

    default public <S> Future<S> map(Function1<T, S> f, ExecutionContext executor) {
        return this.transform((Function1<Try, Try> & Serializable)_$2 -> _$2.map(f), executor);
    }

    public static Future flatMap$(Future $this, Function1 f, ExecutionContext executor) {
        return $this.flatMap(f, executor);
    }

    default public <S> Future<S> flatMap(Function1<T, Future<S>> f, ExecutionContext executor) {
        return this.transformWith((Function1<Try, Future> & Serializable)t -> {
            if (t instanceof Success) {
                return (Future)f.apply(((Success)t).value());
            }
            return this;
        }, executor);
    }

    public static Future flatten$(Future $this, $less$colon$less ev) {
        return $this.flatten(ev);
    }

    default public <S> Future<S> flatten($less$colon$less<T, Future<S>> ev) {
        return this.flatMap(ev, ExecutionContext$parasitic$.MODULE$);
    }

    public static Future filter$(Future $this, Function1 p, ExecutionContext executor) {
        return $this.filter(p, executor);
    }

    default public Future<T> filter(Function1<T, Object> p, ExecutionContext executor) {
        return this.transform((Function1<Try, Try> & Serializable)t -> {
            if (t instanceof Success) {
                if (BoxesRunTime.unboxToBoolean(p.apply(((Success)t).value()))) {
                    return t;
                }
                return Future$.MODULE$.filterFailure();
            }
            return t;
        }, executor);
    }

    public static Future withFilter$(Future $this, Function1 p, ExecutionContext executor) {
        return $this.withFilter(p, executor);
    }

    default public Future<T> withFilter(Function1<T, Object> p, ExecutionContext executor) {
        return this.filter(p, executor);
    }

    public static Future collect$(Future $this, PartialFunction pf, ExecutionContext executor) {
        return $this.collect(pf, executor);
    }

    default public <S> Future<S> collect(PartialFunction<T, S> pf, ExecutionContext executor) {
        return this.transform((Function1<Try, Try> & Serializable)t -> {
            if (t instanceof Success) {
                return Success$.MODULE$.apply(pf.applyOrElse(((Success)t).value(), Future$.MODULE$.collectFailed()));
            }
            return (Failure)t;
        }, executor);
    }

    public static Future recover$(Future $this, PartialFunction pf, ExecutionContext executor) {
        return $this.recover(pf, executor);
    }

    default public <U> Future<U> recover(PartialFunction<Throwable, U> pf, ExecutionContext executor) {
        return this.transform((Function1<Try, Try> & Serializable)_$3 -> _$3.recover(pf), executor);
    }

    public static Future recoverWith$(Future $this, PartialFunction pf, ExecutionContext executor) {
        return $this.recoverWith(pf, executor);
    }

    default public <U> Future<U> recoverWith(PartialFunction<Throwable, Future<U>> pf, ExecutionContext executor) {
        return this.transformWith((Function1<Try, Future> & Serializable)t -> {
            if (t instanceof Failure) {
                Future<Nothing$> result = pf.applyOrElse(((Failure)t).exception(), Future$.MODULE$.recoverWithFailed());
                if (result != Future$.MODULE$.recoverWithFailedMarker()) {
                    return result;
                }
                return this;
            }
            return this;
        }, executor);
    }

    public static Future zip$(Future $this, Future that) {
        return $this.zip(that);
    }

    default public <U> Future<Tuple2<T, U>> zip(Future<U> that) {
        return this.zipWith(that, Future$.MODULE$.zipWithTuple2Fun(), ExecutionContext$parasitic$.MODULE$);
    }

    public static Future zipWith$(Future $this, Future that, Function2 f, ExecutionContext executor) {
        return $this.zipWith(that, f, executor);
    }

    default public <U, R> Future<R> zipWith(Future<U> that, Function2<T, U, R> f, ExecutionContext executor) {
        return this.flatMap((Function1<Object, Future> & Serializable)r1 -> that.map((Function1<Object, Object> & Serializable)r2 -> f.apply(r1, r2), executor), executor instanceof BatchingExecutor ? executor : ExecutionContext$parasitic$.MODULE$);
    }

    public static Future fallbackTo$(Future $this, Future that) {
        return $this.fallbackTo(that);
    }

    default public <U> Future<U> fallbackTo(Future<U> that) {
        if (this == that) {
            return this;
        }
        ExecutionContext$parasitic$ ec = ExecutionContext$parasitic$.MODULE$;
        return this.transformWith((Function1<Try, Future> & Serializable)t -> {
            if (t instanceof Success) {
                return this;
            }
            return that.transform((Function1<Try, Try> & Serializable)tt -> {
                if (tt instanceof Success) {
                    return tt;
                }
                return t;
            }, ec);
        }, ec);
    }

    public static Future mapTo$(Future $this, ClassTag tag) {
        return $this.mapTo(tag);
    }

    default public <S> Future<S> mapTo(ClassTag<S> tag) {
        ExecutionContext$parasitic$ ec = ExecutionContext$parasitic$.MODULE$;
        Class c = tag.runtimeClass();
        Class boxedClass = c.isPrimitive() ? (Class)Future$.MODULE$.toBoxed().apply(c) : c;
        Predef$.MODULE$.require(!(boxedClass == null));
        return this.map((Function1<Object, Object> & Serializable)s -> boxedClass.cast(s), ec);
    }

    public static Future andThen$(Future $this, PartialFunction pf, ExecutionContext executor) {
        return $this.andThen(pf, executor);
    }

    default public <U> Future<T> andThen(PartialFunction<Try<T>, U> pf, ExecutionContext executor) {
        return this.transform((Function1<Try, Try> & Serializable)result -> {
            Object object;
            try {
                object = pf.applyOrElse(result, Future$.MODULE$.id());
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable t = throwable2 = throwable;
                if (!NonFatal$.MODULE$.apply(t)) {
                    throw throwable;
                }
                executor.reportFailure(t);
                object = BoxedUnit.UNIT;
            }
            return result;
        }, executor);
    }
}

