"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.globalTenantName = exports.SAML_AUTH_LOGOUT = exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = exports.SAML_AUTH_LOGIN = exports.ResourceType = exports.PRIVATE_TENANT_SYMBOL = exports.PRIVATE_TENANT_RENDERING_TEXT = exports.PLUGIN_USERS_APP_ID = exports.PLUGIN_TENANTS_APP_ID = exports.PLUGIN_ROLES_APP_ID = exports.PLUGIN_PERMISSIONS_APP_ID = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.PLUGIN_GET_STARTED_APP_ID = exports.PLUGIN_AUTH_APP_ID = exports.PLUGIN_AUDITLOG_APP_ID = exports.OPENID_AUTH_LOGOUT = exports.OPENID_AUTH_LOGIN_WITH_FRAGMENT = exports.OPENID_AUTH_LOGIN = exports.OPENDISTRO_SECURITY_ANONYMOUS = exports.MAX_LENGTH_OF_COOKIE_BYTES = exports.MAX_INTEGER = exports.LOGIN_PAGE_URI = exports.LOCAL_CLUSTER_ID = exports.GLOBAL_TENANT_SYMBOL = exports.GLOBAL_TENANT_RENDERING_TEXT = exports.ESTIMATED_IRON_COOKIE_OVERHEAD = exports.ERROR_MISSING_ROLE_PATH = exports.DEFAULT_TENANT = exports.CUSTOM_ERROR_PAGE_URI = exports.CONFIGURATION_API_PREFIX = exports.AuthType = exports.AUTH_TYPE_PARAM = exports.AUTH_RESPONSE_TYPE = exports.AUTH_HEADER_NAME = exports.AUTH_GRANT_TYPE = exports.APP_ID_LOGIN = exports.APP_ID_CUSTOMERROR = exports.API_PREFIX = exports.API_ENDPOINT_DASHBOARDSINFO = exports.API_ENDPOINT_AUTHTYPE = exports.API_ENDPOINT_AUTHINFO = exports.API_AUTH_LOGOUT = exports.API_AUTH_LOGIN = exports.ANONYMOUS_AUTH_LOGOUT = exports.ANONYMOUS_AUTH_LOGIN = void 0;
exports.isGlobalTenant = isGlobalTenant;
exports.isPrivateTenant = isPrivateTenant;
exports.isRenderingPrivateTenant = isRenderingPrivateTenant;
exports.isValidResourceName = isValidResourceName;
/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'opensearchDashboardsSecurity';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'security-dashboards-plugin';
const PLUGIN_GET_STARTED_APP_ID = exports.PLUGIN_GET_STARTED_APP_ID = `${PLUGIN_NAME}_getstarted`;
const PLUGIN_AUTH_APP_ID = exports.PLUGIN_AUTH_APP_ID = `${PLUGIN_NAME}_auth`;
const PLUGIN_ROLES_APP_ID = exports.PLUGIN_ROLES_APP_ID = `${PLUGIN_NAME}_roles`;
const PLUGIN_USERS_APP_ID = exports.PLUGIN_USERS_APP_ID = `${PLUGIN_NAME}_users`;
const PLUGIN_PERMISSIONS_APP_ID = exports.PLUGIN_PERMISSIONS_APP_ID = `${PLUGIN_NAME}_permissions`;
const PLUGIN_TENANTS_APP_ID = exports.PLUGIN_TENANTS_APP_ID = `${PLUGIN_NAME}_tenants`;
const PLUGIN_AUDITLOG_APP_ID = exports.PLUGIN_AUDITLOG_APP_ID = `${PLUGIN_NAME}_auditlog`;
const APP_ID_LOGIN = exports.APP_ID_LOGIN = 'login';
const APP_ID_CUSTOMERROR = exports.APP_ID_CUSTOMERROR = 'customerror';
const OPENDISTRO_SECURITY_ANONYMOUS = exports.OPENDISTRO_SECURITY_ANONYMOUS = 'opendistro_security_anonymous';
const API_PREFIX = exports.API_PREFIX = '/api/v1';
const CONFIGURATION_API_PREFIX = exports.CONFIGURATION_API_PREFIX = 'configuration';
const API_ENDPOINT_AUTHINFO = exports.API_ENDPOINT_AUTHINFO = API_PREFIX + '/auth/authinfo';
const API_ENDPOINT_DASHBOARDSINFO = exports.API_ENDPOINT_DASHBOARDSINFO = API_PREFIX + '/auth/dashboardsinfo';
const API_ENDPOINT_AUTHTYPE = exports.API_ENDPOINT_AUTHTYPE = API_PREFIX + '/auth/type';
const LOGIN_PAGE_URI = exports.LOGIN_PAGE_URI = '/app/' + APP_ID_LOGIN;
const CUSTOM_ERROR_PAGE_URI = exports.CUSTOM_ERROR_PAGE_URI = '/app/' + APP_ID_CUSTOMERROR;
const API_AUTH_LOGIN = exports.API_AUTH_LOGIN = '/auth/login';
const API_AUTH_LOGOUT = exports.API_AUTH_LOGOUT = '/auth/logout';
const OPENID_AUTH_LOGIN = exports.OPENID_AUTH_LOGIN = '/auth/openid/login';
const OPENID_AUTH_LOGIN_WITH_FRAGMENT = exports.OPENID_AUTH_LOGIN_WITH_FRAGMENT = '/auth/openid/captureUrlFragment';
const SAML_AUTH_LOGIN = exports.SAML_AUTH_LOGIN = '/auth/saml/login';
const SAML_AUTH_LOGIN_WITH_FRAGMENT = exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = '/auth/saml/captureUrlFragment';
const ANONYMOUS_AUTH_LOGIN = exports.ANONYMOUS_AUTH_LOGIN = '/auth/anonymous';
const AUTH_TYPE_PARAM = exports.AUTH_TYPE_PARAM = 'auth_type';
const OPENID_AUTH_LOGOUT = exports.OPENID_AUTH_LOGOUT = '/auth/openid/logout';
const SAML_AUTH_LOGOUT = exports.SAML_AUTH_LOGOUT = '/auth/saml/logout';
const ANONYMOUS_AUTH_LOGOUT = exports.ANONYMOUS_AUTH_LOGOUT = '/auth/anonymous/logout';
const ERROR_MISSING_ROLE_PATH = exports.ERROR_MISSING_ROLE_PATH = '/missing-role';
const AUTH_HEADER_NAME = exports.AUTH_HEADER_NAME = 'authorization';
const AUTH_GRANT_TYPE = exports.AUTH_GRANT_TYPE = 'authorization_code';
const AUTH_RESPONSE_TYPE = exports.AUTH_RESPONSE_TYPE = 'code';
const GLOBAL_TENANT_SYMBOL = exports.GLOBAL_TENANT_SYMBOL = '';
const PRIVATE_TENANT_SYMBOL = exports.PRIVATE_TENANT_SYMBOL = '__user__';
const DEFAULT_TENANT = exports.DEFAULT_TENANT = 'default';
const GLOBAL_TENANT_RENDERING_TEXT = exports.GLOBAL_TENANT_RENDERING_TEXT = 'Global';
const PRIVATE_TENANT_RENDERING_TEXT = exports.PRIVATE_TENANT_RENDERING_TEXT = 'Private';
const globalTenantName = exports.globalTenantName = 'global_tenant';
const MAX_INTEGER = exports.MAX_INTEGER = 2147483647;
const MAX_LENGTH_OF_COOKIE_BYTES = exports.MAX_LENGTH_OF_COOKIE_BYTES = 4000;
const ESTIMATED_IRON_COOKIE_OVERHEAD = exports.ESTIMATED_IRON_COOKIE_OVERHEAD = 1.5;
const LOCAL_CLUSTER_ID = exports.LOCAL_CLUSTER_ID = '';
let AuthType = exports.AuthType = /*#__PURE__*/function (AuthType) {
  AuthType["BASIC"] = "basicauth";
  AuthType["OPEN_ID"] = "openid";
  AuthType["JWT"] = "jwt";
  AuthType["SAML"] = "saml";
  AuthType["PROXY"] = "proxy";
  AuthType["ANONYMOUS"] = "anonymous";
  return AuthType;
}({});
let ResourceType = exports.ResourceType = /*#__PURE__*/function (ResourceType) {
  ResourceType["roles"] = "roles";
  ResourceType["users"] = "users";
  ResourceType["permissions"] = "permissions";
  ResourceType["tenants"] = "tenants";
  ResourceType["tenantsManageTab"] = "tenantsManageTab";
  ResourceType["tenantsConfigureTab"] = "tenantsConfigureTab";
  ResourceType["auth"] = "auth";
  ResourceType["auditLogging"] = "auditLogging";
  return ResourceType;
}({});
/**
 * A valid resource name should not containing percent sign (%) as they raise url injection issue.
 * And also should not be empty.
 * @param resourceName resource name to be validated
 */
function isValidResourceName(resourceName) {
  // see: https://javascript.info/regexp-unicode
  const exp = new RegExp('[\\p{C}%]', 'u');
  return !exp.test(resourceName) && resourceName.length > 0;
}
function isPrivateTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === PRIVATE_TENANT_SYMBOL;
}
function isRenderingPrivateTenant(selectedTenant) {
  return selectedTenant !== null && (selectedTenant === null || selectedTenant === void 0 ? void 0 : selectedTenant.startsWith(PRIVATE_TENANT_SYMBOL));
}
function isGlobalTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === GLOBAL_TENANT_SYMBOL;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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