"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupOpensearchRoutes = setupOpensearchRoutes;
var _configSchema = require("@osd/config-schema");
var _constants = require("../utils/constants");
var _helpers = require("../utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupOpensearchRoutes(services, router) {
  const {
    opensearchService
  } = services;
  router.post({
    path: `${_constants.API.DOCUMENT_IDS_QUERY}`,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)(),
      body: _configSchema.schema.any()
    }
  }, opensearchService.documentIdsQuery);
  router.get({
    path: `${_constants.API.TIME_RANGE_QUERY}`,
    validate: {
      query: _configSchema.schema.any()
    }
  }, opensearchService.timeRangeQuery);
  router.get({
    path: `${_constants.API.PLUGINS}`,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, opensearchService.getPlugins);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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