/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.svg;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.svg.BackgroundMode;
import org.netbeans.modules.svg.SVGDataObject;
import org.netbeans.modules.svg.SVGPanel;
import org.netbeans.modules.svg.toolbar.SVGViewerToolbar;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class SVGViewerElement
implements MultiViewElement {
    private static final Logger LOG;
    private final SVGDataObject dataObject;
    private final Lookup lookup;
    private transient JToolBar toolbar;
    private transient JComponent component;
    private transient MultiViewElementCallback callback;
    private transient JPanel viewer;
    private final SVGLoader svgLoader = new SVGLoader();
    private final SVGPanel svgPanel = new SVGPanel();
    private SVGDocument svgDocument = null;
    private int imageHeight = 0;
    private int imageWidth = 0;
    private long imageSize = -1L;
    private double scale = 1.0;
    private final double changeFactor = Math.sqrt(2.0);
    private final FileChangeListener fcl = new FileChangeAdapter(){

        public void fileChanged(FileEvent fe) {
            SVGViewerElement.this.updateView();
        }
    };

    public SVGViewerElement(Lookup lookup) {
        this.dataObject = (SVGDataObject)((Object)lookup.lookup(SVGDataObject.class));
        this.lookup = new ProxyLookup(new Lookup[]{Lookups.proxy(() -> this.dataObject.getLookup()), Lookups.singleton((Object)this)});
    }

    public JComponent getVisualRepresentation() {
        if (this.component == null) {
            this.viewer = new JPanel();
            this.component = this.viewer;
        }
        return this.component;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new SVGViewerToolbar().createToolbar(this);
        }
        return this.toolbar;
    }

    public Action[] getActions() {
        return this.callback.createDefaultActions();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void componentOpened() {
        this.dataObject.getPrimaryFile().addFileChangeListener(this.fcl);
        this.updateView();
    }

    public void componentClosed() {
        this.dataObject.getPrimaryFile().removeFileChangeListener(this.fcl);
    }

    public void componentShowing() {
    }

    public void componentHidden() {
    }

    public void componentActivated() {
    }

    public void componentDeactivated() {
    }

    public UndoRedo getUndoRedo() {
        return UndoRedo.NONE;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    private void addMouseWheelListenerToViewer(JScrollPane scrollPane) {
        this.svgPanel.addMouseWheelListener(e -> {
            double oldScale = this.scale;
            Point visiblePoint = e.getPoint();
            Point markedPoint = new Point((int)(visiblePoint.getX() / oldScale), (int)(visiblePoint.getY() / oldScale));
            int clicks = e.getWheelRotation();
            int clicks_abs = Math.abs(clicks);
            for (int i = 0; i < clicks_abs; ++i) {
                if (clicks < 0) {
                    this.zoomIn();
                    continue;
                }
                this.zoomOut();
            }
            double newScale = this.scale;
            Point markedPointInRealSpace = new Point((int)(markedPoint.getX() * newScale), (int)(markedPoint.getY() * newScale));
            Rectangle r = scrollPane.getViewport().getViewRect();
            r.setLocation(markedPointInRealSpace);
            r.translate(-r.width / 2, -r.height / 2);
            this.svgPanel.scrollRectToVisible(r);
        });
    }

    private void showEmptyMessage(String message) {
        JLabel label = new JLabel(message, 0);
        label.setForeground(Color.RED);
        this.viewer.removeAll();
        this.viewer.setLayout(new BorderLayout());
        this.viewer.add((Component)label, "Center");
        this.viewer.revalidate();
        this.viewer.repaint();
    }

    private void updateView() {
        FileObject fo = this.dataObject.getPrimaryFile();
        if (fo == null) {
            return;
        }
        if (this.viewer == null) {
            return;
        }
        this.svgDocument = this.svgLoader.load(fo.toURL());
        if (this.svgDocument == null) {
            this.showEmptyMessage(NbBundle.getMessage(SVGViewerElement.class, (String)"ERR_SVGDocument"));
            return;
        }
        FloatSize size = this.svgDocument.size();
        int width = (int)size.width;
        int height = (int)size.height;
        this.imageWidth = width;
        this.imageHeight = height;
        this.imageSize = fo.getSize();
        if (width <= 0 || height <= 0) {
            LOG.log(Level.WARNING, "Invalid SVG dimensions: width={0}, height={1}", new Object[]{width, height});
            return;
        }
        this.svgPanel.setPreferredSize(new Dimension(width, height));
        this.svgPanel.setSVGDocument(this.svgDocument);
        JScrollPane scrollPane = new JScrollPane(this.svgPanel);
        this.addMouseWheelListenerToViewer(scrollPane);
        this.viewer.removeAll();
        this.viewer.setLayout(new BorderLayout());
        this.viewer.add((Component)scrollPane, "Center");
        this.viewer.revalidate();
        this.viewer.repaint();
    }

    public long getImageSize() {
        return this.imageSize;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void customZoom(int fx, int fy) {
        double oldScale = this.scale;
        this.scale = (double)fx / (double)fy;
        if (!this.isNewSizeOK()) {
            this.scale = oldScale;
            return;
        }
        this.svgPanel.setScale(this.scale);
        this.resizePanel();
    }

    public void zoomIn() {
        this.scale *= this.changeFactor;
        if (this.isNewSizeOK()) {
            this.svgPanel.setScale(this.scale);
            this.resizePanel();
        } else {
            this.scale /= this.changeFactor;
        }
    }

    public void zoomOut() {
        this.scale /= this.changeFactor;
        if (this.isNewSizeOK()) {
            this.svgPanel.setScale(this.scale);
            this.resizePanel();
        } else {
            this.scale *= this.changeFactor;
        }
    }

    public void changeBackground(BackgroundMode bgMode) {
        this.svgPanel.setBackgroundMode(bgMode);
        this.viewer.revalidate();
        this.viewer.repaint();
    }

    private void resizePanel() {
        int newWidth = (int)(this.svgDocument.size().getWidth() * this.scale);
        int newHeight = (int)(this.svgDocument.size().getHeight() * this.scale);
        this.svgPanel.setBounds(0, 0, newWidth, newHeight);
        this.svgPanel.setPreferredSize(new Dimension(newWidth, newHeight));
        this.viewer.revalidate();
        this.viewer.repaint();
    }

    private boolean isNewSizeOK() {
        return this.scale * this.svgDocument.size().getWidth() > 1.0 && this.scale * this.svgDocument.size().getHeight() > 1.0;
    }

    static {
        Logger.getLogger("com.github.weisj.jsvg").setLevel(Level.OFF);
        LOG = Logger.getLogger(SVGViewerElement.class.getName());
    }
}

