/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localtasks.task;

import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.RepositoryManager;
import org.netbeans.modules.localtasks.task.Bundle;
import org.netbeans.modules.localtasks.task.LocalTask;

class SubtaskTableModel
extends DefaultTableModel {
    private final Object[][] data;

    public SubtaskTableModel(List<LocalTask.TaskReference> subtasks) {
        super(SubtaskTableModel.columnNames(), subtasks.size());
        this.data = SubtaskTableModel.data(subtasks);
    }

    private static String[] columnNames() {
        String summary = Bundle.SubtaskTableModel_summary();
        String repository = Bundle.SubtaskTableModel_repository();
        return new String[]{summary, repository};
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class<String> clazz = String.class;
        return clazz;
    }

    private static Object[][] data(List<LocalTask.TaskReference> subtasks) {
        Object[][] data = new Object[subtasks.size()][];
        int count = 0;
        for (LocalTask.TaskReference ref : subtasks) {
            String repositoryName;
            String repositoryId = ref.getRepositoryId();
            String taskId = ref.getTaskId();
            Repository repository = null;
            for (Repository r : RepositoryManager.getInstance().getRepositories()) {
                if (!repositoryId.equals(r.getId())) continue;
                repository = r;
                break;
            }
            String taskName = null;
            if (repository == null) {
                repositoryName = Bundle.MSG_SubtaskPanel_repository_unknown();
            } else {
                repositoryName = repository.getDisplayName();
                if (!taskId.isEmpty()) {
                    Issue[] tasks;
                    for (Issue t : tasks = repository.getIssues(new String[]{taskId})) {
                        if (!taskId.equals(t.getID())) continue;
                        taskName = t.getDisplayName();
                    }
                }
            }
            if (taskName == null) {
                taskName = Bundle.MSG_SubtaskPanel_task_unknown(taskId);
            }
            data[count] = new Object[]{taskName, repositoryName, repositoryId, taskId};
            ++count;
        }
        return data;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.data[row][column];
    }
}

