/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorHandler;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Localizer;

class DefaultErrorHandler
implements ErrorHandler {
    DefaultErrorHandler() {
    }

    @Override
    public void jspError(String fname, int line, int column, String errMsg, Exception ex) throws JasperException {
        throw new JasperException(fname + "(" + line + "," + column + ") " + errMsg, ex);
    }

    @Override
    public void jspError(String errMsg, Exception ex) throws JasperException {
        throw new JasperException(errMsg, ex);
    }

    @Override
    public void javacError(JavacErrorDetail[] details) throws JasperException {
        if (details == null) {
            return;
        }
        Object[] args = null;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < details.length; ++i) {
            if (details[i].getJspBeginLineNumber() >= 0) {
                args = new Object[]{details[i].getJspBeginLineNumber(), details[i].getJspFileName()};
                buf.append(Localizer.getMessage("jsp.error.single.line.number", args));
                buf.append("\n");
            }
            buf.append(Localizer.getMessage("jsp.error.corresponding.servlet"));
            buf.append(details[i].getErrorMessage());
            buf.append("\n\n");
        }
        if (buf.length() == 0) {
            throw new JasperException(Localizer.getMessage("jsp.error.nojdk"));
        }
        throw new JasperException(Localizer.getMessage("jsp.error.unable.compile") + "\n\n" + buf);
    }

    @Override
    public void javacError(String errorReport, Exception exception) throws JasperException {
        throw new JasperException(Localizer.getMessage("jsp.error.unable.compile"), exception);
    }
}

