/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.tooling;

import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.War;

class NetBeansExplodedWarPlugin
implements Plugin<Project> {
    private static final String EXPLODED_WAR_TASK = "explodedWar";

    NetBeansExplodedWarPlugin() {
    }

    public void apply(Project project) {
        project.afterEvaluate(p -> {
            if (p.getPlugins().hasPlugin("war") && project.getTasks().findByPath(EXPLODED_WAR_TASK) == null) {
                this.addTask((Project)p);
            }
        });
    }

    private void addTask(Project p) {
        War war = (War)p.getTasks().getByName("war");
        p.getTasks().register(EXPLODED_WAR_TASK, Sync.class, sync -> {
            sync.setGroup("build");
            sync.into((Object)new File(new File(p.getBuildDir(), "exploded"), (String)war.getArchiveFileName().get()));
            sync.with(new CopySpec[]{war});
        });
        war.dependsOn(new Object[]{EXPLODED_WAR_TASK});
    }
}

