/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.debug;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.groovy.debug.Context;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.filesystems.FileObject;

public class GroovyToggleBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private JPDADebugger debugger;

    public GroovyToggleBreakpointActionProvider() {
        Context.addPropertyChangeListener(this);
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
    }

    public GroovyToggleBreakpointActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        Context.addPropertyChangeListener(this);
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        Context.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        FileObject fo = Context.getCurrentFile();
        boolean isGroovyFile = fo != null && "text/x-groovy".equals(fo.getMIMEType());
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, isGroovyFile);
        if (this.debugger != null && this.debugger.getState() == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void doAction(Object action) {
        DebuggerManager debugManager = DebuggerManager.getDebuggerManager();
        int lineNumber = Context.getCurrentLineNumber();
        String url = Context.getCurrentURL();
        if (url == null) {
            return;
        }
        for (Breakpoint breakpoint : debugManager.getBreakpoints()) {
            LineBreakpoint lineBreakpoint;
            if (!(breakpoint instanceof LineBreakpoint) || lineNumber != (lineBreakpoint = (LineBreakpoint)breakpoint).getLineNumber() || !url.equals(lineBreakpoint.getURL())) continue;
            debugManager.removeBreakpoint(breakpoint);
            return;
        }
        debugManager.addBreakpoint((Breakpoint)LineBreakpoint.create((String)url, (int)lineNumber));
    }
}

