/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.stash;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import org.netbeans.libs.git.GitException;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.stash.Bundle;
import org.netbeans.modules.git.ui.stash.SaveStash;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class SaveStashAction
extends SingleRepositoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/get_clean.png";

    public SaveStashAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.saveStash(repository, roots);
    }

    public void saveStash(File repository) {
        this.saveStash(repository, new File[0]);
    }

    public void saveStash(File repository, File[] roots) {
        File[] modifications = Git.getInstance().getFileStatusCache().listFiles(new File[]{repository}, FileInformation.STATUS_LOCAL_CHANGES);
        if (modifications.length == 0) {
            NotifyDescriptor nd = new NotifyDescriptor((Object)Bundle.MSG_SaveStashAction_noModifications(), Bundle.LBL_SaveStashAction_noModifications(), -1, 1, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notifyLater(nd);
            return;
        }
        Mutex.EVENT.readAccess(() -> {
            SaveStash saveStash = new SaveStash(repository, roots, RepositoryInfo.getInstance(repository).getActiveBranch());
            if (saveStash.show()) {
                this.start(repository, modifications, saveStash);
            }
        });
    }

    private void start(final File repository, final File[] modifications, final SaveStash saveStash) {
        GitProgressSupport supp = new GitProgressSupport(){

            @Override
            protected void perform() {
                try {
                    GitClient client = this.getClient();
                    GitUtils.runWithoutIndexing(() -> {
                        client.stashSave(saveStash.getMessage(), saveStash.isIncludeUncommitted(), this.getProgressMonitor());
                        return null;
                    }, repository);
                    RepositoryInfo.getInstance(repository).refreshStashes();
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    if (modifications.length > 0) {
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Arrays.asList(modifications)));
                    }
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.MSG_SaveStashAction_progressName());
    }
}

