/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ExecutionOptionsPanel
extends JPanel {
    private static final GradleCommandLine CLI_MASK = new GradleCommandLine("--offline", "-x", "test", "-x", "check", "--quiet", "--info", "--debug", "--warn", "--configure-on-demand", "--stacktrace", "--full-stacktrace");
    private JCheckBox cbConfigureOnDemand;
    private JComboBox<GradleCommandLine.LogLevel> cbLogLevel;
    private JCheckBox cbOffline;
    private JCheckBox cbSkipCheck;
    private JCheckBox cbSkipTest;
    private JComboBox<GradleCommandLine.StackTrace> cbStackTrace;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public ExecutionOptionsPanel() {
        this.initComponents();
        this.cbLogLevel.setModel(new DefaultComboBoxModel<GradleCommandLine.LogLevel>(GradleCommandLine.LogLevel.values()));
        this.cbStackTrace.setModel(new DefaultComboBoxModel<GradleCommandLine.StackTrace>(GradleCommandLine.StackTrace.values()));
    }

    public void setCommandLine(GradleCommandLine cli) {
        this.cbOffline.setSelected(cli.hasFlag(GradleCommandLine.Flag.OFFLINE));
        this.cbConfigureOnDemand.setSelected(cli.hasFlag(GradleCommandLine.Flag.CONFIGURE_ON_DEMAND));
        Set<String> excluded = cli.getExcludedTasks();
        this.cbSkipCheck.setSelected(excluded.contains("check"));
        this.cbSkipTest.setSelected(excluded.contains("test"));
        this.cbLogLevel.setSelectedIndex(cli.getLoglevel().ordinal());
        this.cbStackTrace.setSelectedIndex(cli.getStackTrace().ordinal());
    }

    public GradleCommandLine getCommandLine() {
        GradleCommandLine ret = new GradleCommandLine(new String[0]);
        ret.setFlag(GradleCommandLine.Flag.OFFLINE, this.cbOffline.isSelected());
        ret.setFlag(GradleCommandLine.Flag.CONFIGURE_ON_DEMAND, this.cbConfigureOnDemand.isSelected());
        ret.setLogLevel((GradleCommandLine.LogLevel)((Object)this.cbLogLevel.getSelectedItem()));
        ret.setStackTrace((GradleCommandLine.StackTrace)((Object)this.cbStackTrace.getSelectedItem()));
        if (this.cbSkipCheck.isSelected()) {
            ret.addParameter(GradleCommandLine.Parameter.EXCLUDE_TASK, "check");
        }
        if (this.cbSkipTest.isSelected()) {
            ret.addParameter(GradleCommandLine.Parameter.EXCLUDE_TASK, "test");
        }
        return ret;
    }

    public static GradleCommandLine getCLIMask() {
        return new GradleCommandLine(CLI_MASK);
    }

    private void initComponents() {
        this.cbOffline = new JCheckBox();
        this.cbSkipTest = new JCheckBox();
        this.cbSkipCheck = new JCheckBox();
        this.cbConfigureOnDemand = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.cbLogLevel = new JComboBox();
        this.jLabel2 = new JLabel();
        this.cbStackTrace = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ExecutionOptionsPanel.class, (String)"ExecutionOptionsPanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbOffline, (String)NbBundle.getMessage(ExecutionOptionsPanel.class, (String)"ExecutionOptionsPanel.cbOffline.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSkipTest, (String)NbBundle.getMessage(ExecutionOptionsPanel.class, (String)"ExecutionOptionsPanel.cbSkipTest.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSkipCheck, (String)NbBundle.getMessage(ExecutionOptionsPanel.class, (String)"ExecutionOptionsPanel.cbSkipCheck.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbConfigureOnDemand, (String)NbBundle.getMessage(ExecutionOptionsPanel.class, (String)"ExecutionOptionsPanel.cbConfigureOnDemand.text"));
        this.jLabel1.setLabelFor(this.cbLogLevel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ExecutionOptionsPanel.class, (String)"ExecutionOptionsPanel.jLabel1.text"));
        this.jLabel2.setLabelFor(this.cbStackTrace);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ExecutionOptionsPanel.class, (String)"ExecutionOptionsPanel.jLabel2.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbOffline, -1, -1, Short.MAX_VALUE).addGap(9, 9, 9)).addGroup(layout.createSequentialGroup().addComponent(this.cbConfigureOnDemand).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 110, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbSkipTest, -2, 342, -2).addComponent(this.cbSkipCheck, -2, 342, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbLogLevel, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbStackTrace, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbOffline).addComponent(this.cbSkipCheck)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbSkipTest).addComponent(this.cbConfigureOnDemand)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbLogLevel, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.cbStackTrace, -2, -1, -2)).addContainerGap()));
    }
}

