/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.javamodel;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.configuration.WSConfiguration;
import org.netbeans.modules.websvc.design.configuration.WSConfigurationProvider;
import org.netbeans.modules.websvc.design.configuration.WSConfigurationProviderRegistry;
import org.netbeans.modules.websvc.design.javamodel.ProjectService;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.openide.ErrorManager;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

class ConfigProjectService
implements ProjectService {
    private static final String BUILD_IMPL_XML_PATH = "nbproject/build-impl.xml";
    private final JAXWSSupport support;
    private Service service;
    private final DataObject dataObject;

    ConfigProjectService(JAXWSSupport support, Service service, DataObject dataObject) {
        this.support = support;
        this.service = service;
        this.dataObject = dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() throws IOException {
        if (this.getService() == null || this.support == null) {
            return;
        }
        String serviceName = this.getService().getName();
        if (serviceName != null) {
            FileObject localWsdlFolder = this.support.getLocalWsdlFolderForService(serviceName, false);
            if (localWsdlFolder != null) {
                FileObject serviceWsdlFolder;
                FileLock lock = null;
                FileObject clientArtifactsFolder = localWsdlFolder.getParent();
                try {
                    lock = clientArtifactsFolder.lock();
                    clientArtifactsFolder.delete(lock);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
                FileObject wsdlFolder = this.support.getWsdlFolder(false);
                if (wsdlFolder != null && (serviceWsdlFolder = wsdlFolder.getFileObject(serviceName)) != null) {
                    try {
                        lock = serviceWsdlFolder.lock();
                        serviceWsdlFolder.delete(lock);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
                FileObject buildImplFo = this.getProject().getProjectDirectory().getFileObject(BUILD_IMPL_XML_PATH);
                try {
                    ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-service-clean-" + serviceName}, null);
                    wsimportTask.waitFinished();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
            }
            this.support.removeService(serviceName);
            Boolean isJsr109 = ((JaxWsModel)this.getProject().getLookup().lookup(JaxWsModel.class)).getJsr109();
            if (isJsr109 != null && !isJsr109.booleanValue()) {
                if (this.getService().getWsdlUrl() != null) {
                    serviceName = this.getService().getServiceName();
                }
                this.support.removeNonJsr109Entries(serviceName);
            }
        }
    }

    @Override
    public Collection<WSConfiguration> getConfigurations() {
        if (this.getService() == null) {
            return Collections.emptyList();
        }
        LinkedList<WSConfiguration> configurations = new LinkedList<WSConfiguration>();
        for (WSConfigurationProvider provider : this.getConfigProviders()) {
            WSConfiguration config = provider.getWSConfiguration(this.getService(), this.dataObject.getPrimaryFile());
            if (config == null) continue;
            configurations.add(config);
        }
        return configurations;
    }

    @Override
    public String getWsdlUrl() {
        Service s = this.getService();
        return s == null ? null : s.getWsdlUrl();
    }

    @Override
    public String getImplementationClass() {
        Service s = this.getService();
        return s == null ? null : s.getImplementationClass();
    }

    @Override
    public String getLocalWsdlFile() {
        Service s = this.getService();
        return s == null ? null : s.getLocalWsdlFile();
    }

    Service getService() {
        if (this.service == null) {
            Project project = this.getProject();
            if (project == null) {
                return null;
            }
            JaxWsModel model = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
            ClassPath classPath = ClassPath.getClassPath((FileObject)this.dataObject.getPrimaryFile(), (String)"classpath/source");
            if (classPath == null) {
                return null;
            }
            String implClass = classPath.getResourceName(this.dataObject.getPrimaryFile(), '.', false);
            this.service = model.findServiceByImplementationClass(implClass);
            return this.service;
        }
        return this.service;
    }

    private Project getProject() {
        return FileOwnerQuery.getOwner((FileObject)this.dataObject.getPrimaryFile());
    }

    private Set<WSConfigurationProvider> getConfigProviders() {
        return WSConfigurationProviderRegistry.getDefault().getWSConfigurationProviders();
    }
}

