/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor;

import java.util.Arrays;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;

public final class ErrorMark {
    private boolean error = true;
    private final int offset;
    private final int len;
    private final String errorType;
    private final Object[] parameters;
    private final String message;
    private final FxNode target;

    public ErrorMark(int offset, int len, String errorType, String message, Object ... params) {
        this(null, true, offset, len, errorType, message, params);
    }

    public ErrorMark(FxNode target, int offset, int len, String errorType, String message, Object ... params) {
        this(null, true, offset, len, errorType, message, params);
    }

    ErrorMark(FxNode target, boolean error, int offset, int len, String errorType, String message, Object ... params) {
        this.target = target;
        this.error = error;
        this.offset = offset;
        this.len = len;
        this.errorType = errorType;
        this.message = message;
        this.parameters = params;
    }

    public static ErrorMark makeError(FxNode target, int offset, int len, String errorType, String message, Object ... params) {
        return new ErrorMark(target, true, offset, len, errorType, message, params);
    }

    public static ErrorMark makeError(int offset, int len, String errorType, String message, Object ... params) {
        return new ErrorMark(null, true, offset, len, errorType, message, params);
    }

    public static ErrorMark makeWarning(int offset, int len, String errorType, String message, Object ... params) {
        return new ErrorMark(null, false, offset, len, errorType, message, params);
    }

    public boolean isError() {
        return this.error;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLen() {
        return this.len;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Error{type: %s, pos: %d, len: %d, message: %s", this.errorType, this.offset, this.len, this.message));
        if (this.parameters != null) {
            sb.append(", ").append(Arrays.asList(this.parameters));
        }
        sb.append("}");
        return sb.toString();
    }
}

