/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import javax.faces.component.MethodBindingAdapterBase;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

class MethodBindingValidator
extends MethodBindingAdapterBase
implements Validator,
StateHolder {
    private MethodBinding methodBinding = null;
    private boolean tranzient = false;

    public MethodBindingValidator() {
    }

    public MethodBindingValidator(MethodBinding methodBinding) {
        this.methodBinding = methodBinding;
    }

    public MethodBinding getWrapped() {
        return this.methodBinding;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (null == context || null == component) {
            throw new NullPointerException();
        }
        try {
            this.methodBinding.invoke(context, new Object[]{context, component, value});
        }
        catch (EvaluationException ee) {
            Throwable cause = this.getExpectedCause(ValidatorException.class, ee);
            if (cause instanceof ValidatorException) {
                throw (ValidatorException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException(ee);
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object[] result = null;
        if (!this.tranzient) {
            if (this.methodBinding instanceof StateHolder) {
                Object[] stateStruct = new Object[]{((StateHolder)((Object)this.methodBinding)).saveState(context), this.methodBinding.getClass().getName()};
                result = stateStruct;
            } else {
                result = this.methodBinding;
            }
        }
        return result;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (null == state) {
            return;
        }
        if (!(state instanceof MethodBinding)) {
            Object[] stateStruct = (Object[])state;
            Object savedState = stateStruct[0];
            String className = stateStruct[1].toString();
            MethodBinding result = null;
            if (null != className) {
                Class toRestoreClass;
                try {
                    toRestoreClass = MethodBindingValidator.loadClass(className, this);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                if (null != toRestoreClass) {
                    try {
                        result = (MethodBinding)toRestoreClass.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalStateException(e);
                    }
                }
                if (null != result && null != savedState) {
                    ((StateHolder)((Object)result)).restoreState(context, savedState);
                }
                this.methodBinding = result;
            }
        } else {
            this.methodBinding = (MethodBinding)state;
        }
    }

    @Override
    public boolean isTransient() {
        return this.tranzient;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this.tranzient = newTransientValue;
    }

    private static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return Class.forName(name, false, loader);
    }
}

