/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Utilities;

public final class FileUtilities {
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");

    private FileUtilities() {
    }

    @CheckForNull
    public static FileObject convertURItoFileObject(@NullAllowed URI uri) {
        if (uri == null) {
            return null;
        }
        File fil = FileUtil.normalizeFile((File)Utilities.toFile((URI)uri));
        return FileUtil.toFileObject((File)fil);
    }

    @CheckForNull
    public static FileObject convertStringToFileObject(@NullAllowed String str) {
        if (str != null) {
            File fil = new File(str);
            fil = FileUtil.normalizeFile((File)fil);
            return FileUtil.toFileObject((File)fil);
        }
        return null;
    }

    @NullUnknown
    public static File convertStringToFile(@NullAllowed String str) {
        if (str != null) {
            File fil = new File(str);
            return FileUtil.normalizeFile((File)fil);
        }
        return null;
    }

    @NullUnknown
    public static URI convertStringToUri(@NullAllowed String str) {
        if (str != null) {
            File fil = new File(str);
            fil = FileUtil.normalizeFile((File)fil);
            return Utilities.toURI((File)fil);
        }
        return null;
    }

    public static File convertArtifactToLocalRepositoryFile(Artifact artifact) {
        String path = EmbedderFactory.getProjectEmbedder().getLocalRepository().pathOf(artifact);
        File base = EmbedderFactory.getProjectEmbedder().getLocalRepositoryFile();
        return FileUtilities.resolveFilePath(base, path);
    }

    public static File resolveFilePath(File basedir, String filename) {
        File f;
        if (basedir == null) {
            throw new NullPointerException("null basedir passed to resolveFile");
        }
        if (filename == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (!basedir.isAbsolute()) {
            throw new IllegalArgumentException("nonabsolute basedir passed to resolveFile: " + basedir);
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(filename).matches()) {
            f = new File(basedir, filename.replace('/', File.separatorChar));
        } else {
            String machinePath = filename.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            f = new File(machinePath);
            if (!f.isAbsolute()) {
                f = new File(basedir, machinePath);
            }
            assert (f.isAbsolute());
        }
        return FileUtil.normalizeFile((File)f);
    }

    public static URI getDirURI(@NonNull File root, @NonNull String path) {
        String pth = path.trim();
        pth = pth.replaceFirst("^\\./", "");
        pth = pth.replaceFirst("^\\.\\\\", "");
        File src = FileUtilities.resolveFilePath(root, pth);
        return Utilities.toURI((File)FileUtil.normalizeFile((File)src));
    }

    public static URI getDirURI(@NonNull FileObject root, @NonNull String path) {
        File rootF = FileUtil.toFile((FileObject)root);
        if (rootF == null) {
            try {
                return root.toURI().resolve(path);
            }
            catch (Exception x) {
                return URI.create("file:/invalid/");
            }
        }
        return FileUtilities.getDirURI(rootF, path);
    }

    public static String getRelativePath(File dir, File file) {
        File tempFile;
        Stack<String> stack = new Stack<String>();
        for (tempFile = file; tempFile != null && !tempFile.equals(dir); tempFile = tempFile.getParentFile()) {
            stack.push(tempFile.getName());
        }
        if (tempFile == null) {
            return null;
        }
        StringBuilder retval = new StringBuilder();
        while (!stack.isEmpty()) {
            retval.append((String)stack.pop());
            if (stack.isEmpty()) continue;
            retval.append('/');
        }
        return retval.toString();
    }

    public static String relativizeFile(File basedir, File file) {
        if (basedir.isFile()) {
            throw new IllegalArgumentException("Cannot relative w.r.t. a data file " + basedir);
        }
        if (basedir.equals(file)) {
            return ".";
        }
        StringBuilder b = new StringBuilder();
        File base = basedir;
        String filepath = file.getAbsolutePath();
        while (!filepath.startsWith(FileUtilities.slashify(base.getAbsolutePath()))) {
            if ((base = base.getParentFile()) == null) {
                return null;
            }
            if (base.equals(file)) {
                b.append("..");
                return b.toString();
            }
            b.append("../");
        }
        URI u = Utilities.toURI((File)base).relativize(Utilities.toURI((File)file));
        assert (!u.isAbsolute()) : u + " from " + basedir + " and " + file + " with common root " + base;
        b.append(u.getPath());
        if (b.charAt(b.length() - 1) == '/') {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    private static String slashify(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separatorChar;
    }

    public static SortedSet<String> getPackageNames(Project prj) {
        TreeSet<String> result = new TreeSet<String>();
        FileUtilities.getSourcePackageNames(prj, result, false);
        return result;
    }

    public static SortedSet<String> getBasePackageNames(Project prj) {
        TreeSet<String> result = new TreeSet<String>();
        FileUtilities.getSourcePackageNames(prj, result, true);
        return result;
    }

    public static File getUserSettingsFile(boolean forceCreate) {
        if (!SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE.exists()) {
            if (!forceCreate) {
                return null;
            }
            try {
                File fil = SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE.getParentFile();
                DataFolder folder = DataFolder.findFolder((FileObject)FileUtil.createFolder((File)fil));
                FileObject temp = FileUtil.getConfigFile((String)"Maven2Templates/settings.xml");
                DataObject dobj = DataObject.find((FileObject)temp);
                dobj.createFromTemplate(folder);
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE;
    }

    private static void getSourcePackageNames(Project prj, SortedSet<String> result, boolean onlyRoots) {
        SourceGroup[] scs = ProjectUtils.getSources((Project)prj).getSourceGroups("java");
        for (int i = 0; i < scs.length; ++i) {
            final FileObject curRoot = scs[i].getRootFolder();
            FileUtilities.processFolder(curRoot, new NameObtainer(){

                @Override
                public String getPackageName(FileObject file) {
                    String pkgName = FileUtilities.relativizeFile(FileUtil.toFile((FileObject)curRoot), FileUtil.toFile((FileObject)file));
                    return pkgName.replace('/', '.');
                }
            }, result, onlyRoots);
        }
    }

    private static void processFolder(FileObject file, NameObtainer nameObtainer, SortedSet<String> result, boolean onlyRoots) {
        Enumeration dataFiles = file.getData(false);
        Enumeration folders = file.getFolders(false);
        if (dataFiles.hasMoreElements()) {
            while (dataFiles.hasMoreElements()) {
                String packageName;
                FileObject kid = (FileObject)dataFiles.nextElement();
                if (!kid.hasExt("java") && !kid.hasExt("class") || !Utilities.isJavaIdentifier((String)kid.getName()) || (packageName = nameObtainer.getPackageName(file)) == null) continue;
                result.add(packageName);
                if (!onlyRoots) break;
                return;
            }
        }
        while (folders.hasMoreElements()) {
            FileUtilities.processFolder((FileObject)folders.nextElement(), nameObtainer, result, onlyRoots);
        }
    }

    private static interface NameObtainer {
        public String getPackageName(FileObject var1);
    }
}

