/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;

public class HtmlKeystrokeHandler
implements KeystrokeHandler {
    public boolean beforeCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public boolean afterCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public boolean charBackspaced(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public int beforeBreak(Document doc, int caretOffset, JTextComponent target) throws BadLocationException {
        return -1;
    }

    public OffsetRange findMatching(Document doc, int caretOffset) {
        return OffsetRange.NONE;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult info, int caretOffset) {
        CharSequence text;
        Token token;
        if (!(info instanceof HtmlParserResult)) {
            return Collections.emptyList();
        }
        HtmlParserResult result = (HtmlParserResult)info;
        TreeSet<OffsetRange> ranges = new TreeSet<OffsetRange>();
        Document doc = info.getSnapshot().getSource().getDocument(true);
        TokenHierarchy hierarchy = TokenHierarchy.get((Document)doc);
        TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence(doc, caretOffset);
        if (ts == null) {
            return Collections.emptyList();
        }
        ts.move(caretOffset);
        if ((ts.moveNext() || ts.movePrevious()) && (token = ts.token()).id() == HTMLTokenId.TEXT && (text = token.text()).toString().trim().length() > 0) {
            int from = ts.offset();
            int to = from + token.text().length();
            List tokenParts = token.joinedParts();
            if (tokenParts != null) {
                Token last = (Token)tokenParts.get(tokenParts.size() - 1);
                to = last.offset(hierarchy) + last.length();
            }
            int trimmed_from = from;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                trimmed_from += i;
                break;
            }
            int trimmed_to = to;
            for (int i = text.length() - 1; i >= 0; --i) {
                char ch = text.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                trimmed_to = to - (text.length() - 1 - i);
                break;
            }
            if (trimmed_from != from || trimmed_to != to) {
                ranges.add(new OffsetRange(trimmed_from, trimmed_to));
            }
            ranges.add(new OffsetRange(from, to));
        }
        Snapshot snapshot = result.getSnapshot();
        ArrayList<Node> roots = new ArrayList<Node>(result.roots().values());
        roots.add(result.rootOfUndeclaredTagsParseTree());
        for (Node root : roots) {
            Node node = ElementUtils.findBySemanticRange((Node)root, (int)snapshot.getEmbeddedOffset(caretOffset), (boolean)false);
            if (node == null) continue;
            do {
                int ast_to = node.type() == ElementType.OPEN_TAG ? ((OpenTag)node).semanticEnd() : node.to();
                int from = snapshot.getOriginalOffset(node.from());
                int to = snapshot.getOriginalOffset(ast_to);
                if (from == -1 || to == -1 || from == to) continue;
                ranges.add(new OffsetRange(from, to));
            } while ((node = node.parent()) != null);
        }
        ArrayList<OffsetRange> ret = new ArrayList<OffsetRange>(ranges);
        Collections.reverse(ret);
        return ret;
    }

    public int getNextWordOffset(Document doc, int caretOffset, boolean reverse) {
        return -1;
    }
}

