/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.UdpTransportMapping;
import org.snmp4j.util.WorkerTask;

public class DefaultUdpTransportMapping
extends UdpTransportMapping {
    private static final LogAdapter logger = LogFactory.getLogger(DefaultUdpTransportMapping.class);
    protected DatagramSocket socket = null;
    protected ListenThread listenerThread;
    private int socketTimeout = 0;
    private int receiveBufferSize = 0;

    public DefaultUdpTransportMapping() throws SocketException {
        super(new UdpAddress("0.0.0.0/0"));
        this.socket = new DatagramSocket(this.udpAddress.getPort());
    }

    public DefaultUdpTransportMapping(UdpAddress udpAddress, boolean reuseAddress) throws SocketException {
        super(udpAddress);
        this.socket = new DatagramSocket(null);
        this.socket.setReuseAddress(reuseAddress);
        InetSocketAddress addr = new InetSocketAddress(udpAddress.getInetAddress(), udpAddress.getPort());
        this.socket.bind(addr);
    }

    public DefaultUdpTransportMapping(UdpAddress udpAddress) throws IOException {
        super(udpAddress);
        this.socket = new DatagramSocket(udpAddress.getPort(), udpAddress.getInetAddress());
    }

    @Override
    public void sendMessage(UdpAddress targetAddress, byte[] message, TransportStateReference tmStateReference, long timeoutMillis, int maxRetries) throws IOException {
        if (this.suspendedAddresses.size() > 0 && this.suspendedAddresses.contains(targetAddress)) {
            this.handleDroppedMessageToSend(targetAddress, message, tmStateReference, timeoutMillis, maxRetries);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Sending message to " + String.valueOf(targetAddress) + " from " + String.valueOf(this.getListenAddress()) + " with length " + message.length + ": " + new OctetString(message).toHexString())));
        }
        DatagramSocket s = this.ensureSocket();
        List<DatagramPacket> netPayload = this.prepareOutPackets(targetAddress, message, tmStateReference, s, timeoutMillis, maxRetries);
        for (DatagramPacket netPacket : netPayload) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Sending packet to " + String.valueOf(targetAddress))));
            }
            s.send(netPacket);
        }
    }

    protected List<DatagramPacket> prepareOutPackets(UdpAddress targetAddress, byte[] message, TransportStateReference tmStateReference, DatagramSocket socket, long timeoutMillis, int maxRetries) throws IOException {
        InetSocketAddress targetSocketAddress = new InetSocketAddress(targetAddress.getInetAddress(), targetAddress.getPort());
        return Collections.singletonList(new DatagramPacket(message, message.length, targetSocketAddress));
    }

    @Override
    public void close() throws IOException {
        DatagramSocket closingSocket;
        boolean interrupted = false;
        WorkerTask l = this.getListenWorkerTask();
        if (l != null) {
            l.terminate();
            l.interrupt();
            if (this.socketTimeout > 0) {
                try {
                    l.join();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    logger.warn(ex);
                }
            }
            this.listenWorkerTask = null;
        }
        if ((closingSocket = this.socket) != null && !closingSocket.isClosed()) {
            closingSocket.close();
        }
        this.socket = null;
        TransportStateEvent e = new TransportStateEvent(this, this.getListenAddress(), 4, null);
        this.fireConnectionStateChanged(e);
        if (l != null && this.socketTimeout <= 0) {
            try {
                l.join();
            }
            catch (InterruptedException ex) {
                interrupted = true;
                logger.warn(ex);
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public synchronized void listen() throws IOException {
        if (this.getListenWorkerTask() != null) {
            throw new SocketException("Port already listening");
        }
        this.ensureSocket();
        this.listenerThread = new ListenThread();
        this.listenWorkerTask = SNMP4JSettings.getThreadFactory().createWorkerThread("DefaultUDPTransportMapping_" + String.valueOf(this.getListenAddress()), this.listenerThread, true);
        this.getListenWorkerTask().run();
        TransportStateEvent e = new TransportStateEvent(this, this.getListenAddress(), 1, null);
        this.fireConnectionStateChanged(e);
    }

    protected synchronized DatagramSocket ensureSocket() throws SocketException {
        DatagramSocket s = this.socket;
        if (s == null) {
            s = new DatagramSocket(this.udpAddress.getPort());
            s.setSoTimeout(this.socketTimeout);
            this.socket = s;
        }
        return s;
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        if (receiveBufferSize <= 0) {
            throw new IllegalArgumentException("Receive buffer size must be > 0");
        }
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(socketTimeout);
            }
            catch (SocketException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public UdpAddress getListenAddress() {
        UdpAddress actualListenAddress = null;
        DatagramSocket socketCopy = this.socket;
        if (socketCopy != null) {
            actualListenAddress = new UdpAddress(socketCopy.getLocalAddress(), socketCopy.getLocalPort());
        }
        return actualListenAddress;
    }

    protected DatagramSocket renewSocketAfterException(SocketException socketException, DatagramSocket failedSocket) throws SocketException {
        if (failedSocket != null && !failedSocket.isClosed()) {
            failedSocket.close();
        }
        DatagramSocket s = new DatagramSocket(this.udpAddress.getPort(), this.udpAddress.getInetAddress());
        s.setSoTimeout(this.socketTimeout);
        return s;
    }

    @Override
    protected void fireProcessMessage(DatagramPacket packet, ByteBuffer bis, TransportStateReference stateReference) {
        this.fireProcessMessage(new UdpAddress(packet.getAddress(), packet.getPort()), bis, stateReference);
    }

    protected ByteBuffer prepareInPacket(DatagramPacket packet, byte[] buf, TransportStateReference tmStateReference) throws IOException {
        return ByteBuffer.wrap(packet.getData(), 0, packet.getLength());
    }

    protected class ListenThread
    implements WorkerTask {
        private byte[] buf;
        private volatile boolean stop = false;

        public ListenThread() throws SocketException {
            this.buf = new byte[DefaultUdpTransportMapping.this.getMaxInboundMessageSize()];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DatagramSocket socketCopy = DefaultUdpTransportMapping.this.socket;
            if (socketCopy != null) {
                try {
                    socketCopy.setSoTimeout(DefaultUdpTransportMapping.this.getSocketTimeout());
                    if (DefaultUdpTransportMapping.this.receiveBufferSize > 0) {
                        socketCopy.setReceiveBufferSize(Math.max(DefaultUdpTransportMapping.this.receiveBufferSize, DefaultUdpTransportMapping.this.maxInboundMessageSize));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("UDP receive buffer size for socket " + String.valueOf(DefaultUdpTransportMapping.this.getAddress()) + " is set to: " + socketCopy.getReceiveBufferSize())));
                    }
                }
                catch (SocketException ex) {
                    logger.error(ex);
                    DefaultUdpTransportMapping.this.setSocketTimeout(0);
                }
                if (logger.isInfoEnabled()) {
                    logger.info("Listening on socket " + String.valueOf(new UdpAddress(socketCopy.getLocalAddress(), socketCopy.getLocalPort())));
                }
            }
            while (!this.stop) {
                Object stateReference;
                if (DefaultUdpTransportMapping.this.isAsyncMsgProcessingSupported() || this.buf == null) {
                    this.buf = new byte[DefaultUdpTransportMapping.this.getMaxInboundMessageSize()];
                }
                DatagramPacket packet = new DatagramPacket(this.buf, this.buf.length, DefaultUdpTransportMapping.this.udpAddress.getInetAddress(), DefaultUdpTransportMapping.this.udpAddress.getPort());
                try {
                    ByteBuffer bis;
                    socketCopy = DefaultUdpTransportMapping.this.socket;
                    stateReference = new TransportStateReference(DefaultUdpTransportMapping.this, DefaultUdpTransportMapping.this.udpAddress, null, SecurityLevel.undefined, SecurityLevel.undefined, false, socketCopy);
                    try {
                        if (socketCopy == null) {
                            this.stop = true;
                            continue;
                        }
                        try {
                            socketCopy.receive(packet);
                        }
                        catch (SocketTimeoutException ste) {
                            continue;
                        }
                        bis = DefaultUdpTransportMapping.this.prepareInPacket(packet, this.buf, (TransportStateReference)stateReference);
                    }
                    catch (InterruptedIOException iiox) {
                        if (iiox.bytesTransferred <= 0) continue;
                        bis = DefaultUdpTransportMapping.this.prepareInPacket(packet, this.buf, (TransportStateReference)stateReference);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Received message from " + String.valueOf(packet.getAddress()) + "/" + packet.getPort() + " with length " + packet.getLength() + ": " + new OctetString(packet.getData(), 0, packet.getLength()).toHexString())));
                    }
                    if (bis == null) continue;
                    DefaultUdpTransportMapping.this.fireProcessMessage(packet, bis, (TransportStateReference)stateReference);
                }
                catch (SocketTimeoutException bis) {
                }
                catch (PortUnreachableException purex) {
                    stateReference = DefaultUdpTransportMapping.this;
                    synchronized (stateReference) {
                        DefaultUdpTransportMapping.this.listenWorkerTask = null;
                    }
                    logger.error(purex);
                    if (logger.isDebugEnabled()) {
                        purex.printStackTrace();
                    }
                    if (!SNMP4JSettings.isForwardRuntimeExceptions()) break;
                    throw new RuntimeException(purex);
                }
                catch (SocketException soex) {
                    if (!this.stop) {
                        logger.warn((Serializable)((Object)("Socket for transport mapping " + this.toString() + " error: " + soex.getMessage())));
                    }
                    if (!this.stop && SNMP4JSettings.isForwardRuntimeExceptions()) {
                        this.stop = true;
                        throw new RuntimeException(soex);
                    }
                    if (this.stop) continue;
                    try {
                        DatagramSocket newSocket = DefaultUdpTransportMapping.this.renewSocketAfterException(soex, socketCopy);
                        if (newSocket == null) {
                            throw soex;
                        }
                        DefaultUdpTransportMapping.this.socket = newSocket;
                    }
                    catch (SocketException e) {
                        this.stop = true;
                        DefaultUdpTransportMapping.this.socket = null;
                        logger.error("Socket renewal for transport mapping " + this.toString() + " failed with: " + e.getMessage(), e);
                    }
                }
                catch (IOException iox) {
                    logger.warn(iox);
                    if (logger.isDebugEnabled()) {
                        iox.printStackTrace();
                    }
                    if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                    throw new RuntimeException(iox);
                }
            }
            DefaultUdpTransportMapping defaultUdpTransportMapping = DefaultUdpTransportMapping.this;
            synchronized (defaultUdpTransportMapping) {
                DefaultUdpTransportMapping.this.listenWorkerTask = null;
                this.stop = true;
                DatagramSocket closingSocket = DefaultUdpTransportMapping.this.socket;
                if (closingSocket != null && !closingSocket.isClosed()) {
                    closingSocket.close();
                }
                DefaultUdpTransportMapping.this.socket = null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Worker task stopped:" + this.getClass().getName())));
            }
        }

        public void close() {
            this.stop = true;
        }

        @Override
        public void terminate() {
            this.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Terminated worker task: " + this.getClass().getName())));
            }
        }

        @Override
        public void join() throws InterruptedException {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Joining worker task: " + this.getClass().getName())));
            }
        }

        @Override
        public void interrupt() {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Interrupting worker task: " + this.getClass().getName())));
            }
            this.close();
        }
    }
}

