/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import org.logstash.settings.Coercible;

public class NumericSetting
extends Coercible<Number> {
    public NumericSetting(String name, Number defaultValue) {
        super(name, defaultValue, true, NumericSetting.noValidator());
    }

    public NumericSetting(String name, Number defaultValue, boolean strict) {
        super(name, defaultValue, strict, NumericSetting.noValidator());
    }

    @Override
    public Number coerce(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Failed to coerce value to NumericSetting. Received null");
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Float.valueOf(Float.parseFloat(obj.toString()));
            }
            catch (NumberFormatException numberFormatException2) {
                throw new IllegalArgumentException(this.coercionFailureMessage(obj));
            }
        }
    }

    private String coercionFailureMessage(Object obj) {
        return String.format("Failed to coerce value to NumericSetting. Received %s (%s)", obj, obj.getClass());
    }
}

