/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.PrivilegeNode;
import org.apache.derby.shared.common.error.StandardException;

class GrantNode
extends DDLStatementNode {
    private PrivilegeNode privileges;
    private List<String> grantees;

    GrantNode(PrivilegeNode privileges, List<String> grantees, ContextManager cm) {
        super(cm);
        this.privileges = privileges;
        this.grantees = grantees;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String grantee : this.grantees) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(grantee);
        }
        return super.toString() + this.privileges.toString() + "TO: \n" + sb.toString() + "\n";
    }

    @Override
    String statementToString() {
        return "GRANT";
    }

    @Override
    public void bindStatement() throws StandardException {
        this.privileges = (PrivilegeNode)this.privileges.bind(new HashMap<Provider, Provider>(), this.grantees, true);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getGrantConstantAction(this.privileges.makePrivilegeInfo(), this.grantees);
    }
}

