/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.chain.MonotoneChain;
import org.locationtech.jts.index.chain.MonotoneChainSelectAction;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.snapround.HotPixel;

public class MCIndexPointSnapper {
    private STRtree index;
    private static final double SAFE_ENV_EXPANSION_FACTOR = 0.75;

    public MCIndexPointSnapper(SpatialIndex index) {
        this.index = (STRtree)index;
    }

    public boolean snap(HotPixel hotPixel, SegmentString parentEdge, int hotPixelVertexIndex) {
        final Envelope pixelEnv = this.getSafeEnvelope(hotPixel);
        final HotPixelSnapAction hotPixelSnapAction = new HotPixelSnapAction(hotPixel, parentEdge, hotPixelVertexIndex);
        this.index.query(pixelEnv, new ItemVisitor(){

            @Override
            public void visitItem(Object item) {
                MonotoneChain testChain = (MonotoneChain)item;
                testChain.select(pixelEnv, hotPixelSnapAction);
            }
        });
        return hotPixelSnapAction.isNodeAdded();
    }

    public boolean snap(HotPixel hotPixel) {
        return this.snap(hotPixel, null, -1);
    }

    public Envelope getSafeEnvelope(HotPixel hp) {
        double safeTolerance = 0.75 / hp.getScaleFactor();
        Envelope safeEnv = new Envelope(hp.getCoordinate());
        safeEnv.expandBy(safeTolerance);
        return safeEnv;
    }

    public static class HotPixelSnapAction
    extends MonotoneChainSelectAction {
        private HotPixel hotPixel;
        private SegmentString parentEdge;
        private int hotPixelVertexIndex;
        private boolean isNodeAdded = false;

        public HotPixelSnapAction(HotPixel hotPixel, SegmentString parentEdge, int hotPixelVertexIndex) {
            this.hotPixel = hotPixel;
            this.parentEdge = parentEdge;
            this.hotPixelVertexIndex = hotPixelVertexIndex;
        }

        public boolean isNodeAdded() {
            return this.isNodeAdded;
        }

        @Override
        public void select(MonotoneChain mc, int startIndex) {
            NodedSegmentString ss = (NodedSegmentString)mc.getContext();
            if (this.parentEdge != null && ss == this.parentEdge && (startIndex == this.hotPixelVertexIndex || startIndex + 1 == this.hotPixelVertexIndex)) {
                return;
            }
            this.isNodeAdded |= this.addSnappedNode(this.hotPixel, ss, startIndex);
        }

        public boolean addSnappedNode(HotPixel hotPixel, NodedSegmentString segStr, int segIndex) {
            Coordinate p1;
            Coordinate p0 = segStr.getCoordinate(segIndex);
            if (hotPixel.intersects(p0, p1 = segStr.getCoordinate(segIndex + 1))) {
                segStr.addIntersection(hotPixel.getCoordinate(), segIndex);
                return true;
            }
            return false;
        }
    }
}

