/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Event;
import jdk.jfr.SettingControl;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.AnnotationConstruct;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.PlatformEventType;

public class Type
implements Comparable<Type> {
    public static final String SUPER_TYPE_ANNOTATION = Annotation.class.getName();
    public static final String SUPER_TYPE_SETTING = SettingControl.class.getName();
    public static final String SUPER_TYPE_EVENT = Event.class.getName();
    public static final String EVENT_NAME_PREFIX = "jdk.";
    public static final String TYPES_PREFIX = "jdk.types.";
    public static final String SETTINGS_PREFIX = "jdk.settings.";
    private static final Map<Type, Class<?>> knownTypes = new HashMap();
    static final Type BOOLEAN = Type.register(Boolean.TYPE, new Type("boolean", null, 4L));
    static final Type CHAR = Type.register(Character.TYPE, new Type("char", null, 5L));
    static final Type FLOAT = Type.register(Float.TYPE, new Type("float", null, 6L));
    static final Type DOUBLE = Type.register(Double.TYPE, new Type("double", null, 7L));
    static final Type BYTE = Type.register(Byte.TYPE, new Type("byte", null, 8L));
    static final Type SHORT = Type.register(Short.TYPE, new Type("short", null, 9L));
    static final Type INT = Type.register(Integer.TYPE, new Type("int", null, 10L));
    static final Type LONG = Type.register(Long.TYPE, new Type("long", null, 11L));
    static final Type CLASS = Type.register(Class.class, new Type("java.lang.Class", null, 20L));
    static final Type STRING = Type.register(String.class, new Type("java.lang.String", null, 21L));
    static final Type THREAD = Type.register(Thread.class, new Type("java.lang.Thread", null, 22L));
    static final Type STACK_TRACE = Type.register(null, new Type("jdk.types.StackTrace", null, 23L));
    private final AnnotationConstruct annos = new AnnotationConstruct();
    private final String name;
    private final String superType;
    private final boolean constantPool;
    private final long id;
    private List<ValueDescriptor> fields = new ArrayList<ValueDescriptor>();
    private Boolean simpleType;
    private boolean remove = true;

    public Type(String string, String string2, long l) {
        this(string, string2, l, false);
    }

    Type(String string, String string2, long l, boolean bl) {
        this(string, string2, l, bl, null);
    }

    Type(String string, String string2, long l, boolean bl, Boolean bl2) {
        Objects.requireNonNull(string);
        if (!Type.isValidJavaIdentifier(string)) {
            throw new IllegalArgumentException(string + " is not a valid Java identifier");
        }
        this.constantPool = bl;
        this.superType = string2;
        this.name = string;
        this.id = l;
        this.simpleType = bl2;
    }

    static boolean isDefinedByJVM(long l) {
        return l < 400L;
    }

    public static long getTypeId(Class<?> clazz) {
        Type type = Type.getKnownType(clazz);
        return type == null ? JVM.getJVM().getTypeId(clazz) : type.getId();
    }

    static Collection<Type> getKnownTypes() {
        return knownTypes.keySet();
    }

    public static boolean isValidJavaIdentifier(String string) {
        if (string.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaFieldType(String string) {
        for (Map.Entry<Type, Class<?>> entry : knownTypes.entrySet()) {
            Class<?> clazz = entry.getValue();
            if (clazz == null || !string.equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public static Type getKnownType(String string) {
        for (Type type : knownTypes.keySet()) {
            if (!type.getName().equals(string)) continue;
            return type;
        }
        return null;
    }

    static boolean isKnownType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return clazz.equals(Class.class) || clazz.equals(Thread.class) || clazz.equals(String.class);
    }

    public static Type getKnownType(Class<?> clazz) {
        for (Map.Entry<Type, Class<?>> entry : knownTypes.entrySet()) {
            if (clazz == null || !clazz.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getLogName() {
        return this.getName() + "(" + this.getId() + ")";
    }

    public List<ValueDescriptor> getFields() {
        if (this.fields instanceof ArrayList) {
            ((ArrayList)this.fields).trimToSize();
            this.fields = Collections.unmodifiableList(this.fields);
        }
        return this.fields;
    }

    public boolean isSimpleType() {
        if (this.simpleType == null) {
            this.simpleType = this.calculateSimpleType();
        }
        return this.simpleType;
    }

    private boolean calculateSimpleType() {
        if (this.fields.size() != 1) {
            return false;
        }
        return this.superType == null;
    }

    public boolean isDefinedByJVM() {
        return this.id < 400L;
    }

    private static Type register(Class<?> clazz, Type type) {
        knownTypes.put(type, clazz);
        return type;
    }

    public void add(ValueDescriptor valueDescriptor) {
        Objects.requireNonNull(valueDescriptor);
        this.fields.add(valueDescriptor);
    }

    void trimFields() {
        this.getFields();
    }

    void setAnnotations(List<AnnotationElement> list) {
        this.annos.setAnnotationElements(list);
    }

    public String getSuperType() {
        return this.superType;
    }

    public long getId() {
        return this.id;
    }

    public boolean isConstantPool() {
        return this.constantPool;
    }

    public String getLabel() {
        return this.annos.getLabel();
    }

    public List<AnnotationElement> getAnnotationElements() {
        return this.annos.getUnmodifiableAnnotationElements();
    }

    public <T> T getAnnotation(Class<? extends Annotation> clazz) {
        return this.annos.getAnnotation(clazz);
    }

    public String getDescription() {
        return this.annos.getDescription();
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object object) {
        if (object instanceof Type) {
            Type type = (Type)object;
            return type.id == this.id;
        }
        return false;
    }

    @Override
    public int compareTo(Type type) {
        return Long.compare(this.id, type.id);
    }

    void log(String string, LogTag logTag, LogLevel logLevel) {
        if (Logger.shouldLog(logTag, logLevel) && !this.isSimpleType()) {
            Logger.log(logTag, LogLevel.TRACE, string + " " + this.typeText() + " " + this.getLogName() + " {");
            for (ValueDescriptor valueDescriptor : this.getFields()) {
                String string2 = valueDescriptor.isArray() ? "[]" : "";
                Logger.log(logTag, LogLevel.TRACE, "  " + valueDescriptor.getTypeName() + string2 + " " + valueDescriptor.getName() + ";");
            }
            Logger.log(logTag, LogLevel.TRACE, "}");
        } else if (Logger.shouldLog(logTag, LogLevel.INFO) && !this.isSimpleType()) {
            Logger.log(logTag, LogLevel.INFO, string + " " + this.typeText() + " " + this.getLogName());
        }
    }

    private String typeText() {
        if (this instanceof PlatformEventType) {
            return "event type";
        }
        if (SUPER_TYPE_SETTING.equals(this.superType)) {
            return "setting type";
        }
        if (SUPER_TYPE_ANNOTATION.equals(this.superType)) {
            return "annotation type";
        }
        return "type";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLogName());
        if (!this.getFields().isEmpty()) {
            stringBuilder.append(" {\n");
            for (ValueDescriptor valueDescriptor : this.getFields()) {
                stringBuilder.append("  type=" + valueDescriptor.getTypeName() + "(" + valueDescriptor.getTypeId() + ") name=" + valueDescriptor.getName() + "\n");
            }
            stringBuilder.append("}\n");
        }
        return stringBuilder.toString();
    }

    public void setRemove(boolean bl) {
        this.remove = bl;
    }

    public boolean getRemove() {
        return this.remove;
    }
}

