/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.graalvm.visualvm.lib.ui.swing.PopupButton;

public class ActionPopupButton
extends PopupButton {
    private Action action;
    private final Action[] actions;

    public ActionPopupButton(Action ... _actions) {
        this(0, _actions);
    }

    public ActionPopupButton(int initial, Action ... _actions) {
        this.actions = _actions;
        this.selectAction(initial);
    }

    public final Action[] getActions() {
        return this.actions;
    }

    public final void selectAction(Action _action) {
        this.action = _action;
        this.setText(this.action == null ? "" : this.action.getValue("Name").toString());
        this.putClientProperty("JComponent.sizeVariant", "regular");
    }

    public final void selectAction(int index) {
        this.selectAction(this.actions[index]);
    }

    public final Action getSelectedAction() {
        return this.action;
    }

    public final int getSelectedIndex() {
        for (int i = 0; i < this.actions.length; ++i) {
            if (this.actions[i] != this.action) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void populatePopup(JPopupMenu popup) {
        for (final Action _action : this.actions) {
            if (_action != null) {
                popup.add(new JRadioButtonMenuItem(_action.getValue("Name").toString(), _action == this.action){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        ActionPopupButton.this.selectAction(_action);
                        _action.actionPerformed(e);
                    }
                });
                continue;
            }
            popup.addSeparator();
        }
    }
}

