/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.cpu;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.graalvm.visualvm.lib.jfluid.TargetAppRunner;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.jfluid.results.ExportDataDumper;
import org.graalvm.visualvm.lib.jfluid.results.cpu.FlatProfileContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.FlatProfileProvider;
import org.graalvm.visualvm.lib.ui.LiveResultsPanel;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.FilterComponent;
import org.graalvm.visualvm.lib.ui.cpu.CPUResUserActionsHandler;
import org.graalvm.visualvm.lib.ui.cpu.CPUSelectionHandler;
import org.graalvm.visualvm.lib.ui.cpu.FlatProfilePanel;

public class LiveFlatProfileCollectorPanel
extends FlatProfilePanel
implements LiveResultsPanel {
    private JPopupMenu popup;
    private TargetAppRunner runner = null;
    private boolean firstTime = true;
    private boolean updateResultsInProgress = false;
    private boolean updateResultsPending = false;

    public LiveFlatProfileCollectorPanel(TargetAppRunner runner, CPUResUserActionsHandler actionsHandler, CPUSelectionHandler selectionHandler, boolean sampling) {
        super(actionsHandler, selectionHandler, sampling);
        this.runner = runner;
        this.addFilterListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LiveFlatProfileCollectorPanel.this.flatProfileContainer != null) {
                    LiveFlatProfileCollectorPanel.this.setDataToDisplay(LiveFlatProfileCollectorPanel.this.flatProfileContainer);
                }
            }
        });
        this.initComponents();
    }

    public void setDataToDisplay(FlatProfileContainer fpc) {
        this.threadId = -1;
        this.flatProfileContainer = fpc;
        this.collectingTwoTimeStamps = this.flatProfileContainer.isCollectingTwoTimeStamps();
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterValues(this.filterString), this.filterType, this.valueFilterValue);
        this.prepareResults(this.firstTime);
        this.firstTime = false;
        this.setResultsAvailable(this.hasData());
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    @Override
    public String getViewName() {
        return "cpu-live";
    }

    @Override
    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    @Override
    public void handleRemove() {
    }

    @Override
    public void handleShutdown() {
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = false;
            this.popup.setVisible(false);
        }
    }

    public boolean hasData() {
        return this.flatProfileContainer != null && this.flatProfileContainer.getNRows() > 0;
    }

    @Override
    public boolean hasView() {
        return this.resTable != null;
    }

    @Override
    public void prepareResults() {
        super.prepareResults();
    }

    @Override
    public boolean supports(int instrumentationType) {
        return instrumentationType == 3 || instrumentationType == 4 || instrumentationType == 2;
    }

    @Override
    public void updateLiveResults() {
        FlatProfileProvider flatProvider;
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = true;
            return;
        }
        if (this.updateResultsInProgress) {
            return;
        }
        this.updateResultsInProgress = true;
        String selectedRowString = null;
        if (this.resTable != null) {
            int selectedRowIndex = this.resTable.getSelectedRow();
            if (selectedRowIndex >= this.resTable.getRowCount()) {
                selectedRowIndex = -1;
                this.resTable.clearSelection();
            }
            if (selectedRowIndex != -1) {
                selectedRowString = this.resTable.getValueAt(selectedRowIndex, 0).toString();
            }
        }
        if ((flatProvider = this.getFlatProfileProvider()) != null) {
            FlatProfileContainer fpc = flatProvider.createFlatProfile();
            int retryCounter = 2;
            boolean doRetry = false;
            do {
                doRetry = false;
                if (fpc != null) {
                    this.setDataToDisplay(fpc);
                    if (selectedRowString != null) {
                        this.resTable.selectRowByContents(selectedRowString, 0, false);
                    }
                } else {
                    doRetry = true;
                }
                if (!doRetry) continue;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    doRetry = false;
                }
            } while (--retryCounter > 0 && doRetry);
        }
        this.updateResultsInProgress = false;
    }

    public FlatProfileProvider getFlatProfileProvider() {
        return this.runner.getProfilerClient().getFlatProfileProvider();
    }

    @Override
    protected String[] getMethodClassNameAndSig(int methodId, int currentView) {
        ProfilingSessionStatus status = this.runner.getProfilingSessionStatus();
        String className = status.getInstrMethodClasses()[methodId];
        if (currentView == 0) {
            String methodName = status.getInstrMethodNames() != null ? status.getInstrMethodNames()[methodId] : null;
            String methodSig = status.getInstrMethodSignatures() != null ? status.getInstrMethodSignatures()[methodId] : null;
            return new String[]{className, methodName, methodSig};
        }
        return new String[]{className, null, null};
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        if (this.popup == null) {
            this.popup = super.createPopupMenu();
        }
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (LiveFlatProfileCollectorPanel.this.updateResultsPending) {
                            LiveFlatProfileCollectorPanel.this.updateLiveResults();
                            LiveFlatProfileCollectorPanel.this.updateResultsPending = false;
                        }
                    }
                });
            }
        });
        return this.popup;
    }

    @Override
    protected void obtainResults() {
        if (!this.collectingTwoTimeStamps && this.sortBy == 3) {
            this.sortBy = 2;
        }
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterValues(this.filterString), this.filterType, this.valueFilterValue);
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
    }

    @Override
    protected void showReverseCallGraph(int threadId, int methodId, int currentView, int sortingColumn, boolean sortingOrder) {
        throw new IllegalStateException();
    }

    @Override
    protected boolean supportsReverseCallGraph() {
        return false;
    }

    @Override
    protected boolean supportsSubtreeCallGraph() {
        return false;
    }

    void setSelectedRowString(String rowString) {
        if (rowString != null) {
            this.resTable.selectRowByContents(rowString, 0, false);
        }
    }

    String getSelectedRowString() {
        String selectedRowString = null;
        if (this.resTable != null) {
            int selectedRowIndex = this.resTable.getSelectedRow();
            if (selectedRowIndex >= this.resTable.getRowCount()) {
                selectedRowIndex = -1;
                this.resTable.clearSelection();
            }
            if (selectedRowIndex != -1) {
                selectedRowString = this.resTable.getValueAt(selectedRowIndex, 0).toString();
            }
        }
        return selectedRowString;
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(800, 600));
    }

    public void exportData(int exportedFileType, ExportDataDumper eDD, String viewName) {
        this.percentFormat.setMaximumFractionDigits(2);
        this.percentFormat.setMinimumFractionDigits(2);
        switch (exportedFileType) {
            case 1: {
                this.exportCSV(",", eDD);
                break;
            }
            case 2: {
                this.exportCSV(";", eDD);
                break;
            }
            case 3: {
                this.exportXML(eDD, viewName);
                break;
            }
            case 4: {
                this.exportHTML(eDD, viewName);
            }
        }
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
    }

    private void exportHTML(ExportDataDumper eDD, String viewName) {
        int i;
        StringBuffer result = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + viewName + "</TITLE></HEAD><BODY><TABLE border=\"1\"><tr>");
        for (i = 0; i < this.columnCount; ++i) {
            result.append("<th>").append(this.columnNames[i]).append(this.columnNames[i].equals("Total Time") ? " [&micro;s]" : "").append("</th>");
        }
        result.append("</tr>");
        eDD.dumpData((CharSequence)result);
        for (i = 0; i < this.flatProfileContainer.getNRows(); ++i) {
            result = new StringBuffer("<tr><td>" + this.replaceHTMLCharacters(this.flatProfileContainer.getMethodNameAtRow(i)) + "</td>");
            result.append("<td align=\"right\">").append(this.percentFormat.format(this.flatProfileContainer.getPercentAtRow(i) / 100.0f)).append(this.flatProfileContainer.getTimeInMcs0AtRow(i) % 10L == 0L ? (this.flatProfileContainer.getTimeInMcs0AtRow(i) % 100L == 0L ? (this.flatProfileContainer.getTimeInMcs0AtRow(i) % 1000L == 0L ? "    " : "  ") : " ") : "").append("</td>");
            result.append("<td align=right>").append((double)this.flatProfileContainer.getTimeInMcs0AtRow(i) / 1000.0).append(" ms</td>");
            if (this.collectingTwoTimeStamps) {
                result.append("<td align=right>").append((double)this.flatProfileContainer.getTimeInMcs1AtRow(i) / 1000.0).append(" ms</td>");
            }
            result.append("<td align=right>").append((double)this.flatProfileContainer.getTotalTimeInMcs0AtRow(i) / 1000.0).append(" ms</td>");
            if (this.collectingTwoTimeStamps) {
                result.append("<td align=right>").append((double)this.flatProfileContainer.getTotalTimeInMcs1AtRow(i) / 1000.0).append(" ms</td>");
            }
            result.append("<td align=\"right\">").append(this.flatProfileContainer.getNInvocationsAtRow(i)).append("</td></tr>");
            eDD.dumpData((CharSequence)result);
        }
        eDD.dumpDataAndClose(new StringBuffer(" </TABLE></BODY></HTML>"));
    }

    private void exportXML(ExportDataDumper eDD, String viewName) {
        int i;
        String newline = System.lineSeparator();
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<ExportedView Name=\"" + viewName + "\" type=\"table\">" + newline + " <TableData NumRows=\"" + this.flatProfileContainer.getNRows() + "\" NumColumns=\"4\">" + newline + "  <TableHeader>");
        for (i = 0; i < this.columnCount; ++i) {
            result.append("   <TableColumn><![CDATA[").append(this.columnNames[i]).append("]]></TableColumn>").append(newline);
        }
        result.append("  </TableHeader>").append(newline).append("  <TableBody>").append(newline);
        eDD.dumpData((CharSequence)result);
        for (i = 0; i < this.flatProfileContainer.getNRows(); ++i) {
            result = new StringBuffer("   <TableRow>" + newline + "    <TableColumn><![CDATA[" + this.flatProfileContainer.getMethodNameAtRow(i) + "]]></TableColumn>" + newline);
            result.append("    <TableColumn><![CDATA[").append(this.percentFormat.format(this.flatProfileContainer.getPercentAtRow(i) / 100.0f)).append("]]></TableColumn>").append(newline);
            result.append("    <TableColumn><![CDATA[").append((double)this.flatProfileContainer.getTimeInMcs0AtRow(i) / 1000.0).append(" ms]]></TableColumn>").append(newline);
            if (this.collectingTwoTimeStamps) {
                result.append("    <TableColumn><![CDATA[").append((double)this.flatProfileContainer.getTimeInMcs1AtRow(i) / 1000.0).append(" ms]]></TableColumn>").append(newline);
            }
            result.append("    <TableColumn><![CDATA[").append((double)this.flatProfileContainer.getTotalTimeInMcs0AtRow(i) / 1000.0).append(" ms]]></TableColumn>").append(newline);
            if (this.collectingTwoTimeStamps) {
                result.append("    <TableColumn><![CDATA[").append((double)this.flatProfileContainer.getTotalTimeInMcs1AtRow(i) / 1000.0).append(" ms]]></TableColumn>").append(newline);
            }
            result.append("    <TableColumn><![CDATA[").append(this.flatProfileContainer.getNInvocationsAtRow(i)).append("]]></TableColumn>").append(newline).append("  </TableRow>").append(newline);
            eDD.dumpData((CharSequence)result);
        }
        eDD.dumpDataAndClose(new StringBuffer("  </TableBody> </TableData>" + newline + "</ExportedView>"));
    }

    private void exportCSV(String separator, ExportDataDumper eDD) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        for (i = 0; i < this.columnCount; ++i) {
            result.append(quote).append(this.columnNames[i]).append(quote).append(separator);
        }
        result.deleteCharAt(result.length() - 1);
        result.append(newLine);
        eDD.dumpData((CharSequence)result);
        for (i = 0; i < this.flatProfileContainer.getNRows(); ++i) {
            result = new StringBuffer();
            result.append(quote).append(this.flatProfileContainer.getMethodNameAtRow(i)).append(quote).append(separator);
            result.append(quote).append(this.flatProfileContainer.getPercentAtRow(i)).append(quote).append(separator);
            result.append(quote).append((double)this.flatProfileContainer.getTimeInMcs0AtRow(i) / 1000.0).append(" ms").append(quote).append(separator);
            if (this.collectingTwoTimeStamps) {
                result.append(quote).append((double)this.flatProfileContainer.getTimeInMcs1AtRow(i) / 1000.0).append(" ms").append(quote).append(separator);
            }
            result.append(quote).append((double)this.flatProfileContainer.getTotalTimeInMcs0AtRow(i) / 1000.0).append(" ms").append(quote).append(separator);
            if (this.collectingTwoTimeStamps) {
                result.append(quote).append((double)this.flatProfileContainer.getTotalTimeInMcs1AtRow(i) / 1000.0).append(" ms").append(quote).append(separator);
            }
            result.append(quote).append(this.flatProfileContainer.getNInvocationsAtRow(i)).append(quote).append(newLine);
            eDD.dumpData((CharSequence)result);
        }
        eDD.close();
    }

    private String replaceHTMLCharacters(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

