/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class NeosProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text(">").number("(d{8}),").number("d+,").number("([01]),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").expression("([EW])").number("(d+)(dd.d+),").expression("([NS])").number("(d+)(dd.d+),").expression("[^,]*,").number("(d+),").number("(d+),").number("(d+),").expression("[^,]*,").number("(d+)-").number("(d+),").number("0,").number("d,").number("([01]{8})").text("*").number("xx!").any().compile();

    public NeosProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("$OK!", remoteAddress));
        }
        if (!(parser = new Parser(PATTERN, (String)msg)).matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(parser.nextInt() > 0);
        position.setTime(parser.nextDateTime());
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setSpeed(parser.nextInt().intValue());
        position.setCourse(parser.nextInt().intValue());
        position.set("rssi", parser.nextInt());
        position.set("adc1", parser.nextInt());
        position.set("batteryLevel", parser.nextInt());
        position.set("input", parser.nextBinInt());
        return position;
    }
}

